# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession

class XDataTestTestCase(unittest.TestCase):
    def test(self):
        #
        salome = XSalomeSession(modules=["TECHOBJ"], logger=1)
        engine = salome.lcc.FindOrLoadComponent("FactoryServerPy", "TECHOBJ")
        self.failUnless(engine)
        from TECHOBJ_CORBA import TECHOBJ_Component
        engine = engine._narrow(TECHOBJ_Component)
        self.failUnless(engine)
        #
        radius = 1.0
        #
        circle = engine.newCircle(
            radius,
            )
        self.failUnless(circle)
        self.failUnlessEqual(circle.getR(), radius)
        #
        bounds = circle.getBounds()
        self.failUnlessEqual(bounds[0], -radius)
        self.failUnlessEqual(bounds[1], +radius)
        self.failUnlessEqual(bounds[2], -radius)
        self.failUnlessEqual(bounds[3], +radius)
        #
        mat = engine.newMaterial(
            engine.newXString("mmm"),
            )
        self.failUnlessEqual(mat.getName().value(), "mmm")
        #
        to = engine.newTechnologyObject(
            mat,
            circle,
            )
        #
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
