# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

class TestCase(unittest.TestCase):
    def test(self):
        #
        from xsalome import XSalomeSession
        salome = XSalomeSession(modules=["DATATEST1"])
        #
        from xfloatphysicalvalue import Point
        p = Point(1, 2, 3)
        epsilon = 1.e-5
        error = abs(p.x.value - 1)
        self.failUnless(error < epsilon)
        self.failUnlessEqual(p.x.quantity, "length")
        p = Point(1, 2)
        epsilon = 1.e-5
        error = abs(p.z.value - 0)
        self.failUnless(error < epsilon)
        self.failUnlessEqual(p.z.quantity, "length")
        #
        from xfloatphysicalvalue import Vector
        v = Vector([1, 2, 3])
        epsilon = 1.e-5
        error = abs(v.coords[0].value - 1)
        self.failUnless(error < epsilon)
        self.failUnlessEqual(v.coords[0].quantity, "length")
        #
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
