# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

# --
#

global __xclasses__
global __xobjects__

def resetXClasses():
    global __xclasses__
    __xclasses__ = []
    return

def resetXObjects():
    global __xobjects__
    __xobjects__ = []
    return

resetXClasses()
resetXObjects()

def getXClasses():
    return tuple(__xclasses__)

def getXObjects():
    return tuple(__xobjects__)

def removeXObject(obj):
    __xobjects__.remove(obj)
    return

# --
#

class XMetaClass(type):
    
    def __init__(cls, name, bases, dict):
        type.__init__(cls, name, bases, dict)
        #
        dict_keys = dict.keys()
        #
        if not hasattr(cls, "__xsomething__"):
            __xclasses__.append(cls)
            #
            my_keys = dict_keys[:]
            for c in cls.__mro__[1:]:
                if c is object: continue
                d = c.__dict__
                for key, value in d.items():
                    if key in my_keys: continue
                    my_keys.append(key)
                    from types import FunctionType
                    if not isinstance(value, FunctionType): continue
                    if value.__name__ == "__xaccessor__": continue
                    XMetaClass.__setattr__(cls, key, value)
                    pass
                pass
            #
            pass
        #
        XMetaClass.__setattr__(cls, "__xabstract__", 0)
        #
        for key in dict_keys:
            value = dict[key]
            XMetaClass.__setattr__(cls, key, value)
            pass
        #
        return
    
    def __setattr__(cls, name, value):
        # --
        if name == '__new__':
            return
        # --
        # This operation convert a function
        # into a unbound method
        type.__setattr__(cls, name, value)
        # --
        # Don't intercept the __call__ of XType instances
        if hasattr(cls, '__xtype__'):
            if name == '__call__':
                return
            pass
        # --
        # Re-get the attribute 
        value = type.__getattribute__(cls, name)
        #
        if str(value)[:15] == "<unbound method":
            if name == '__init__':
                from xinterceptor import InitXInterceptor
                value = InitXInterceptor(name, value)
            else:
                # --
                # WHY ????
                from xinterceptor import XInterceptor
                value = XInterceptor(name, value)
                pass
            # --
            # Replace the attribute by the interceptor
            type.__setattr__(cls, name, value)
            pass
        #
        if name[:3] in ('get', 'set'):
            type.__setattr__(cls, "__user%s"%(name), value)
            capname = name[3:]
            for x in cls.getXAttributesMRO():
                from xutilities import name2capname
                if capname == name2capname(getattr(x, '__name')):
                    cls.setXAttribute(x)
                    break
                pass
            pass
        #
        return
    
    def getAllInitXAttributes(cls, name_first=0):
        if name_first: return cls.__ixattrs__namefirst__
        return cls.__ixattrs__namelast__
    
    def getAllInitXAttributesNames(cls, name_first=0):
        if name_first: return cls.__inames__namefirst__
        return cls.__inames__namelast__
    
    def getXAttributesMRO(cls, name_first=0):
        xattrs = []
        xattrs_names = []
        from xutilities import getMRO
        from xobject import XObject
        mro = getMRO(cls, XObject)
        for c in mro:
            l  = []
            l += c.getAllInitXAttributes(name_first)
            l += c.__object__xattributes__
            for x in l:
                if x not in xattrs:
                    name = getattr(x, '__name')
                    if name not in xattrs_names:
                        xattrs.append(x)
                        xattrs_names.append(name)
                        pass
                    pass
                pass
            pass
        return xattrs
    
    def setXAttribute(cls, x):
        obj = cls
        key = getattr(x, '__name')
        #
        from xutilities import name2capname
        try:
            user_get = getattr(cls, '__userget%s'%(name2capname(key)))
        except AttributeError:
            user_get = None
            pass
        try:
            user_set = getattr(cls, '__userset%s'%(name2capname(key)))
        except AttributeError:
            user_set = None
            pass
        # --
        # To be improved ...
        # Done like that for optimisation ?!?!
        from xaccessor import GetXAccessor
        get = GetXAccessor(key, x, user_get, id(cls))
        from xaccessor import SetXAccessor
        set = SetXAccessor(key, x, user_set, id(cls))
        from xutilities import name2capname
        def __xaccessor__(self, *args, **kwargs):
            return get(self, *args, **kwargs)
        type.__setattr__(obj, 'get%s'%(name2capname(key)), __xaccessor__)
        def __xaccessor__(self, *args, **kwargs):
            return set(self, *args, **kwargs)
        type.__setattr__(obj, 'set%s'%(name2capname(key)), __xaccessor__)
        type.__setattr__(obj, key, property(get, set))
        # --
        return
    
    def __call__(cls, *args, **kwargs):
        
        # --
        
        if cls.__xabstract__:
            msg  = "The class %s is abstract. Impossible to create instances of it."%(cls)
            from xexceptions import XValueError
            raise XValueError(msg)

        # --
            
        self = cls.__new__(cls, *args, **kwargs)
        self.__xcontext__ = None
        
        if hasattr(cls, "__xsomething__"):
            self.__init__(*args, **kwargs)
            return self
        
        # --
        # get the context
        
        from xcontext import getContext
        context = getContext()
        
        # --
        # Should we create a pure python object
        # or a corba object ???
        
        component = None
        if context == "clt":
            from xutilities import message
            message("client side detected", cls=XMetaClass)
            from xsalome import getComponentFromClass
            message("searching a component for %s"%(cls), cls=XMetaClass)
            component = getComponentFromClass(cls)
            message("component %s found"%(component), cls=XMetaClass)
            self.__corba__component__ = component
            pass
        
        # --
        # get the interface
        
        from xcontext import getInterface
        interface = getInterface()
        
        # --
        # Get the creation information:
        
        code_next_operation, instance_name, code_percent = None, None, None
        if ( interface in ("gui", "tui", ) ) or ( cls.__xnamedobject__ ) :
            from xutilities import getCreationInformations
            t = getCreationInformations()
            code_next_operation, instance_name, code_percent = t
            pass
        self.__code__next__operation__ = code_next_operation
        self.__instance__name__ = instance_name
        self.__code__percentage__ = code_percent
        
        # --
        # run __init__ as usual
        
        self.__init__ok__ = 0
        user_kwargs = self.__init__(*args, **kwargs)
        self.__init__ok__ = 1
        
        # --
        # Register self in __xobjects__
        # ( cls.__xnamedobject__ ) added 'cause strange comportment otherwise !!!??
        if ( interface in ("gui", "tui", ) ) or ( cls.__xnamedobject__ ) :
            __xobjects__.append(self)
            pass
        
        # --
        #
        if ( interface in ("gui", "tui", ) ) :
            from xutilities import message
            if self.__code__next__operation__ == "STORE_NAME":
                message("instance_name", self.__instance__name__)
                try:
                    import xqt
                    qt_ok = 1
                except:
                    qt_ok = 0
                    pass
                if qt_ok:
                    from xdatagui import getMainWindow
                    mw = getMainWindow()
                    if mw:
                        mw.newObjectCreated(self)
                        pass
                    pass
                pass
            pass
        # --
        # Don't forget to return self
        return self
    
    pass

__developper__dict__ = {
    '__init__xattributes__' : [],
    '__init__argslen__' : -1,
    '__object__xattributes__' : [],
    '__object__xmethods__': [],
    '__xnamedobject__': 0,
    '__xabstract__': 0,
    }

l  = __developper__dict__.keys()
l += ['__init__xproperties__', '__object__xproperties__']

for key in l:
    from xbootstrap import XAttributeBootstrap
    xattr = XAttributeBootstrap(key)
    from xdescriptor import XMetaClassDescriptor
    desc = XMetaClassDescriptor(key, xattr)
    setattr(XMetaClass, key, desc)
    pass
