# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xsomething import XSomething

class XAttribute(XSomething):
    __init__argslen__ = 1
    
    def __init__(self, *args, **kwargs):
        # print self, args, kwargs
        # --
        # Has default ???
        has_default_value = kwargs.has_key("default_value")
        self.__has_default_value = has_default_value
        if has_default_value:
            xtype = getattr(self, "__xtype")
            val = getattr(self, "__default_value")
            # --
            # Particuliar case when default_value is None :
            # We must accept the value None ...
            if val is None:
                if xtype is None:
                    from xtypes import xnone_empty
                    xtype = xnone_empty
                    setattr(self, "__xtype", xtype)
                else:
                    # --
                    # Try if xtype already accept None
                    try:
                        xtype(None)
                    except:
                        # --
                        # xnone_empty first 'cause we must evaluate "None" before all
                        from xtypes import xnone_empty, XMulTypes
                        xtype = XMulTypes(xtypes=[xnone_empty, xtype])
                        setattr(self, "__xtype", xtype)
                        pass
                    pass
                pass
            if xtype is None:
                # --
                # if self.has_default_value and self.xtype is None :
                #    attempt to set self.xtype to the XType
                #    of the default value
                # --
                # Try to find the good XType
                known_types  = [type(None), int, float, str]
                known_types += [tuple, list, dict]
                xtype = None
                if type(val) in known_types:
                    t = str(type(val))
                    t = t[len("<type '"):-len("'>")]
                    t = "X%s"%(t.capitalize())
                    if t == "XNonetype":
                        t = "XNone"
                    elif t == "XStr":
                        t = "XString"
                        pass
                    exec "from xtypes import %s"%(t)
                    exec "xtype = %s()"%(t)
                    pass
                else:
                    xtype = XInstance(classes=[val.__class__])
                    pass
                # --
                #
                setattr(self, "__xtype", xtype)
                pass
            # --
            # Test the default value if optional
            xtype(val)
            pass
        
        return
    
    def hasDefaultValue(self):
        return self.__has_default_value
    
    def getDefaultValue(self):
        if not self.hasDefaultValue():
            msg  = ""
            msg += "The attribute %s is non optional.\n"%(self.name)
            msg += "No default value exists for it.\n"
            from xexceptions import XValueError
            raise XValueError(msg)
        return getattr(self, '__default_value')
    
    pass

class XProperty(XAttribute):
    def __init__(self, *args, **kwargs):
        warning_sep  = '-------------------------------------------------------\n'
        warning_line = 'WARNING WARNING WARNING WARNING WARNING WARNING WARNING\n'
        msg  = warning_sep
        msg += warning_line
        msg += "The use of 'XProperty' is deprecated.\n"
        msg += "Please, use 'XAttribute' instead.\n"
        msg += warning_line
        msg += warning_sep
        print msg
        XAttribute.__init__(self, *args, **kwargs)
        return
    pass

from xbootstrap import XAttributeBootstrap

XAttribute.__init__xattributes__ = [
    XAttributeBootstrap("name"),
    XAttributeBootstrap("xtype"),
    XAttributeBootstrap("default_value"),
    XAttributeBootstrap("mode"),
    ]

from xbootstrap import xtype_bootstrap

name_x = XAttribute("name", xtype=xtype_bootstrap, mode="r")

XAttribute.__init__xattributes__ = [
    name_x,
    XAttribute("xtype", xtype=xtype_bootstrap, default_value=None, mode="r"),
    XAttribute("default_value", xtype=xtype_bootstrap, default_value=None, mode="r"),
    XAttribute("mode", xtype=xtype_bootstrap, default_value=None, mode="r"),
    ]
