# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class A:
    pass

class B(object):
    pass

class C(object):
    pass

class XInstanceTestCase(unittest.TestCase):
    def test(self):
        self.failUnlessRaises(XAttributeError, XInstance)
        return
    def test_init(self):
        self.failUnlessRaises(XValueError, XInstance, classes=3.2)
        self.failUnlessRaises(XValueError, XInstance, classes=[3.2])
        self.failUnlessRaises(XValueError, XInstance, 3.2)
        self.failUnlessRaises(XValueError, XInstance, "XXXXXX")
        x = XInstance(classes=[A, B])
        self.failUnlessEqual(x.classes, [A, B])
        x = XInstance(A, B)
        self.failUnlessEqual(x.classes, [A, B])
        x = XInstance("xdata.XString")
        return
    def test_classes(self):
        x = XInstance(A)
        self.failUnlessRaises(XValueError, x, 3.2)
        x = XInstance(A)
        a = A()
        self.failUnlessEqual(x(a), a)
        x = XInstance(B)
        self.failUnlessRaises(XValueError, x, A())
        b = B()
        self.failUnlessEqual(x(b), b)
        x = XInstance(classes=[A, B])
        a = A()
        self.failUnlessEqual(x(a), a)
        b = B()
        self.failUnlessEqual(x(b), b)
        c = C()
        self.failUnlessRaises(XValueError, x, c)
        return
    def test_string_classes(self):
        x = XInstance("xdata.XString")
        self.failUnlessRaises(XValueError, x, "toto")
        v = XString()
        self.failUnlessEqual(x(v), v)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
