# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

xint = XInt()

class A(XObject):
    __init__xattributes__ = [
        XAttribute("a", xtype=xint),
        ]
    pass

class B(A):
    __init__xattributes__ = A.__init__xattributes__ + [
        XAttribute("b", xtype=xint),
        ]
    pass

class C(A):
    __init__xattributes__ = A.__init__xattributes__ + [
        XAttribute("c", xtype=xint),
        ]
    pass

class D(B, C):
    __init__xattributes__ = B.__init__xattributes__ + C.__init__xattributes__ + [
        XAttribute("d", xtype=xint),
        ]
    pass

class TestCase(unittest.TestCase):
    def test(self):
        ixa = D.__init__xattributes__
        self.failUnlessEqual([ x.name for x in ixa ], ['a', 'b', 'c', 'd'])
        d = D(1, 2, 3, 4)
        self.failUnlessEqual(d.a, 1)
        self.failUnlessEqual(d.b, 2)
        self.failUnlessEqual(d.c, 3)
        self.failUnlessEqual(d.d, 4)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
