//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  VISU VISUGUI : GUI of VISU component
//  File   : VVTK_PrimitiveBox.h
//  Author : Oleg UVAROV
//  Module : VISU
//
#ifndef VVTK_PRIMITIVEBOX_H
#define VVTK_PRIMITIVEBOX_H

#include "VVTK.h"

#include <QGroupBox>

class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;

class QtxDoubleSpinBox;
class QtxIntSpinBox;

class VVTK_EXPORT VVTK_PrimitiveBox : public QGroupBox
{
  Q_OBJECT

public:
  VVTK_PrimitiveBox( QWidget* );
  ~VVTK_PrimitiveBox() {}

public:
  int                      getPrimitiveType() const { return myPrimitiveType; }
  void                     setPrimitiveType( int );

  float                    getClamp() const;
  void                     setClamp( float );
  void                     setClampMaximum( float );

  QString                  getMainTexture() const { return myMainTexture; }
  void                     setMainTexture( const QString& );

  QString                  getAlphaTexture() const { return myAlphaTexture; }
  void                     setAlphaTexture( const QString& );

  float                    getAlphaThreshold() const;
  void                     setAlphaThreshold( float );

  int                      getResolution() const;
  void                     setResolution( int );

  int                      getFaceNumber() const;
  void                     setFaceNumber( int );

  int                      getFaceLimit() const;
  void                     setFaceLimit( int );

protected slots:
  void                     onTogglePointSprite();
  void                     onToggleOpenGLPoint();
  void                     onToggleGeomSphere();

  void                     onBrowseMainTexture();
  void                     onBrowseAlphaTexture();

  void                     onResolutionChanged( int );

private:
  int                      myPrimitiveType;

  QRadioButton*            myPointSpriteButton;
  QRadioButton*            myOpenGLPointButton;
  QRadioButton*            myGeomSphereButton;

  QString                  myMainTexture;
  QString                  myAlphaTexture;

  QLabel*                  myClampLabel;
  QtxDoubleSpinBox*        myClampSpinBox;

  QLabel*                  myMainTextureLabel;
  QLineEdit*               myMainTextureLineEdit;
  QPushButton*             myMainTextureButton;

  QLabel*                  myAlphaTextureLabel;
  QLineEdit*               myAlphaTextureLineEdit;
  QPushButton*             myAlphaTextureButton;

  QLabel*                  myAlphaThresholdLabel;
  QtxDoubleSpinBox*        myAlphaThresholdSpinBox;

  QLabel*                  myResolutionLabel;
  QtxIntSpinBox*           myResolutionSpinBox;

  QLabel*                  myFaceNumberLabel;
  QLineEdit*               myFaceNumberLineEdit;

  QLabel*                  myFaceLimitLabel;
  QtxIntSpinBox*           myFaceLimitSpinBox;
};



#endif
