//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#include "MEDMEMTest.hxx"
#include <cppunit/TestAssert.h>

#include <MEDMEM_Field.hxx>
#include <MEDMEM_MedFieldDriver21.hxx>

// use this define to enable lines, execution of which leads to Segmentation Fault
//#define ENABLE_FAULTS

// use this define to enable CPPUNIT asserts and fails, showing bugs
//#define ENABLE_FORCED_FAILURES

/*!
 *  Check methods (17), defined in MEDMEM_MedFieldDriver21.hxx:
 *  template <class T> class MED_FIELD_DRIVER21 : public virtual MED_FIELD_DRIVER<T> {
 *   (+) MED_FIELD_DRIVER21();
 *   (+) template <class INTERLACING_TAG> MED_FIELD_DRIVER21(const string & fileName,
 *          FIELD<T, INTERLACING_TAG> * ptrField, MED_EN::med_mode_acces accessMode);
 *   (+) MED_FIELD_DRIVER21(const MED_FIELD_DRIVER21 & fieldDriver);
 *   (+) virtual ~MED_FIELD_DRIVER21();
 *   (+) void open() throw (MEDEXCEPTION);
 *   (+) void close();
 *  }
 *  template <class T> class MED_FIELD_RDONLY_DRIVER21 : public virtual MED_FIELD_DRIVER21<T>,
 *                                                       public virtual IMED_FIELD_RDONLY_DRIVER<T> {
 *   (+) MED_FIELD_RDONLY_DRIVER21();
 *   (+) template <class INTERLACING_TAG> MED_FIELD_RDONLY_DRIVER21
 *                 (const string & fileName, FIELD<T, INTERLACING_TAG> * ptrField);
 *   (+) MED_FIELD_RDONLY_DRIVER21(const MED_FIELD_RDONLY_DRIVER21 & fieldDriver);
 *   (+) virtual ~MED_FIELD_RDONLY_DRIVER21();
 *   (+) void write(void) const throw (MEDEXCEPTION);
 *   (+) void read (void) throw (MEDEXCEPTION);
 *  }
 *  template <class T> class MED_FIELD_WRONLY_DRIVER21 : public virtual MED_FIELD_DRIVER21<T>,
 *                                                       public virtual IMED_FIELD_WRONLY_DRIVER<T> {
 *   (+) MED_FIELD_WRONLY_DRIVER21();
 *   (+) template <class INTERLACING_TAG> MED_FIELD_WRONLY_DRIVER21
 *              (const string & fileName, FIELD<T, INTERLACING_TAG> * ptrField);
 *   (+) MED_FIELD_WRONLY_DRIVER21(const MED_FIELD_WRONLY_DRIVER21 & fieldDriver);
 *   (+) virtual ~MED_FIELD_WRONLY_DRIVER21();
 *   (+) void write(void) const throw (MEDEXCEPTION);
 *   (+) void read (void) throw (MEDEXCEPTION);
 *  }
 *  template <class T> class MED_FIELD_RDWR_DRIVER21 : public MED_FIELD_RDONLY_DRIVER21<T>,
 *                           public MED_FIELD_WRONLY_DRIVER21<T>, public IMED_FIELD_RDWR_DRIVER<T> {
 *   (+) MED_FIELD_RDWR_DRIVER21();
 *   (+) template <class INTERLACING_TAG> MED_FIELD_RDWR_DRIVER21
 *              (const string & fileName, FIELD<T, INTERLACING_TAG> * ptrField);
 *   (+) MED_FIELD_RDWR_DRIVER21(const MED_FIELD_RDWR_DRIVER21 & fieldDriver);
 *   (+) ~MED_FIELD_RDWR_DRIVER21();
 *   (+) void write(void) const throw (MEDEXCEPTION);
 *   (+) void read (void) throw (MEDEXCEPTION);
 *  }
 */
void MEDMEMTest_testMedFieldDriver21()
{
  FIELD<int> *aField                = new FIELD<int> ();
  FIELD<int> *aField_1              = new FIELD<int> ();
  FIELD<double> *aField_2           = new FIELD<double> ();
  string filename_rd                = getResourceFile("pointe.med");
  string filenameWithOutFileds      = getResourceFile("Mistrat.med");
  string fileldnotexist             = "anyfield";
  string fieldname                  = "fieldnodeint";
  string fieldname_cpy              = fieldname + "_cpy";
  string fileNotExist_rd            = "notExist.med";
  string emptyfilename              = "";

  string filename_wr                = makeTmpFile("myWrField_pointe21.med", filename_rd);
  string fileNotExist_wr            = "/path_not_exist/file_not_exist.med";
  string emptyfile_wr               = makeTmpFile("myWrField_pointe_empty21.med");
  string other_file                 = getResourceFile("fra.med");
  string other_file_wr              = makeTmpFile("myWRfra.med", other_file);

  string filename_rdwr              = makeTmpFile("myRdWrField_pointe21.med", filename_rd);
  string emptyfile_rdwr             = makeTmpFile("myRdWrField_pointe_empty21.med");
  string fieldnameDouble            = "fieldnodedouble";
  string fieldnameDouble_cpy        = fieldnameDouble + "_cpy";

  // To remove tmp files from disk
  MEDMEMTest_TmpFilesRemover aRemover;
  aRemover.Register(filename_wr);
  aRemover.Register(emptyfile_wr);
  aRemover.Register(other_file_wr);
  aRemover.Register(filename_rdwr);
  aRemover.Register(emptyfile_rdwr);

  //--------------------------Test READ ONLY part------------------------------//

  /////////////////////////////////////
  //  TEST1: Open not existing file  //
  /////////////////////////////////////

  //Creation Invalid Read Only MedFieldDriver21 (file not exist)
  MED_FIELD_RDONLY_DRIVER21<int> *aInvalidMedRdFieldDriver21_1 =
    new MED_FIELD_RDONLY_DRIVER21<int>(fileNotExist_rd, aField);
  //Trying open not existing file
  CPPUNIT_ASSERT_THROW(aInvalidMedRdFieldDriver21_1->open(), MEDEXCEPTION);

  //////////////////////////////////////////////
  //  TEST2: Open file with empty file name  ///
  //////////////////////////////////////////////

  //Creation Invalid Read Only MedFieldDriver21 (empty file name)
  MED_FIELD_RDONLY_DRIVER21<int> *aInvalidMedRdFieldDriver21_2 =
    new MED_FIELD_RDONLY_DRIVER21<int>(emptyfilename, aField);
  //Trying file with empty name
  CPPUNIT_ASSERT_THROW(aInvalidMedRdFieldDriver21_2->open(), MEDEXCEPTION);

  /////////////////////////////////////////////////////
  //  TEST3: Reading field from file without fields  //
  /////////////////////////////////////////////////////
  MED_FIELD_RDONLY_DRIVER21<int> *aInvalidMedRdFieldDriver21_3 =
    new MED_FIELD_RDONLY_DRIVER21<int>(filenameWithOutFileds, aField);
  aInvalidMedRdFieldDriver21_3->open();
  aInvalidMedRdFieldDriver21_3->setFieldName(fieldname);
  //Trying read field from file
  CPPUNIT_ASSERT_THROW(aInvalidMedRdFieldDriver21_3->read(), MEDEXCEPTION);
  aInvalidMedRdFieldDriver21_3->close();

  ////////////////////////
  //  TEST4: Main test  //
  ////////////////////////
  //Creation correct Read Only MedFieldDriver21
  MED_FIELD_RDONLY_DRIVER21<int> *aMedRdFieldDriver21 =
    new MED_FIELD_RDONLY_DRIVER21<int>(filename_rd, aField);

  //Check driver
  CPPUNIT_ASSERT(aMedRdFieldDriver21);

  //Trying read field before open file
  CPPUNIT_ASSERT_THROW(aMedRdFieldDriver21->read(),MEDEXCEPTION);

  //Test open() method
  try
  {
    aMedRdFieldDriver21->open();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }

//#ifdef ENABLE_FORCED_FAILURES
  //Trying open file secondary.
  CPPUNIT_ASSERT_THROW(aMedRdFieldDriver21->open(), MEDEXCEPTION);
  // (BUG) No exception in this case
//#endif

  //Trying read field form file if it name is empty
  CPPUNIT_ASSERT_THROW(aMedRdFieldDriver21->read(), MEDEXCEPTION);

  //Test setFieldName() and getFieldName()
  try
  {
    aMedRdFieldDriver21->setFieldName(fileldnotexist);
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }
  CPPUNIT_ASSERT_EQUAL(fileldnotexist, aMedRdFieldDriver21->getFieldName());

  //Trying read not existing field from file
  CPPUNIT_ASSERT_THROW(aMedRdFieldDriver21->read(), MEDEXCEPTION);

  //Test read() method
  aMedRdFieldDriver21->setFieldName(fieldname);
  try
  {
    aMedRdFieldDriver21->read();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }

  //Test write() method for READ ONLY driver
  CPPUNIT_ASSERT_THROW(aMedRdFieldDriver21->write(), MEDEXCEPTION);

  //Test close() method
  try
  {
    aMedRdFieldDriver21->close();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }

  //Default constructor
  MED_FIELD_RDONLY_DRIVER21<int> aMedRdFieldDriver21Cpy_1;

  //Test (void operator =) defined in GENDRIVER class in MEDMEM_GenDriver.hxx
  aMedRdFieldDriver21Cpy_1 = *aMedRdFieldDriver21;

  //Test (bool operator ==) defined GENDRIVER class in MEDMEM_GenDriver.hxx
  CPPUNIT_ASSERT(aMedRdFieldDriver21Cpy_1 ==  *aMedRdFieldDriver21);

  //Test copy constructor
  MED_FIELD_RDONLY_DRIVER21<int> aMedRdFieldDriver21Cpy_2 (*aMedRdFieldDriver21);
  CPPUNIT_ASSERT_EQUAL(aMedRdFieldDriver21Cpy_2, *aMedRdFieldDriver21);

  //Test (friend ostream & operator <<) defined GENDRIVER class in MEDMEM_GenDriver.hxx
  ostringstream rostr1, rostr2;
  rostr1<<aMedRdFieldDriver21Cpy_1;
  rostr2<<aMedRdFieldDriver21Cpy_2;
  CPPUNIT_ASSERT(rostr1.str() != "");
  CPPUNIT_ASSERT(rostr1.str() == rostr2.str());


  //--------------------------Test WRITE ONLY part------------------------------//

  /////////////////////////////////////
  //  TEST1: Open not existing file  //
  /////////////////////////////////////

  //Creation Invalid Write Only MedFieldDriver21 (file not exist)
  MED_FIELD_WRONLY_DRIVER21<int> *aInvalidMedWrFieldDriver21_1 =
    new MED_FIELD_WRONLY_DRIVER21<int>(fileNotExist_wr, aField_1);
  //Trying open not existing file
  CPPUNIT_ASSERT_THROW(aInvalidMedWrFieldDriver21_1->open(), MEDEXCEPTION);

  /////////////////////////////////////////////
  //  TEST2: Open file with empty file name  //
  /////////////////////////////////////////////
  //Creation Invalid Write Only MedFieldDriver21 (empty file name)
  MED_FIELD_WRONLY_DRIVER21<int> *aInvalidMedWrFieldDriver21_2 =
    new MED_FIELD_WRONLY_DRIVER21<int>(emptyfilename, aField_1);
  //Trying open not existing file and file with empty name
  CPPUNIT_ASSERT_THROW(aInvalidMedWrFieldDriver21_2->open(), MEDEXCEPTION);

  ///////////////////////////////////////////////////////
  //  TEST3: Writing field in empty file without mesh  //
  ///////////////////////////////////////////////////////
  //Creation Invalid Write Only MedFieldDriver21
   MED_FIELD_WRONLY_DRIVER21<int> *aInvalidMedWrFieldDriver21_3 =
     new MED_FIELD_WRONLY_DRIVER21<int>(emptyfile_wr, aField);

  aInvalidMedWrFieldDriver21_3->open();
//#ifdef ENABLE_FAULTS
  CPPUNIT_ASSERT_THROW(aInvalidMedWrFieldDriver21_3->write(), MEDEXCEPTION);
  //=>Segmentation fault in this case
//#endif

  //////////////////////////////////////////////
  //  TEST4: Writing field in the other file  //
  //////////////////////////////////////////////

  //Creation Invalid Write Only MedFieldDriver21
  MED_FIELD_WRONLY_DRIVER21<int> *aInvalidMedWrFieldDriver21_4 =
    new MED_FIELD_WRONLY_DRIVER21<int>(other_file_wr, aField);
  aInvalidMedWrFieldDriver21_4->open();
//#ifdef ENABLE_FAULTS
  CPPUNIT_ASSERT_THROW(aInvalidMedWrFieldDriver21_4->write(), MEDEXCEPTION);
  //=>Segmentation fault in this case
//#endif

  ////////////////////////
  //  TEST5: Main test  //
  ////////////////////////

  //Creation correct Write Only MedFieldDriver21
  MED_FIELD_WRONLY_DRIVER21<int> *aMedWrFieldDriver21 =
    new MED_FIELD_WRONLY_DRIVER21<int>(filename_wr, aField);

  //Check driver
  CPPUNIT_ASSERT(aMedWrFieldDriver21);

  //Trying write field before open file
//#ifdef ENABLE_FORCED_FAILURES
  CPPUNIT_ASSERT_THROW(aMedWrFieldDriver21->write(),MEDEXCEPTION);
  // (BUG) No exception in this case
//#endif

  //Test open() method
  try
  {
    aMedWrFieldDriver21->open();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }

//#ifdef ENABLE_FORCED_FAILURES
  //Trying open file secondary.
  CPPUNIT_ASSERT_THROW(aMedWrFieldDriver21->open(), MEDEXCEPTION);
  // (BUG) No exception in this case
//#endif

  //Test setFieldName() and getFieldName
  aField->setName(fieldname_cpy);
  try
  {
    aMedWrFieldDriver21->setFieldName(fieldname_cpy);
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }
  CPPUNIT_ASSERT_EQUAL(fieldname_cpy, aMedWrFieldDriver21->getFieldName());

//#ifdef ENABLE_FAULTS
  //Test write() method
  try
  {
    aMedWrFieldDriver21->write();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }
  //=>Segmentation fault in this case
//#endif

  //Test read() method for Write only part
  CPPUNIT_ASSERT_THROW(aMedWrFieldDriver21->read(),MEDEXCEPTION);

  //Test close() method
  try
  {
    aMedWrFieldDriver21->close();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }

  //Default constructor
  MED_FIELD_WRONLY_DRIVER21<int> aMedWrFieldDriver21Cpy_1;

  //Test (void operator =) defined in GENDRIVER class
  //aMedWrFieldDriver21Cpy_1 = *aMedWrFieldDriver21;

  //Test (bool operator ==) defined in GENDRIVER class
  CPPUNIT_ASSERT(aMedWrFieldDriver21Cpy_1.GENDRIVER::operator==(*aMedWrFieldDriver21));

  //Test copy constructor
  MED_FIELD_WRONLY_DRIVER21<int> aMedWrFieldDriver21Cpy_2 (*aMedWrFieldDriver21);
  CPPUNIT_ASSERT_EQUAL(aMedWrFieldDriver21Cpy_2, *aMedWrFieldDriver21);

  //Test (friend ostream & operator <<) defined GENDRIVER class in MEDMEM_GenDriver.hxx
  ostringstream wostr1, wostr2;
  wostr1 << aMedWrFieldDriver21Cpy_1;
  wostr2 << aMedWrFieldDriver21Cpy_2;
  CPPUNIT_ASSERT(wostr1.str() != "");
  CPPUNIT_ASSERT(wostr1.str() == wostr2.str());


  //--------------------------Test READ/WRITE part------------------------------//

  /////////////////////////////////////
  //  TEST1: Open not existing file  //
  /////////////////////////////////////

  //Creation Invalid Read/Write MedFieldDriver21 (file not exist)
  MED_FIELD_RDWR_DRIVER21<int> *aInvalidMedRdWrFieldDriver21_1 =
    new MED_FIELD_RDWR_DRIVER21<int>(fileNotExist_wr, aField_1);
  //Trying open not existing file
  CPPUNIT_ASSERT_THROW(aInvalidMedRdWrFieldDriver21_1->open(), MEDEXCEPTION);

  /////////////////////////////////////////////
  //  TEST2: Open file with empty file name  //
  /////////////////////////////////////////////
  //Creation Invalid Read/Write MedFieldDriver21 (empty file name)
  MED_FIELD_RDWR_DRIVER21<int> *aInvalidMedRdWrFieldDriver21_2 =
    new MED_FIELD_RDWR_DRIVER21<int>(emptyfilename, aField_1);
  //Trying open not existing file and file with empty name
  CPPUNIT_ASSERT_THROW(aInvalidMedRdWrFieldDriver21_2->open(), MEDEXCEPTION);

  /////////////////////////////////////////////////////
  //  TEST3: Reading field from file without fields  //
  /////////////////////////////////////////////////////
  MED_FIELD_RDWR_DRIVER21<int> *aInvalidMedRdWrFieldDriver21_3 =
    new MED_FIELD_RDWR_DRIVER21<int>(filenameWithOutFileds, aField_1);
  aInvalidMedRdWrFieldDriver21_3->open();
  aInvalidMedRdWrFieldDriver21_3->setFieldName(fieldname);
  //Trying read field from file
  CPPUNIT_ASSERT_THROW(aInvalidMedRdWrFieldDriver21_3->read(), MEDEXCEPTION);
  aInvalidMedRdWrFieldDriver21_3->close();

  ///////////////////////////////////////////////////////
  //  TEST4: Writing field in empty file without mesh  //
  ///////////////////////////////////////////////////////
  //Creation Invalid Read/Write MedFieldDriver21
   MED_FIELD_RDWR_DRIVER21<int> *aInvalidMedRdWrFieldDriver21_4 =
     new MED_FIELD_RDWR_DRIVER21<int>(emptyfile_rdwr, aField);

  aInvalidMedRdWrFieldDriver21_4->open();
//#ifdef ENABLE_FAULTS
  CPPUNIT_ASSERT_THROW(aInvalidMedRdWrFieldDriver21_4->write(), MEDEXCEPTION);
  //=>Segmentation fault in this case
//#endif

  //////////////////////////////////////////////
  //  TEST6: Writing field in the other file  //
  //////////////////////////////////////////////
  //Creation Invalid Read/Write MedFieldDriver21
  MED_FIELD_RDWR_DRIVER21<int> *aInvalidMedRdWrFieldDriver21_5 =
    new MED_FIELD_RDWR_DRIVER21<int>(other_file_wr, aField);
  aInvalidMedRdWrFieldDriver21_5->open();
//#ifdef ENABLE_FAULTS
  CPPUNIT_ASSERT_THROW(aInvalidMedRdWrFieldDriver21_5->write(), MEDEXCEPTION);
  //=>Segmentation fault in this case
//#endif

  ////////////////////////
  //  TEST7: Main test  //
  ////////////////////////

  //Creation correct Read/Write MedFieldDriver21
  MED_FIELD_RDWR_DRIVER21<double> *aMedRdWrFieldDriver21 =
    new MED_FIELD_RDWR_DRIVER21<double>(filename_rdwr, aField_2);

  //Check driver
  CPPUNIT_ASSERT(aMedRdWrFieldDriver21);

  //Trying read/write field before open file
  CPPUNIT_ASSERT_THROW(aMedRdWrFieldDriver21->read(),MEDEXCEPTION);
//#ifdef ENABLE_FORCED_FAILURES
  CPPUNIT_ASSERT_THROW(aMedRdWrFieldDriver21->write(),MEDEXCEPTION);
  //(BUG) No exception in this case
//#endif

  //Test open() method
  try
  {
    aMedRdWrFieldDriver21->open();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }

//#ifdef ENABLE_FORCED_FAILURES
  //Trying open file secondary.
  CPPUNIT_ASSERT_THROW(aMedRdWrFieldDriver21->open(), MEDEXCEPTION);
  // (BUG) No exception in this case
//#endif

  //Trying read field from file if field name is empty
  CPPUNIT_ASSERT_THROW(aMedRdFieldDriver21->read(), MEDEXCEPTION);

  //Test setFieldName() and getFieldName
  try
  {
    aMedRdWrFieldDriver21->setFieldName(fileldnotexist);
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }
  CPPUNIT_ASSERT_EQUAL(fileldnotexist, aMedRdWrFieldDriver21->getFieldName());

  //Trying read not existing field from file
  CPPUNIT_ASSERT_THROW(aMedRdWrFieldDriver21->read(), MEDEXCEPTION);

  //Test read() method
  aMedRdWrFieldDriver21->setFieldName(fieldnameDouble);
  try
  {
    aMedRdWrFieldDriver21->read();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }

  //Trying write field in the file with empty name
  aField_2->setName(emptyfilename);
  aMedRdWrFieldDriver21->setFieldName(emptyfilename);
  CPPUNIT_ASSERT_THROW(aMedRdWrFieldDriver21->write(), MEDEXCEPTION);

  //Test write() method
  aField_2->setName(fieldnameDouble_cpy);
  aMedRdWrFieldDriver21->setFieldName(fieldnameDouble_cpy);
//#ifdef ENABLE_FAULTS
  try
  {
    aMedRdWrFieldDriver21->write();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }
  //=>Segmentation fault in this case
//#endif

  //Test close() method
  try
  {
    aMedRdWrFieldDriver21->close();
  }
  catch(MEDEXCEPTION &e)
  {
    CPPUNIT_FAIL(e.what());
  }
  catch( ... )
  {
    CPPUNIT_FAIL("Unknown exception");
  }

  //Default constructor
  MED_FIELD_RDWR_DRIVER21<double> aMedRdWrFieldDriver21Cpy_1;

  //Test (void operator =) defined in GENDRIVER class
  //aMedRdWrFieldDriver21Cpy_1 = *aMedRdWrFieldDriver21;

  //Test (bool operator ==) defined in GENDRIVER class
  CPPUNIT_ASSERT(aMedRdWrFieldDriver21Cpy_1.GENDRIVER::operator==(*aMedRdWrFieldDriver21));

  //Test copy constructor
  MED_FIELD_RDWR_DRIVER21<double> aMedRdWrFieldDriver21Cpy_2 (*aMedRdWrFieldDriver21);
  CPPUNIT_ASSERT_EQUAL(aMedRdWrFieldDriver21Cpy_2, *aMedRdWrFieldDriver21);

  //Test (friend ostream & operator <<) defined GENDRIVER class in MEDMEM_GenDriver.hxx
  ostringstream rwostr1, rwostr2;
  rwostr1 << aMedRdWrFieldDriver21Cpy_1;
  rwostr2 << aMedRdWrFieldDriver21Cpy_2;
  CPPUNIT_ASSERT(rwostr1.str() != "");
  CPPUNIT_ASSERT(rwostr1.str() == rwostr2.str());

  //Delete all objects
  delete aField;
  delete aField_1;
  delete aField_2;

  delete aInvalidMedRdFieldDriver21_1;
  delete aInvalidMedRdFieldDriver21_2;
  delete aInvalidMedRdFieldDriver21_3;
  delete aMedRdFieldDriver21;

  delete aInvalidMedWrFieldDriver21_1;
  delete aInvalidMedWrFieldDriver21_2;
  delete aInvalidMedWrFieldDriver21_3;
  delete aInvalidMedWrFieldDriver21_4;
  delete aMedWrFieldDriver21;

  delete aInvalidMedRdWrFieldDriver21_1;
  delete aInvalidMedRdWrFieldDriver21_2;
  delete aInvalidMedRdWrFieldDriver21_3;
  delete aInvalidMedRdWrFieldDriver21_4;
  delete aInvalidMedRdWrFieldDriver21_5;
  delete aMedRdWrFieldDriver21;
}

int main (int argc, char** argv)
{
  MEDMEMTest_testMedFieldDriver21();
}
