// Copyright (C) 2007-2008  CEA/DEN, EDF R&D
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
// See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
// ---
//
// File   : GHS3DPRLPlugin_GHS3DPRL_i.hxx
// Author : Christian VAN WAMBEKE (CEA) (from Hexotic plugin Lioka RAZAFINDRAZAKA)
//
// ---

#ifndef _GHS3DPRLPlugin_GHS3DPRL_I_HXX_
#define _GHS3DPRLPlugin_GHS3DPRL_I_HXX_

#include <SALOMEconfig.h>
#include CORBA_SERVER_HEADER(GHS3DPRLPlugin_Algorithm)
#include CORBA_SERVER_HEADER(SALOME_Exception)

#include "SMESH_3D_Algo_i.hxx"
#include "GHS3DPRLPlugin_GHS3DPRL.hxx"

// ======================================================
// GHS3DPRL 3d algorithm
// ======================================================
class GHS3DPRLPlugin_GHS3DPRL_i:
  public virtual POA_GHS3DPRLPlugin::GHS3DPRLPlugin_GHS3DPRL,
  public virtual SMESH_3D_Algo_i
{
public:
  // Constructor
  GHS3DPRLPlugin_GHS3DPRL_i (PortableServer::POA_ptr thePOA,
			     int                     theStudyId,
			     ::SMESH_Gen*            theGenImpl );
  // Destructor
  virtual ~GHS3DPRLPlugin_GHS3DPRL_i();

  // Get implementation
  ::GHS3DPRLPlugin_GHS3DPRL* GetImpl();
};

#endif
