/*
 * Copyright (C) 1993-2004 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 * 
 * $Id: formmould.cpp,v 1.27 2005/05/08 16:11:08 jeremy_laine Exp $
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "formmould.h"
#include "widgetprofile.h"
#include "widgetprofilevert.h"
#include "sailmould.h"

#include <qhgroupbox.h>
#include <qvgroupbox.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qspinbox.h>


/** The constructor.
 *
 * @param parent the parent dialog
 * @param mouldptr pointer to the CSailMould
 */
CFormMould::CFormMould( QWidget *parent, CSailMould *mouldptr )
        : QDialog(parent, 0, true)
{
    // we store the pointer to the CSailMould so we can update it when
    // the user clicks OK
    sailmould = mouldptr;

    setSizeGripEnabled( TRUE );
    QGridLayout* CFormMouldLayout = new QGridLayout( this, 1, 1, 11, 6 );

    // Add the buttons at the bottom of the screen
    QHBoxLayout* buttonsLayout = new QHBoxLayout( 0, 0, 6 );

    buttonHelp = new QPushButton( this );
    buttonHelp->setAutoDefault( TRUE );
    buttonsLayout->addWidget( buttonHelp );
    buttonsLayout->addItem( new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum ) );

    buttonOk = new QPushButton( this );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    buttonsLayout->addWidget( buttonOk );

    buttonCancel = new QPushButton( this );
    buttonCancel->setAutoDefault( TRUE );
    buttonsLayout->addWidget( buttonCancel );

    CFormMouldLayout->addMultiCellLayout( buttonsLayout, 1, 1, 0, 1 );


    // add vertical repartition   
    widgetVert = new CWidgetProfileVert( this, sailmould, tr("Vertical repartition") );
    CFormMouldLayout->addWidget( widgetVert, 0, 0 );

    // add 3 profile areas and bind them to their respective profiles
    QFrame* frmProfile = new QFrame( this );
    frmProfile->setFrameShape( QFrame::NoFrame );
    frmProfile->setFrameShadow( QFrame::Raised );
    QGridLayout* frmProfileLayout = new QGridLayout( frmProfile, 1, 1, 0, 0 );
    CFormMouldLayout->addWidget( frmProfile, 0, 1 );

    prfTop = new CWidgetProfile( frmProfile, &sailmould->profile[2], tr("Top profile"), widgetVert );
    prfMiddle = new CWidgetProfile( frmProfile, &sailmould->profile[1], tr("Middle profile"), widgetVert );
    prfBottom = new CWidgetProfile( frmProfile, &sailmould->profile[0], tr("Bottom profile"), widgetVert );
    frmProfileLayout->addWidget( prfTop, 0, 0 );
    frmProfileLayout->addWidget( prfMiddle, 1, 0 );
    frmProfileLayout->addWidget( prfBottom, 2, 0 );

    // init
    languageChange();
    resize( QSize(487, 555).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // setting the range for profile spin boxes is done in widgetprofile.cpp
    prfBottom->spinDepth->setMinValue( 0 );
    
    /* we hide the bottom profile's leech and luff spin boxes and labels
    prfBottom->lblLeech->hide();
    prfBottom->lblLuff->hide();
    prfBottom->spinLeech->hide();
    prfBottom->spinLuff->hide();
    */

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}


/**  Sets the strings of the subwidgets using the current
 *  language.
 */
void CFormMould::languageChange()
{
    setCaption( tr( "Sail mould" ) );
    buttonHelp->setText( tr( "&Help" ) );
    buttonOk->setCaption( QString::null );
    buttonOk->setText( tr( "&OK" ) );
    buttonCancel->setText( tr( "&Cancel" ) );
}

