/*
 * Copyright (C) 1993-2004 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 *
 * $Id: formmain.h,v 1.41 2004/10/26 19:30:36 jeremy_laine Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FORMMAIN_H
#define FORMMAIN_H

#include <qdialog.h>
#include <qmessagebox.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qpaintdevicemetrics.h>

#include "sail.h"
#include "saildef.h"

// forward definitions
class QApplication;
class QMenuBar;
class QGridLayout;
class QPopupMenu;
class QStatusBar;
class QTabWidget;
class QTranslator;
class CSailViewerPanel;
class CPrefs;
class CSailApp;


/** The main dialog of the Sailcut application.
 *
 * @version $Id: formmain.h,v 1.41 2004/10/26 19:30:36 jeremy_laine Exp $
 */
class CFormMain : public QDialog
{
    Q_OBJECT

public:
    // construction, destruction
    CFormMain(CSailApp *myApp, QWidget *parent = 0, bool modal = false);

    void show(const QString newname = QString::null);
    void setSailDef(const CSailDef newdef);

protected:
    void closeEvent( QCloseEvent * e);
    void keyPressEvent ( QKeyEvent * e );
    void makeMenuMru();
    void fileAccess(QString event, QString file);


    // slots
protected slots:

    virtual void languageChange();

    virtual void slotAbout();
    virtual void slotAboutQt();

    virtual void slotDef();
    virtual void slotExportDXF();
    virtual void slotExportTXT();
    virtual void slotExportXML();
    virtual void slotExportFlatCarlson();
    virtual void slotExportFlatDXF();
    virtual void slotExportFlatTXT();
    virtual void slotExportFlatXML();
    virtual void slotMould();
    virtual void slotNew();
    virtual void slotOpen();
    virtual void slotOpenRecent(int);
    virtual void slotRig();
    virtual void slotSave();
    virtual void slotSaveAs();

    virtual void slotPrintData();
    virtual void slotPrintDwg();
    virtual void slotPrintDev();

    virtual void slotHandbook();

    virtual void slotLanguage(int);

    // member variables
protected:
    /** the location of the Sailcut Handbook */
    QString handbook;

    /** the application */
    CSailApp *app;
    /** the user preferences */
    CPrefs *prefs;

    /** the menu bar */
    QMenuBar* menubar;
    /** the Most Recently Used files menu */
    QPopupMenu *menuRecent;

    /** the widgets of each view */
    vector<CSailViewerPanel *> panel;
    /** the tab widget */
    QTabWidget *tabs;

    /** the status bar */
    QStatusBar* statusbar;

    /** the definition of the current sail */
    CSailDef saildef;
    /** the sail */
    CSail sail;
    /** the developped sail */
    CSail flatsail;
    /** the display version of the flat sail */
    CSail dispsail;
    /** the current filename */
    QString filename;

};

#endif
