/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : font.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __FONT_H__
#define __FONT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _FONT_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _FONT_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */

/* sagfont */
int DrawTextVector (GtkWidget *widget, DIMENSION *a, long color);
int sfd_open(void);
int sfd_search(char *moji, SAG_FONT *FontData);
int char_scale(double scale, SAG_FONT *FontData);
int char_offset(double x, double y, SAG_FONT *FontData);
int char_rolling(double angle, SAG_FONT *FontData);
int char_draw(GtkWidget *widget, SAG_FONT *font, long color);
int saglen(char *text);
double CulcTextVector (GtkWidget *widget, DIMENSION *a);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __FONT_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : font.h
 * ====================================================================
 */
