/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : fileselection.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2002/06/25
 * ====================================================================
 */


#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

/*
 * File selection dialog
 */
#include <gtk/gtk.h>
#include <string.h>

#define _FILESELECT_
#include "fileselect.h"



/* 
 * Get the selected filename and print it to the console 
 */
void file_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{
	char *sTempFile;
	int i;


	/* --- Get the name --- */
	sTempFile = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));

	//g_print ("file_ok_sel : Getting %s\n", sTempFile);

	i = strlen (sTempFile);
	if (sTempFile[i-1] == '/') {
		//g_print("Last char is /\n");
		return;
	}



	/* --- Allocate space and save it. --- */
	sFilename = g_malloc (sizeof (char) * (strlen (sTempFile) + 1));
	strcpy (sFilename, sTempFile);

	/* --- Destroy the file selection --- */
	gtk_widget_destroy (filew);
}



void file_cancel_sel (GtkWidget *w, GtkFileSelection *fs)
{
	//g_print ("file_cancel_sel : Getting \n");
	sFilename = NULL;
	/* --- Destroy the file selection --- */
	gtk_widget_destroy (filew);
}



/*
 * DestroyDialog
 *
 * Destroy the dialog (obvious, eh?) but also remove the
 * grab and close the modal. 
 */
int DestroyDialog (GtkWidget *widget, gpointer *data)
{
	//g_print ("DestroyDialog : widget destroyed\n");
	gtk_grab_remove (widget);
	gtk_main_quit ();
	return (FALSE);
}



/*
 * GetFilename 
 */
char *GetFilename (char *sTitle, char *def_str)
{

	/* --- If the value is saved from last time we used the dialog,
	 * --- free the memory
	 */
	if (sFilename) {
		g_free (sFilename);
		sFilename = NULL;
	}

	/* --- Create a new file selection widget --- */
	filew = gtk_file_selection_new (sTitle);

	/* etc Button hide */
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(filew));

	/* --- If it's destroyed --- */
	gtk_signal_connect (GTK_OBJECT (filew), "destroy",
			(GtkSignalFunc) DestroyDialog, &filew);

	/* --- Connect the ok_button to file_ok_sel function  --- */
	gtk_signal_connect (
			GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
			"clicked", (GtkSignalFunc) file_ok_sel, filew );
	
	/* --- Connect the cancel_button to destroy the widget	--- */
	gtk_signal_connect (
			 GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
			 "clicked", (GtkSignalFunc) file_cancel_sel, filew);


	//gtk_file_selection_complete(GTK_FILE_SELECTION(filew), "*.sgy");


	/* --- Lets set the filename, as if this were a save 
	 *	   dialog, and we are giving a default filename 
	 */
	gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), def_str);
	
	/* --- Of course, we show it --- */
	gtk_widget_show (filew);

	/* --- Make sure we keep the focus --- */
	gtk_grab_add (filew);

	gtk_main ();

	return (sFilename);
}





#ifdef TEST
/*
 * ButtonClicked
 *
 * Get a filename from the file selection dialog.
 */
void ButtonClicked (GtkWidget *widget, gpointer data)
{
    /* --- Pass in a title of "hey, hey, hey" --- */
    char *sFile = GetFilename ("Hey, hey, hey", "/home/yutaka/Develop/sagcad4/sgy/");

    g_print ("ButtonClicked : Got %s\n", sFile);
}



/*
 * CloseApp
 *
 * The window is closing down, end the gtk loop
 */
int CloseApp (GtkWidget *widget, gpointer *data)
{
    g_print ("CloseApp : \n");
    gtk_main_quit ();
    return (FALSE);
}



/*
 * main
 *
 * Program begins here
 */
int main (int argc, char *argv[])
{
    GtkWidget *window;
    GtkWidget *frame;          

    /* --- GTK locale setting --- */
	gtk_set_locale();

    /* --- GTK initialization --- */
    gtk_init (&argc, &argv);

    /* --- Create the top window --- */
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

    /* --- Give the window a title. --- */
    gtk_window_set_title (GTK_WINDOW (window), "Frame example");

    /* --- Set the window size. --- */
    gtk_widget_set_usize (window, 250, 250);

    /* --- Need to know when app is being closed --- */
    gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                        GTK_SIGNAL_FUNC (CloseApp), NULL);

    /*
     * --- Create the start button with smilely face on it
     */
    frame = gtk_button_new_with_label ("File dialog");

    gtk_signal_connect (GTK_OBJECT (frame), "clicked",
                        GTK_SIGNAL_FUNC (ButtonClicked), NULL);

    gtk_container_add (GTK_CONTAINER (window), frame);

    /*
     * --- Make everything visible
     */

    gtk_widget_show (frame);
    gtk_widget_show (window);

    gtk_main ();
    return (0);
}
#endif



/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : fileselection.c
 * ====================================================================
 */
