/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : etc.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2002 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2003/07/18
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <langinfo.h>
#include <iconv.h>
#include <locale.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "List_font.h"
#define _ETC_
#include "etc.h"





/* -------------------------------------------------------------------
 * ʸ str  nܤˤ split_word ΰ֤֤
 *	
 * "פ˰Ϥޤ줿,Ͽʤ
 *	
 */
int split_word_point(char *str, char split_word, int n)
{
	int point = 1;
	int counter = 0;
	int i;

	i = 0;
	while (*str) {
		if (*str == '\"' && i == 1)	i = 0;
		else if (*str == '\"' && i == 0)	i = 1;

		if (*str == split_word && i == 0) {
			counter++;
			if (n == counter) {
				return(point);
			}
		}
		point++;
		str++;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * ʸ str  split_word Ĥ뤫֤
 *	
 * "פ˰Ϥޤ줿,Ͽʤ
 *	
 */
int split_word_num(char *str, char split_word)
{
	int counter = 0;
	int i;

	i = 0;
	while (*str) {
		if (*str == '\"' && i == 1)	i = 0;
		else if (*str == '\"' && i == 0)	i = 1;
		
		if (*str == split_word && i == 0) {
			counter++;
		}
		str++;
	}
	return(counter);
}



/* -------------------------------------------------------------------
 * ʸ str κ num ʸФʸ ret ֤
 *	
 * "פ˰Ϥޤ줿,Ͽʤ
 *	
 */
int strLeft(char *str, int num, char *ret)
{
	int counter = 1;
	if ((int) strlen(str) < num)	return(0);

	while (counter <= num) {
		*ret = *str;
		counter++;
		str++;
		ret++;
	}
	*ret = '\0';
	return(1);
}



/* -------------------------------------------------------------------
 * ʸ str κ midܤ numʸФ
 * ʸ ret ֤
 *	
 * "פ˰Ϥޤ줿,Ͽʤ
 *	
 */
int strMid(char *str, int mid, int num, char *ret)
{
	int counter = 1;
	if ((int)strlen(str) < mid)	return(-1 * ((int)strlen(str)));
	
	str = str + (mid - 1);
	while (*str) {
		if (*str == '\0')	return (-1);
		*ret = *str;
		counter++;
		str++;
		ret++;
		if (counter > num) {
			*ret = '\0';
			return(1);
		}
	}
	*ret = '\0';
	return(-1);
}



/* -------------------------------------------------------------------
 * ʸ str α num ʸФʸ ret ֤
 *	
 * "פ˰Ϥޤ줿,Ͽʤ
 *	
 */
int strRight(char *str, int num, char *ret)
{
	if ((int)strlen(str) < num)	return(0);
	str = str + (strlen(str) - num);
	while (*str) {
		*ret = *str;
		str++;
		ret++;
	}
	*ret = '\0';
	return(1);
}



/* -------------------------------------------------------------------
 * ץåʸ (split_word) Ƕڤơǡ¤Ǥʸ (str) 
 * num ܤΥǡʸФʸ (ret) ֤
 *	
 * 1,2,3,4,5,6,7
 *	1 2 3 4 5 6
 * 1234567890123
 *	
 *	
 * "פ˰Ϥޤ줿,Ͽʤ
 *	
 */
int LineDataSplit(char *str, char split_word, int num, char *ret)
{
	char DumyStr[256], StrStr[256];
	int Len, Split, Split_P[2];

	/* ʸ str  split_word Ĥ뤫֤ */
	Split = split_word_num(str, split_word);
	if (num	 > Split + 1 )	return -1;

	if (num == 1) {
		/* ʸ str  nܤˤ split_word ΰ֤֤ */
		Split_P[0] = split_word_point(str, split_word, 1);
		/* ʸ str κ num ʸФʸ ret ֤ */
		strLeft(str, Split_P[0] - 1, DumyStr);
	}
	else if (num > 1 && num <= Split) {
		/* ʸ str  nܤˤ split_word ΰ֤֤ */
		Split_P[0] = split_word_point(str, split_word, num - 1);
		Split_P[1] = split_word_point(str, split_word, num);
		strMid(str, Split_P[0] + 1, Split_P[1] - Split_P[0] - 1, DumyStr);
	}
	else if (num == Split + 1) {
		/* ʸ str  nܤˤ split_word ΰ֤֤ */
		Split_P[0] = split_word_point(str, split_word, num - 1);
		/* ʸ str α num ʸФʸ ret ֤ */
		strRight(str, strlen(str) - Split_P[0], DumyStr);
	}

	Len = strlen(DumyStr);
	if (DumyStr[0] == '\"' && DumyStr[Len - 1] == '\"') {
		if(Len > 2) {
			strMid(DumyStr, 2, Len - 2, StrStr);
			strcpy(ret, StrStr);
			return Split;
		}
		else {
			strcpy(ret, "");
			return Split;
		}
	}
	else {
		strcpy(ret, DumyStr);
		return Split;
	}
}



/* -------------------------------------------------------------------
 * ֤ؿ
 * 
 */
void replace(char *text, char *key, char *rep)
{
	char *p, work[2*256], a[2*256];

	strcpy(work, text);
	p = search(work, key);				/*	ΰ˥ԡ*/
	while (p != NULL) {
		if (strlen(work) > (256*2)-1) {
			work[2*256-2] = '\n';
			work[2*256-1] = '\0';
			break;
		}
		*p = '\0';
		strcpy(a, p + strlen(key)); 	/* ʸƤȥХåե˥ԡ */
		strcat(work, rep);				/* ֤ʸworkϢ뤹 */
		strcat(work, a);				/* ΰ֤õ */
		p = search(p+strlen(rep), key);
	}
	strcpy(text, work);
}



/* -------------------------------------------------------------------
 * ؿ
 * 
 */
char *search(char *text, char *key)
{
	int m, n;
	char *p;

	m = strlen(text);
	n = strlen(key);
	for (p = text ; p <= text + m - n ; p++) {
		if (strncmp(p, key, n) == 0)	/* 2ĤʸʸӤޤ */
			return (p);
	}
	return (NULL);
}



/* -------------------------------------------------------------------
 * ltrim
 * 
 */
int ltrim(char *str, char *ret)
{
	while (*str) {
		if (*str == ' ' || *str == '	' || *str == '\n' || *str == '\r') {
			str++;
		}
		else {
			*ret = *str;
			str++;
			ret++;
		}
	}
	*ret = '\0';
	return 0;
}



/* -------------------------------------------------------------------
 * եѥ̾ե̾
 *	
 * char *lpszPath	  ե̾ޤѥ̾ؤΥݥ
 * char * ե̾ؤΥݥ
 * ե̾ޤޤʤȤ""ؤΥݥ
 * [\],[/],[:]Ĥʤä硢ե̾ȤߤʤƤΤޤ֤
 *	
 * ѥ̾Ƭʸ򸡺ơ:,\,/פΤ줫Ǹ˸õ
 * ʸӤȤϡоݤʸ2Хʸ1ХʸĴ٤ɬפޤ
 *	
 * "פ˰Ϥޤ줿,Ͽʤ
 */
char *getFileName(char *lpszPath)
{
	char *lpszPtr = lpszPath;
	int charset = 0, Ret;
	int (*WHAT_KANJI)(/* unsigned */ char *str) = 0;


	Ret = Get_charset();
	if (Ret == 0) {
		charset = 2;
		WHAT_KANJI = whatKanji_sjis;
	}
	else if (Ret == 1) {
		charset = 8;
		WHAT_KANJI = whatKanji_euc;
	}

	while(*lpszPtr != '\0') {
		/* ХʸƬϥå */
		if((WHAT_KANJI((unsigned char *) lpszPtr) & charset) == charset ) {
			/* ʸ */
			lpszPtr++;
		}
		else {
			/* [\],[/],[:]򸫤Ĥ鸽+1Υݥ󥿤¸ */
			if((*lpszPtr == '\\') || (*lpszPtr == '/') || (*lpszPtr == ':')) {
				lpszPath=lpszPtr+1;
			}
		}
		/* ʸ */
		lpszPtr++;
	}
	return lpszPath;
}



/* -------------------------------------------------------------------
 * ե̾ĥҤ
 *	
 * char *lpszFileName	  ե̾ؤΥݥ
 * ʼ¹Ը塢ե̾ĥҤڤΥ
 */
void cutExtName(char *lpszFileName)
{
	char *pEnd = lpszFileName;
	char *pStart = lpszFileName;

	int charset = 0, Ret;
	int (*WHAT_KANJI)(/* unsigned */ char *str) = 0;


	Ret = Get_charset();
	if (Ret == 0) {
		charset = 2;
		WHAT_KANJI = whatKanji_sjis;
	}
	else if (Ret == 1) {
		charset = 8;
		WHAT_KANJI = whatKanji_euc;
	}


	/* ǥ쥯ȥʬκǸޤ */
	while(*pEnd != '\0') {
		/* ХʸƬϥå */
		if((WHAT_KANJI((unsigned char *) pEnd) & charset) == charset ) {
			/* ʸ */
			pEnd++;
		}
		else {
			/* [\],[/],[:]򸫤Ĥ鸽+1Υݥ󥿤¸ */
			if((*pEnd == '\\') || (*pEnd == '/') || (*pEnd == ':')) {
				pStart=pEnd+1;
			}
		}
		/* ʸ */
		pEnd++;
	}


	pEnd=lpszFileName;
	while(*pStart != '\0') {
		/* ХʸƬϥå */
		if((WHAT_KANJI((unsigned char *) pStart) & charset) == charset ) {
			/* ʸ */
			pStart++;
		}
		else {
			/* [.]򸫤Ĥ鸽+1Υݥ󥿤¸ */
			if(*pStart == '.') {
				pEnd=pStart;
			}
		}
		/* ʸ */
		pStart++;
	}


	/* ե̾˳ĥҤޤޤʤä粿⤷ʤ */
	if(pEnd == lpszFileName) {
		return;
	}
	/* ե̾ĥҤڤΥ */
	*pEnd='\0';
}



/* -------------------------------------------------------------------
 * ѥ̾ե̾
 *	
 * char *lpszPath	  ե̾ޤѥ̾ؤΥݥ
 * ʼ¹Ը塢ѥ̾ե̾ڤΥ
 *
 * ѥ̾Ƭʸ򸡺ơ:,\,/פΤ줫Ǹ˸줿Υݥ󥿤
 * '\0' 뤳Ȥǥե̾ޤ
 */
void cutFileName(char *lpszPath)
{
	char *lpszEnd = lpszPath;

	int charset = 0, Ret;
	int (*WHAT_KANJI)(/* unsigned */ char *str) = 0;


	Ret = Get_charset();
	if (Ret == 0) {
		charset = 2;
		WHAT_KANJI = whatKanji_sjis;
	}
	else if (Ret == 1) {
		charset = 8;
		WHAT_KANJI = whatKanji_euc;
	}


	while(*lpszPath != '\0') {
		/* ХʸƬϥå */
		if((WHAT_KANJI((unsigned char *) lpszPath) & charset) == charset ) {
			/* ʸ */
			lpszPath++;
		}
		else {
			/* [\],[/],[:]򸫤Ĥ鸽+1Υݥ󥿤¸ */
			if((*lpszPath == '\\') || (*lpszPath == '/') || (*lpszPath == ':')) {
				lpszEnd=lpszPath+1;
			}
		}
		/* ʸ */
		lpszPath++;
	}


	/* ѥ̾˥եޤޤʤä粿⤷ʤ */
	if(lpszEnd == lpszPath) {
		return;
	}
	/* ѥ̾ե̾ڤΥ */
	*lpszEnd='\0';
	return;
}



/* -------------------------------------------------------------------
 * ¹ԥեΥեѥ
 *	
 */
#ifdef AFTER
int GetAppPath(char *App_Path)
{
	char  szModulePath[MAX_PATH];


	/* ¹ԥեΥեѥ */
	GetModuleFileName(NULL, szModulePath, MAX_PATH);

	//ѥ̾ե̾
	//  char *lpszPath	ե̾ޤѥ̾ؤΥݥ
	//			  ʼ¹Ը塢ѥ̾ե̾ڤΥ
	//͡ʤ
	cutFileName(szModulePath);
	strcpy(App_Path, szModulePath);
	return 1;
}
#endif



/* -------------------------------------------------------------------
 * ȥ꡼फ飱ɤߤ ret ֤
 *	
 *	
 *	1 : Ԥ֤
 *	0 : ե뽪üˤ
 */
int LineRead(FILE *stream, char *ret)
{
	int i, j;
	char c, str[256];

	i = 0;
	j = 0;
	while((c = getc( stream )) != EOF) {
		/* CR ʳ */
		if (c == 0x0d) {
			// Ф
		}
		/* 1ɤ߹ߴλ */
		else if(c == 0x0a) {
			str[i] = '\0';
			strcpy(ret, str);
			return 1;
		}
		else {
			str[i] = (char)c;
			i++;
		}
		j++;
		if (j == 255) return -1;
	}
	return 0;
}



/* -------------------------------------------------------------------
 * RGB(0xrrggbb) Υ顼 (red, green, blue) Υǡʬ
 * 
 */
int color_split(struct ColorDat *a)
{
	int red, green, blue;

	/* blue */
	blue = a->rgb & 0x0000ff;
	a->blue = blue;
	/* green */
	green = a->rgb & 0x00ff00;
	green = green >> 8;
	a->green = green;
	/* red */
	red = a->rgb & 0xff0000;
	red = red >> 16;
	a->red = red;
	return 1;
}



/* ---------------------------------------------------------------------
 * (red, green, blue) Υǡ RGB(0xrrggbb) Υ顼˹
 * 
 */
long color_rgb(struct ColorDat *a)
{
	long red, green, blue;

	blue = a->blue;

	green = a->green;
	green = green << 8;

	red = a->red;
	red = red << 16;

	a->rgb = (red | green | blue);
	return (red | green | blue);
}



/* ---------------------------------------------------------------------
 * 0xrrggbb ηΥǡ "rr"  "bb" 򴹤
 * Windows(0xbbggrr) Υ顼  <-->  0xrrggbb  Ѵ
 * 
 */
long color_rb_change(long rgbcol)
{
	long color;
	long red, green, blue;

	/* red */
	red = rgbcol & 0x0000ff;
	red = red << 16;

	/* green */
	green = rgbcol & 0x00ff00;

	/* blue */
	blue = rgbcol & 0xff0000;
	blue = blue >> 16;

	color = red + green + blue;
	return color;
}



/* -------------------------------------------------------------------
 * ʸ(б 0xղ)ͤѴ
 * 
 */
int atoi16(char *str)
{
	char *hexstr;

	hexstr = strstr(str, "0x");
	if(hexstr != NULL) {
		hexstr = hexstr + 2;
		return hextoint(hexstr);
	}
	else return atoi(str);
}


/* -------------------------------------------------------------------
 * ʸͤѴ
 * 
 *  hextoint("B6119");
 */
int hextoint(char *str)
{
	int val;
	int sign;
	
	while (*str == ' ' || *str == '\t') str++;
	sign = 1;
	if (*str == '+') str++;
	else if (*str == '-') {
		sign = -1;
		str++;
	}
	val = 0;
	while ( (*str >= '0' && *str <= '9') ||
			(*str >= 'A' && *str <= 'F') ||
			(*str >= 'a' && *str <= 'f') ) {
		val <<= 4;
		if		(*str >= '0' && *str <= '9') val += *str - '0';
		else if (*str >= 'A' && *str <= 'F') val += *str - 'A' + 10;
		else								 val += *str - 'a' + 10;
		str++;
	}

	return sign == 1 ? val : -val;
}



/* -------------------------------------------------------------------
 * ʸ
 * 
 */
int HexString(long data, char *hex)
{
	int red, green, blue;
	char str[256];

	/* red */
	red = data & 0xff0000;
	red = red >> 16;
	/* green */
	green = data & 0x00ff00;
	green = green >> 8;
	/* blue */
	blue = data & 0x0000ff;

	sprintf(str, "%x", red);
	if (strlen(str) == 1) {
		sprintf(hex,"0x0%x", red);
	}
	else
		sprintf(hex,"0x%x", red);

	sprintf(str, "%x", green);
	if (strlen(str) == 1) {
		sprintf(str,"0%x", green);
	}
	else 
		sprintf(str,"%x", green);
	strcat(hex, str);

	sprintf(str, "%x", blue);
	if (strlen(str) == 1) {
		sprintf(str,"0%x", blue);
	}
	else 
		sprintf(str,"%x", blue);
	strcat(hex, str);
	return 1;
}





/* -------------------------------------------------------------------
 * log ե񤭤
 *	
 */
int LogFileOpen(char *str)
{
	/* ե򥪡ץ */ 
	if((stream_log = fopen( str, "w")) == NULL) {
//		MsgBox("LogFileOpen", "ե %s ϳޤǤ");
		return 0;
	}
	LogFileWrite("SagCAD run\n");
	return 1;
}


int LogFileWrite(char *str)
{

	if (strstr(str, "\n") == NULL) strcat(str, "\n");
	fputs(str, stream_log);
	return 1;
}


int LogFileClose(void)
{
	LogFileWrite("SagCAD stop\n");
	/* ե򥯥 */ 
	fclose(stream_log);
	return 1;
}



/* -------------------------------------------------------------------
 * log ե񤭤
 *	
 */
int OneShotLog(char *str)
{
	FILE *stream;
	char path[256], dummy[256];


	GetConfigPath(path);

	sprintf(dummy, "%s//OneShotLog", path);

	/* ե򥪡ץ */ 
	if((stream = fopen(dummy, "a")) == NULL) {
//		MsgBox("LogFileOpen", "ե %s ϳޤǤ");
		return 0;
	}

//	if (strstr(str, "\n") == NULL) strcat(str, "\n");
	fputs(str, stream);

	/* ե򥯥 */ 
	fclose(stream);
	return 1;
}


int DeleteOneShotLog(void)
{
	char path[256], str[256];


	GetConfigPath(path);

	sprintf(str, "%s//OneShotLog", path);
	unlink(str);

	return 0;
}





/* -------------------------------------------------------------------
 * եΥѥ
 *	
 * Windows ξ硢¹ԥեƱեե֤
 * LINUX ξ硢/home/[user]/.sagcad/sagcadrc
 */
int GetConfigPath(char *path)
{
	uid_t uid;
	struct passwd *pwd;

	uid = getuid();
	pwd = getpwuid(uid);
	sprintf(path, "%s/.sagcad", pwd->pw_dir);
	return 1;

	return 0;
}





/* -------------------------------------------------------------------
 * ɤμ 
 * 
 * եJISʤ0eucʤ1֤
 */
int Get_charset(void)
{
	char *envvalue, str[256];

	/* ja_JP.eucJP */
	envvalue = getenv("LANG");
	if (envvalue != NULL) {
		strcpy(str, envvalue);
		if (strstr(str, "euc") != NULL) {
			return 1;
		}
		else if (strstr(str, "EUC") != NULL) {
			return 1;
		}
		else if (strstr(str, "ujis") != NULL) {
			return 1;
		}
		else if (strstr(str, "SJIS") != NULL) {
			return 0;
		}
		else if (strstr(str, "sjis") != NULL) {
			return 0;
		}
		else if (strstr(str, "shift_jis") != NULL) {
			return 0;
		}
		else {
			return 1;
		}
		return 1;
	}
	return -1;
}





void home_of_user(char *home)
{
	uid_t uid;
	struct passwd *pwd;

	uid = getuid();
	pwd = getpwuid(uid);
	strcpy (home, pwd->pw_dir);
}





void name_of_user(char *user)
{
	uid_t uid;
	struct passwd *pwd;

	uid = getuid();
	pwd = getpwuid(uid);
	strcpy (user, pwd->pw_name);
}





/* -------------------------------------------------------------------
 * ʸΥѴ
 * 
 * from_str : Ѵʸ
 * from_code : ѴΥ
 * to_code : ѴΥ
 * 
 * ѴʸΥݥ󥿤֤ƤӽФ¦ free 롣
 */
char *p_sag_iconv(char *from_str, char *from_code, char *to_code)
{
//#ifdef P_SAG_ICONV
	iconv_t cd;					/* Ѵѥǥץ */
	char *inbuf;				/* ѥХåե */
	char *outbuf;				/* ѥХåե */
	char *outptr;				/* ƥݥݥ󥿡ʽѡ */
	const char *inptr;			/* ƥݥݥ󥿡ѡ */
	size_t inbyteleft;			/* ϥХåե */
	size_t outbyteleft;			/* ϥХåե */
	size_t ret;					/*  */
#ifdef P_SAG_ICONV
	int i;						/* 롼ץѿ */
	int n;						/* ХåեĹ */
#endif

	/* Ϥ줿ʸ򥳥ԡơĹ */
	inbuf = strdup(from_str);
	inbyteleft = strlen(inbuf);

	/* ѤΥХåեݤ */
	/* malloc ϡvoid ݥ󥿤֤Τǡ˾η˥㥹ȤƻȤޤ礦 */
	outbuf = (char *)xmalloc(inbyteleft * 4 + 1);
	outbyteleft = inbyteleft * 4;
	inbyteleft = strlen(inbuf) + 1;
	if (!outbuf) {
		printf("error in malloc\n");
		return NULL;
	}

	/* ѥХåեΥԡʥݥ󥿡 */
	outptr = outbuf;
	inptr = inbuf;

	/* iconv open */
	/* ʸѴѤΥǥץ򥪡ץ󤹤 */
	cd = iconv_open(to_code, from_code);
	if (cd == (iconv_t)(-1)) {
		printf("error in iconv_open\n");

		switch(errno) {
			case EMFILE:
				printf("p_sag_iconv() : ƤӽФȤΥץǴOPEN_MAXĤεһҤץ󤵤Ƥ\n");
				break;
			case ENFILE:
				printf("p_sag_iconv() : ץ󤵤Ƥե¤¿\n");
				break;
			case ENOMEM:
				printf("p_sag_iconv() : ΰ褬­Ƥ\n");
				break;
			case EINVAL:
				printf("p_sag_iconv() : fromcodetocodeǻꤷѴ򥵥ݡȤƤʤ\n");
				break;
		}

		free(inbuf);
		free(outbuf);
		return NULL;
	}

	/* iconv */
	/* ʸѴ¹ */
	/* iconv ΰץȥ̤˷㥹ȤȡٹϽФʤʤޤ*/
	ret = iconv(cd, (char **)&inptr, &inbyteleft, (char **)&outptr, &outbyteleft);
//	printf("ret1 = %d\n", ret);
	if ((size_t)(-1) != ret) {
		switch( errno ) {
			case EBADF:
				printf("p_sag_iconv() : ɥåȡСεһҤǤϤʤ\n");
				break;
			case E2BIG:
				printf("p_sag_iconv() : Ѵʸΰ­\n");
				break;
#ifdef ELISEQ
			case ELISEQ:
				printf("p_sag_iconv() : ϥХåեѴΥɥåȤ°ʤǡ¸\n");
				break;
#endif
			case EINVAL:
				printf("p_sag_iconv() : ϥХåեκǸԴʸ¸ߤ\n");
				break;
		}

		ret = iconv(cd, NULL, NULL, &outptr, &outbyteleft);
//		printf("ret2 = %d\n", ret);
		//free(outbuf);
		//return NULL;
	}

#ifdef P_SAG_ICONV
	/* ̤ɸϤɽ */
	n = strlen(outbuf);
	printf("in sag_iconv() \n");
	printf("----------------------------------------------------------\n");
	printf("from [%s] %s \n", from_code, from_str);
	printf("to   [%s] %s \n", to_code, outbuf);
	printf("----------------------------------------------------------\n");
	for (i = 0 ; i < n ; i++) {
		printf("%x ", outbuf[i] & 0xff);
	}
	printf("\n");
	printf("----------------------------------------------------------\n");
	printf("\n");
#endif

	/* ѤǥץĤ */
	iconv_close(cd);

	/* Ѥΰ */
	free(inbuf);

	return outbuf;
}





/* -------------------------------------------------------------------
 * ʸΥѴ
 * 
 * from_str  : Ѵʸ
 * to_str    : Ѵʸ
 * from_code : ѴΥ
 * to_code   : ѴΥ
 */
int sag_iconv(char *from_str, char *to_str, char *from_code, char *to_code)
{
//#define SAG_ICONV
	iconv_t cd;					/* Ѵѥǥץ */
	char *inbuf;				/* ѥХåե */
	char *outbuf;				/* ѥХåե */
	char *outptr;				/* ƥݥݥ󥿡ʽѡ */
	const char *inptr;			/* ƥݥݥ󥿡ѡ */
	size_t inbyteleft;			/* ϥХåե */
	size_t outbyteleft;			/* ϥХåե */
	size_t ret;					/*  */
#ifdef SAG_ICONV
	int i;						/* 롼ץѿ */
	int n;						/* ХåեĹ */
#endif

	/* Ϥ줿ʸ򥳥ԡơĹ */
	inbuf = strdup(from_str);
	inbyteleft = strlen(inbuf);

	/* ѤΥХåեݤ */
	/* malloc ϡvoid ݥ󥿤֤Τǡ˾η˥㥹ȤƻȤޤ礦 */
	outbuf = (char *)xmalloc(inbyteleft * 4 + 1);
	outbyteleft = inbyteleft * 4;
	inbyteleft = strlen(inbuf) + 1;
	if (!outbuf) {
		printf("error in malloc\n");
		return 0;
	}

	/* ѥХåեΥԡʥݥ󥿡 */
	outptr = outbuf;
	inptr = inbuf;

	/* iconv open */
	/* ʸѴѤΥǥץ򥪡ץ󤹤 */
	cd = iconv_open(to_code, from_code);
	if (cd == (iconv_t)(-1)) {
		printf("error in iconv_open\n");
		switch(errno) {
			case EMFILE:
				printf("sag_iconv() : ƤӽФȤΥץǴOPEN_MAXĤεһҤץ󤵤Ƥ\n");
				break;
			case ENFILE:
				printf("sag_iconv() : ץ󤵤Ƥե¤¿\n");
				break;
			case ENOMEM:
				printf("sag_iconv() : ΰ褬­Ƥ\n");
				break;
			case EINVAL:
				printf("sag_iconv() : fromcodetocodeǻꤷѴ򥵥ݡȤƤʤ\n");
				break;
		}
		free(inbuf);
		free(outbuf);
		return 0;
	}

	/* iconv */
	/* ʸѴ¹ */
	/* iconv ΰץȥ̤˷㥹ȤȡٹϽФʤʤޤ*/
	ret = iconv(cd, (char **)&inptr, &inbyteleft, (char **)&outptr, &outbyteleft);
//	printf("ret = %d\n", ret);
	if ((size_t)(-1) != ret) {
		switch( errno ) {
			case EBADF:
				printf("sag_iconv() : ɥåȡСεһҤǤϤʤ\n");
				break;
			case E2BIG:
				printf("sag_iconv() : Ѳʸΰ­\n");
				break;
#ifdef ELISEQ
			case ELISEQ:
				printf("sag_iconv() : ϥХåեѴΥɥåȤ°ʤǡ¸\n");
				break;
#endif
			case EINVAL:
				printf("sag_iconv() : ϥХåեκǸԴʸ¸ߤ\n");
				break;
		}

		ret = iconv(cd, NULL, NULL, &outptr, &outbyteleft);
//		printf("ret = %d\n", ret);
	}

#ifdef SAG_ICONV
	/* ̤ɸϤɽ */
	n = strlen(outbuf);
	printf("in sag_iconv() \n");
	printf("----------------------------------------------------------\n");
	printf("from [%s] %s \n", from_code, from_str);
	printf("to   [%s] %s \n", to_code, outbuf);
	printf("------------------------------------------------\n");
	for (i = 0 ; i < n ; i++) {
		printf("%x ", outbuf[i] & 0xff);
	}
	printf("\n");
	printf("----------------------------------------------------------\n");
	printf("\n");
#endif

	/* ̤᤹ */
	strcpy(to_str, outbuf);

	/* ѤǥץĤ */
	iconv_close(cd);

	/* Ѥΰ */
	free(inbuf);
	free(outbuf);

	return 1;
}





/*============================================================================
 * NAME:	conv_iconv
 * USAGE:	char *conv_iconv(const char *from_str, const char *from_code, const char *to_code)
 * PARAMS:	from_str		Ѵʸؤݥ(I)
 *			from_code		ѴΥɤǼʸ(I)
 *			to_code			ѴΥɤǼʸ(I)
 * RETURN VALUE:
 *			ｪλ		char *	Ѵʸؤݥ(O)
 * 			۾ｪλ		NULL	ѴǤʤä
 * DESCRIPTION:
 *			ʸΥѴ
 * 			from_str ʸ from_code  to_code ʸѴ
 * 			ѴʸΥݥ󥿤֤
 * 			ѴʸΥϡƤӽФ¦ǳ (free) 롣
 *=============================================================================
 */
char *conv_iconv(const char *from_str, const char *from_code, const char *to_code)
{
//#define CONV_ICONV
	iconv_t cd;				/* Ѵѥǥץ */
	const char *inbuf_p;	/* ƥݥݥ󥿡ѡ */
	char *outbuf;			/* ѥХåե */
	char *outbuf_p;			/* ƥݥݥ󥿡ʽѡ */
	int in_size;			/* ϥХåե */
	int in_left;			/* ϥХåե */
	int out_size;			/* ϥХåե */
	int out_left;			/* ϥХåե */
	int n_conv;
	int len;
#ifdef CONV_ICONV
	int i;					/* 롼ץѿ */
	int n;					/* ХåեĹ */
#endif


	/* ʸѴѤΥǥץ򥪡ץ󤹤 */
	cd = iconv_open(to_code, from_code);
	if (cd == (iconv_t)-1) {
		return NULL;
	}


	/* ѴʸΥԡȡ */
	inbuf_p = from_str;
	in_size = strlen(from_str);
	in_left = in_size;
	out_size = (in_size + 1) * 2;
	/* ѤΥХåեݤ */
	outbuf = (char *)g_malloc(out_size);
	if ( !outbuf ) {
		/* malloc Υå */
		g_print ("conv_iconv() : error in malloc\n");
		return NULL;
	}
	/* ѴʸΥԡȡ */
	outbuf_p = outbuf;
	out_left = out_size;


	while ((n_conv = iconv(cd, (char **)&inbuf_p, &in_left, (char **)&outbuf_p, &out_left)) < 0) {
		if (EILSEQ == errno) {
			inbuf_p++;
			in_left--;
			if (out_left == 0) {
				len = outbuf_p - outbuf;
				out_size *= 2;
				outbuf = g_realloc(outbuf, out_size);
				outbuf_p = outbuf + len;
				out_left = out_size - len;
			}
			*outbuf_p++ = '_';
			out_left--;
		}
		else if (EINVAL == errno) {
			break;
		}
		else if (E2BIG == errno) {
			len = outbuf_p - outbuf;
			out_size *= 2;
			outbuf = g_realloc(outbuf, out_size);
			outbuf_p = outbuf + len;
			out_left = out_size - len;
		}
		else {
			g_print ("conv_iconv(): %s\n", g_strerror(errno));
			break;
		}
	}

	while ((n_conv = iconv(cd, NULL, NULL, &outbuf_p, &out_left)) < 0) {
		if (E2BIG == errno) {
			len = outbuf_p - outbuf;
			out_size *= 2;
			outbuf = g_realloc(outbuf, out_size);
			outbuf_p = outbuf + len;
			out_left = out_size - len;
		}
		else {
			g_print ("conv_iconv(): %s\n", g_strerror(errno));
			break;
		}
	}

	len = outbuf_p - outbuf;
	outbuf = g_realloc(outbuf, len + 1);
	outbuf[len] = '\0';

	/* ѤǥץĤ */
	iconv_close(cd);

#ifdef CONV_ICONV
	/* ̤ɸϤɽ */
	n = strlen(outbuf);
	printf("----------------------------------------------------------\n");
	printf("from [%s] %s \n", from_code, from_str);
	printf("to   [%s] %s \n", to_code, outbuf);
	printf("------------------------------------------------\n");
	for (i = 0 ; i < n ; i++) {
		printf("%x ", outbuf[i] & 0xff);
	}
	printf("\n");
	printf("----------------------------------------------------------\n");
	printf("\n");
#endif

	return outbuf;
}





/* -------------------------------------------------------------------
 * UTF-8 ΣʸΣХܤ飱ʸΥХȿ֤
 */
int utf8_bite_num(char c)
{
	/* 4 bite */
	if ((c & 0xf0) == 0xf0) {
		return 4;
	}
	/* 3 bite */
	else if ((c & 0xe0) == 0xe0) {
		return 3;
	}
	/* 2 bite */
	else if ((c & 0xc0) == 0xc0) {
		return 2;
	}
	/* 1 bite */
	else if ((c & 0xff) < 0x80) {
		return 1;
	}

	return 0;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : etc.c
 * ====================================================================
 */
