/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Trace.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __TRACE_H__
#define __TRACE_H__


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */
#define PI 3.14159265358979

	/* ɸ׻ؿѡ¤Τ */
	struct RtnDat
	{
		int type;		// 
		double angle;	// 
		double l;		// 
		double sx[5];	// 
		double sy[5];	// 
		double ex[5];	// 
		double ey[5];	// 
		double cx[13];	// 
		double cy[13];	// 
		double r[13];	// 
	};



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef	  _TRACE_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL int calcu_digits GLOBAL_VAL(10);	/* ׻Ѿʲ */
	GLOBAL int compa_digits GLOBAL_VAL(3);	/* Ѿʲ */
	GLOBAL double digits GLOBAL_VAL(0.0001);		/* Ѹ */
	// Act_llp()  sg() ؿηϡ


#undef	GLOBAL
#undef	GLOBAL_VAL
#undef	_TRACE_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
double raddeg(double a);					/*	1 */
double degrad(double a);					/*	2 */
int pa(struct RtnDat *dumy);				/*	3 */
int ppp(struct RtnDat *dumy);				/*	4 */
int lla(struct RtnDat *dumy);				/*	5 */
int pap(struct RtnDat *dumy);				/*	6 */
int lo(struct RtnDat *dumy);				/*	7 */
int la(struct RtnDat *dumy);				/*	8 */
int pp(struct RtnDat *dumy);				/*	9 */
int llp(struct RtnDat *dumy);				/* 10 */
int lcp(struct RtnDat *dumy);				/* 11 */
int ccp(struct RtnDat *dumy);				/* 12 */
int plp (struct RtnDat *dumy);				/* 13 */
int pcl(struct RtnDat *dumy);				/* 14 */
int ccl(struct RtnDat *dumy);				/* 15 */
int pcc(struct RtnDat *dumy);				/* 16 */
int lcc(struct RtnDat *dumy);				/* 17 */
int ppc(struct RtnDat *dumy);				/* 18 */
int ccc(struct RtnDat *dumy);				/* 19 */
int plc(struct RtnDat *dumy);				/* 20 */
int llc(struct RtnDat *dumy);				/* 21 */
int lll(struct RtnDat *dumy);				/* 22 */
int pll(struct RtnDat *dumy);				/* 23 */
int cal(struct RtnDat *dumy);				/* 24 */
double sg(double dumy,int keta);			/* 28 */
int pppc(struct RtnDat *dumy);
int lllc(struct RtnDat *a);
int ChkPointCircleSide(struct RtnDat *a);
int ChkPointLineSide(struct RtnDat *a);
int LCP1(struct RtnDat *a);
int CCP1(struct RtnDat *a);
int Act_llp(struct RtnDat *a);
int Act_lcp(struct RtnDat *a);
int Act_ccp(struct RtnDat *dumy);
int Swap_double(double *a, double *b);
int FloatOut(char *str, double dbl, int Dot);	// ()
int FloatOut6(char *str, double dbl, int Dot);	// ()
int FloatOut_n(char *str, double dbl, int n, int Dot);

/* ž    (px,py)  (x,y) 濴 Angle ٲžư */
int rotation(double *px, double *py, double x, double y, double Angle);
/* ʿ    (px,py)  ٥ȥ(x,y) ʿ԰ư */
int parallel(double *px, double *py, double x, double y);
/* о    (x,y)  (sx,sy)-(ex,ey) Фоΰư */
int symmetry(double sx, double sy, double ex, double ey, double *x, double *y);
/*     (x,y)  (x,y) 濴 k ܤ޷Ѵ */
int scaling(double *px, double *py, double x, double y, double k);

/* ٤ 0  360 δ֤ˤ */
int angle_check(double *angle);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __TRACE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Trace.h
 * ====================================================================
 */
