/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Trace.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 1998/10/13
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <math.h>
#include <gtk/gtk.h>

#include "intl.h"
#define _TRACE_
#include "Trace.h"



/* -------------------------------------------------------------------
 *  : [1] ٤ñ̤ (DEG) 饸 (RAD) Ѵ롣
 *		:   RAD
 * ؿ : degrad
 *  : double
 *  : double
 *  : ̵
 *  : ̵
 */
double degrad(double a)
{	return (a * (PI / 180));	}



/* -------------------------------------------------------------------
 *  : [2] ٤ñ̤򡢥饸 (RAD)  (DEG)  (DEG) Ѵ롣
 *		: RAD  
 * ؿ : raddeg
 *  : double
 *  : double
 *  : ̵
 *  : ̵
 */
double raddeg(double a)
{	return ((180 / PI) * a);	}



/* -------------------------------------------------------------------
 *  : [3] ӣţ
 * ؿ : pa
 *  : rtndat
 *			  濴		  (cx[1] , cy[1])
 *			 ߾ޤ (sx[1] , sy[1])
 *  : rtndat
 *			   angle
 *  : ̵
 *  : RtnDat lah
 */
int pa(struct RtnDat *dumy)
{
	struct RtnDat lah;
	int msg;
	
	lah.sx[1] = dumy->cx[1];
	lah.sy[1] = dumy->cy[1];
	lah.ex[1] = dumy->sx[1];
	lah.ey[1] = dumy->sy[1];
	msg = la(&lah);
	dumy->angle = lah.angle;
	return 0;
}



/* -------------------------------------------------------------------
 *  : [4] Ƚʬ sx[2] : ex[2] 
 *		: ʬ
 * ؿ : ppp
 *  : rtndat
 *		:		(sx[1] , sy[1])
 *		:		(ex[1] , ey[1])
 *		:			(sx[2] , ex[2])
 *  : rtndat
 *		:			(sx[3] , sy[3])
 *  : ̵
 *  : 
 */
int ppp(struct RtnDat *dumy)
{
	dumy->sx[3] = ((dumy->sx[2]) * (dumy->ex[1]) + (dumy->ex[2]) * (dumy->sx[1])) / ((dumy->sx[2]) + (dumy->ex[2]));
	dumy->sy[3] = ((dumy->sx[2]) * (dumy->ey[1]) + (dumy->ex[2]) * (dumy->sy[1])) / ((dumy->sx[2]) + (dumy->ex[2]));
	return 0;
}



/* -------------------------------------------------------------------
 *  : [5] ľľ򤹤ľγ
 * ؿ : lla
 *  : rtndat
 *		:		  (sx[1] , sy[1]) -  (ex[1] , ey[1])
 *  : rtndat
 *		:	   angle
 *  : ̵
 *  : RtnDat lah
 */
int lla(struct RtnDat *dumy)
{
	struct RtnDat lah;
	int msg;

	lah.sx[1] = dumy->sx[1];
	lah.sy[1] = dumy->sy[1];
	lah.ex[1] = dumy->ex[1];
	lah.ey[1] = dumy->ey[1];
	msg = la(&lah);
	dumy->angle = lah.angle;
	dumy->angle = (dumy->angle) + 90;

	if ((dumy->angle) < 0)
		dumy->angle = (dumy->angle) + 360.;
	else if ((dumy->angle) >= 360)
		dumy->angle = (dumy->angle) - 360.;
	return 0;
}



/* -------------------------------------------------------------------
 *  : [6] ȳ٤ȵΥľν
 * ؿ : pap
 *  : rtndat
 *		:	   (sx[1] , sy[1])
 *		:	   angle
 *		:	Ĺ   l
 *  : rtndat
 *		:		   (ex[1] , ey[1])
 *  : ̵
 *  : 
 */
int pap(struct RtnDat *dumy)
{
	if ((dumy->angle) < 0)
		dumy->angle = 360 + (dumy->angle);

	dumy->angle = degrad(dumy->angle);
	dumy->ex[1] = (dumy->sx[1]) + (dumy->l) * cos(dumy->angle);
	dumy->ey[1] = (dumy->sy[1]) + (dumy->l) * sin(dumy->angle);

	return 0;
}



/* -------------------------------------------------------------------
 *  : [7] ȽͿľΥեå
 * ؿ : lo
 *  : rtndat
 *		:		(sx[1] , sy[1]) - (ex[1] , ey[1])
 *		:	Ĺ	 l
 *  : rtndat
 *		:		(sx[2] , sy[2]) - (ex[2] , ey[2]) ʹ	
 *		:		(sx[3] , sy[3]) - (ex[3] , ey[3]) ʹ	
 *  : ̵
 *  : RtnDat llah,paph
 */
int lo(struct RtnDat *dumy)
{
	struct RtnDat llah,paph;
	int msg;

	/* ľľ򤹤ľγ */
	llah.sx[1] = dumy->sx[1]; 
	llah.sy[1] = dumy->sy[1];
	llah.ex[1] = dumy->ex[1]; 
	llah.ey[1] = dumy->ey[1];
	msg = lla(&llah);

	/* Τ줾ȤLLAǵ᤿٤
	 * եåȤεΥΥ줿롣
	 * ʹ˥եå
	 */
	paph.sx[1] = dumy->sx[1]; 
	paph.sy[1] = dumy->sy[1]; 
	paph.angle = llah.angle; 
	paph.l = dumy->l;
	msg = pap(&paph);
	dumy->sx[2] = paph.ex[1]; 
	dumy->sy[2] = paph.ey[1];

	paph.sx[1] = dumy->ex[1]; 
	paph.sy[1] = dumy->ey[1]; 
	paph.angle = llah.angle; 
	paph.l = dumy->l;
	msg = pap(&paph);
	dumy->ex[2] = paph.ex[1]; 
	dumy->ey[2] = paph.ey[1];

	/* ȿžΥեå
	 * ʹ˥եå
	 * ľľ򤹤ľγ
	 */
	llah.sx[1] = dumy->ex[1];
	llah.sy[1] = dumy->ey[1];
	llah.ex[1] = dumy->sx[1];
	llah.ey[1] = dumy->sy[1];
	msg = lla(&llah);

	paph.sx[1] = dumy->sx[1];
	paph.sy[1] = dumy->sy[1];
	paph.angle = llah.angle; 
	paph.l = dumy->l;
	msg = pap(&paph);
	dumy->sx[3] = paph.ex[1];
	dumy->sy[3] = paph.ey[1];

	paph.sx[1] = dumy->ex[1];
	paph.sy[1] = dumy->ey[1];
	paph.angle = llah.angle; 
	paph.l = dumy->l;
	msg = pap(&paph);
	dumy->ex[3] = paph.ex[1];
	dumy->ey[3] = paph.ey[1];

	return 0;
}



/* -------------------------------------------------------------------
 *  : [8] ľγ
 * ؿ : la
 *  : *rtndat
 *		:			(sx[1] , sy[1]) - (ex[1] , ey[1])
 *  : int
 *		:		 angle
 *  : ̵
 *  : 
 */
int la(struct RtnDat *dumy)
{
	double dx;
	double dy;


	dx = dumy->ex[1] - dumy->sx[1];
	dy = dumy->ey[1] - dumy->sy[1];
	dx = sg(dx, calcu_digits);
	dy = sg(dy, calcu_digits);

	if (dx == 0 && dy > 0) {					/* X ư̵Y+ ư	 */
		dumy->angle = 90;
		dumy->type = 1;
	}

	else if (dx == 0 && dy < 0) {				/* X ư̵Y- ư	 */
		dumy->angle = 270;
		dumy->type = 1;
	}

	else if (dx > 0 && dy == 0) {				/* X+ ưY ư̵	 */
		dumy->angle = 0;
		dumy->type = 1;
	}

	else if (dx < 0 && dy == 0) {				/* X- ưY ư̵	 */
		dumy->angle = 180;
		dumy->type = 1;
	}

	else if (dx == 0 && dy == 0) {				/* X ư̵Y ư̵ */
		/* msg "ưͭޤ" */
		dumy->type = 0;
	}

	else {
		dumy->angle = atan(fabs(dy) / fabs(dx));
		dumy->angle = raddeg(dumy->angle);
		
		if (dx < 0 && dy > 0)
			dumy->angle = 180 - dumy->angle;
		if (dx < 0 && dy < 0)
			dumy->angle = 180 + dumy->angle;
		if (dx > 0 && dy < 0)
			dumy->angle = 360 - dumy->angle;
		if (dumy->angle < 0)
			dumy->angle = dumy->angle + 360;
		if (dumy->angle >= 360)
			dumy->angle = dumy->angle - 360;
		dumy->type = 1;
	}
	return 0;
}



/* -------------------------------------------------------------------
 *  : [9] ֤εΥ
 * ؿ : pp
 *  : RtnDat
 *		:	 1	(sx[1] , sy[1])
 *		:	 2	(ex[1] , ey[1])
 *  : int
 *		:	l
 *  : ̵
 *  : ̵
 */
int pp(struct RtnDat *dumy)
{
	dumy->l = sqrt(((dumy->ex[1] - dumy->sx[1]) * (dumy->ex[1] - dumy->sx[1])) + ((dumy->ey[1] - dumy->sy[1]) * (dumy->ey[1] - dumy->sy[1])));
	dumy->type = 1;

	return 0;
}



/* -------------------------------------------------------------------
 *  : [10] ľθ  ƤΥեå P120
 * ؿ : llp
 *  : RtnDat
 *		:	(sx[1] , sy[1]) (ex[1] , ey[1])
 *		:	(sx[2] , sy[2]) (ex[2] , ey[2])
 *  : int
 *		:	(sx[3] , sy[3]) , (type = 1:ｪλ   0:顼 )
 *  : ̵
 *  : 
 */
int llp(struct RtnDat *dumy)
{
//#define LLP_TEST
#ifdef LLP_TEST
	char str[256];
#endif

	double a1, a2, b1, b2;


#ifdef LLP_TEST
	sprintf(str, "llp 1 : LINE 1 (%f , %f)-(%f , %f)\n", dumy->sx[1], dumy->sy[1], dumy->ex[1], dumy->ey[1]);
	OneShotLog(str);
	sprintf(str, "llp 1 : LINE 2 (%f , %f)-(%f , %f)\n", dumy->sx[2], dumy->sy[2], dumy->ex[2], dumy->ey[2]);
	OneShotLog(str);
#endif

	/* ľǡʿΤȤ */
	if (
		sg(dumy->sx[1], compa_digits) == sg(dumy->ex[1], compa_digits) 
		&& 
		sg(dumy->sy[2], compa_digits) == sg(dumy->ey[2], compa_digits)
		) 
	{
		dumy->sx[3] = sg(dumy->sx[1], calcu_digits);
		dumy->sy[3] = sg(dumy->sy[2], calcu_digits);
		dumy->type = 1;
#ifdef LLP_TEST
	sprintf(str, "llp 2 : ľǡʿ\n");
	OneShotLog(str);
#endif
		return 1;
	}

	/* ľǡʿΤȤ */
	if (
		sg(dumy->sx[2], compa_digits) == sg(dumy->ex[2], compa_digits) 
		&& 
		sg(dumy->sy[1], compa_digits) == sg(dumy->ey[1], compa_digits)
		) 
	{
		dumy->sx[3] = sg(dumy->sx[2], calcu_digits);
		dumy->sy[3] = sg(dumy->sy[1], calcu_digits);
		dumy->type = 1;
#ifdef LLP_TEST
	sprintf(str, "llp 2 : ľǡʿ\n");
	OneShotLog(str);
#endif
		return 1;
	}

	/* ФΤȤ */
	if (
		sg(dumy->ex[1] - dumy->sx[1], compa_digits) == 0 
		&& 
		sg(dumy->ex[2] - dumy->sx[2], compa_digits) != 0
		) 
	{
		a2 = (dumy->ey[2] - dumy->sy[2]) / (dumy->ex[2] - dumy->sx[2]);
		b2 = dumy->sy[2] - a2 * dumy->sx[2];
		dumy->sx[3] = dumy->sx[1];
		dumy->sy[3] = a2 * dumy->sx[3] + b2;
		dumy->type = 1;
#ifdef LLP_TEST
	sprintf(str, "llp 2 : Ф\n");
	OneShotLog(str);
#endif
	}

	/* ľȤټʿԤΤȤ */
	if (
		sg(dumy->ex[1] - dumy->sx[1], compa_digits) == 0 
		&& 
		sg(dumy->ex[2] - dumy->sx[2], compa_digits) == 0
		) 
	{
		dumy->type = 0;
#ifdef LLP_TEST
	sprintf(str, "llp 3 : ľȤټʿ\n");
	OneShotLog(str);
#endif
		return 0;
	}

	/* ФΤȤ */
	if (
		sg(dumy->ex[2] - dumy->sx[2], compa_digits) == 0 
		&& 
		sg(dumy->ex[1] - dumy->sx[1], compa_digits) != 0
		) 
	{
		a1 = (dumy->ey[1] - dumy->sy[1]) / (dumy->ex[1] - dumy->sx[1]);
		b1 = dumy->sy[1] - a1 * dumy->sx[1];
		dumy->sx[3] = dumy->sx[2];
		dumy->sy[3] = a1 * dumy->sx[3] + b1;
		dumy->type = 1;
#ifdef LLP_TEST
	sprintf(str, "llp 4 : Ф\n");
	OneShotLog(str);
#endif
	}

	/* ФޤϡʿΤȤ */
	if (
		sg(dumy->ex[1] - dumy->sx[1], compa_digits) != 0 
		&& 
		sg(dumy->ex[2] - dumy->sx[2], compa_digits) != 0
		) 
	{
		a1 = (dumy->ey[1] - dumy->sy[1]) / (dumy->ex[1] - dumy->sx[1]);
		a2 = (dumy->ey[2] - dumy->sy[2]) / (dumy->ex[2] - dumy->sx[2]);
		b1 = dumy->sy[1] - a1 * dumy->sx[1];
		b2 = dumy->sy[2] - a2 * dumy->sx[2];
		if (a1 - a2 != 0) {
			dumy->sx[3] = (b2 - b1) / (a1 - a2);
			dumy->sy[3] = a1 * dumy->sx[3] + b1;
			dumy->type = 1;
		}
		else if (a1 - a2 == 0) {
			/* ľʿ */
			dumy->type = 0;
			return 0;
		}
#ifdef LLP_TEST
	sprintf(str, "llp 5 : Фޤϡʿ\n");
	OneShotLog(str);
	sprintf(str, "llp 5 : sx[3] = %f   sy[3] = %f\n", dumy->sx[3], dumy->sy[3]);
	OneShotLog(str);
#endif
	}
	return 1;
}



/* -------------------------------------------------------------------
 *  : [11] ľȱߤθ  ƤΥեå P126
 * ؿ : lcp
 *  : RtnDat
 *		:	 1	(sx[1],sy[1]) - (ex[1],ey[1])
 *		:	 1	(cx[1],cy[1]) ,r[1]
 *  : RtnDat
 *		:	type	0 , 1 , 2
 *		:	 1	(sx[2],sy[2])
 *		:	 2	(sx[3],sy[3])
 *  : ̵
 *  : RtnDat plph,pph
 */
int lcp(struct RtnDat *dumy)
{
//#define LCP
	struct RtnDat plph, pph;
	int lcptype, msg;
	double aa1, bb, cc, dd, mm, nn;
	double f_dumy, disp, r1;
	int debug = 0;


#ifdef LCP
	debug = 1;
#endif


	lcptype = 0;

	/* ľȱߤ濴ȤεΥ */
	plph.sx[2] = dumy->cx[1];
	plph.sy[2] = dumy->cy[1];
	plph.sx[1] = dumy->sx[1];
	plph.sy[1] = dumy->sy[1];
	plph.ex[1] = dumy->ex[1];
	plph.ey[1] = dumy->ey[1];
	msg = plp(&plph);

	/* ֤εΥ */
	pph.sx[1] = dumy->cx[1];
	pph.sy[1] = dumy->cy[1];
	pph.ex[1] = plph.ex[2];
	pph.ey[1] = plph.ey[2];
	msg = pp(&pph);

	disp = pph.l;
	r1 = dumy->r[1];



	/* ܤƤ */
	if (debug > 0) g_print("ܤƤ : (disp == r1) = %d\n", 
			(disp + (1/pow(10, compa_digits)) > r1 
			&& 
			disp - (1/pow(10, compa_digits)) < r1) );
	/* ŤʤäƤ */
	if (debug > 0) g_print("ŤʤäƤ : sg(disp, compa_digits) < sg(r1, compa_digits) = %d\n", 
			sg(disp, compa_digits) < sg(r1, compa_digits));
	/* ΥƤ */
	if (debug > 0) g_print("ΥƤ : sg(disp, compa_digits) > sg(r1, compa_digits) = %d\n", 
			sg(disp, compa_digits) > sg(r1, compa_digits));

	if (debug > 0) g_print("           : sg(disp, compa_digits) = %f\n", sg(disp, compa_digits));
	if (debug > 0) g_print("           : sg(r1, compa_digits) = %f\n", sg(r1, compa_digits));


	/* -----------------------------------------------------
	 * ߤľΰִطȸ
	 *
	 */

// (1/pow(10, compa_digits))

	/* -----------------------------------------------------
	 * ܤƤ 
	 */
	if (disp + (1/pow(10, compa_digits)) > r1 
		&& 
		disp - (1/pow(10, compa_digits)) < r1) 
	{
//	if (sg(disp, compa_digits) == sg(r1, compa_digits)) {
		dumy->type = 1;
		dumy->sx[2] = plph.ex[2];
		dumy->sy[2] = plph.ey[2];
	}



	/* -----------------------------------------------------
	 * ŤʤäƤ
	 */
	else if (sg(disp, compa_digits) < sg(r1, compa_digits)) {
		dumy->type = 2;
		/* ʬ줬0ˤʤȥ顼Ȥʤ뤿XɸYɸ׻촹롣 */
		if (sg((dumy->ex[1] - dumy->sx[1]), compa_digits) == 0) {
			f_dumy = dumy->sx[1];
			dumy->sx[1] = dumy->sy[1];
			dumy->sy[1] = f_dumy;
			f_dumy = dumy->ex[1];
			dumy->ex[1] = dumy->ey[1];
			dumy->ey[1] = f_dumy;
			f_dumy = dumy->cx[1];
			dumy->cx[1] = dumy->cy[1];
			dumy->cy[1] = f_dumy;
			lcptype = 1;
		}

		mm = (dumy->ey[1] - dumy->sy[1]) / (dumy->ex[1] - dumy->sx[1]);
		nn = dumy->sy[1] - mm * dumy->sx[1];
		aa1 = (mm * mm + 1);
		bb = 2 * (mm * nn - dumy->cx[1] - dumy->cy[1] * mm);
		cc = dumy->cx[1] * dumy->cx[1] - dumy->r[1] * dumy->r[1] + (nn - dumy->cy[1]) * (nn - dumy->cy[1]);
		dd = bb * bb - aa1 * aa1 * cc;

		dumy->sx[2] = (-bb - sqrt(bb * bb - 4 * aa1 * cc)) / (2 * aa1);
		dumy->sy[2] = mm * dumy->sx[2] + nn;
		dumy->sx[3] = (-bb + sqrt(bb * bb - 4 * aa1 * cc)) / (2 * aa1);
		dumy->sy[3] = mm * dumy->sx[3] + nn;

		/* X ɸY ɸ촹Τ򸵤᤹ */
		if (lcptype == 1) {
			f_dumy = dumy->sx[1];
			dumy->sx[1] = dumy->sy[1];
			dumy->sy[1] = f_dumy;
			f_dumy = dumy->ex[1];
			dumy->ex[1] = dumy->ey[1];
			dumy->ey[1] = f_dumy;
			f_dumy = dumy->cx[1];
			dumy->cx[1] = dumy->cy[1];
			dumy->cy[1] = f_dumy;
			f_dumy = dumy->sx[2];
			dumy->sx[2] = dumy->sy[2];
			dumy->sy[2] = f_dumy;
			f_dumy = dumy->sx[3];
			dumy->sx[3] = dumy->sy[3];
			dumy->sy[3] = f_dumy;
			lcptype = 0;
		}
	}



	/* -----------------------------------------------------
	 * ΥƤ
	 */
	else if (sg(disp, compa_digits) > sg(r1, compa_digits)) {
		dumy->type = 0;
		return 0;
	}

	return 1;
}



/* -------------------------------------------------------------------
 *  : [12] ߤθ
 * ؿ : ccp
 *  : rtndat
 *		:	 1	  (cx[1] , cy[1]) , r[1]
 *		:	 2	  (cx[2] , cy[2]) , r[2]
 *  : rtndat
 *		:	type	   0 , 1 , 2
 *		:	 1	  (sx[1] , sy[1])
 *		:	 2	  (sx[2] , sy[2])
 *  : ̵
 *  : RtnDat pph,lah,paph,lcph,llah
 */
int ccp(struct RtnDat *dumy)
{
	struct RtnDat pph,lah,paph,lcph,llah, DumyRtn;
	double p;
	int msg;
	double dist,r1pr2,r1mr2;


	/* 1礭ʤ褦˥ǡ줫 */
	if (dumy->r[1] < dumy->r[2]) {
		DumyRtn.cx[1] = dumy->cx[2];
		DumyRtn.cy[1] = dumy->cy[2];
		DumyRtn.r[1] = dumy->r[2];

		DumyRtn.cx[2] = dumy->cx[1];
		DumyRtn.cy[2] = dumy->cy[1];
		DumyRtn.r[2] = dumy->r[1];

		dumy->cx[1] = DumyRtn.cx[1];
		dumy->cy[1] = DumyRtn.cy[1];
		dumy->r[1] = DumyRtn.r[1];

		dumy->cx[2] = DumyRtn.cx[2];
		dumy->cy[2] = DumyRtn.cy[2];
		dumy->r[2] = DumyRtn.r[2];
	}

	/* 濴εΥ */
	pph.sx[1] = dumy->cx[1];
	pph.sy[1] = dumy->cy[1];
	pph.ex[1] = dumy->cx[2];
	pph.ey[1] = dumy->cy[2];
	msg = pp(&pph);

	/* ߤΰִطȸ */
	dist = pph.l;
	/* R1 + R2 */
	r1pr2 = dumy->r[1] + dumy->r[2];
	/* R1 - R2 */
	r1mr2 = dumy->r[1] - dumy->r[2];

	/* -----------------------------------------------------
	 *  1  
	 */
	if (
		sg(dist, compa_digits) == sg(r1pr2, compa_digits) 
		|| 
		sg(dist, compa_digits) == sg(r1mr2, compa_digits)
		) 
	{
		dumy->type = 1;
		lah.sx[1] = dumy->cx[1];
		lah.sy[1] = dumy->cy[1];
		lah.ex[1] = dumy->cx[2];
		lah.ey[1] = dumy->cy[2];
		msg = la(&lah);

		paph.sx[1] = dumy->cx[1];
		paph.sy[1] = dumy->cy[1];
		paph.angle = lah.angle;
		paph.l = dumy->r[1];
		msg = pap(&paph);

		dumy->sx[1] = paph.ex[1];
		dumy->sy[1] = paph.ey[1];
		dumy->sx[2] = 0;
		dumy->sy[2] = 0;
	}

	/* -----------------------------------------------------
	 * 2
	 */
	else if (
				sg(dist, compa_digits) < sg(r1pr2, compa_digits) 
				&& 
				sg(dist, compa_digits) > sg(r1mr2, compa_digits)
			) 
	{
		dumy->type = 2;
		p = ((dumy->r[1] * dumy->r[1]) - (dumy->r[2] * dumy->r[2]) + (pph.l * pph.l)) / (2 * pph.l);
		/* -------------------------------------------------
		 * LA ľγ
		 */
		lah.sx[1] = dumy->cx[1];
		lah.sy[1] = dumy->cy[1];
		lah.ex[1] = dumy->cx[2];
		lah.ey[1] = dumy->cy[2];
		msg = la(&lah);

		/* -------------------------------------------------
		 * PAP ȳ٤ȵΥľν
		 */
		paph.sx[1] = dumy->cx[1];
		paph.sy[1] = dumy->cy[1];
		paph.angle = lah.angle;
		paph.l = p;
		msg = pap(&paph);

		/* -------------------------------------------------
		 * LLA ľľ򤹤ľγ
		 */
		llah.sx[1] = dumy->cx[1];
		llah.sy[1] = dumy->cy[1];
		llah.ex[1] = dumy->cx[2];
		llah.ey[1] = dumy->cy[2];
		msg = lla(&llah);

		/* -------------------------------------------------
		 * PAP ȳ٤ȵΥľν
		 */
		paph.sx[1] = paph.ex[1];
		paph.sy[1] = paph.ey[1];
		paph.angle = llah.angle;
		paph.l = 10;
		msg = pap(&paph);

		/* -------------------------------------------------
		 * LCP ľȱߤθ
		 */
		lcph.sx[1] = paph.sx[1];
		lcph.sy[1] = paph.sy[1];
		lcph.ex[1] = paph.ex[1];
		lcph.ey[1] = paph.ey[1];
		lcph.cx[1] = dumy->cx[1];
		lcph.cy[1] = dumy->cy[1];
		lcph.r[1] = dumy->r[1];
		msg = lcp(&lcph);

		dumy->sx[1] = lcph.sx[2];
		dumy->sy[1] = lcph.sy[2];
		dumy->sx[2] = lcph.sx[3];
		dumy->sy[2] = lcph.sy[3];
	}

	/* -----------------------------------------------------
	 *  0  
	 */
	else {
//	else if ((dist > r1pr2) || (dist < r1mr2 && dist > 0)) {
		dumy->type = 0;
		return 0;
	}

	return 1;
}



/* -------------------------------------------------------------------
 *  : [13] PLP	 ľκǶʣ̤
 * ؿ : plp
 *  : RtnDat
 *		:	 1	(sx[1],sy[1]) - (ex[1],ey[1])
 *		:	 1	(sx[2],sy[2])
 *  : RtnDat
 *		:	type	 0 , 1
 *		:	 1	(ex[2],ey[2])
 *		:	 2	(ex[3],ey[3]) ȴطʤ
 *  : ̵
 *  : RtnDat llah,paph,llph
 */
int plp(struct RtnDat *dumy)
{
	struct RtnDat llah,paph,llph;
	int msg;


	/* ľľ򤹤ľγ٤롣 */
	llah.sx[1] = dumy->sx[1];
	llah.sy[1] = dumy->sy[1];
	llah.ex[1] = dumy->ex[1];
	llah.ey[1] = dumy->ey[1];
	msg = lla(&llah);
	/* dumy->ANGLE = llah.ANGLE;  */
	
	/* ʣˤȳ٤ȵΥ[1]ľν롣 */
	paph.sx[1] = dumy->sx[2];
	paph.sy[1] = dumy->sy[2];
	paph.angle = llah.angle;
	paph.l = 100;
	msg = pap(&paph);
	
	/* ľθ */
	llph.sx[1] = dumy->sx[1];
	llph.sy[1] = dumy->sy[1];
	llph.ex[1] = dumy->ex[1];
	llph.ey[1] = dumy->ey[1];
	llph.ex[2] = dumy->sx[2];
	llph.ey[2] = dumy->sy[2];
	llph.sx[2] = paph.ex[1];
	llph.sy[2] = paph.ey[1];
	msg = llp(&llph);
	
	dumy->ex[2] = llph.sx[3];
	dumy->ey[2] = llph.sy[3];
	dumy->ex[3] = paph.ex[1];
	dumy->ey[3] = paph.ey[1];
	dumy->type = 1;
	return 1;
}



/* -------------------------------------------------------------------
 *  : [14] ̤ߤܤľν  ƤΥեå P129
 * ؿ : pcl
 *  : rtndat
 *		:			(sx[1] , sy[1])
 *		:			(cx[1] , cy[1]) , r[1]
 *  : rtndat
 *		:	type	 0 , 1 , 21])
 *		:	 1	(ex[1] , ey[1])
 *		:	 2	(ex[2] , ey[2])
 *  : ̵
 *  : RtnDat pph,lah,llah,paph,ccph
 */
int pcl(struct RtnDat *dumy)
{
	struct RtnDat pph,lah,llah,paph,ccph;
	int msg;


	/* ֤εΥ */
	pph.sx[1] = dumy->sx[1];
	pph.sy[1] = dumy->sy[1];
	pph.ex[1] = dumy->cx[1];
	pph.ey[1] = dumy->cy[1];
	msg = pp(&pph);

	if (sg(pph.l, compa_digits) < sg(dumy->r[1], compa_digits)) {
		dumy->type = 0;
		return 1;
	}

	if (sg(pph.l, compa_digits) == sg(dumy->r[1], compa_digits)) {
		/* ߾ˤ뤫顢ȱߤ濴˿ľ̤ */
		/* LLA	 ľľ򤹤ľγ */
		llah.sx[1] = dumy->sx[1];
		llah.sy[1] = dumy->sy[1];
		llah.ex[1] = dumy->cx[1];
		llah.ey[1] = dumy->cy[1];
		msg = lla(&llah);
		
		/* PAP	ȳ٤ȵΥľν */
		paph.sx[1] = dumy->sx[1];
		paph.sy[1] = dumy->sy[1];
		paph.angle = llah.angle;
		paph.l = 100;
		msg = pap(&paph);
		
		dumy->type = 1;
		dumy->sx[1] = paph.sx[1];
		dumy->sy[1] = paph.sy[1];
		dumy->ex[1] = paph.ex[1];
		dumy->ey[1] = paph.ey[1];
		
		return 0;
	}

	if (sg(pph.l, compa_digits) > sg(dumy->r[1], compa_digits)) {
		/* 濴εΥpph.l */
		/* LA	ľγ */
		lah.sx[1] = dumy->sx[1];
		lah.sy[1] = dumy->sy[1];
		lah.ex[1] = dumy->cx[1];
		lah.ey[1] = dumy->cy[1];
		msg = la(&lah);
		
		/* PAP	ȳ٤ȵΥľν */
		paph.sx[1] = dumy->sx[1];
		paph.sy[1] = dumy->sy[1];
		paph.angle = lah.angle;
		paph.l = pph.l / 2;
		msg = pap(&paph);
		
		/* CCP	ߤθ */
		ccph.cx[1] = dumy->cx[1];
		ccph.cy[1] = dumy->cy[1];
		ccph.r[1] = dumy->r[1];
		ccph.cx[2] = paph.ex[1];
		ccph.cy[2] = paph.ey[1];
		ccph.r[2] = pph.l / 2;
		msg = ccp(&ccph);
		
		dumy->type = 2;
		dumy->ex[1] = ccph.sx[1];
		dumy->ey[1] = ccph.sy[1];
		dumy->ex[2] = ccph.sx[2];
		dumy->ey[2] = ccph.sy[2];
		
		return 0;
	}
	return 1;
}



/* -------------------------------------------------------------------
 *  : [15] ߤܤľ   ƤΥեå P131
 * ؿ : ccl
 *  : rtndat
 *		:	 1	(cx[1] , cy[1]) ,r[1]
 *		:	 2	(cx[2] , cy[2]) ,r[2]
 *  : rtndat
 *		:	type	 0, 1 , 2 , 3 , 4
 *		:	 1	(sx[1] , sy[1]) - (ex[1] , ey[1])
 *		:	 2	(sx[2] , sy[2]) - (ex[2] , ey[2])
 *		:	 3	(sx[3] , sy[3]) - (ex[3] , ey[3])
 *		:	 4	(sx[4] , sy[4]) - (ex[4] , ey[4])
 *  : ̵
 *  : RtnDat pph,pp2h,ppph,pclh,lah,la2h,paph,plph,lcph,pap2h
 */
int ccl(struct RtnDat *dumy)
{
//#define CCL
	struct RtnDat pph,pp2h,ppph,lah,la2h,paph,plph,lcph,pap2h;
	int msg,ccltype;
	double f_dumy,kaku_b1,kaku_b2,kaku_o,kaku_a;
	double x,x1,x2;
	double dist,r1pr2,r1mr2;
	int debug = 0;


#ifdef CCL
	debug = 1;
#endif

	ccltype = 0;
	pph.sx[1] = dumy->cx[1];
	pph.sy[1] = dumy->cy[1];
	pph.ex[1] = dumy->cx[2];
	pph.ey[1] = dumy->cy[2];
	msg = pp(&pph);

	dist = sg(pph.l, compa_digits);
	r1pr2 = sg((dumy->r[1] + dumy->r[2]), compa_digits);
	r1mr2 = sg((dumy->r[1] - dumy->r[2]), compa_digits);


//#ifdef TEAT
	/* ߤΥƤ롣 */
	if (debug > 0) g_print("type 4 : dist > r1pr2 = %d\n", dist > r1pr2);
	/* ߤܤƤ롣 */
	if (debug > 0) g_print("type 3 : dist == r1pr2 = %d\n", dist == r1pr2);
	/* ߤŤʤäƤ롣 */
	if (debug > 0) g_print("type 2 : dist < r1pr2 && dist > r1mr2 = %d\n", (dist < r1pr2 && dist > r1mr2));
	if (debug > 0) g_print("  type 2-1 : dist < r1pr2 = %d\n", (dist < r1pr2));
	if (debug > 0) g_print("  type 2-2 : dist > r1mr2 = %d\n", (dist > r1mr2));
	/* ߤŤʤäܤƤ롣 */
	if (debug > 0) g_print("type 1 : dist == r1mr2 = %d\n", (dist == r1mr2));
	/* ߤŤʤäΥƤ롣 0  */
	if (debug > 0) g_print("type 0 : (dist < r1mr2 && sg(dumy->l, compa_digits) > 0) = %d\n", 
			(dist < r1mr2 && sg(dumy->l, compa_digits) > 0));
	if (debug > 0) g_print("  type 0-1 : (dist < r1mr2) = %d\n", (dist < r1mr2));
	if (debug > 0) g_print("  type 0-2 : (sg(dumy->l, compa_digits) > 0) = %d\n", (sg(dumy->l, compa_digits) > 0));
//#endif


	/* ߤΥƤ롣 */
	if (dist > r1pr2) {
		if (debug > 0) g_print("type 4 : in\n");
		dumy->type = 4;
		
		/* ܤľ */

		/* O1(dumy.cx[1],dumy.cy[1]) - O2(dumy.cx[2],dumy.cy[2])  */
		/* dumy.r[1] : dumy.r[2] ʬ P 롣 */
		ppph.sx[1] = dumy->cx[1];
		ppph.sy[1] = dumy->cy[1];
		ppph.ex[1] = dumy->cx[2];
		ppph.ey[1] = dumy->cy[2];
		ppph.sx[2] = dumy->r[1];
		ppph.ex[2] = dumy->r[2];
		msg = ppp(&ppph);

		/* O1(dumy.cx[1] , dumy.cy[1])  P (pph.sx[3] , pph.sy[3]) γ٤롣 */
		la2h.sx[1] = dumy->cx[1];
		la2h.sy[1] = dumy->cy[1];
		la2h.ex[1] = ppph.sx[3];
		la2h.ey[1] = ppph.sy[3];
		msg = la(&la2h);

		/* O1(dumy.cx[1] , dumy.cy[1])  P (pph.sx[3] , pph.sy[3]) εΥ롣 */
		pp2h.sx[1] = dumy->cx[1];
		pp2h.sy[1] = dumy->cy[1];
		pp2h.ex[1] = ppph.sx[3];
		pp2h.ey[1] = ppph.sy[3];
		msg = pp(&pp2h);
		
		x = dumy->r[1] / pp2h.l;
		x = atan(x / sqrt(-x * x + 1));
		x = (180 / PI) * x;
		
		x1 = la2h.angle + x;
		x2 = la2h.angle - x;

		/*  P  x1  */
		pap2h.sx[1] = ppph.sx[3];
		pap2h.sy[1] = ppph.sy[3];
		pap2h.angle = x1;
		pap2h.l = 100;
		msg = pap(&pap2h);

		lcph.sx[1] = ppph.sx[3];
		lcph.sy[1] = ppph.sy[3];
		lcph.ex[1] = pap2h.ex[1];
		lcph.ey[1] = pap2h.ey[1];
		lcph.cx[1] = dumy->cx[1];
		lcph.cy[1] = dumy->cy[1];
		lcph.r[1] = dumy->r[1];
		msg = lcp(&lcph);

		if (lcph.type != 1) {
			if (debug > 0) g_print("type 4-1 : lcp.type != 1\n");
			dumy->type = 0;
			return 1;
		}
		dumy->sx[3] = lcph.sx[2];
		dumy->sy[3] = lcph.sy[2];

		/* ߣ */
		lcph.sx[1] = ppph.sx[3];
		lcph.sy[1] = ppph.sy[3];
		lcph.ex[1] = pap2h.ex[1];
		lcph.ey[1] = pap2h.ey[1];
		lcph.cx[1] = dumy->cx[2];
		lcph.cy[1] = dumy->cy[2];
		lcph.r[1] = dumy->r[2];
		msg = lcp(&lcph);

		if (lcph.type != 1) {
			if (debug > 0) g_print("type 4-2 : lcp.type != 1\n");
			dumy->type = 0;
			return 1;
		}
		dumy->ex[3] = lcph.sx[2];
		dumy->ey[3] = lcph.sy[2];


		/*  P  x2  */
		pap2h.sx[1] = ppph.sx[3];
		pap2h.sy[1] = ppph.sy[3];
		pap2h.angle = x2;
		pap2h.l = 100;
		msg = pap(&pap2h);

		lcph.sx[1] = ppph.sx[3];
		lcph.sy[1] = ppph.sy[3];
		lcph.ex[1] = pap2h.ex[1];
		lcph.ey[1] = pap2h.ey[1];
		lcph.cx[1] = dumy->cx[1];
		lcph.cy[1] = dumy->cy[1];
		lcph.r[1] = dumy->r[1];
		msg = lcp(&lcph);

		if (lcph.type != 1) {
			if (debug > 0) g_print("type 4-3 : lcp.type != 1\n");
			dumy->type = 0;
			return 1;
		}
		dumy->sx[4] = lcph.sx[2];
		dumy->sy[4] = lcph.sy[2];

		/* ߣ */
		lcph.sx[1] = ppph.sx[3];
		lcph.sy[1] = ppph.sy[3];
		lcph.ex[1] = pap2h.ex[1];
		lcph.ey[1] = pap2h.ey[1];
		lcph.cx[1] = dumy->cx[2];
		lcph.cy[1] = dumy->cy[2];
		lcph.r[1] = dumy->r[2];
		msg = lcp(&lcph);

		if (lcph.type != 1) {
			if (debug > 0) g_print("type 4-4 : lcp.type != 1\n");
			dumy->type = 0;
			return 1;
		}
		dumy->ex[4] = lcph.sx[2];
		dumy->ey[4] = lcph.sy[2];
	}



	/* ߤܤƤ롣 */
	else if (dist == r1pr2) {
		if (debug > 0) g_print("type 3 : in\n");
		dumy->type = 3;
	}



	/* ߤŤʤäƤ롣 */
	else if (dist < r1pr2 && dist > r1mr2) {
		if (debug > 0) g_print("type 2 : in\n");
		dumy->type = 2;
	}



	/* ߤŤʤäܤƤ롣 */
	else if (dist == r1mr2) {
		/* Ťʤäܤ */
		dumy->type = 1;

		/* dumy->r[1]  dumy->r[2] 羮١礭ߣˤ롣 */
		if (dumy->r[1] < dumy->r[2]) {
			f_dumy = dumy->cx[1];
			dumy->cx[1] = dumy->cx[2];
			dumy->cx[2] = f_dumy;
			f_dumy = dumy->cy[1];
			dumy->cy[1] = dumy->cy[2];
			dumy->cy[2] = f_dumy;
			f_dumy = dumy->r[1];
			dumy->r[1] = dumy->r[2];
			dumy->r[2] = f_dumy;
			ccltype = 2;
		}

		/* ߣ濴ߣ濴ؤγ٣롣 */
		lah.sx[1] = dumy->cx[1];
		lah.sy[1] = dumy->cy[1];
		lah.ex[1] = dumy->cx[2];
		lah.ey[1] = dumy->cy[2];
		msg = la(&lah);

		/* ߣ濴٣ˣңԤäФ롣 */
		paph.sx[1] = dumy->cx[1];
		paph.sy[1] = dumy->cy[1];
		paph.angle = lah.angle;
		paph.l = dumy->r[1];
		msg = pap(&paph);

		/* Ф̤ꡢߣ濴ߣ濴ؤľ˿ľ롣 */
		plph.sx[2] = paph.ex[1];
		plph.sy[2] = paph.ey[1];
		plph.sx[1] = dumy->cx[1];
		plph.sy[1] = dumy->cy[1];
		plph.ex[1] = dumy->cx[2];
		plph.ey[1] = dumy->cy[2];
		msg = plp(&plph);
	
		dumy->sx[1] = plph.sx[2];
		dumy->sy[1] = plph.sy[2];
		dumy->ex[1] = plph.ex[3];
		dumy->ey[1] = plph.ey[3];
	
		if (ccltype == 2) {
			f_dumy = dumy->cx[1];
			dumy->cx[1] = dumy->cx[2];
			dumy->cx[2] = f_dumy;
			f_dumy = dumy->cy[1];
			dumy->cy[1] = dumy->cy[2];
			dumy->cy[2] = f_dumy;
			f_dumy = dumy->r[1];
			dumy->r[1] = dumy->r[2];
			dumy->r[2] = f_dumy;
			ccltype = 0;
		}
	}



	/* ߤŤʤäΥƤ롣 0  */
	else if (dist < r1mr2 && sg(dumy->l, compa_digits) > 0) {
		if (debug > 0) g_print("type 1 : in\n");
		dumy->type = 0;
		return 1;
	}



	/* ܤľ */
	if (dumy->type >= 2) {
		/* ңξϣˤ롣 */
		if (dumy->r[1] > dumy->r[2]) {
			f_dumy = dumy->cx[1];
			dumy->cx[1] = dumy->cx[2];
			dumy->cx[2] = f_dumy;
			f_dumy = dumy->cy[1];
			dumy->cy[1] = dumy->cy[2];
			dumy->cy[2] = f_dumy;
			f_dumy = dumy->r[1];
			dumy->r[1] = dumy->r[2];
			dumy->r[2] = f_dumy;
			ccltype = 1;
		}

		/* ϣϣΥ٥ȥγ٤롣(RAD) */
		lah.sx[1] = dumy->cx[1];
		lah.sy[1] = dumy->cy[1];
		lah.ex[1] = dumy->cx[2];
		lah.ey[1] = dumy->cy[2];
		msg = la(&lah);
		lah.angle = degrad(lah.angle);
		kaku_o = lah.angle;

		/* ϣϣεΥ롣 */
		pph.sx[1] = dumy->cx[1];
		pph.sy[1] = dumy->cy[1];
		pph.ex[1] = dumy->cx[2];
		pph.ey[1] = dumy->cy[2];
		msg = pp(&pph);

		/* ѣ롣 */
		kaku_a = (dumy->r[2] - dumy->r[1]) / pph.l;
		kaku_a = atan(kaku_a / sqrt(-kaku_a * kaku_a + 1));

		/* ϣϣγ١ޡʳѣܣˡѣ¤롣 */

		kaku_a = kaku_a + (PI / 2);
		kaku_b1 = kaku_o + kaku_a;
		kaku_b2 = kaku_o - kaku_a;

		kaku_b1 = raddeg(kaku_b1);
		kaku_b2 = raddeg(kaku_b2);

		/* Ʊߤ濴ѣ¤˳ƣҹԤä롣(4) */
		paph.sx[1] = dumy->cx[1];
		paph.sy[1] = dumy->cy[1];
		paph.angle = kaku_b1;
		paph.l = dumy->r[1];
		msg = pap(&paph);
		dumy->sx[1] = paph.ex[1];
		dumy->sy[1] = paph.ey[1];

		paph.sx[1] = dumy->cx[1];
		paph.sy[1] = dumy->cy[1];
		paph.angle = kaku_b2;
		paph.l = dumy->r[1];
		msg = pap(&paph);
		dumy->sx[2] = paph.ex[1];
		dumy->sy[2] = paph.ey[1];

		paph.sx[1] = dumy->cx[2];
		paph.sy[1] = dumy->cy[2];
		paph.angle = kaku_b1;
		paph.l = dumy->r[2];
		msg = pap(&paph);
		dumy->ex[1] = paph.ex[1];
		dumy->ey[1] = paph.ey[1];
		paph.sx[1] = dumy->cx[2];
		paph.sy[1] = dumy->cy[2];
		paph.angle = kaku_b2;
		paph.l = dumy->r[2];
		msg = pap(&paph);
		dumy->ex[2] = paph.ex[1];
		dumy->ey[2] = paph.ey[1];

		if (ccltype == 1) {
			f_dumy = dumy->cx[1];
			dumy->cx[1] = dumy->cx[2];
			dumy->cx[2] = f_dumy;
			f_dumy = dumy->cy[1];
			dumy->cy[1] = dumy->cy[2];
			dumy->cy[2] = f_dumy;
			f_dumy = dumy->r[1];
			dumy->r[1] = dumy->r[2];
			dumy->r[2] = f_dumy;
			ccltype = 0;
		}
	}



	if (dumy->type == 3) {
		/* ¤ܤ */
		/*  1 濴 2 濴ޤǤʬ  */
		/* dumy->r[1] : dumy->r[2] ʬФ롣 */
		ppph.sx[1] = dumy->cx[1];
		ppph.sy[1] = dumy->cy[1];
		ppph.ex[1] = dumy->cx[2];
		ppph.ey[1] = dumy->cy[2];
		ppph.sx[2] = dumy->r[1];
		ppph.ex[2] = dumy->r[2];
		msg = ppp(&ppph);

		/* Ф̤äơ 1 濴 2 濴ޤǤʬ˿ľ롣 */
		plph.sx[2] = ppph.sx[3];
		plph.sy[2] = ppph.sy[3];
		plph.sx[1] = dumy->cx[1];
		plph.sy[1] = dumy->cy[1];
		plph.ex[1] = dumy->cx[2];
		plph.ey[1] = dumy->cy[2];
		msg = plp(&plph);

		dumy->sx[3] = ppph.sx[3];
		dumy->sy[3] = ppph.sy[3];
		dumy->ex[3] = plph.ex[3];
		dumy->ey[3] = plph.ey[3];
	}
	return 0;
}



/* -------------------------------------------------------------------
 *  : [16] ̤ߤܤ
 * ؿ : pcc
 *  : rtndat
 *		:	ߤȾ	  r[2]
 *		:	ߤ濴		 (cx[1] , cy[1]) ,r[1]
 *		:					 (sx[1] , sy[1])
 *  : rtndat
 *		:	type			  0 , 1 , 2 , 3 , 4
 *		:	 1			 (cx[2] , cy[2]) , r[2]
 *		:	 2			 (cx[3] , cy[3]) , r[3]
 *		:	 3			 (cx[4] , cy[4]) , r[4]
 *		:	 4			 (cx[5] , cy[5]) , r[5]
 *  : ̵
 *  : RtnDat pph,ccph,pp2h,lah,paph
 */
int pcc(struct RtnDat *dumy)
{
	struct RtnDat pph,ccph,lah,paph;
	int msg;


	dumy->type = 0;
	/* 1ȱߤ濴ȤεΥ */
	pph.sx[1] = dumy->sx[1];
	pph.sy[1] = dumy->sy[1];
	pph.ex[1] = dumy->cx[1];
	pph.ey[1] = dumy->cy[1];
	msg = pp(&pph);
	
	
	
	/* ߤγˤȤ ------------------------------------------ */
	if (sg(pph.l, compa_digits) > sg(dumy->r[1], compa_digits))
	{
		/* 1.2 */
		if (sg(pph.l - dumy->r[1], compa_digits) <= sg((2 * dumy->r[2]), compa_digits))
		{
			/* Ⱦ£ңαߤȱߤ濴Ⱦ£ңܣңαߤθߤ濴 */
			ccph.cx[1] = dumy->sx[1];
			ccph.cy[1] = dumy->sy[1];
			ccph.r[1] = dumy->r[2];
			ccph.cx[2] = dumy->cx[1];
			ccph.cy[2] = dumy->cy[1];
			ccph.r[2] = dumy->r[1] + dumy->r[2];
			msg = ccp(&ccph);
			dumy->type = ccph.type;
			if (ccph.type == 1)
			{
				dumy->cx[2] = ccph.sx[1];
				dumy->cy[2] = ccph.sy[1];
				dumy->r[2] = dumy->r[2];
			}
			if (ccph.type == 2)
			{
				dumy->cx[2] = ccph.sx[1];
				dumy->cy[2] = ccph.sy[1];
				dumy->r[2] = dumy->r[2];
				dumy->cx[3] = ccph.sx[2];
				dumy->cy[3] = ccph.sy[2];
				dumy->r[3] = dumy->r[2];
			}
		}

		if (sg((pph.l + dumy->r[1]), compa_digits) <= sg((2 * dumy->r[2]), compa_digits))
		{
			/* Ⱦ£ңαߤȱߤ濴Ⱦ£ңݣңαߤθߤ濴 */
			ccph.cx[1] = dumy->sx[1];
			ccph.cy[1] = dumy->sy[1];	
			ccph.r[1] = dumy->r[2];
			ccph.cx[2] = dumy->cx[1];	
			ccph.cy[2] = dumy->cy[1];	
			ccph.r[2] = dumy->r[2] - dumy->r[1];
			msg = ccp(&ccph);
			if (dumy->type == 0)
			{
				dumy->cx[2] = ccph.sx[1];	
				dumy->cy[2] = ccph.sy[1];	
				dumy->r[2] = dumy->r[2];
				if (ccph.type == 2)
				{
					dumy->cx[3] = ccph.sx[2];	
					dumy->cy[3] = ccph.sy[2];	
					dumy->r[3] = dumy->r[2];
				}
			}
			else if (dumy->type == 1)
			{
				dumy->cx[3] = ccph.sx[1];	
				dumy->cy[3] = ccph.sy[1];	
				dumy->r[3] = dumy->r[2];
				if (ccph.type == 2)
				{
					dumy->cx[4] = ccph.sx[2];	
					dumy->cy[4] = ccph.sy[2];	
					dumy->r[4] = dumy->r[2];
				}
			}
			else if (dumy->type == 2)
			{
				dumy->cx[4] = ccph.sx[1];	
				dumy->cy[4] = ccph.sy[1];	
				dumy->r[4] = dumy->r[2];
				if (ccph.type == 2)
				{
					dumy->cx[5] = ccph.sx[2];	
					dumy->cy[5] = ccph.sy[2];	
					dumy->r[5] = dumy->r[2];
				}
			}
			dumy->type = dumy->type + ccph.type;
		}
		else
		{
			dumy->type = dumy->type + 0;
		}
	}





	/* ߤˤȤ ------------------------------------------ */
	if (sg(pph.l, compa_digits) < sg(dumy->r[1], compa_digits))
	{
		if ((sg((dumy->r[1] + pph.l), compa_digits) >= sg((2 * dumy->r[2]), compa_digits))	
			&& (sg((dumy->r[1] - pph.l), compa_digits) <= sg((2 * dumy->r[2]), compa_digits)))
		{
			/* 濴Ⱦ(R1-R2)αߤȾ(R2)αߤθ  */
			ccph.cx[1] = dumy->cx[1];	
			ccph.cy[1] = dumy->cy[1];	
			ccph.r[1] = (dumy->r[1] - dumy->r[2]);
			ccph.cx[2] = dumy->sx[1];	
			ccph.cy[2] = dumy->sy[1];	
			ccph.r[2] = dumy->r[2];
			msg = ccp(&ccph);
			
			if (ccph.type != 0)
			{
				dumy->type = ccph.type;
				dumy->cx[2] = ccph.sx[1];	
				dumy->cy[2] = ccph.sy[1];
				if (dumy->type == 2)
				{
					dumy->cx[3] = ccph.sx[2];	
					dumy->cy[3] = ccph.sy[2];	
					dumy->r[3] = dumy->r[2];
				}
			}
			else
			{
				dumy->type = 0;
			}
		}
	}





	/* ߤξˤȤ ------------------------------------------ */
	if (sg(pph.l, compa_digits) == sg(dumy->r[1], compa_digits))
	{
		dumy->type = 2;
		/* 濴ޤǤγ٣롣 */
		lah.sx[1] = dumy->cx[1];	
		lah.sy[1] = dumy->cy[1];	
		lah.ex[1] = dumy->sx[1];	
		lah.ey[1] = dumy->sy[1];
		msg = la(&lah);

		/* ٣Ⱦ£.r[2]  */
		paph.sx[1] = dumy->sx[1];	
		paph.sy[1] = dumy->sy[1];
		paph.angle = lah.angle; 
		paph.l = dumy->r[2];
		msg = pap(&paph);
				
		dumy->cx[2] = paph.ex[1];	
		dumy->cy[2] = paph.ey[1];

		/* ٣ܣȾ£.r[2] */
		paph.sx[1] = dumy->sx[1];	
		paph.sy[1] = dumy->sy[1];
		paph.angle = (lah.angle + 180); 
		paph.l = dumy->r[2];
		msg = pap(&paph);
				
		dumy->cx[3] = paph.ex[1];	
		dumy->cy[3] = paph.ey[1];	
		dumy->r[3] = dumy->r[2];
	}


	return 0;
}



/* -------------------------------------------------------------------
 *  : [17] ľȱߤܤ
 * ؿ : lcc
 *  : rtndat
 *		:	Ⱦ		r[2]
 *		:			   (sx[1] , sy[1]) - (ex[1] , ey[1])
 *		:			   (cx[1] , cy[1]) , r[1]
 *  : rtndat
 *		:	type
 *		:	 1	   (cx[2] , cy[2]) , r[2]
 *		:	 2	   (cx[3] , cy[3]) , r[3]
 *		:	 3	   (cx[4] , cy[4]) , r[4]
 *		:	 4	   (cx[5] , cy[5]) , r[5]
 *		:	 5	   (cx[6] , cy[6]) , r[6]
 *		:	 6	   (cx[7] , cy[7]) , r[7]
 *		:	 7	   (cx[8] , cy[8]) , r[8]
 *		:	 8	   (cx[9] , cy[9]) , r[9]
 *  : ̵
 *  : RtnDat plph,pph,lah,paph,lcph,loh
 */
int lcc(struct RtnDat *dumy)
{
	struct RtnDat plph,pph,lah,paph,lcph,loh;
	int msg;
	double dist,r1,lmr1,r2x2,lpr1,r2,r1ml;


	dumy->type = 0;
	/* 1 ==============================================================  */
	/* ========== ޤߤ濴εΥ롣			 ==========  */
	/* === start ======================================================  */


	/* ------------------------------------------------  */
	/* PLP	ľκǶʣ̤			 */
	/* ------------------------------------------------  */
	plph.sx[1] = dumy->sx[1];
	plph.sy[1] = dumy->sy[1];
	plph.ex[1] = dumy->ex[1];
	plph.ey[1] = dumy->ey[1];
	plph.sx[2] = dumy->cx[1];
	plph.sy[2] = dumy->cy[1];
	msg = plp(&plph);
	
	/* Ƕ(plph.ex[2],plph.ey[2])  */
	/* ------------------------------------------------  */
	/* PP	֤εΥ								 */
	/* ------------------------------------------------  */
	pph.sx[1] = dumy->cx[1];	
	pph.sy[1] = dumy->cy[1];	
	pph.ex[1] = plph.ex[2]; 
	pph.ey[1] = plph.ey[2];
	msg = pp(&pph);
	/* === end ========================================================  */
	/* ========== ޤߤ濴εΥ롣			 ==========  */
	/* ================================================================  */


	dist = sg(pph.l, compa_digits);
	r1 = sg(dumy->r[1], compa_digits);
	lmr1 = sg(pph.l - dumy->r[1], compa_digits);
	r2x2 = sg(2 * dumy->r[2], compa_digits);
	lpr1 = sg(pph.l + dumy->r[1], compa_digits);
	r2 = sg(dumy->r[2], calcu_digits);
	r1ml = sg(dumy->r[1] - pph.l, compa_digits);



	/* 2 = start ======================================================  */
	/* ========== <   ȱߤΥƤ롣 >				 ==========  */
	/* ================================================================  */
	if (dist > r1)
	{
		/* -< 1 & 2 >-	*/
		/* 濴顢ľκǶޤǤΡγ٣롣 */
		/* ------------------------------------------------  */
		/* LA	ľγ */
		/* ------------------------------------------------  */
		lah.sx[1] = dumy->cx[1];	
		lah.sy[1] = dumy->cy[1];	
		lah.ex[1] = plph.ex[2]; 
		lah.ey[1] = plph.ey[2];
		msg = la(&lah);
		
		if (lmr1 <= r2x2)
		{
			/* ߤ濴 dumy.r[2] եåȤ롣 */
			/* Ƕߤ濴γ٤롣						*/
			/* lah.ANGLE+180  */
			/* ------------------------------------------------  */
			/* PAP	ȳ٤ȵΥľν		 */
			/* ------------------------------------------------  */
			/* ׻  */
			paph.sx[1] = dumy->sx[1];	
			paph.sy[1] = dumy->sy[1];
			paph.angle = lah.angle + 180;	
			paph.l = dumy->r[2];
			msg = pap(&paph);
		
			dumy->sx[2] = paph.ex[1];	
			dumy->sy[2] = paph.ey[1];
		
			/* ׻  */
			paph.sx[1] = dumy->ex[1];	
			paph.sy[1] = dumy->ey[1];
			paph.angle = lah.angle + 180;	
			paph.l = dumy->r[2];
			msg = pap(&paph);
		
			dumy->ex[2] = paph.ex[1];	
			dumy->ey[2] = paph.ey[1];
		
			/* ߤ濴Ⱦ (dumy.r[1] + dumy.r[2]) αߤθ롣 */
			/* ------------------------------------------------  */
			/* LCP ľȱߤθ	ƤΥեå P126  */
			/* ------------------------------------------------  */
			lcph.sx[1] = dumy->sx[2];	
			lcph.sy[1] = dumy->sy[2];	
			lcph.ex[1] = dumy->ex[2];	
			lcph.ey[1] = dumy->ey[2];
			lcph.cx[1] = dumy->cx[1];	
			lcph.cy[1] = dumy->cy[1];	
			lcph.r[1] = (dumy->r[1] + dumy->r[2]);
			msg = lcp(&lcph);
			
			dumy->type = lcph.type;
			
			dumy->cx[2] = lcph.sx[2];	
			dumy->cy[2] = lcph.sy[2];	
			dumy->r[2] = dumy->r[2];
			
			if (lcph.type == 2)
			{
				dumy->cx[3] = lcph.sx[3];	
				dumy->cy[3] = lcph.sy[3];	
				dumy->r[3] = dumy->r[2];
			}
		}



		/* -< 1 & 2 >- OR -< 3 & 4 >-  */
		if (lmr1 <= r2x2)
		{
			/* ߤ濴 dumy.r[2] եåȤ롣  */
			/* Ƕߤ濴γ٤롣 */
			/* lah.ANGLE+180  */
			/* ------------------------------------------------  */
			/* PAP	ȳ٤ȵΥľν */
			/* ------------------------------------------------  */
			/* ׻  */
			paph.sx[1] = dumy->sx[1];	
			paph.sy[1] = dumy->sy[1];
			paph.angle = lah.angle + 180;	
			paph.l = dumy->r[2];
			msg = pap(&paph);
		
			dumy->sx[2] = paph.ex[1];	
			dumy->sy[2] = paph.ey[1];
		
			/* ׻  */
			paph.sx[1] = dumy->ex[1];	
			paph.sy[1] = dumy->ey[1];
			paph.angle = lah.angle + 180;	
			paph.l = dumy->r[2];
			msg = pap(&paph);
		
			dumy->ex[2] = paph.ex[1];	
			dumy->ey[2] = paph.ey[1];
		
			/* ߤ濴Ⱦ (dumy.r[2] - dumy.r[1]) αߤθ롣 */
			/* ------------------------------------------------  */
			/* LCP ľȱߤθ	ƤΥեå P126  */
			/* ------------------------------------------------  */
			lcph.sx[1] = dumy->sx[2];	
			lcph.sy[1] = dumy->sy[2];	
			lcph.ex[1] = dumy->ex[2];	
			lcph.ey[1] = dumy->ey[2];
			lcph.cx[1] = dumy->cx[1];	
			lcph.cy[1] = dumy->cy[1];	
			lcph.r[1] = (dumy->r[2] - dumy->r[1]);
			msg = lcp(&lcph);
			
			if (dumy->type == 0)
			{
				if (lcph.type == 1)
				{
					dumy->cx[2] = lcph.sx[2];	
					dumy->cy[2] = lcph.sy[2];	
					dumy->r[2] = dumy->r[2];
				}
				if (lcph.type == 2)
				{
					dumy->cx[2] = lcph.sx[2];	
					dumy->cy[2] = lcph.sy[2];	
					dumy->r[2] = dumy->r[2];
					dumy->cx[3] = lcph.sx[3];	
					dumy->cy[3] = lcph.sy[3];	
					dumy->r[3] = dumy->r[2];
				}
			}
			
			if (dumy->type == 1)
			{
				if (lcph.type == 1)
				{
					dumy->cx[3] = lcph.sx[2];	
					dumy->cy[3] = lcph.sy[2];	
					dumy->r[3] = dumy->r[2];
				}
				if (lcph.type == 2)
				{
					dumy->cx[3] = lcph.sx[2];	
					dumy->cy[3] = lcph.sy[2];	
					dumy->r[3] = dumy->r[2];
					dumy->cx[4] = lcph.sx[3];	
					dumy->cy[4] = lcph.sy[3];	
					dumy->r[4] = dumy->r[2];
				}
			}
			
			if (dumy->type == 2)
			{
				if (lcph.type == 1)
				{
					dumy->cx[4] = lcph.sx[2];	
					dumy->cy[4] = lcph.sy[2];	
					dumy->r[4] = dumy->r[2];
				}
				if (lcph.type == 2)
				{
					dumy->cx[4] = lcph.sx[2];	
					dumy->cy[4] = lcph.sy[2];	
					dumy->r[4] = dumy->r[2];
					dumy->cx[5] = lcph.sx[3];	
					dumy->cy[5] = lcph.sy[3];	
					dumy->r[5] = dumy->r[2];
				}
			}
			dumy->type = dumy->type + lcph.type;
		}
	}
	/* 2 = end ========================================================  */
	/* ========== <   ȱߤΥƤ롣 >				 ==========  */
	/* ================================================================  */
	
	
	
	
	
	/* 3 = start ======================================================  */
	/* ========== < ȱߤܤƤ롣 >				 ==========  */
	/* ================================================================  */
	if (dist == r1)
	{
		/* -< 1 & 2 >-	*/
		/* -----	<	Ƕ(plph.ex[2],plph.ey[2])ܤߡġ  >------  */
		dumy->type = 4;
		/* 濴顢ľκǶޤǤΡγ٣롣 */
		/* ------------------------------------------------  */
		/* LA	ľγ									 */
		/* ------------------------------------------------  */
		lah.sx[1] = dumy->cx[1];	
		lah.sy[1] = dumy->cy[1];	
		lah.ex[1] = plph.ex[2]; 
		lah.ey[1] = plph.ey[2];
		msg = la(&lah);
		
		/* Ƕ٣ĹȾdumy.r[2]	*/
		/* ------------------------------------------------  */
		/* PAP	ȳ٤ȵΥľν		 */
		/* ------------------------------------------------  */
		paph.sx[1] = plph.ex[2];	
		paph.sy[1] = plph.ey[2];
		paph.angle = lah.angle; 
		paph.l = dumy->r[2];
		msg = pap(&paph);
		
		dumy->cx[2] = paph.ex[1];	
		dumy->cy[2] = paph.ey[1];	
		dumy->r[2] = dumy->r[2];
		
		/* Ƕ٣ܣĹȾdumy.r[2]	*/
		/* paph.sx[1] = plph.ex[2]; paph.sy[1] = plph.ey[2]  */
		paph.angle = (lah.angle + 180);
		paph.l = dumy->r[2];
		msg = pap(&paph);
		
		dumy->cx[3] = paph.ex[1];
		dumy->cy[3] = paph.ey[1];
		dumy->r[3] = dumy->r[2];
		
		
		
		/* -< 3 & 4 >-	*/
		/* ߤ濴 dumy.r[2] եåȤ롣 */
		/* Ƕߤ濴γ٤롣 */
		/* lah.ANGLE+180  */
		/* ------------------------------------------------  */
		/* PAP	ȳ٤ȵΥľν		 */
		/* ------------------------------------------------  */
		/* ׻  */
		paph.sx[1] = dumy->sx[1];	
		paph.sy[1] = dumy->sy[1];
		paph.angle = lah.angle + 180;	
		paph.l = dumy->r[2];
		msg = pap(&paph);
		
		dumy->sx[2] = paph.ex[1];	
		dumy->sy[2] = paph.ey[1];
		
		/* ׻  */
		paph.sx[1] = dumy->ex[1];	
		paph.sy[1] = dumy->ey[1];
		paph.angle = lah.angle + 180;	
		paph.l = dumy->r[2];
		msg = pap(&paph);
		
		dumy->ex[2] = paph.ex[1];	
		dumy->ey[2] = paph.ey[1];
		
		/* ߤ濴Ⱦ (dumy.r[1] + dumy.r[2]) αߤθ롣 */
		/* ------------------------------------------------  */
		/* LCP ľȱߤθ	ƤΥեå P126  */
		/* ------------------------------------------------  */
		lcph.sx[1] = dumy->sx[2]; 
		lcph.sy[1] = dumy->sy[2];	
		lcph.ex[1] = dumy->ex[2];	
		lcph.ey[1] = dumy->ey[2];
		lcph.cx[1] = dumy->cx[1];	
		lcph.cy[1] = dumy->cy[1];	
		lcph.r[1] = (dumy->r[1] + dumy->r[2]);
		msg = lcp(&lcph);
		
		dumy->cx[4] = lcph.sx[2];	
		dumy->cy[4] = lcph.sy[2];	
		dumy->r[4] = dumy->r[2];
		dumy->cx[5] = lcph.sx[3];	
		dumy->cy[5] = lcph.sy[3];	
		dumy->r[5] = dumy->r[2];
	}
	/* 3 = end ========================================================  */
	/* ========== < ȱߤܤƤ롣 >				 ==========  */
	/* ================================================================  */
	
	
	
	
	
	/* 4 = start ======================================================  */
	/* ========== < ȱߤŤʤäƤ롣 >				 ==========  */
	/* ================================================================  */
	if (dist < r1)
	{
		/* -< 1 & 2 & 3 & 4 >-	*/
		/* ξ dumy.r[2] եåȤ¤롣 */
		/* ------------------------------------------------  */
		/* LO	ȽͿľΥեå			 */
		/* ------------------------------------------------  */
		loh.sx[1] = dumy->sx[1];	
		loh.sy[1] = dumy->sy[1];	
		loh.ex[1] = dumy->ex[1];	
		loh.ey[1] = dumy->ey[1];	
		loh.l = dumy->r[2];
		msg = lo(&loh);
		
		/* 濴Ⱦ (dumy.r[1] + dumy.r[2]) αߤθ롣 */
		/* ------------------------------------------------  */
		/* LCP ľȱߤθ	ƤΥեå P126  */
		/* ------------------------------------------------  */
		lcph.sx[1] = loh.sx[2]; 
		lcph.sy[1] = loh.sy[2]; 
		lcph.ex[1] = loh.ex[2]; 
		lcph.ey[1] = loh.ey[2];
		lcph.cx[1] = dumy->cx[1];	
		lcph.cy[1] = dumy->cy[1];	
		lcph.r[1] = (dumy->r[1] + dumy->r[2]);
		msg = lcp(&lcph);
		
		dumy->cx[2] = lcph.sx[2];	
		dumy->cy[2] = lcph.sy[2];	
		dumy->r[2] = dumy->r[2];
		dumy->cx[3] = lcph.sx[3];	
		dumy->cy[3] = lcph.sy[3];	
		dumy->r[3] = dumy->r[2];
		
		/* ¤濴Ⱦ (dumy.r[1] + dumy.r[2]) αߤθ롣 */
		lcph.sx[1] = loh.sx[3]; 
		lcph.sy[1] = loh.sy[3]; 
		lcph.ex[1] = loh.ex[3]; 
		lcph.ey[1] = loh.ey[3];
		lcph.cx[1] = dumy->cx[1];	
		lcph.cy[1] = dumy->cy[1];	
		lcph.r[1] = (dumy->r[1] + dumy->r[2]);
		msg = lcp(&lcph);
		
		dumy->cx[4] = lcph.sx[2];	
		dumy->cy[4] = lcph.sy[2];	
		dumy->r[4] = dumy->r[2];
		dumy->cx[5] = lcph.sx[3];	
		dumy->cy[5] = lcph.sy[3];	
		dumy->r[5] = dumy->r[2];
		
		dumy->type = 4;
		
		
		
		
		/*  ---  */
		if ((lpr1 > r2) && dist != 0)
		{
			/* 濴dumy.r[2]եåȤ롣 */
			/* ľκǶ顢濴ޤǤΡγ٣롣 */
			/* ------------------------------------------------  */
			/* LA	ľγ									 */
			/* ------------------------------------------------  */
			lah.sx[1] = plph.ex[2]; 
			lah.sy[1] = plph.ey[2]; 
			lah.ex[1] = dumy->cx[1];	
			lah.ey[1] = dumy->cy[1];
			msg = la(&lah);
		
			/* Ƕ٣ĹȾdumy.r[2]	*/
			/* ------------------------------------------------  */
			/* PAP	ȳ٤ȵΥľν		 */
			/* ------------------------------------------------  */
			paph.sx[1] = dumy->sx[1];	
			paph.sy[1] = dumy->sy[1];
			paph.angle = lah.angle; 
			paph.l = dumy->r[2];
			msg = pap(&paph);
			dumy->sx[2] = paph.ex[1];	
			dumy->sy[2] = paph.ey[1];
		
			paph.sx[1] = dumy->ex[1];	
			paph.sy[1] = dumy->ey[1];
			paph.angle = lah.angle; 
			paph.l = dumy->r[2];
			msg = pap(&paph);
			dumy->ex[2] = paph.ex[1];	
			dumy->ey[2] = paph.ey[1];
		
			/* 濴Ⱦ(dumy.r[1] - dumy.r[2])αߤθ롣 */
		
			/* ------------------------------------------------  */
			/* LCP ľȱߤθ	ƤΥեå P126  */
			/* ------------------------------------------------  */
			lcph.sx[1] = dumy->sx[2];	
			lcph.sy[1] = dumy->sy[2];	
			lcph.ex[1] = dumy->ex[2];	
			lcph.ey[1] = dumy->ey[2];
			lcph.cx[1] = dumy->cx[1];	
			lcph.cy[1] = dumy->cy[1];	
			lcph.r[1] = (dumy->r[1] - dumy->r[2]);
			msg = lcp(&lcph);
		
			if (lcph.type == 1)
			{
				dumy->cx[6] = lcph.sx[2];	
				dumy->cy[6] = lcph.sy[2];	
				dumy->r[6] = dumy->r[2];
			}
			if (lcph.type == 2)
			{
				dumy->cx[6] = lcph.sx[2];	
				dumy->cy[6] = lcph.sy[2];	
				dumy->r[6] = dumy->r[2];
				dumy->cx[7] = lcph.sx[3];	
				dumy->cy[7] = lcph.sy[3];	
				dumy->r[7] = dumy->r[2];
			}
			dumy->type = dumy->type + lcph.type;
		}
		
		
		
		
		/*  ---  */
		if ((r1ml > r2) && dist != 0)
		{
			/* 濴ȵդdumy.r[2]եåȤ¤롣 */
			/* ľκǶ顢濴ޤǤΡγ٣롣 */
			/* ------------------------------------------------  */
			/* LA	ľγ									 */
			/* ------------------------------------------------  */
			lah.sx[1] = plph.ex[2]; 
			lah.sy[1] = plph.ey[2]; 
			lah.ex[1] = dumy->cx[1];	
			lah.ey[1] = dumy->cy[1];
			msg = la(&lah);
		
			/* Ƕ٣ĹȾdumy.r[2]	*/
			/* ------------------------------------------------  */
			/* PAP	ȳ٤ȵΥľν		 */
			/* ------------------------------------------------  */
			paph.sx[1] = dumy->sx[1];	
			paph.sy[1] = dumy->sy[1];
			paph.angle = (lah.angle + 180); 
			paph.l = dumy->r[2];
			msg = pap(&paph);
			dumy->sx[2] = paph.ex[1];	
			dumy->sy[2] = paph.ey[1];
		
			paph.sx[1] = dumy->ex[1];	
			paph.sy[1] = dumy->ey[1];
			paph.angle = (lah.angle + 180); 
			paph.l = dumy->r[2];
			msg = pap(&paph);
			dumy->ex[2] = paph.ex[1];	
			dumy->ey[2] = paph.ey[1];
		
			/* 濴Ⱦ(dumy->r[1]-dumy.r[2])αߤ¤θ롣 */
		
			/* ------------------------------------------------  */
			/* LCP ľȱߤθ	ƤΥեå P126  */
			/* ------------------------------------------------  */
			lcph.sx[1] = dumy->sx[2];	
			lcph.sy[1] = dumy->sy[2];	
			lcph.ex[1] = dumy->ex[2];	
			lcph.ey[1] = dumy->ey[2];
			lcph.cx[1] = dumy->cx[1];	
			lcph.cy[1] = dumy->cy[1];	
			lcph.r[1] = (dumy->r[1] - dumy->r[2]);
			msg = lcp(&lcph);
			
			
			
			if (dumy->type == 4)
			{
				if (lcph.type == 1)
				{
					dumy->cx[6] = lcph.sx[2];	
					dumy->cy[6] = lcph.sy[2];	
					dumy->r[6] = dumy->r[2];
				}
			
				if (lcph.type == 2)
				{
					dumy->cx[6] = lcph.sx[2];	
					dumy->cy[6] = lcph.sy[2];	
					dumy->r[6] = dumy->r[2];
					dumy->cx[7] = lcph.sx[3];	
					dumy->cy[7] = lcph.sy[3];	
					dumy->r[7] = dumy->r[2];
				}
			}
			
			if (dumy->type == 5)
			{
				if (lcph.type == 1)
				{
					dumy->cx[7] = lcph.sx[2];	
					dumy->cy[7] = lcph.sy[2]; 
					dumy->r[7] = dumy->r[2];
				}
			
				if (lcph.type == 2)
				{
					dumy->cx[7] = lcph.sx[2];	
					dumy->cy[7] = lcph.sy[2];	
					dumy->r[7] = dumy->r[2];
					dumy->cx[8] = lcph.sx[3];	
					dumy->cy[8] = lcph.sy[3];	
					dumy->r[8] = dumy->r[2];
				}
			}
			
			if (dumy->type == 6)
			{
				if (lcph.type == 1)
				{
					dumy->cx[8] = lcph.sx[2];	
					dumy->cy[8] = lcph.sy[2];	
					dumy->r[8] = dumy->r[2];
				}
			
				if (lcph.type == 2)
				{
					dumy->cx[8] = lcph.sx[2];	
					dumy->cy[8] = lcph.sy[2];	
					dumy->r[8] = dumy->r[2];
					dumy->cx[9] = lcph.sx[3];	
					dumy->cy[9] = lcph.sy[3];	
					dumy->r[9] = dumy->r[2];
				}
			}
			dumy->type = dumy->type + lcph.type;
		}
		
		
		
		/* ߤ濴̤Ȥ ---  */
		if ((dist == 0) && r1 >= r2x2)
		{
			/* ξ dumy->r[2] եåȤ¤롣 */
			/* ------------------------------------------------  */
			/* LO	ȽͿľΥեå			 */
			/* ------------------------------------------------  */
			loh.sx[1] = dumy->sx[1];	
			loh.sy[1] = dumy->sy[1];	
			loh.ex[1] = dumy->ex[1];	
			loh.ey[1] = dumy->ey[1];	
			loh.l = dumy->r[2];
			msg = lo(&loh);
		
			/* 濴Ⱦ (dumy->r[1]-dumy->r[2]) αߤθ롣 */
			/* ------------------------------------------------  */
			/* LCP ľȱߤθ	ƤΥեå P126  */
			/* ------------------------------------------------  */
			lcph.sx[1] = loh.sx[2]; 
			lcph.sy[1] = loh.sy[2]; 
			lcph.ex[1] = loh.ex[2]; 
			lcph.ey[1] = loh.ey[2];
			lcph.cx[1] = dumy->cx[1];	
			lcph.cy[1] = dumy->cy[1];	
			lcph.r[1] = (dumy->r[1] - dumy->r[2]);
			msg = lcp(&lcph);
		
			if (lcph.type == 1)
			{
				dumy->cx[6] = lcph.sx[2];	
				dumy->cy[6] = lcph.sy[2];	
				dumy->r[6] = dumy->r[2];
			}
			
			if (lcph.type == 2)
			{
				dumy->cx[6] = lcph.sx[2];	
				dumy->cy[6] = lcph.sy[2];	
				dumy->r[6] = dumy->r[2];
				dumy->cx[7] = lcph.sx[3];	
				dumy->cy[7] = lcph.sy[3];	
				dumy->r[7] = dumy->r[2];
			}
						
			dumy->type = dumy->type + lcph.type;
			
			/* ¤濴Ⱦ (dumy->r[1]-dumy->r[2]) αߤθ롣 */
			lcph.sx[1] = loh.sx[3]; 
			lcph.sy[1] = loh.sy[3]; 
			lcph.ex[1] = loh.ex[3]; 
			lcph.ey[1] = loh.ey[3];
			lcph.cx[1] = dumy->cx[1];	
			lcph.cy[1] = dumy->cy[1];	
			lcph.r[1] = (dumy->r[1] - dumy->r[2]);
			msg = lcp(&lcph);
		
			if (dumy->type == 4)
			{
				if (lcph.type == 1)
				{
					dumy->cx[6] = lcph.sx[2];	
					dumy->cy[6] = lcph.sy[2];	
					dumy->r[6] = dumy->r[2];
				}
				if (lcph.type == 2)
				{
					dumy->cx[6] = lcph.sx[2];	
					dumy->cy[6] = lcph.sy[2];	
					dumy->r[6] = dumy->r[2];
					dumy->cx[7] = lcph.sx[3];	
					dumy->cy[7] = lcph.sy[3];	
					dumy->r[7] = dumy->r[2];
				}
			}
				
			if (dumy->type == 5)
			{
				if (lcph.type == 1)
				{
					dumy->cx[7] = lcph.sx[2];	
					dumy->cy[7] = lcph.sy[2];	
					dumy->r[7] = dumy->r[2];
				}
				if (lcph.type == 2)
				{
					dumy->cx[7] = lcph.sx[2];	
					dumy->cy[7] = lcph.sy[2];	
					dumy->r[7] = dumy->r[2];
					dumy->cx[8] = lcph.sx[3];	
					dumy->cy[8] = lcph.sy[3];	
					dumy->r[8] = dumy->r[2];
				}
			}
				
			if (dumy->type == 6)
			{
				if (lcph.type == 1)
				{
					dumy->cx[8] = lcph.sx[2];	
					dumy->cy[8] = lcph.sy[2];	
					dumy->r[8] = dumy->r[2];
				}
				if (lcph.type == 2)
				{
					dumy->cx[8] = lcph.sx[2];
					dumy->cy[8] = lcph.sy[2];
					dumy->r[8] = dumy->r[2];
					dumy->cx[9] = lcph.sx[3];
					dumy->cy[9] = lcph.sy[3];
					dumy->r[9] = dumy->r[2];
				}
			}
			dumy->type = dumy->type + lcph.type;
		}
	}
	/* 4 = end ========================================================  */
	/* ========== < ȱߤŤʤäƤ롣 >				 ==========  */
	/* ================================================================  */

	return 0;
} 



/* -------------------------------------------------------------------
 *  : [18] ̤
 * ؿ : ppc
 *  : rtndat
 *		:	 1	   (sx[1] , sy[1])
 *		:	 2	   (sx[2] , sy[2])
 *		:	ߤȾ	r[1]
 *  : rtndat
 *		:	type		0 , 1 , 2
 *		:	 1	   (cx[1] , cy[1]) , r[1]
 *		:	 2	   (cx[2] , cy[2]) , r[2]
 *  : ̵
 *  : RtnDat pph,ccph
 */
int ppc(struct RtnDat *dumy)
{
	struct RtnDat pph,ccph;
	int msg;


	/* ---	֤εΥߤȽ  ---  */
	pph.sx[1] = dumy->sx[1];	
	pph.sy[1] = dumy->sy[1];	
	pph.ex[1] = dumy->sx[2];	
	pph.ey[1] = dumy->sy[2];
	msg = pp(&pph);

	if ( sg(pph.l, compa_digits) < sg(2 * dumy->r[1], compa_digits) )
		dumy->type = 2;
	else if ( sg(pph.l, compa_digits) == sg(2 * dumy->r[1], compa_digits) )
		dumy->type = 1;
	else if ( sg(pph.l, compa_digits) > sg(2 * dumy->r[1], compa_digits) )
		dumy->type = 0;


	if (dumy->type != 0)
	{
		/* 濴ȤȾ£ҤΣߤθߤθ  */
		ccph.cx[1] = dumy->sx[1];	
		ccph.cy[1] = dumy->sy[1];	
		ccph.r[1] = dumy->r[1];
		ccph.cx[2] = dumy->sx[2];	
		ccph.cy[2] = dumy->sy[2];	
		ccph.r[2] = dumy->r[1];
		msg = ccp(&ccph);

		dumy->cx[1] = ccph.sx[1];	
		dumy->cy[1] = ccph.sy[1];
		dumy->cx[2] = ccph.sx[2];
		dumy->cy[2] = ccph.sy[2];
		dumy->r[2] = dumy->r[1];
	}

	return 0;
}



/* -------------------------------------------------------------------
 *  : [20] ̤ľܤ
 * ؿ : plc
 *  : rtndat
 *		:				 (sx[1] , sy[1])
 *		:				 (sx[2] , sy[2]) - (ex[2] , ey[2])
 *		:	ߤȾ	  r[3]
 *  : rtndat
 *		:	type
 *		:	 1		 (cx[3]  , cy[3]) , r[3]
 *		:	 2		 (cx[4]  , cy[4]) , r[4]
 *  : ̵
 *  : RtnDat plph,pph,lah,paph,lcph,loh
 */
int plc(struct RtnDat *dumy)
{
	struct RtnDat plph,pph,lah,paph,lcph,loh;
	int msg;
	double dist;


	/* εΥ롣 */
	/* Ⱦ£ңեåȤ롣 */
	plph.sx[1] = dumy->sx[2];	
	plph.sy[1] = dumy->sy[2];	
	plph.ex[1] = dumy->ex[2];	
	plph.ey[1] = dumy->ey[2];
	plph.sx[2] = dumy->sx[1];	
	plph.sy[2] = dumy->sy[1];
	msg = plp(&plph);
	/* (plph.ex[2],plph.ey[2])	*/

	pph.sx[1] = dumy->sx[1];	
	pph.sy[1] = dumy->sy[1];	
	pph.ex[1] = plph.ex[2]; 
	pph.ey[1] = plph.ey[2];
	msg = pp(&pph);

	dist = sg(pph.l, compa_digits);



	if (dist > 0)
	{
		lah.sx[1] = plph.ex[2]; 
		lah.sy[1] = plph.ey[2];
		lah.ex[1] = dumy->sx[1];	
		lah.ey[1] = dumy->sy[1];
		msg = la(&lah);

		paph.sx[1] = dumy->sx[2];	
		paph.sy[1] = dumy->sy[2];	
		paph.angle = lah.angle; 
		paph.l = dumy->r[3];
		msg = pap(&paph);

		lcph.sx[1] = paph.ex[1];	
		lcph.sy[1] = paph.ey[1];

		paph.sx[1] = dumy->ex[2];	
		paph.sy[1] = dumy->ey[2];	
		paph.angle = lah.angle; 
		paph.l = dumy->r[3];
		msg = pap(&paph);

		lcph.ex[1] = paph.ex[1];	
		lcph.ey[1] = paph.ey[1];

		/* 濴ȤȾ£ңαߤȡθ롣 */
		lcph.cx[1] = dumy->sx[1];	
		lcph.cy[1] = dumy->sy[1];	
		lcph.r[1] = dumy->r[3];
		msg = lcp(&lcph);

		if (lcph.type == 0)
		{
			dumy->type = 0;
		}

		if (lcph.type == 1)
		{
			dumy->type = 1;
			dumy->cx[3] = lcph.sx[2];	
			dumy->cy[3] = lcph.sy[2];
		}

		if (lcph.type == 2)
		{
			dumy->type = 2;
			dumy->cx[3] = lcph.sx[2];	
			dumy->cy[3] = lcph.sy[2];
			dumy->cx[4] = lcph.sx[3];	
			dumy->cy[4] = lcph.sy[3];	
			dumy->r[4] = dumy->r[3];
		}
	}


	if (dist == 0)
	{
		loh.sx[1] = dumy->sx[2];	
		loh.sy[1] = dumy->sy[2];	
		loh.ex[1] = dumy->ex[2];	
		loh.ey[1] = dumy->ey[2];	
		loh.l = dumy->r[3];
		msg = lo(&loh);

		lcph.sx[1] = loh.sx[2]; 
		lcph.sy[1] = loh.sy[2]; 
		lcph.ex[1] = loh.ex[2]; 
		lcph.ey[1] = loh.ey[2];
		lcph.cx[1] = dumy->sx[1];	
		lcph.cy[1] = dumy->sy[1];	
		lcph.r[1] = dumy->r[3];
		msg = lcp(&lcph);

		dumy->cx[3] = lcph.sx[2];	
		dumy->cy[3] = lcph.sy[2];	
		dumy->r[3] = dumy->r[3];

		lcph.sx[1] = loh.sx[3]; 
		lcph.sy[1] = loh.sy[3]; 
		lcph.ex[1] = loh.ex[3]; 
		lcph.ey[1] = loh.ey[3];
		lcph.cx[1] = dumy->sx[1];	
		lcph.cy[1] = dumy->sy[1];	
		lcph.r[1] = dumy->r[3];
		msg = lcp(&lcph);

		dumy->cx[4] = lcph.sx[2];	
		dumy->cy[4] = lcph.sy[2];	
		dumy->r[4] = dumy->r[3];

		dumy->type = 2;
	}

	return 0;
}



/* -------------------------------------------------------------------
 *  : [21] ľܤ
 * ؿ : llc
 *  : rtndat
 *		:	 1	(sx[1] , sy[1]) -  (ex[1] , ey[1])
 *		:	 2	(sx[2] , sy[2]) -  (ex[2] , ey[2])
 *		:	Ⱦ	 r[1]
 *  : rtndat
 *		:	 1	(cx[1] , cy[1]) , r[1]
 *		:	 2	(cx[2] , cy[2]) , r[2]
 *		:	 3	(cx[3] , cy[3]) , r[3]
 *		:	 4	(cx[4] , cy[4]) , r[4]
 *  : ̵
 *  : RtnDat loh,llph
 */
int llc(struct RtnDat *dumy)
{
	struct RtnDat loh,llph;
	double sx11,sy11,ex11,ey11;
	double sx12,sy12,ex12,ey12;
	double sx21,sy21,ex21,ey21;
	double sx22,sy22,ex22,ey22;
	int msg;


	/* Ⱦ£ʬեåȤ롣 */
	loh.sx[1] = dumy ->sx[1];	
	loh.sy[1] = dumy ->sy[1];	
	loh.ex[1] = dumy ->ex[1];	
	loh.ey[1] = dumy ->ey[1];	
	loh.l = dumy ->r[1];
	msg = lo(&loh);
	
	sx11 = loh.sx[2];	
	sy11 = loh.sy[2];	
	ex11 = loh.ex[2];	
	ey11 = loh.ey[2];
	sx12 = loh.sx[3];	
	sy12 = loh.sy[3];	
	ex12 = loh.ex[3];	
	ey12 = loh.ey[3];
	
	/* Ⱦ£ʬեåȤ롣 */
	loh.sx[1] = dumy ->sx[2];	
	loh.sy[1] = dumy ->sy[2];	
	loh.ex[1] = dumy ->ex[2];	
	loh.ey[1] = dumy ->ey[2];	
	loh.l = dumy ->r[1];
	msg = lo(&loh);
	
	sx21 = loh.sx[2];	
	sy21 = loh.sy[2];	
	ex21 = loh.ex[2];	
	ey21 = loh.ey[2];
	sx22 = loh.sx[3];	
	sy22 = loh.sy[3];	
	ex22 = loh.ex[3];	
	ey22 = loh.ey[3];
	
	/* Ȥθߣ濴 */
	llph.sx[1] = sx11;	
	llph.sy[1] = sy11;	
	llph.ex[1] = ex11;	
	llph.ey[1] = ey11;
	llph.sx[2] = sx21;	
	llph.sy[2] = sy21;	
	llph.ex[2] = ex21;	
	llph.ey[2] = ey21;
	msg = llp(&llph);
	
	if (llph.type == 0)
	{
		dumy ->type = 0;
		return 1;
	}

	dumy ->type = 4;

	dumy ->cx[1] = llph.sx[3];	
	dumy ->cy[1] = llph.sy[3];

	/* Ȥθߣ濴 */
	llph.sx[1] = sx11;	
	llph.sy[1] = sy11;	
	llph.ex[1] = ex11;	
	llph.ey[1] = ey11;
	llph.sx[2] = sx22;	
	llph.sy[2] = sy22;	
	llph.ex[2] = ex22;	
	llph.ey[2] = ey22;
	msg = llp(&llph);

	dumy ->cx[2] = llph.sx[3];	
	dumy ->cy[2] = llph.sy[3];	
	dumy ->r[2] = dumy ->r[1];

	/* Ȥθߣ濴 */
	llph.sx[1] = sx12;	
	llph.sy[1] = sy12;	
	llph.ex[1] = ex12;	
	llph.ey[1] = ey12;
	llph.sx[2] = sx21;	
	llph.sy[2] = sy21;	
	llph.ex[2] = ex21;	
	llph.ey[2] = ey21;
	msg = llp(&llph);

	dumy ->cx[3] = llph.sx[3];	
	dumy ->cy[3] = llph.sy[3];	
	dumy ->r[3] = dumy ->r[1];

	/* Ȥθߣ濴 */
	llph.sx[1] = sx12;	
	llph.sy[1] = sy12;	
	llph.ex[1] = ex12;	
	llph.ey[1] = ey12;
	llph.sx[2] = sx22;	
	llph.sy[2] = sy22;	
	llph.ex[2] = ex22;	
	llph.ey[2] = ey22;
	msg = llp(&llph);

	dumy ->cx[4] = llph.sx[3];	
	dumy ->cy[4] = llph.sy[3];	
	dumy ->r[4] = dumy ->r[1];

	return 0;
}



/* -------------------------------------------------------------------
 *  : [22] ʬ
 * ؿ : lll
 *  : rtndat
 *		:	 1	(sx[1] , sy[1]) -  (ex[1] , ey[1])
 *		:	 2	(sx[2] , sy[2]) -  (ex[2] , ey[2])
 *  : rtndat
 *		:	type	 0:ľʿ
 *		:			(sx[3] , sy[3]) - (ex[3] , ey[3])  ٥ȥǹͤ롣
 *  : ̵
 *  : RtnDat lah,llph,paph
 */
int lll(struct RtnDat *dumy)
{
	struct RtnDat lah,llph,paph;
	double a0 = 0,a1 = 0,a2 = 0;
	int msg;


	/* ľγ */
	lah.sx[1] = dumy->sx[1];	
	lah.sy[1] = dumy->sy[1];	
	lah.ex[1] = dumy->ex[1];	
	lah.ey[1] = dumy->ey[1];
	msg = la(&lah);
	a1 = lah.angle;

	/* ľγ */
	lah.sx[1] = dumy->sx[2];	
	lah.sy[1] = dumy->sy[2];	
	lah.ex[1] = dumy->ex[2];	
	lah.ey[1] = dumy->ey[2];
	msg = la(&lah);
	a2 = lah.angle;

	/* ľľκ٣ */
	if (sg(a1, compa_digits) > sg(a2, compa_digits)){
		a0 = a1 - a2;	
		a0 = a2 + (a0 / 2);
	}
	if (sg(a1, compa_digits) == sg(a2, compa_digits)){
		dumy->type = 0;
		return 1;
	}
	if (sg(a1, compa_digits) < sg(a2, compa_digits)){
		a0 = a2 - a1;	
		a0 = a1 + (a0 / 2);
	}

	/* ľľθ */
	llph.sx[1] = dumy->sx[1];
	llph.sy[1] = dumy->sy[1];
	llph.ex[1] = dumy->ex[1];
	llph.ey[1] = dumy->ey[1];
	llph.sx[2] = dumy->sx[2];
	llph.sy[2] = dumy->sy[2];
	llph.ex[2] = dumy->ex[2];
	llph.ey[2] = dumy->ey[2];
	msg = llp(&llph);

	dumy->sx[3] = llph.sx[3];
	dumy->sy[3] = llph.sy[3];

	/* ٣˵Υ 100 ľ */
	paph.sx[1] = dumy->sx[3];	
	paph.sy[1] = dumy->sy[3];	
	paph.angle = a0;	
	paph.l = 100;
	msg = pap(&paph);
	
	dumy->ex[3] = paph.ex[1];	
	dumy->ey[3] = paph.ey[1];
	dumy->type = 1;

	return 0;
}



/* -------------------------------------------------------------------
 *  : [23] ̤ꡢľʿԤľ
 * ؿ : pll
 *  : rtndat
 *		:			 (sx[1] , sy[1])
 *		:			 (sx[2] , sy[2]) -	(ex[2] , ey[2])
 *  : rtndat
 *		:	type
 *		:			 (sx[3] , sy[3]) - (ex[3] , ey[3])
 *  : ̵
 *  : RtnDat plph
 */
int pll(struct RtnDat *dumy)
{
	struct RtnDat plph;
	double dx,dy;
	int msg;


	/* PLP	ľκǶʣ̤ */
	plph.sx[2] = dumy->sx[1];	
	plph.sy[2] = dumy->sy[1];
	plph.sx[1] = dumy->sx[2];	
	plph.sy[1] = dumy->sy[2];	
	plph.ex[1] = dumy->ex[2];	
	plph.ey[1] = dumy->ey[2];
	msg = plp(&plph);
	/* Ƕ (plph.ex[2],plph.ey[2])  */

	dx = dumy->sx[1] - plph.ex[2];
	dy = dumy->sy[1] - plph.ey[2];

	dumy->sx[3] = dumy->sx[2] + dx;
	dumy->sy[3] = dumy->sy[2] + dy;
	dumy->ex[3] = dumy->ex[2] + dx;
	dumy->ey[3] = dumy->ey[2] + dy;

	dumy->type = 1;
	return 0;
}



/* -------------------------------------------------------------------
 *  : [24] ߤܤ٣
 * ؿ : cal
 *  : rtndat
 *		:			(cx[1] , cy[1]) , r[1]
 *		:		 angle
 *		:	Ĺ	 l (l = 0 ΤȤ l=100)
 *  : rtndat
 *		:	type	 0 , 2
 *		:	 1	(sx[1] , sy[1]) - (ex[1] , ey[1])
 *		:	 2	(sx[2] , sy[2]) - (ex[2] , ey[2])
 *  : ̵
 *  : RtnDat paph,loh
 */
int cal(struct RtnDat *dumy)
{
	struct RtnDat paph,loh;
	int msg;


	if (dumy->l == 0)
		dumy->l = 100.;

	/* 濴٣ */
	paph.sx[1] = dumy->cx[1];	
	paph.sy[1] = dumy->cy[1];
	paph.angle = dumy->angle;	
	paph.l = dumy->l;
	msg = pap(&paph);
	/* (paph.sx[1],paph.sy[1])-(paph.ex[1],paph.ey[1])	*/

	/* Ⱦ¥եåȤ  */
	loh.sx[1] = paph.sx[1]; 
	loh.sy[1] = paph.sy[1];
	loh.ex[1] = paph.ex[1]; 
	loh.ey[1] = paph.ey[1];
	loh.l = dumy->r[1];
	msg = lo(&loh);
	/* (loh.sx[2],loh.sy[2])-(loh.ex[2],loh.ey[2]),,(loh.sx[3],loh.sy[3])-(loh.ex[3],loh.ey[3])  */

	dumy->type = 2;
	dumy->sx[1] = loh.sx[2];
	dumy->sy[1] = loh.sy[2];
	dumy->ex[1] = loh.ex[2];
	dumy->ey[1] = loh.ey[2];
	dumy->sx[2] = loh.sx[3];
	dumy->sy[2] = loh.sy[3];
	dumy->ex[2] = loh.ex[3];
	dumy->ey[2] = loh.ey[3];
	return 0;
}



/* -------------------------------------------------------------------
 * ͼθ ʲ (20)
 *	
 * double : ǡ 
 * int	  : ݤ
 */
double sg(double value, int keta)
{
	int i = 1;

	if (value < 0)
		i = -1;
	value = value * (double) i;
	value = (double) i * (floor( ( pow(10, keta) * value) + 0.5) ) / pow(10, keta);
	return value;
}



/* -------------------------------------------------------------------
 *  : [19] ߤܤ
 * ؿ : ccc
 *  : rtndat
 *		:	 1	 (cx[1] , cy[1]) ,r[1]
 *		:	 2	 (cx[2] , cy[2]) ,r[2]
 *		:	ߤȾ  r[3]
 *  : rtndat
 *		:	type
 *		:	 1	 (cx[ 3]  , cy[ 3]) , r[ 3]
 *		:	 2	 (cx[ 4]  , cy[ 4]) , r[ 4]
 *		:	 3	 (cx[ 5]  , cy[ 5]) , r[ 5]
 *		:	 4	 (cx[ 6]  , cy[ 6]) , r[ 6]
 *		:	 5	 (cx[ 7]  , cy[ 7]) , r[ 7]
 *		:	 6	 (cx[ 8]  , cy[ 8]) , r[ 8]
 *		:	 7	 (cx[ 9]  , cy[ 9]) , r[ 9]
 *		:	 8	 (cx[10]  , cy[10]) , r[10]
 *		:	 9	 (cx[11]  , cy[11]) , r[11]
 *		:	 10	 (cx[12]  , cy[12]) , r[12]
 *  : ̵
 *  : RtnDat pph,ccph,,lah,paph
 */
int ccc(struct RtnDat *dumy)
{
	struct RtnDat pph, ccph, lah, paph;
	double DumyD;
	int i;


	i = 2;

	/* ߣ礭ʤ褦ˤ롣 */
	if (dumy->r[1] > dumy->r[2]) {
		DumyD = dumy->cx[1];
		dumy->cx[1] = dumy->cx[2];
		dumy->cx[2] = DumyD;

		DumyD = dumy->cy[1];
		dumy->cy[1] = dumy->cy[2];
		dumy->cy[2] = DumyD;

		DumyD = dumy->r[1];
		dumy->r[1] = dumy->r[2];
		dumy->r[2] = DumyD;
	}

	/* 2ߤ濴εΥ׻ */
	pph.sx[1] = dumy->cx[1];
	pph.sy[1] = dumy->cy[1];
	pph.ex[1] = dumy->cx[2];
	pph.ey[1] = dumy->cy[2];
	pp(&pph);



	/*  ߣȱߣΥƤ롣 ----------------------------------- */
	if (sg(pph.l, calcu_digits) > sg(dumy->r[1] + dumy->r[2], calcu_digits)) {
		/* < 1 & 2 > */
		if (sg(2 * dumy->r[3], calcu_digits) >= sg(pph.l - dumy->r[1] - dumy->r[2], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[1]+dumy->R[3] αߤ */
			/* ߣ濴Ⱦ dumy->r[2]+dumy->R[3] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[1] + dumy->r[3];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[2] + dumy->r[3];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i = i + 1;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}

			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
			
		}



		/* < 3 & 4 > */
		if (sg(2 * dumy->r[3], calcu_digits) >= sg(pph.l + dumy->r[1] - dumy->r[2], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[3]-dumy->R[1] αߤ */
			/* ߣ濴Ⱦ dumy->r[3]+dumy->R[2] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[3] - dumy->r[1];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[3] + dumy->r[2];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}



		/* < 5 & 6 > */
		if (sg(2 * dumy->r[3], calcu_digits) >= sg(pph.l + dumy->r[2] - dumy->r[1], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[3]+dumy->R[1] αߤ */
			/* ߣ濴Ⱦ dumy->r[3]-dumy->R[2] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[3] + dumy->r[1];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[3] - dumy->r[2];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}

			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}



		/* < 7 & 8 > */
		if (sg(2 * dumy->r[3], calcu_digits) >= sg(pph.l + dumy->r[1] + dumy->r[2], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[3]-dumy->R[1] αߤ */
			/* ߣ濴Ⱦ dumy->r[3]-dumy->R[2] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[3] - dumy->r[1];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[3] - dumy->r[2];
			ccp(&ccph);

			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}

			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}
	}





	/*  ߣȱߣƱܤƤ롣 ----------------------------- */
	if (sg(pph.l, calcu_digits) == sg(dumy->r[1] + dumy->r[2], calcu_digits)) {
		/* < 1 & 2 > */
		/* ߣ濴Ⱦ dumy->r[3]+dumy->R[1] αߤ */
		/* ߣ濴Ⱦ dumy->r[3]+dumy->R[2] αߤθ */
		/* ------------------------------------------------ */
		/* CCP	ߤθ */
		/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
		/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
		/*	   dumy->TYPE */
		/* ------------------------------------------------ */
		ccph.cx[1] = dumy->cx[1];
		ccph.cy[1] = dumy->cy[1];
		ccph.r[1] = dumy->r[3] + dumy->r[1];
		ccph.cx[2] = dumy->cx[2];
		ccph.cy[2] = dumy->cy[2];
		ccph.r[2] = dumy->r[3] + dumy->r[2];
		ccp(&ccph);

		if (ccph.type == 1) {
			i++;
			dumy->cx[i] = ccph.sx[1];
			dumy->cy[i] = ccph.sy[1];
			dumy->r[i] = dumy->r[3];
		}

		if (ccph.type == 2) {
			i++;
			dumy->cx[i] = ccph.sx[1];
			dumy->cy[i] = ccph.sy[1];
			dumy->r[i] = dumy->r[3];
			i++;
			dumy->cx[i] = ccph.sx[2];
			dumy->cy[i] = ccph.sy[2];
			dumy->r[i] = dumy->r[3];
		}


		/* < 3 & 4 > */
		/* ------------------------------------------------ */
		/* CCP	ߤθ */
		/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX(2),dumy->CY(2)) dumy->R(2) */
		/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX(2),dumy->SY(2)) */
		/*	   dumy->TYPE */
		/* ------------------------------------------------ */
		ccph.cx[1] = dumy->cx[1];
		ccph.cy[1] = dumy->cy[1];
		ccph.r[1] = dumy->r[1];
		ccph.cx[2] = dumy->cx[2];
		ccph.cy[2] = dumy->cy[2];
		ccph.r[2] = dumy->r[2];
		ccp(&ccph);
						
		if (ccph.type == 1) {
			/* (ccph.sx[1],ccph.sy[1]) */
			/* ------------------------------------------------ */
			/* la	ľγ */
			/*	  (dumy->sx[1],dumy->sy[1]),(dumy->ex[1],dumy->ey[1]) */
			/*		   ans dumy->angle */
			/* ------------------------------------------------ */
			lah.sx[1] = ccph.sx[1];
			lah.sy[1] = ccph.sy[1];
			lah.ex[1] = dumy->cx[1];
			lah.ey[1] = dumy->cy[1];
			la(&lah);

			/* 3 */
			/* ------------------------------------------------ */
			/* pap	ȳ٤ȵΥľν */
			/*	  (dumy->sx[1] , dumy->sy[1]) , dumy->angle , dumy->l */
			/*		   ans	(dumy->ex[1] , dumy->ey[1]) */
			/* ------------------------------------------------ */
			paph.sx[1] = ccph.sx[1];
			paph.sy[1] = ccph.sy[1];
			paph.angle = lah.angle;
			paph.l = dumy->r[3];
			pap(&paph);

			i++;
			dumy->cx[i] = paph.ex[1];
			dumy->cy[i] = paph.ey[1];
			dumy->r[i] = dumy->r[3];

			/* 4 */
			/* ------------------------------------------------ */
			/* pap	ȳ٤ȵΥľν */
			/*	  (dumy->sx[1] , dumy->sy[1]) , dumy->angle , dumy->l */
			/*		   ans	(dumy->ex[1] , dumy->ey[1]) */
			/* ------------------------------------------------ */
			paph.sx[1] = ccph.sx[1];
			paph.sy[1] = ccph.sy[1];
			paph.angle = (lah.angle + 180);
			paph.l = dumy->r[3];
			pap(&paph);

			i++;
			dumy->cx[i] = paph.ex[1];
			dumy->cy[i] = paph.ey[1];
			dumy->r[i] = dumy->r[3];
		}



		/* < 5 & 6 > */
		if (sg(2 * dumy->r[3], calcu_digits) >= sg(pph.l + dumy->r[1] + dumy->r[2], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[3]-dumy->R[1] αߤ */
			/* ߣ濴Ⱦ dumy->r[3]-dumy->R[2] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[3] - dumy->r[1];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[3] - dumy->r[2];
			ccp(&ccph);

			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}
	}





	/*  ߣȱߣŤʤäƤ롣---------------------------------- */
	if ((sg(pph.l, calcu_digits) < sg(dumy->r[1] + dumy->r[2], calcu_digits))
		&&
			(sg(pph.l, calcu_digits) > sg(dumy->r[2] - dumy->r[1], calcu_digits)))
	{
		/* < 1 & 2 >  Ф */
		/* ߣ濴Ⱦ dumy->r[3]+dumy->R[1] αߤ */
		/* ߣ濴Ⱦ dumy->r[3]+dumy->R[2] αߤθ */
		/* ------------------------------------------------ */
		/* CCP	ߤθ */
		/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
		/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
		/*	   dumy->TYPE */
		/* ------------------------------------------------ */
		ccph.cx[1] = dumy->cx[1];
		ccph.cy[1] = dumy->cy[1];
		ccph.r[1] = dumy->r[3] + dumy->r[1];
		ccph.cx[2] = dumy->cx[2];
		ccph.cy[2] = dumy->cy[2];
		ccph.r[2] = dumy->r[3] + dumy->r[2];
		ccp(&ccph);
						
		if (ccph.type == 1) {
			i++;
			dumy->cx[i] = ccph.sx[1];
			dumy->cy[i] = ccph.sy[1];
			dumy->r[i] = dumy->r[3];
		}
			
		if (ccph.type == 2) {
			i++;
			dumy->cx[i] = ccph.sx[1];
			dumy->cy[i] = ccph.sy[1];
			dumy->r[i] = dumy->r[3];
			i++;
			dumy->cx[i] = ccph.sx[2];
			dumy->cy[i] = ccph.sy[2];
			dumy->r[i] = dumy->r[3];
		}



		/* < 3 & 4 > */
		if (sg(2 * dumy->r[3], calcu_digits) <= sg(pph.l - dumy->r[2] + dumy->r[1], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[1]-dumy->R[3] αߤ */
			/* ߣ濴Ⱦ dumy->r[3]+dumy->R[2] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[1] - dumy->r[3];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[3] + dumy->r[2];
			ccp(&ccph);

			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}



		/* < 5 & 6 > */
		if (sg(2 * dumy->r[3], calcu_digits) <= sg(pph.l - dumy->r[1] + dumy->r[2], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[1]+dumy->R[3] αߤ */
			/* ߣ濴Ⱦ dumy->r[2]-dumy->R[3] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[1] + dumy->r[3];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[2] - dumy->r[3];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}



		/* < 7 & 8 > */
		if (sg(2 * dumy->r[3], calcu_digits) <= sg(dumy->r[1] + dumy->r[2] - pph.l, calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[1]-dumy->R[3] αߤ */
			/* ߣ濴Ⱦ dumy->r[2]-dumy->R[3] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[1] - dumy->r[3];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[2] - dumy->r[3];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}



		/* < 9 & 10 > */
		if (sg(2 * dumy->r[3], calcu_digits) >= sg(pph.l + dumy->r[1] + dumy->r[2], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[3]-dumy->R[1] αߤ */
			/* ߣ濴Ⱦ dumy->r[3]-dumy->R[2] αߤθ */
			/* ------------------------------------------------ */
			/* CCP	ߤθ */
			/* (dumy->cx[1],dumy->CY[1]) dumy->r[1] (dumy->CX[2],dumy->cy[2]) dumy->R[2] */
			/*	 Ans (dumy->SX[1],dumy->SY[1]) (dumy->SX[2],dumy->SY[2]) */
			/*	   dumy->TYPE */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[3] - dumy->r[1];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[3] - dumy->r[2];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}
	}





	/*  ߣ˱ߣäܤƤ롣-------------------------- */
	if (sg(pph.l, calcu_digits) == sg(dumy->r[2] - dumy->r[1], calcu_digits)
		&& sg(dumy->r[2], calcu_digits) != sg(dumy->r[1], calcu_digits))
	{
		/* < 1 & 2 > */
		/* ------------------------------------------------ */
		/* ccp	ߤθ */
		/* (dumy->cx[1],dumy->cy[1]) dumy->r[1] (dumy->cx[2],dumy->cy[2]) dumy->r[2] */
		/*	 ans (dumy->sx[1],dumy->sy[1]) (dumy->sx[2],dumy->sy[2]) */
		/*	   dumy->type */
		/* ------------------------------------------------ */
		ccph.cx[1] = dumy->cx[1];
		ccph.cy[1] = dumy->cy[1];
		ccph.r[1] = dumy->r[1];
		ccph.cx[2] = dumy->cx[2];
		ccph.cy[2] = dumy->cy[2];
		ccph.r[2] = dumy->r[2];
		ccp(&ccph);
						
		/* (ccph.sx[1],ccph.sy[1]) */
		/* ------------------------------------------------ */
		/* la	ľγ */
		/*	  (dumy->sx[1],dumy->sy[1]),(dumy->ex[1],dumy->ey[1]) */
		/*		   ans dumy->angle */
		/* ------------------------------------------------ */
		lah.sx[1] = ccph.sx[1];
		lah.sy[1] = ccph.sy[1];
		lah.ex[1] = dumy->cx[1];
		lah.ey[1] = dumy->cy[1];
		la(&lah);
			
		/* 3 */
		/* ------------------------------------------------ */
		/* pap	ȳ٤ȵΥľν */
		/*	  (dumy->sx[1] , dumy->sy[1]) , dumy->angle , dumy->l */
		/*		   ans	(dumy->ex[1] , dumy->ey[1]) */
		/* ------------------------------------------------ */
		paph.sx[1] = ccph.sx[1];
		paph.sy[1] = ccph.sy[1];
		paph.angle = lah.angle;
		paph.l = dumy->r[3];
		pap(&paph);
			
		i++;
		dumy->cx[i] = paph.ex[1];
		dumy->cy[i] = paph.ey[1];
		dumy->r[i] = dumy->r[3];
		
		/* 4 */
		/* ------------------------------------------------ */
		/* pap	ȳ٤ȵΥľν */
		/*	  (dumy->sx[1] , dumy->sy[1]) , dumy->angle , dumy->l */
		/*		   ans	(dumy->ex[1] , dumy->ey[1]) */
		/* ------------------------------------------------ */
		paph.sx[1] = ccph.sx[1];
		paph.sy[1] = ccph.sy[1];
		paph.angle = (lah.angle + 180);
		paph.l = dumy->r[3];
		pap(&paph);
			
		i++;
		dumy->cx[i] = paph.ex[1];
		dumy->cy[i] = paph.ey[1];
		dumy->r[i] = dumy->r[3];



		/* < 3 & 4 > */
		if (sg(2 * dumy->r[3], calcu_digits) <= sg(2 * dumy->r[2] - 2 * dumy->r[1], calcu_digits)) {
			/* ߣ濴Ⱦ dumy->r[1]+dumy->r[3] αߤ */
			/* ߣ濴Ⱦ dumy->r[2]-dumy->r[3] αߤθ */
			/* ------------------------------------------------ */
			/* ccp	ߤθ */
			/* (dumy->cx[1],dumy->cy[1]) dumy->r[1] (dumy->cx[2],dumy->cy[2]) dumy->r[2] */
			/*	 ans (dumy->sx[1],dumy->sy[1]) (dumy->sx[2],dumy->sy[2]) */
			/*	   dumy->type */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[1] + dumy->r[3];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[2] - dumy->r[3];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}
	}



	/*  ߣ˱ߣäΥƤ롣-------------------------- */
	if (sg(pph.l, calcu_digits) < sg(dumy->r[2] - dumy->r[1], calcu_digits)
		&& sg(dumy->r[2], calcu_digits) != sg(dumy->r[1], calcu_digits))
	{
		/* < 1 & 2 > */
		if ((sg(2 * dumy->r[3], calcu_digits) >= sg(dumy->r[2] - pph.l - dumy->r[1], calcu_digits))
			&&
				(sg(2 * dumy->r[3], calcu_digits) <= sg(dumy->r[2] + pph.l - dumy->r[1], calcu_digits)))
		{
			/* ߣ濴Ⱦ dumy->r[1]+dumy->r[3] αߤ */
			/* ߣ濴Ⱦ dumy->r[2]-dumy->r[3] αߤθ */
			/* ------------------------------------------------ */
			/* ccp	ߤθ */
			/* (dumy->cx[1],dumy->cy[1]) dumy->r[1] (dumy->cx[2],dumy->cy[2]) dumy->r[2] */
			/*	 ans (dumy->sx[1],dumy->sy[1]) (dumy->sx[2],dumy->sy[2]) */
			/*	   dumy->type */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[1] + dumy->r[3];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[2] - dumy->r[3];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}



		/* < 3 & 4 > */
		if ((sg(2 * dumy->r[3], calcu_digits) >= sg(dumy->r[2] - pph.l + dumy->r[1], calcu_digits))
			&& (sg(2 * dumy->r[3], calcu_digits) <= sg(dumy->r[2] + pph.l + dumy->r[1], calcu_digits)))
		{
			/* ߣ濴Ⱦ dumy->r[3]-dumy->r[1] αߤ */
			/* ߣ濴Ⱦ dumy->r[2]-dumy->r[3] αߤθ */
			/* ------------------------------------------------ */
			/* ccp	ߤθ */
			/* (dumy->cx[1],dumy->cy[1]) dumy->r[1] (dumy->cx[2],dumy->cy[2]) dumy->r[2] */
			/*	 ans (dumy->sx[1],dumy->sy[1]) (dumy->sx[2],dumy->sy[2]) */
			/*	   dumy->type */
			/* ------------------------------------------------ */
			ccph.cx[1] = dumy->cx[1];
			ccph.cy[1] = dumy->cy[1];
			ccph.r[1] = dumy->r[3] - dumy->r[1];
			ccph.cx[2] = dumy->cx[2];
			ccph.cy[2] = dumy->cy[2];
			ccph.r[2] = dumy->r[2] - dumy->r[3];
			ccp(&ccph);
						
			if (ccph.type == 1) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
			}
			
			if (ccph.type == 2) {
				i++;
				dumy->cx[i] = ccph.sx[1];
				dumy->cy[i] = ccph.sy[1];
				dumy->r[i] = dumy->r[3];
				i++;
				dumy->cx[i] = ccph.sx[2];
				dumy->cy[i] = ccph.sy[2];
				dumy->r[i] = dumy->r[3];
			}
		}
	}



	i = i - 2;
	dumy->type = i;
	return 0;
}



/* -------------------------------------------------------------------
 *  : ̤
 * ؿ : pppc()
 *  : struct RtnDat *a
 *		:	( a->sx[1] , a->sy[1] )
 *		:	( a->sx[2] , a->sy[2] )
 *		:	( a->sx[3] , a->sy[3] )
 *  : int
 *		:	(a->cx[1],a->cy[1]),a->r[1]
 *  : ̵
 *  : ̵
 *  : ʸ	[Visual Basic ˤ CG] ˭  ȿ޽
 */
int pppc(struct RtnDat *dumy)
{
	double x1, y1, x2, y2, x3, y3, dev, eps = 0.000001;
	double f1, f2, f3, g1, g2, g3, fg1, fg2, fg3;
	double a1, a2, b1, b2, c1, c2;
	double a11, a22, b11, b22, c11, c22;
	double xa, ya, xb, yb, xc, yc, r;


	x1 = dumy->sx[1];
	y1 = dumy->sy[1];

	x2 = dumy->sx[2];
	y2 = dumy->sy[2];

	f1 = x2 - x1;
	g1 = y2 - y1;
	fg1 = f1*f1 + g1*g1;
	if (fg1 < eps) {
		g_print( _("Circle from three points : Error : Identical Point") );
		return 0;
	}

	/* η׻ */
	xa = x1 + f1/2;
	ya = y1 + g1/2;
	/* ʬL1η */
	a1 = -g1;
	b1 = f1;
	c1 = x1*g1 - y1*f1;
	/* ʬL11η */
	a11 = b1;
	b11 = -a1;
	c11 = a1*ya - b1*xa;

	x3 = dumy->sx[3];
	y3 = dumy->sy[3];

	f2 = x3 - x2;
	g2 = y3 - y2;
	fg2 = f2*f2 + g2*g2;
	if (fg2 < eps) {
		g_print( _("Circle from three points : Error : Identical Point") );
		return 0;
	}


	f3 = x3 - x1;
	g3 = y3 - y1;
	fg3 = f3*f3 + g3*g3;
	if (fg3 < eps) {
		g_print( _("Circle from three points : Error : Identical Point") );
		return 0;
	}

	/* η׻ */
	xb = x2 + f2/2;
	yb = y2 + g2/2;
	/* ʬL2η */
	a2 = -g2;
	b2 = f2;
	c2 = x2*g2 - y2*f2;
	/* ʬL22η */
	a22 = b2;
	b22 = -a2;
	c22 = a2*yb - b2*xb;

	dev = a11*b22 - a22*b11;
	/* 濴η׻ */
	xc = (b11*c22 - b22*c11) / dev;
	yc = (a22*c11 - a11*c22) / dev;
	/* Ⱦ¤η׻ */
	r = sqrt( (xc-x1)*(xc-x1) + (yc-y1)*(yc-y1) );


	dumy->cx[1] = xc;
	dumy->cy[1] = yc;
	dumy->r[1]	= r;
	return 1;
}



/* -------------------------------------------------------------------
 *  : դܤ
 * ؿ : lllc()
 *  : struct RtnDat *a
 *		:	  (a->sx[1],a->sy[1]) - (a->ex[1],a->ey[1])
 *		:	  (a->sx[2],a->sy[2]) - (a->ex[2],a->ey[2])
 *		:	  (a->sx[3],a->sy[3]) - (a->ex[3],a->ey[3])
 *  : int Type = 0,2,4	
 *		:	  (a->cx[1],a->cy[1]),a->r[1]
 *		:	  (a->cx[2],a->cy[2]),a->r[2]
 *		:	  (a->cx[3],a->cy[3]),a->r[3]
 *		:	  (a->cx[4],a->cy[4]),a->r[4]
 *  : ̵
 *  : ̵
 *  : ʸ	[Visual Basic ˤ CG] ˭  ȿ޽
 */
int lllc(struct RtnDat *a)
{
/* 1	̤ */
/* 2	ľʿ */
/* 0	ľʿ */
/* ------------------------------------------------ */
/*	⤷ľΣľʿԤʤ顢ΣľȾ¤ơ */
/* ľʿԤǿľ;˱ߤ濴뤫顢ľ */
/* ͤȣܤľθơθľͤΡޤΣ */
/* ȾʬΥ줿ߤ濴 */
	double dumy;
	struct RtnDat PPPH, PAPH, LOH;
	struct RtnDat LLLH, LLPH, PLPH, PPH;
	struct RtnDat lah;
	double La1, La2 , La3;
	double AX = 0, AY = 0, BX = 0, BY = 0, FX = 0, FY = 0;
	double SXA, SYA, EXA, EYA,	SXB, SYB, EXB, EYB;


	/* --- <  > ---------------------------------------------------------- */



	/* ----------------------------------------------------- */
	/* --- < ľγ٤롣 > ---------------------- */
	/* --- */
	/* --- */

	/* γ٤롣 */
	lah.sx[1] = a->sx[1]; lah.sy[1] = a->sy[1]; lah.ex[1] = a->ex[1]; lah.ey[1] = a->ey[1];
	la(&lah);
	La1 = lah.angle;
	if (La1 > 180) La1 = La1 - 180;

	/* γ٤롣 */
	lah.sx[1] = a->sx[2]; lah.sy[1] = a->sy[2]; lah.ex[1] = a->ex[2]; lah.ey[1] = a->ey[2];
	la(&lah);
	La2 = lah.angle;
	if (La2 > 180) La2 = La2 - 180;

	/* γ٤롣 */
	lah.sx[1] = a->sx[3]; lah.sy[1] = a->sy[3]; lah.ex[1] = a->ex[3]; lah.ey[1] = a->ey[3];
	la(&lah);
	La3 = lah.angle;
	if (La3 > 180) La3 = La3 - 180;



	/* ----------------------------------------------------- */
	/* --- < ٤ǼνȽꤹ롣 > ------------------ */
	/* --- */
	/* --- */

	/* ľȤʿ */
	if (sg(La1, compa_digits) == sg(La2, compa_digits) && sg(La1, compa_digits) == sg(La3, compa_digits)) {
		a->type = 0;
		return 0;
	}

	/* ľʿ */
	if (sg(La1, compa_digits) == sg(La2, compa_digits) || sg(La1, compa_digits) == sg(La3, compa_digits) || sg(La2, compa_digits) == sg(La3, compa_digits)) {
		a->type = 2;
	}
	else a->type = 4;
	/* --- <  > ---------------------------------------------------------- */



	/* --- < ľʿԡ> --------------------------------------------------- */
	if (a->type == 2) {
		/* ľ1ľ2ʿԤˤʤ褦˥ǡؤ롣 */
		if (sg(La1, compa_digits) == sg(La2, compa_digits)) {
			/* OK */
		}
		else if (sg(La1, compa_digits) == sg(La3, compa_digits)) {
			/* 23ؤ롣 */
			dumy = La3; La3 = La2; La2 = dumy;	
			dumy = a->sx[3]; a->sx[3] = a->sx[2]; a->sx[2] = dumy;
			dumy = a->sy[3]; a->sy[3] = a->sy[2]; a->sy[2] = dumy;
			dumy = a->ex[3]; a->ex[3] = a->ex[2]; a->ex[2] = dumy;
			dumy = a->ey[3]; a->ey[3] = a->ey[2]; a->ey[2] = dumy;
		}
		else if (sg(La2, compa_digits) == sg(La3, compa_digits)) {
			/* 13ؤ롣 */
			dumy = La3; La3 = La1; La1 = dumy;
			dumy = a->sx[3]; a->sx[3] = a->sx[1]; a->sx[1] = dumy;
			dumy = a->sy[3]; a->sy[3] = a->sy[1]; a->sy[1] = dumy;
			dumy = a->ex[3]; a->ex[3] = a->ex[1]; a->ex[1] = dumy;
			dumy = a->ey[3]; a->ey[3] = a->ey[1]; a->ey[1] = dumy;
		}


		/* --- < ľ 1 ľ 2 εΥ롣> ----------------------------- */
		/* ľ 1 λľ 2 κǶ롣 */
		PLPH.sx[2] = a->sx[1]; PLPH.sy[2] = a->sy[1];	
		PLPH.sx[1] = a->sx[2]; PLPH.sy[1] = a->sy[2]; PLPH.ex[1] = a->ex[2]; PLPH.ey[1] = a->ey[2];
		plp(&PLPH); /* ( PLPH.ex[2] , PLPH.ey[2] ) */

		/* ľ 1 λľ 2 κǶεΥᡢȾ R 롣 */
		PPH.sx[1] = a->sx[1]; PPH.sy[1] = a->sy[1]; PPH.ex[1] = PLPH.ex[2]; PPH.ey[1] = PLPH.ey[2];
		pp(&PPH);
		a->r[1] = PPH.l / 2;
		a->r[2] = PPH.l / 2;

		/* ľ 1 λľ 2 κǶᡢľ 1ʿԤľ 4롣 */
		PPPH.sx[1] = a->sx[1]; PPPH.sy[1] = a->sy[1]; PPPH.ex[1] = PLPH.ex[2]; PPPH.ey[1] = PLPH.ey[2];
		PPPH.sx[2] = 1; PPPH.ex[2] = 1;
		ppp(&PPPH);
		/*   ľ 4 λ( PPPH.sx[3] , PPPH.sy[3]) */

		PAPH.sx[1] = PPPH.sx[3]; PAPH.sy[1] = PPPH.sy[3]; PAPH.angle = La1; PAPH.l = 50;
		pap(&PAPH);
		/* ľ 4 ν( PAPH.ex[1] , PAPH.ey[1]) */

		/* ľ 4 ľ 3 θ 5 롣 */
		LLPH.sx[1] = PPPH.sx[3]; LLPH.sy[1] = PPPH.sy[3]; LLPH.ex[1] = PAPH.ex[1]; LLPH.ey[1] = PAPH.ey[1];
		LLPH.sx[2] = a->sx[3]; LLPH.sy[2] = a->sy[3]; LLPH.ex[2] = a->ex[3]; LLPH.ey[2] = a->ey[3];
		llp(&LLPH);
		/*  5( LLPH.sx[3] , LLPH.sy[3] ) */



		/* ľ 3 򥪥եåȤľ 5,6 롣 */
		/* ------------------------------------------------------------------- */
		/*  : ȽͿľΥեå */
		/* ------------------------------------------------------------------- */
		LOH.sx[1] = a->sx[3];
		LOH.sy[1] = a->sy[3];
		LOH.ex[1] = a->ex[3];
		LOH.ey[1] = a->ey[3];
		LOH.l = a->r[1];
		lo(&LOH);
		/* (LOH.sx[2] , LOH.sy[2]) - (LOH.ex[2] , LOH.ey[2]) */
		/* (LOH.sx[3] , LOH.sy[3]) - (LOH.ex[3] , LOH.ey[3]) */

		/* ľ 5,6 ľ 4 θ */
		/* ------------------------------------------------------------------- */
		/*  : ľθ	ƤΥեå P120 */
		/* ------------------------------------------------------------------- */
		LLPH.sx[1] = LOH.sx[2];
		LLPH.sy[1] = LOH.sy[2];
		LLPH.ex[1] = LOH.ex[2];
		LLPH.ey[1] = LOH.ey[2];

		LLPH.sx[2] = PPPH.sx[3];
		LLPH.sy[2] = PPPH.sy[3];
		LLPH.ex[2] = PAPH.ex[1];
		LLPH.ey[2] = PAPH.ey[1];
		llp(&LLPH);
		a->cx[1] = LLPH.sx[3];
		a->cy[1] = LLPH.sy[3];


		LLPH.sx[1] = LOH.sx[3];
		LLPH.sy[1] = LOH.sy[3];
		LLPH.ex[1] = LOH.ex[3];
		LLPH.ey[1] = LOH.ey[3];

		LLPH.sx[2] = PPPH.sx[3];
		LLPH.sy[2] = PPPH.sy[3];
		LLPH.ex[2] = PAPH.ex[1];
		LLPH.ey[2] = PAPH.ey[1];
		llp(&LLPH);
		a->cx[2] = LLPH.sx[3];
		a->cy[2] = LLPH.sy[3];
		return 1;
	}
	/* --- < ľʿԡ> --------------------------------------------------- */





	/* --- < դʿԤǤʤ> ----------------------------------------------- */
	if (a->type == 4) {
		/* ----------------------------------------------------- */
		/* --- < դθ롣 > ------------------------ */
		/* --- */
		/* --- */

		/* ***	ľľθ롣 */
		LLPH.sx[1] = a->sx[1]; LLPH.sy[1] = a->sy[1]; LLPH.ex[1] = a->ex[1]; LLPH.ey[1] = a->ey[1];
		LLPH.sx[2] = a->sx[2]; LLPH.sy[2] = a->sy[2]; LLPH.ex[2] = a->ex[2]; LLPH.ey[2] = a->ey[2];
		llp(&LLPH);
		/* =0 ʤʿ */
		if (LLPH.type != 0) {
			AX = LLPH.sx[3];
			AY = LLPH.sy[3];
		}

		/* ***	ľľθ¤롣 */
		LLPH.sx[1] = a->sx[2]; LLPH.sy[1] = a->sy[2]; LLPH.ex[1] = a->ex[2]; LLPH.ey[1] = a->ey[2];
		LLPH.sx[2] = a->sx[3]; LLPH.sy[2] = a->sy[3]; LLPH.ex[2] = a->ex[3]; LLPH.ey[2] = a->ey[3];
		llp(&LLPH);
		if (LLPH.type != 0) {
			BX = LLPH.sx[3];
			BY = LLPH.sy[3];
		}

		/* ***	ľľθƤ롣 */
		LLPH.sx[1] = a->sx[3]; LLPH.sy[1] = a->sy[3]; LLPH.ex[1] = a->ex[3]; LLPH.ey[1] = a->ey[3];
		LLPH.sx[2] = a->sx[1]; LLPH.sy[2] = a->sy[1]; LLPH.ex[2] = a->ex[1]; LLPH.ey[2] = a->ey[1];
		llp(&LLPH);
		if (LLPH.type != 0) {
			FX = LLPH.sx[3];
			FY = LLPH.sy[3];
		}


		if (sg(AX, compa_digits) == sg(BX, compa_digits) && sg(BX, compa_digits) == sg(FX, compa_digits) && sg(AY, compa_digits) == sg(BY, compa_digits) && sg(BY, compa_digits) == sg(FY, compa_digits)) {
			a->type = 0;
			return -1;
		}



		/* ----------------------------------------------------- */
		/* --- < 1 > --------------------------------------- */
		/* --- */
		/* --- */

		/* Ȥ룲ľΣʬ(SXA,SYA)-(EXA,EYA)  --- */
		LLLH.sx[1] = AX; LLLH.sy[1] = AY; LLLH.ex[1] = BX; LLLH.ey[1] = BY; 
		LLLH.sx[2] = AX; LLLH.sy[2] = AY; LLLH.ex[2] = FX; LLLH.ey[2] = FY;
		lll(&LLLH);
		SXA = LLLH.sx[3]; SYA = LLLH.sy[3]; EXA = LLLH.ex[3]; EYA = LLLH.ey[3];

		/* Ȥ룲ľΣʬ(SXB,SYB)-(EXB,EYB)  --- */
		LLLH.sx[1] = BX; LLLH.sy[1] = BY; LLLH.ex[1] = AX; LLLH.ey[1] = AY;
		LLLH.sx[2] = BX; LLLH.sy[2] = BY; LLLH.ex[2] = FX; LLLH.ey[2] = FY;
		lll(&LLLH);
		SXB = LLLH.sx[3]; SYB = LLLH.sy[3]; EXB = LLLH.ex[3]; EYB = LLLH.ey[3];


		/* ʬȣʬ¤θ롣ߤ濴(CX,CY)	--- */
		LLPH.sx[1] = SXA; LLPH.sy[1] = SYA; LLPH.ex[1] = EXA; LLPH.ey[1] = EYA;
		LLPH.sx[2] = SXB; LLPH.sy[2] = SYB; LLPH.ex[2] = EXB; LLPH.ey[2] = EYB;
		llp(&LLPH);
		a->cx[1] = LLPH.sx[3];
		a->cy[1] = LLPH.sy[3];

		/* 濴ľޤǤεΥ롣ߤȾ R	--- */
		PLPH.sx[2] = a->cx[1]; PLPH.sy[2] = a->cy[1];	
		PLPH.sx[1] = a->sx[1]; PLPH.sy[1] = a->sy[1]; PLPH.ex[1] = a->ex[1]; PLPH.ey[1] = a->ey[1];
		plp(&PLPH);
		/*	 --- */
		PPH.sx[1] = a->cx[1]; PPH.sy[1] = a->cy[1]; PPH.ex[1] = PLPH.ex[2]; PPH.ey[1] = PLPH.ey[2];
		pp(&PPH);
		a->r[1] = PPH.l;



		/* ----------------------------------------------------- */
		/* --- < 2 > --------------------------------------- */
		/* --- */
		/* --- */

		/* ȽȤ룲ľΣʬ(SXA,SYA)-(EXA,EYA)	--- */
		LLLH.sx[1] = FX; LLLH.sy[1] = FY; LLLH.ex[1] = AX; LLLH.ey[1] = AY; 
		LLLH.sx[2] = AX; LLLH.sy[2] = AY; LLLH.ex[2] = BX; LLLH.ey[2] = BY;
		lll(&LLLH);
		SXA = LLLH.sx[3]; SYA = LLLH.sy[3]; EXA = LLLH.ex[3]; EYA = LLLH.ey[3];

		/* ȽȤ룲ľΣʬ(SXB,SYB)-(EXB,EYB)	--- */
		LLLH.sx[1] = FX; LLLH.sy[1] = FY; LLLH.ex[1] = BX; LLLH.ey[1] = BY;
		LLLH.sx[2] = BX; LLLH.sy[2] = BY; LLLH.ex[2] = AX; LLLH.ey[2] = AY;
		lll(&LLLH);
		SXB = LLLH.sx[3]; SYB = LLLH.sy[3]; EXB = LLLH.ex[3]; EYB = LLLH.ey[3];


		/* ʬȣʬ¤θ롣ߤ濴(CX,CY)	--- */
		LLPH.sx[1] = SXA; LLPH.sy[1] = SYA; LLPH.ex[1] = EXA; LLPH.ey[1] = EYA;
		LLPH.sx[2] = SXB; LLPH.sy[2] = SYB; LLPH.ex[2] = EXB; LLPH.ey[2] = EYB;
		llp(&LLPH);
		a->cx[2] = LLPH.sx[3];
		a->cy[2] = LLPH.sy[3];

		/* 濴ľޤǤεΥ롣ߤȾ R	--- */
		PLPH.sx[2] = a->cx[2]; PLPH.sy[2] = a->cy[2];	
		PLPH.sx[1] = a->sx[1]; PLPH.sy[1] = a->sy[1]; PLPH.ex[1] = a->ex[1]; PLPH.ey[1] = a->ey[1];
		plp(&PLPH);
		/*	 --- */
		PPH.sx[1] = a->cx[2]; PPH.sy[1] = a->cy[2]; PPH.ex[1] = PLPH.ex[2]; PPH.ey[1] = PLPH.ey[2];
		pp(&PPH);
		a->r[2] = PPH.l;



		/* ----------------------------------------------------- */
		/* --- < 3 > --------------------------------------- */
		/* --- */
		/* --- */

		/* B ȽȤ룲ľΣʬ(SXA,SYA)-(EXA,EYA)	--- */
		LLLH.sx[1] = AX; LLLH.sy[1] = AY; LLLH.ex[1] = BX; LLLH.ey[1] = BY; 
		LLLH.sx[2] = BX; LLLH.sy[2] = BY; LLLH.ex[2] = FX; LLLH.ey[2] = FY;
		lll(&LLLH);
		SXA = LLLH.sx[3]; SYA = LLLH.sy[3]; EXA = LLLH.ex[3]; EYA = LLLH.ey[3];

		/* F ȽȤ룲ľΣʬ(SXB,SYB)-(EXB,EYB)	--- */
		LLLH.sx[1] = AX; LLLH.sy[1] = AY; LLLH.ex[1] = FX; LLLH.ey[1] = FY;
		LLLH.sx[2] = FX; LLLH.sy[2] = FY; LLLH.ex[2] = BX; LLLH.ey[2] = BY;
		lll(&LLLH);
		SXB = LLLH.sx[3]; SYB = LLLH.sy[3]; EXB = LLLH.ex[3]; EYB = LLLH.ey[3];


		/* ʬȣʬ¤θ롣ߤ濴(CX,CY)	--- */
		LLPH.sx[1] = SXA; LLPH.sy[1] = SYA; LLPH.ex[1] = EXA; LLPH.ey[1] = EYA;
		LLPH.sx[2] = SXB; LLPH.sy[2] = SYB; LLPH.ex[2] = EXB; LLPH.ey[2] = EYB;
		llp(&LLPH);
		a->cx[3] = LLPH.sx[3];
		a->cy[3] = LLPH.sy[3];

		/* 濴ľޤǤεΥ롣ߤȾ R	--- */
		PLPH.sx[2] = a->cx[3]; PLPH.sy[2] = a->cy[3];	
		PLPH.sx[1] = a->sx[1]; PLPH.sy[1] = a->sy[1]; PLPH.ex[1] = a->ex[1]; PLPH.ey[1] = a->ey[1];
		plp(&PLPH);
		/*	 --- */
		PPH.sx[1] = a->cx[3]; PPH.sy[1] = a->cy[3]; PPH.ex[1] = PLPH.ex[2]; PPH.ey[1] = PLPH.ey[2];
		pp(&PPH);
		a->r[3] = PPH.l;



		/* ----------------------------------------------------- */
		/* --- < 4 > --------------------------------------- */
		/* --- */
		/* --- */

		/* F ȽȤ룲ľΣʬ(SXA,SYA)-(EXA,EYA)	--- */
		LLLH.sx[1] = BX; LLLH.sy[1] = BY; LLLH.ex[1] = FX; LLLH.ey[1] = FY; 
		LLLH.sx[2] = FX; LLLH.sy[2] = FY; LLLH.ex[2] = AX; LLLH.ey[2] = AY;
		lll(&LLLH);
		SXA = LLLH.sx[3]; SYA = LLLH.sy[3]; EXA = LLLH.ex[3]; EYA = LLLH.ey[3];

		/* A ȽȤ룲ľΣʬ(SXB,SYB)-(EXB,EYB)	--- */
		LLLH.sx[1] = BX; LLLH.sy[1] = BY; LLLH.ex[1] = AX; LLLH.ey[1] = AY;
		LLLH.sx[2] = AX; LLLH.sy[2] = AY; LLLH.ex[2] = FX; LLLH.ey[2] = FY;
		lll(&LLLH);
		SXB = LLLH.sx[3]; SYB = LLLH.sy[3]; EXB = LLLH.ex[3]; EYB = LLLH.ey[3];

		/* ʬȣʬ¤θ롣ߤ濴(CX,CY)	--- */
		LLPH.sx[1] = SXA; LLPH.sy[1] = SYA; LLPH.ex[1] = EXA; LLPH.ey[1] = EYA;
		LLPH.sx[2] = SXB; LLPH.sy[2] = SYB; LLPH.ex[2] = EXB; LLPH.ey[2] = EYB;
		llp(&LLPH);
		a->cx[4] = LLPH.sx[3];
		a->cy[4] = LLPH.sy[3];

		/* 濴ľޤǤεΥ롣ߤȾ R	--- */
		PLPH.sx[2] = a->cx[4]; PLPH.sy[2] = a->cy[4];	
		PLPH.sx[1] = a->sx[1]; PLPH.sy[1] = a->sy[1]; PLPH.ex[1] = a->ex[1]; PLPH.ey[1] = a->ey[1];
		plp(&PLPH);
		/*	 --- */
		PPH.sx[1] = a->cx[4]; PPH.sy[1] = a->cy[4]; PPH.ex[1] = PLPH.ex[2]; PPH.ey[1] = PLPH.ey[2];
		pp(&PPH);
		a->r[4] = PPH.l;
		return 1;
	}
	return 0;
}



/* -------------------------------------------------------------------
 *  : ߤˤ뤫ˤ뤫
 * ؿ : ChkPointCircleSide
 *  : struct RtnDat *
 *		:	(a->sx[1] , a->sy[1]) 
 *		:	(a->cx[1] , a->cy[1]) , a->r[1]
 *  : int	 a->type = 0ERR	1	2	3
 *  : ̵
 *  :
 */
int ChkPointCircleSide(struct RtnDat *a)
{
	struct RtnDat PPH;


	PPH.sx[1] = a->sx[1];
	PPH.sy[1] = a->sy[1];
	PPH.ex[1] = a->cx[1];
	PPH.ey[1] = a->cy[1];
	pp(&PPH);

	if (sg(PPH.l, calcu_digits) == sg(a->r[1], calcu_digits))	  a->type = 0;
	else if (sg(PPH.l, calcu_digits) < sg(a->r[1], calcu_digits)) a->type = 1;
	else if (sg(PPH.l, calcu_digits) > sg(a->r[1], calcu_digits)) a->type = 2;

	return 1;
}



/* -------------------------------------------------------------------
 *  : ľοʹα(1)ˤ뤫(2)ˤ뤫
 * ؿ : ChkPointLineSide
 *  : struct RtnDat *
 *		:	( a->sx[1] , a->sy[1] )-( a->ex[1] , a->ey[1] )
 *		:	( a->sx[2] , a->sy[2] )
 *  : int
 *		:	a->type = 0ERR	1	 2	  3
 *  : ̵
 *  : 
 */
int ChkPointLineSide(struct RtnDat *a)
{
	struct RtnDat PLPH, LAH;
	double Ang1, Ang2, Dumy;


	a->type = 0;

	/* --- < Ƕ롣 > --- */
	PLPH = *a;
	plp(&PLPH);
	/* Ƕ	(PLPH.ex[2],PLPH.ey[2]) */

	if (a->sx[2] == PLPH.ex[2] && a->sy[2] == PLPH.ey[2]) {
		a->type = 3;
		return 1;
	}

	/* --- < ľγ > --- */
	LAH.sx[1] = a->sx[1];
	LAH.sy[1] = a->sy[1];
	LAH.ex[1] = a->ex[1];
	LAH.ey[1] = a->ey[1];
	la(&LAH);
	Ang1 = LAH.angle;
		
	/* --- < ǶޤǤγ > --- */
	LAH.sx[1] = PLPH.ex[2];
	LAH.sy[1] = PLPH.ey[2];
	LAH.ex[1] = a->sx[2];
	LAH.ey[1] = a->sy[2];
	la(&LAH);
	Ang2 = LAH.angle;
	
	/* ʹȽ */
	Dumy = Ang1 + 90;
	if (Dumy >= 360)	Dumy = Dumy - 360;
	if (sg(Dumy, calcu_digits) <= sg(Ang2, calcu_digits)+1	&& sg(Dumy, calcu_digits) >= sg(Ang2, calcu_digits)-1)  a->type = 2;
	else a->type = 1;

	return 1;
}



/* -------------------------------------------------------------------
 *  : ľȱߤθ(å˶ᤤ)
 * ؿ : LCP1
 *  : struct RtnDat *
 *		:	(a->sx[1] , a->sy[1])-(a->ex[1] , a->ey[1])
 *		:	(a->cx[1] , a->CY[1]) , a->R[1]
 *		:	(a->sx[4] , a->SY[4]) , (a->ex[4] , a->EY[4])  å
 *  : int
 *		:	(a->sx[2] , a->SY[2])
 *  : ̵
 *  : 
 */
int LCP1(struct RtnDat *a)
{
	struct RtnDat PPH;
	double P1X, P1Y, P2X, P2Y, L1, L2;
	double Ck1X, Ck1Y, Ck2X, Ck2Y;


	/* å */
	Ck1X = a->sx[4];
	Ck1Y = a->sy[4];
	Ck2X = a->ex[4];
	Ck2Y = a->ey[4];

	/* 롣 */
	lcp(a);

	if (a->type == 0)	return 0;
	else if (a->type == 1)	return 1;


	else if (a->type == 2) {
		/*  P1(a->sx[2],a->sy[2]) P2(a->sx[3],a->sy[3]) */
		P1X = a->sx[2];
		P1Y = a->sy[2];
		P2X = a->sx[3];
		P2Y = a->sy[3];
		
		/* å(a->sx[4],a->sy[4])ȸ(P1X,P1Y)εΥ롣 */
		PPH.sx[1] = Ck1X;
		PPH.sy[1] = Ck1Y;
		PPH.ex[1] = P1X;
		PPH.ey[1] = P1Y;
		pp(&PPH);
		L1 = PPH.l;
		/* å(a->sx[4],a->sy[4])ȸ(P2X,P2Y)εΥ롣 */
		PPH.sx[1] = Ck1X;
		PPH.sy[1] = Ck1Y;
		PPH.ex[1] = P2X;
		PPH.ey[1] = P2Y;
		pp(&PPH);
		L2 = PPH.l;
		/* ɤäθå˶ᤤ */
		if (L1 < L2) {
			a->sx[2] = P1X;
			a->sy[2] = P1Y;
			a->sx[3] = 0;
			a->sy[3] = 0;
		}
		else if (L1 > L2) {
			a->sx[2] = P2X;
			a->sy[2] = P2Y;
			a->sx[3] = 0;
			a->sy[3] = 0;
		}
	}

	a->type = 1;
	return 1;
}



/* -------------------------------------------------------------------
 *  : ߤθ(å˶ᤤ)
 * ؿ : CCP1
 *  : struct RtnDat *
 *		:	(a->cx[1] , a->cy[1]) a->r[1] (a->cx[2] , a->cy[2]) a->r[2]
 *		:	(a->sx[1] , a->sy[1]) (a->sx[2] , a->sy[2])    å
 *  : int 0,1
 *		:	(a->sx[1] , a->sy[1])
 *  : ̵
 *  : 
 */
int CCP1(struct RtnDat *a)
{
	struct RtnDat PPH;
	double P1X, P1Y, P2X, P2Y, L1, L2, Ck1X, Ck1Y, Ck2X, Ck2Y;


	/* å */
	Ck1X = a->sx[1];
	Ck1Y = a->sy[1];
	Ck2X = a->sx[2];
	Ck2Y = a->sy[2];
	/* 롣 */
	ccp(a);    /* (a->sx[1],a->sy[1])(a->sx[2],a->sy[2]) */

	/*  0 ΤȤ------------------------------ */
	if (a->type == 0) {
		a->sx[2] = 0;
		a->sy[2] = 0;
		return 0;
	}
	/*  1ĤΤȤ---------------------------- */
	else if (a->type == 1) return 1;
	/*  2ĤΤȤ---------------------------- */
	else if (a->type == 2) {
		/*  P1(a->sx[2],a->sy[2]) P2(a->sx[3],a->sy[3]) */
		P1X = a->sx[1];
		P1Y = a->sy[1];
		P2X = a->sx[2];
		P2Y = a->sy[2];
		
		/* å(a->sx[4],a->sy[4])ȸ(P1X,P1Y)εΥ롣 */
		PPH.sx[1] = Ck1X;
		PPH.sy[1] = Ck1Y;
		PPH.ex[1] = P1X;
		PPH.ey[1] = P1Y;
		pp(&PPH);
		L1 = PPH.l;
		/* å(a->sx[4],a->sy[4])ȸ(P2X,P2Y)εΥ롣 */
		PPH.sx[1] = Ck2X;
		PPH.sy[1] = Ck2Y;
		PPH.ex[1] = P2X;
		PPH.ey[1] = P2Y;
		pp(&PPH);
		L2 = PPH.l;
		/* ɤäθå˶ᤤ */
		if (L1 < L2) {
			a->sx[1] = P1X;
			a->sy[1] = P1Y;
		}
		else if (L1 > L2) {
			a->sx[1] = P2X;
			a->sy[1] = P2Y;
		}
	}
	a->sx[2] = 0;
	a->sy[2] = 0;
	a->type = 1;
	return 1;
}



/* -------------------------------------------------------------------
 *  : ľμºݤθ
 * ؿ : Act_llp
 *  : RtnDat
 *		:	(sx[1] , sy[1]) (ex[1] , ey[1])
 *		:	(sx[2] , sy[2]) (ex[2] , ey[2])
 *  : int	 0:ºݤθʤ	 1:ºݤθ)
 *		:	(sx[3] , sy[3]) , (type =
 *  : ̵
 *  : 
 */
int Act_llp(struct RtnDat *a)
{
	struct RtnDat dumy, LAH, PPH;
	double A1, A2;
	double L1, L2;


	dumy = *a;

	llp(&dumy);
	/* dumy.sx[3] , dumy.sy[3] */
	*a = dumy;
	if (dumy.type == 0) return 0;
	
	/* =========================================================== */
	/*  : ľγ										   */
	/* =========================================================== */
	LAH.sx[1] = dumy.sx[1];
	LAH.sy[1] = dumy.sy[1];
	LAH.ex[1] = dumy.ex[1];
	LAH.ey[1] = dumy.ey[1];
	la(&LAH);
	A1 = LAH.angle;

	LAH.sx[1] = dumy.sx[1];
	LAH.sy[1] = dumy.sy[1];
	LAH.ex[1] = dumy.sx[3];
	LAH.ey[1] = dumy.sy[3];
	la(&LAH);
	if (sg(A1, 2) != sg(LAH.angle, 2)) return 0;


	LAH.sx[1] = dumy.sx[2];
	LAH.sy[1] = dumy.sy[2];
	LAH.ex[1] = dumy.ex[2];
	LAH.ey[1] = dumy.ey[2];
	la(&LAH);
	A2 = LAH.angle;

	LAH.sx[1] = dumy.sx[2];
	LAH.sy[1] = dumy.sy[2];
	LAH.ex[1] = dumy.sx[3];
	LAH.ey[1] = dumy.sy[3];
	la(&LAH);
	if (sg(A2, 2) != sg(LAH.angle, 2)) return 0;


	/* =================================================== */
	/*  : ֤εΥ								   */
	/* =================================================== */
	PPH.sx[1] = dumy.sx[1];
	PPH.sy[1] = dumy.sy[1];
	PPH.ex[1] = dumy.ex[1];
	PPH.ey[1] = dumy.ey[1];
	pp(&PPH);
	L1 = PPH.l;

	PPH.sx[1] = dumy.sx[1];
	PPH.sy[1] = dumy.sy[1];
	PPH.ex[1] = dumy.sx[3];
	PPH.ey[1] = dumy.sy[3];
	pp(&PPH);
	if (L1 < PPH.l) return 0;


	PPH.sx[1] = dumy.sx[2];
	PPH.sy[1] = dumy.sy[2];
	PPH.ex[1] = dumy.ex[2];
	PPH.ey[1] = dumy.ey[2];
	pp(&PPH);
	L2 = PPH.l;

	PPH.sx[1] = dumy.sx[2];
	PPH.sy[1] = dumy.sy[2];
	PPH.ex[1] = dumy.sx[3];
	PPH.ey[1] = dumy.sy[3];
	pp(&PPH);
	if (L2 < PPH.l) return 0;

	return 1;
}



/* -------------------------------------------------------------------
 *  : ľȱ߸̤μºݤθ
 * ؿ : Act_lcp
 *  : RtnDat
 *		:	 1  (sx[1],sy[1]) - (ex[1],ey[1])
 *		:	 1  (cx[1],cy[1]) ,r[1], (sx[4],sy[4]) - (ex[4],ey[4])
 *  : RtnDat
 *		:	type   0 , 1 , 2
 *		:	 1  (sx[2],sy[2])
 *		:	 2  (sx[3],sy[3])
 *  : ̵
 *  : RtnDat plph,pph
 */
int Act_lcp(struct RtnDat *a)
{
	struct RtnDat dumy, LAH, PPH;
	double A1, L, SA, EA;
	int Ret = 0, Ret1 = 0;


	dumy = *a;

	lcp(&dumy);
	/* (dumy.sx[2] , dumy.sy[2]) */
	/* (dumy.sx[3] , dumy.sy[3]) */
	*a = dumy;

	if (dumy.type == 0) return Ret;


	else if (dumy.type > 0) {
		if (sg(dumy.sx[1], compa_digits) == sg(dumy.sx[2], compa_digits) && sg(dumy.sy[1], compa_digits) == sg(dumy.sy[2], compa_digits))
			Ret1 = 1;
		else {
			/* --- < ľǧ > ---------------------------------- */
			/* =========================================================== */
			/*  : ľγ										  */
			/* =========================================================== */
			LAH.sx[1] = dumy.sx[1];
			LAH.sy[1] = dumy.sy[1];
			LAH.ex[1] = dumy.ex[1];
			LAH.ey[1] = dumy.ey[1];
			la(&LAH);
			A1 = LAH.angle;

			LAH.sx[1] = dumy.sx[1];
			LAH.sy[1] = dumy.sy[1];
			LAH.ex[1] = dumy.sx[2];
			LAH.ey[1] = dumy.sy[2];
			la(&LAH);
			
			if (A1+1 > LAH.angle && A1-1 < LAH.angle)
				Ret1 = 1;
			else	
				Ret1 = 0;
		}


		if (Ret1 == 1) {
			/* =================================================== */
			/*  : ֤εΥ							  */
			/* =================================================== */
			PPH.sx[1] = dumy.sx[1];
			PPH.sy[1] = dumy.sy[1];
			PPH.ex[1] = dumy.ex[1];
			PPH.ey[1] = dumy.ey[1];
			pp(&PPH);
			L = PPH.l;

			PPH.sx[1] = dumy.sx[1];
			PPH.sy[1] = dumy.sy[1];
			PPH.ex[1] = dumy.sx[2];
			PPH.ey[1] = dumy.sy[2];
			pp(&PPH);
			if (sg(L, compa_digits) < sg(PPH.l, compa_digits))
				Ret1 = 0;
			else
				Ret1 = 1;
		}
		/* --- < ľǧ > ---------------------------------- */



		if (Ret1 == 1) {
			/* --- < ߸̤ǧ > ---------------------------------- */
			/* =========================================================== */
			/*  : ľγ										  */
			/* =========================================================== */
			LAH.sx[1] = dumy.cx[1];
			LAH.sy[1] = dumy.cy[1];
			LAH.ex[1] = dumy.sx[2];
			LAH.ey[1] = dumy.sy[2];
			la(&LAH);
			A1 = LAH.angle;

			/* SA & EA롣 */
			LAH.sx[1] = dumy.cx[1];
			LAH.sy[1] = dumy.cy[1];
			LAH.ex[1] = dumy.sx[4];
			LAH.ey[1] = dumy.sy[4];
			la(&LAH);
			SA = LAH.angle;

			LAH.sx[1] = dumy.cx[1];
			LAH.sy[1] = dumy.cy[1];
			LAH.ex[1] = dumy.ex[4];
			LAH.ey[1] = dumy.ey[4];
			la(&LAH);
			EA = LAH.angle;
			if (SA == EA) {
				SA = 0;
				EA = 360;
			}

			/* --- <  1  ߸̾ˤ뤫 > --- */
			if(SA < EA) {
				if(sg(A1, compa_digits) >= sg(SA, compa_digits) && sg(A1, compa_digits) <= sg(EA, compa_digits))
					Ret = 1;
				else
					Ret = 0;
			}
			else if(SA > EA) {
				if(sg(A1, compa_digits) >= sg(SA, compa_digits) || sg(A1, compa_digits) <= sg(EA, compa_digits))
					Ret = 1;
				else
					Ret = 0;
			}
			/* --- < ߸̤ǧ > ---------------------------------- */
		}
	}



	Ret1 = 0;
	if (dumy.type == 2) {
		if (sg(dumy.sx[1], compa_digits) == sg(dumy.sx[3], compa_digits) && sg(dumy.sy[1], compa_digits) == sg(dumy.sy[3], compa_digits))
			Ret1 = 1;
		else {
			/* --- < ľǧ > ---------------------------------- */
			/* =========================================================== */
			/*  : ľγ										  */
			/* =========================================================== */
			LAH.sx[1] = dumy.sx[1];
			LAH.sy[1] = dumy.sy[1];
			LAH.ex[1] = dumy.ex[1];
			LAH.ey[1] = dumy.ey[1];
			la(&LAH);
			A1 = LAH.angle;

			LAH.sx[1] = dumy.sx[1];
			LAH.sy[1] = dumy.sy[1];
			LAH.ex[1] = dumy.sx[3];
			LAH.ey[1] = dumy.sy[3];
			la(&LAH);
			if (A1+1 > LAH.angle && A1-1 < LAH.angle)
				Ret1 = 1;
			else
				Ret1 = 0;
		}

		if (Ret1 == 1) {
			/* =================================================== */
			/*  : ֤εΥ							  */
			/* =================================================== */
			PPH.sx[1] = dumy.sx[1];
			PPH.sy[1] = dumy.sy[1];
			PPH.ex[1] = dumy.ex[1];
			PPH.ey[1] = dumy.ey[1];
			pp(&PPH);
			L = PPH.l;

			PPH.sx[1] = dumy.sx[1];
			PPH.sy[1] = dumy.sy[1];
			PPH.ex[1] = dumy.sx[3];
			PPH.ey[1] = dumy.sy[3];
			pp(&PPH);
			if (sg(L, compa_digits) < sg(PPH.l, compa_digits))
				Ret1 = 0;
			else
				Ret1 = 1;
		}
		/* --- < ľǧ > ---------------------------------- */



		if (Ret1 == 1) {
			/* --- < ߸̤ǧ > --- */
			/* =========================================================== */
			/*  : ľγ										  */
			/* =========================================================== */
			LAH.sx[1] = dumy.cx[1];
			LAH.sy[1] = dumy.cy[1];
			LAH.ex[1] = dumy.sx[3];
			LAH.ey[1] = dumy.sy[3];
			la(&LAH);
			A1 = LAH.angle;

			/* SA & EA롣 */
			LAH.sx[1] = dumy.cx[1];
			LAH.sy[1] = dumy.cy[1];
			LAH.ex[1] = dumy.sx[4];
			LAH.ey[1] = dumy.sy[4];
			la(&LAH);
			SA = LAH.angle;

			LAH.sx[1] = dumy.cx[1];
			LAH.sy[1] = dumy.cy[1];
			LAH.ex[1] = dumy.ex[4];
			LAH.ey[1] = dumy.ey[4];
			la(&LAH);
			EA = LAH.angle;

			/* --- <  1  ߸̾ˤ뤫 > --- */
			if(SA < EA) {
				if(sg(A1, compa_digits) >= sg(SA, compa_digits) && sg(A1, compa_digits) <= sg(EA, compa_digits)) {
					if (Ret1 == 1) Ret = Ret + 2;
				}
			}
			else if(SA > EA) {
				if(sg(A1, compa_digits) >= sg(SA, compa_digits) || sg(A1, compa_digits) <= sg(EA, compa_digits)) {
					if (Ret1 == 1) Ret = Ret + 2;
				}
			}
		}
	}

	return Ret;
}



/* -------------------------------------------------------------------
 *  : ߸̤μºݤθ
 * ؿ : Act_ccp
 *  : rtndat
 *		:	 1	  (cx[1] , cy[1]) , r[1], (sx[3] , sy[3]) - (ex[3] , ey[3])
 *		:	 2	  (cx[2] , cy[2]) , r[2], (sx[4] , sy[4]) - (ex[4] , ey[4])
 *  : rtndat
 *		:	type	   0 , 1 , 2
 *		:	 1	  (sx[1] , sy[1])
 *		:	 2	  (sx[2] , sy[2])
 *  : ̵
 *  : RtnDat pph,lah,paph,lcph,llah
 */
int Act_ccp(struct RtnDat *a)
{
	struct RtnDat dumy, LAH;
	double A1, SA, EA;
	int Ret1 = 0, Ret = 0;


	dumy = *a;

	ccp(&dumy);
	/* (dumy.sx[1] , dumy.sy[1]) */
	/* (dumy.sx[2] , dumy.sy[2]) */

	/* ccp() ¹Ԥȱ߸̤ΥǡؤäƤꤹΤǡʲν򤹤 */
	a->sx[1] = dumy.sx[1];
	a->sy[1] = dumy.sy[1];
	a->sx[2] = dumy.sx[2];
	a->sy[2] = dumy.sy[2];
	a->type = dumy.type;
	dumy = *a;


	if (dumy.type == 0) return Ret;

	else if (dumy.type > 0) {
		/* --- < ߸ 1 ǧ > --- */
		/* =========================================================== */
		/*  : ľγ										  */
		/* =========================================================== */
		LAH.sx[1] = dumy.cx[1];
		LAH.sy[1] = dumy.cy[1];
		LAH.ex[1] = dumy.sx[1];
		LAH.ey[1] = dumy.sy[1];
		la(&LAH);
		A1 = LAH.angle;

		/* SA & EA롣 */
		LAH.sx[1] = dumy.cx[1];
		LAH.sy[1] = dumy.cy[1];
		LAH.ex[1] = dumy.sx[3];
		LAH.ey[1] = dumy.sy[3];
		la(&LAH);
		SA = LAH.angle;

		LAH.sx[1] = dumy.cx[1];
		LAH.sy[1] = dumy.cy[1];
		LAH.ex[1] = dumy.ex[3];
		LAH.ey[1] = dumy.ey[3];
		la(&LAH);
		EA = LAH.angle;

		/* --- <  1  ߸̾ˤ뤫 > --- */
		if(SA < EA) {
			if( (A1 >= SA) && (A1 <= EA) )
				Ret1 = 1;
			else
				Ret1 = 0;
		}
		else if(SA > EA) {
			if(sg(A1, compa_digits) >= sg(SA, compa_digits) || sg(A1, compa_digits) <= sg(EA, compa_digits))
				Ret1 = 1;
			else
				Ret1 = 0;
		}



		if (Ret1 == 1) {
			/* --- < ߸ 2 ǧ > --- */
			/* =========================================================== */
			/*  : ľγ										  */
			/* =========================================================== */
			LAH.sx[1] = dumy.cx[2];
			LAH.sy[1] = dumy.cy[2];
			LAH.ex[1] = dumy.sx[1];
			LAH.ey[1] = dumy.sy[1];
			la(&LAH);
			A1 = LAH.angle;

			/* SA & EA롣 */
			LAH.sx[1] = dumy.cx[2];
			LAH.sy[1] = dumy.cy[2];
			LAH.ex[1] = dumy.sx[4];
			LAH.ey[1] = dumy.sy[4];
			la(&LAH);
			SA = LAH.angle;

			LAH.sx[1] = dumy.cx[2];
			LAH.sy[1] = dumy.cy[2];
			LAH.ex[1] = dumy.ex[4];
			LAH.ey[1] = dumy.ey[4];
			la(&LAH);
			EA = LAH.angle;

			/* --- <  1  ߸̾ˤ뤫 > --- */
			if(SA < EA) {
				if(sg(A1, compa_digits) >= sg(SA, compa_digits) && sg(A1, compa_digits) <= sg(EA, compa_digits))
					Ret = 1;
			}
			else if(SA > EA) {
				if(sg(A1, compa_digits) >= sg(SA, compa_digits) || sg(A1, compa_digits) <= sg(EA, compa_digits))
					Ret = 1;
			}
		}
	}



	Ret1 = 0;
	if (dumy.type == 2) {
		/* --- < ߸ 1 ǧ > --- */
		/* =========================================================== */
		/*  : ľγ										  */
		/* =========================================================== */
		LAH.sx[1] = dumy.cx[1];
		LAH.sy[1] = dumy.cy[1];
		LAH.ex[1] = dumy.sx[2];
		LAH.ey[1] = dumy.sy[2];
		la(&LAH);
		A1 = LAH.angle;

		/* SA & EA */
		LAH.sx[1] = dumy.cx[1];
		LAH.sy[1] = dumy.cy[1];
		LAH.ex[1] = dumy.sx[3];
		LAH.ey[1] = dumy.sy[3];
		la(&LAH);
		SA = LAH.angle;

		LAH.sx[1] = dumy.cx[1];
		LAH.sy[1] = dumy.cy[1];
		LAH.ex[1] = dumy.ex[3];
		LAH.ey[1] = dumy.ey[3];
		la(&LAH);
		EA = LAH.angle;

		/*  2  ߸̾ˤ뤫 */
		if(SA < EA) {
			if(sg(A1, compa_digits) >= sg(SA, compa_digits) && sg(A1, compa_digits) <= sg(EA, compa_digits))
				Ret1 = 1;
			else
				Ret1 = 0;
		}
		else if(SA > EA) {
			if(sg(A1, compa_digits) >= sg(SA, compa_digits) || sg(A1, compa_digits) <= sg(EA, compa_digits))
				Ret1 = 1;
			else
				Ret1 = 0;
		}



		if (Ret1 == 1) {
			/* ߸ 2 ǧ */
			/*  : ľγ */
			LAH.sx[1] = dumy.cx[2];
			LAH.sy[1] = dumy.cy[2];
			LAH.ex[1] = dumy.sx[2];
			LAH.ey[1] = dumy.sy[2];
			la(&LAH);
			A1 = LAH.angle;

			/* SA & EA */
			LAH.sx[1] = dumy.cx[2];
			LAH.sy[1] = dumy.cy[2];
			LAH.ex[1] = dumy.sx[4];
			LAH.ey[1] = dumy.sy[4];
			la(&LAH);
			SA = LAH.angle;

			LAH.sx[1] = dumy.cx[2];
			LAH.sy[1] = dumy.cy[2];
			LAH.ex[1] = dumy.ex[4];
			LAH.ey[1] = dumy.ey[4];
			la(&LAH);
			EA = LAH.angle;

			/*  1  ߸̾ˤ뤫 */
			if(SA < EA) {
				if(sg(A1, compa_digits) >= sg(SA, compa_digits) && sg(A1, compa_digits) <= sg(EA, compa_digits))
					Ret = Ret + 2;
			}
			else if(SA > EA) {
				if(sg(A1, compa_digits) >= sg(SA, compa_digits) || sg(A1, compa_digits) <= sg(EA, compa_digits))
					Ret = Ret + 2;
			}
		}
	}
	return Ret;
}



/* -------------------------------------------------------------------
 * ǡؤ
 * -------------------------------------
 * a  b Υǡ촹
 *	
 * -------------------------------------
 * a	   : 
 * b	   : 
 * -------------------------------------------------------------------
 */
int Swap_double(double *a, double *b)
{
	double dumy;

	dumy = *a;
	*a = *b;
	*b = dumy;
	return 1;
}



/* -------------------------------------------------------------------
 * (ʲ 3 )
 * -------------------------------------
 * dbl  ʸˤ str ֤
 *	
 * -------------------------------------
 * dbl	   : 
 * str	   : Υݥ󥿤˷̤򤤤֤
 * Dot = 0 : ξ羮  ̵
 *	   = 1 : ξ⾮  ͭ
 * -------------------------------------------------------------------
 */
int FloatOut(char *str, double dbl, int Dot)
{
	int i = 1, j;
	double dumy, dumy2, Dumy_dbl;


	if (dbl < 0) {
		i = -1;
		dbl = dbl * i;
	}
	dbl = sg(dbl, 6);

	/* 0 */
	Dumy_dbl = dbl;
	dumy = floor(Dumy_dbl);
	dumy2 = Dumy_dbl - dumy;
	if (dumy2 == 0) {
		if (Dot == 0) sprintf(str, "%d", (int)dbl*i);
		else		  sprintf(str, "%d.", (int)dbl*i);
		return 1;
	}

	/* 1-3 */
	for(j=1 ; j<=3 ; j++) {
		Dumy_dbl = dbl;
		Dumy_dbl = Dumy_dbl * pow( 10, (double) j);  /* pow ϡ 10  j */
		dumy = floor( sg(Dumy_dbl, 3) );			 /* floor ϡͤڤΤƤ׻ */
		dumy2 = Dumy_dbl - dumy;
		if (sg(dumy2, 3) == 0) {
			if (j == 1) 	 sprintf(str, "%.1f", dbl*i);
			else if (j == 2) sprintf(str, "%.2f", dbl*i);
			else if (j == 3) sprintf(str, "%.3f", dbl*i);
			else			 sprintf(str, "%.3f", dbl*i);
			return 1;
		}
	}
	sprintf(str, "%.3f", dbl*i);
	return 1;
}



/* -------------------------------------------------------------------
 * (ʲ 6 )
 * -------------------------------------
 * dbl  ʸˤ str ֤
 *	
 * -------------------------------------
 * dbl	   : 
 * str	   : Υݥ󥿤˷̤򤤤֤
 * Dot = 0 : ξ羮  ̵
 *	   = 1 : ξ⾮  ͭ
 * -------------------------------------------------------------------
 */
int FloatOut6(char *str, double dbl, int Dot)
{
	int i = 1, j;
	double dumy, dumy2, Dumy_dbl;

	/* -----------------------------------------------------
	 * ޤå i 
	 */
	if (dbl < 0) {
		i = -1;
		dbl = dbl * i;
	}
	/* ʲ 6 ˻ͼθ */
	dbl = sg(dbl, 6);

	/* 0 */
	Dumy_dbl = dbl;
	dumy = floor( sg(Dumy_dbl, 6) );  /* ʲڤΤơdumy  */
	dumy2 = Dumy_dbl - dumy;		  /* ʲΤߤᡢdumy2  */
	/* ʲΤߤ򾯿ʲ 6 ˻ͼθ 0 ˤʤС
	 * ͤϡǤ롣
	 */
	if (sg(dumy2, 6) == 0) {
		if (Dot == 0) sprintf(str, "%d", (int) dbl*i);
		else sprintf(str, "%d.", (int) dbl*i);
		return 1;
	}

	/* 1-6 */
	for(j=1 ; j<=6 ; j++) {
		Dumy_dbl = dbl;
		Dumy_dbl = Dumy_dbl * pow( 10, (double) j);
		dumy = floor( sg(Dumy_dbl, 6) );
		dumy2 = Dumy_dbl - dumy;
		if (sg(dumy2, 6) == 0) {
			if (j ==1 ) 	 sprintf(str, "%.1f", dbl*i);
			else if (j == 2) sprintf(str, "%.2f", dbl*i);
			else if (j == 3) sprintf(str, "%.3f", dbl*i);
			else if (j == 4) sprintf(str, "%.4f", dbl*i);
			else if (j == 5) sprintf(str, "%.5f", dbl*i);
			else			 sprintf(str, "%.6f", dbl*i);
			return 1;
		}
	}
	sprintf(str, "%.6f", dbl*i);
	return 1;
}


/* -------------------------------------------------------------------
 * (ʲ n )
 * -------------------------------------
 * dbl  ʸˤ str ֤
 *	
 * -------------------------------------
 * dbl	   : 
 * str	   : Υݥ󥿤˷̤򤤤֤
 * n	   : ͼθǵ뾮ʲη
 * Dot = 0 : ξ羮	 ̵
 *	   = 1 : ξ⾮  ͭ
 * -------------------------------------------------------------------
 */
int FloatOut_n(char *str, double dbl, int n, int Dot)
{
	int i = 1, j;
	double dumy, dumy2, Dumy_dbl;
	char out_n[256];

	/* -----------------------------------------------------
	 * ޤå i 
	 */
	if (dbl < 0) {
		i = -1;
		dbl = dbl * i;
	}
	/* ʲ n ˻ͼθ */
	dbl = sg(dbl, n);

	/* -----------------------------------------------------
	 * ɤΥå 0 
	 */
	Dumy_dbl = dbl;
	dumy = floor( sg(Dumy_dbl, n) );  /* ʲڤΤơdumy  */
	dumy2 = Dumy_dbl - dumy;		  /* ʲΤߤᡢdumy2  */
	/* ʲΤߤ򾯿ʲ n ˻ͼθ 0 ˤʤС
	 * ͤϡǤ롣
	 */
	if (sg(dumy2, n) == 0) {
		if (Dot == 0) sprintf(str, "%d", (int) dbl*i);
		else sprintf(str, "%d.", (int) dbl*i);
		return 1;
	}

	/* -----------------------------------------------------
	 * ʲ夫å 1-n	
	 */
	for(j = n-1 ; j >= 0 ; j--) {
		Dumy_dbl = dbl;
		Dumy_dbl = Dumy_dbl * pow(10, (double) j);
		dumy = floor( sg(Dumy_dbl, n) );
		dumy2 = Dumy_dbl - dumy;
		if (sg(dumy2, n) != 0) {
			sprintf(out_n, "%%.%df", j+1);
			sprintf(str, out_n, dbl*i);
			return 1;
		}
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ž    (px,py)  (x,y) 濴 Angle ٲžư
 */
int rotation(double *px, double *py, double x, double y, double Angle)
{
	double RAD, DX, DY;

	/* ư٥ȥ */
	RAD = degrad(Angle);

	DX = *px - x;
	DY = *py - y;
	*px = sg((DX * cos(RAD) - DY * sin(RAD)) + x, calcu_digits);
	*py = sg((DY * cos(RAD) + DX * sin(RAD)) + y, calcu_digits);

	return 1;
}

/* -------------------------------------------------------------------
 * ʿ    (px,py)  ٥ȥ(x,y) ʿ԰ư
 */
int parallel(double *px, double *py, double x, double y)
{
	*px = sg(*px + x, calcu_digits);
	*py = sg(*py + y, calcu_digits);
	return 1;
}

/* -------------------------------------------------------------------
 * о    (x,y)  (sx,sy)-(ex,ey) Фоΰư
 */
int symmetry(double sx, double sy, double ex, double ey, double *x, double *y)
{
	struct RtnDat PLPH;

	/* -----------------------------------------------------
	 * ФƤΤ ľ
	 */
	PLPH.sx[1] = sx; PLPH.sy[1] = sy; PLPH.ex[1] = ex; PLPH.ey[1] = ey;
	PLPH.sx[2] = *x; PLPH.sy[2] = *y;
	plp(&PLPH);

	*x = sg(*x + 2 * (sg(PLPH.ex[2], calcu_digits) - sg(*x, calcu_digits)), calcu_digits);
	*y = sg(*y + 2 * (sg(PLPH.ey[2], calcu_digits) - sg(*y, calcu_digits)), calcu_digits);
	return 1;
}

/* -------------------------------------------------------------------
 *     (x,y)  (x,y) 濴 k ܤ޷Ѵ
 */
int scaling(double *px, double *py, double x, double y, double k)
{
	*px = sg((k * *px) + x * (1 - k), calcu_digits);
	*py = sg((k * *py) + y * (1 - k), calcu_digits);
	return 1;
}





/* ====================================================================
 * ===	Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *	  Project			   : SagCAD
 *	  Source			   : Trace.c
 * ====================================================================
 */





/* -------------------------------------------------------------------
 * ٤ 0  360 δ֤ˤ
 */
int angle_check(double *angle)
{
	while (*angle < 0 || *angle > 360) {
		if (*angle > 360) *angle = *angle - 360;
		if (*angle < 0) *angle = *angle + 360;
	}
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Trace.c
 * ====================================================================
 */
