/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : SnapDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2003/02/20
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
//#include <math.h>
#include "intl.h"

//#include "Trace.h"
#define _SNAPDLG_
#include "SnapDlg.h"





/* -------------------------------------------------------------------
 * CANCEL
 */
void snap_dlg_cancel_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	snap_dlg->value = 0;
}



/* 
 *	  ޷	 1 : 
 *				 2 : 
 *				 4 : ߸
 *				 8 : 
 *				15 : ޷
 *	
 *	  ˡ޷	16 : 
 *				32 : Ⱦ
 *				64 : 濴
 *			   128 : Ǥ
 *			   256 : ˡ޷
 *			   512 : ݥ饤
 *			  1024 : ֥å
 *			  2048 : ʱ
 *			  
 */



int snap_mode_set(GtkWidget *check_button, SNAP_DLG *snap_dlg, gint frag)
{
	/* check button */
	/* check_on */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button)) == TRUE) {
		if ( (snap_dlg->snap & frag) != frag ) {
			snap_dlg->snap = snap_dlg->snap + frag;
		}
	}
	/* check_off */
	else {
		if ( (snap_dlg->snap & frag) == frag ) {
			snap_dlg->snap = snap_dlg->snap - frag;
		}
	}
	return 1;
}



/* -------------------------------------------------------------------
 * CHAIN
 */
void snap_dlg_chain_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	snap_dlg->value = 2;
}

/* -------------------------------------------------------------------
 * CHAIN2
 */
void snap_dlg_chain2_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	snap_dlg->value = 4;
}

/* -------------------------------------------------------------------
 * COLOR
 */
void snap_dlg_color_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	snap_dlg->value = 8;
}



/* -------------------------------------------------------------------
 * OK
 */
void snap_dlg_ok_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	/* POINT check button [ 1 ]*/
	snap_mode_set(snap_dlg->point_check_button, snap_dlg, 1);

	/* LINE check button [ 2 ]*/
	snap_mode_set(snap_dlg->line_check_button, snap_dlg, 2);

	/* ARC check button [ 4 ]*/
	snap_mode_set(snap_dlg->arc_check_button, snap_dlg, 4);

	/* CIRCLE check button [ 8 ]*/
	snap_mode_set(snap_dlg->circle_check_button, snap_dlg, 8);

	/* DIMENSION check button [ 256 ]*/
	snap_mode_set(snap_dlg->dimension_check_button, snap_dlg, 256);

	/* POLYLINE check button [ 512 ]*/
	snap_mode_set(snap_dlg->polyline_check_button, snap_dlg, 512);

	/* BLOCK check button [ 1024 ]*/
//	snap_mode_set(snap_dlg->block_check_button, snap_dlg, 1024);

	/* ELLIPSE check button [ 2048 ]*/
	snap_mode_set(snap_dlg->ellipse_check_button, snap_dlg, 2048);


	/* START & END POINT check button [ 16 ]*/
	snap_mode_set(snap_dlg->start_end_check_button, snap_dlg, 16);

	/* HALF 4 POINT check button [ 32 ]*/
	snap_mode_set(snap_dlg->half_4_point_check_button, snap_dlg, 32);

	/* CENTER POINT check button [ 64 ]*/
	snap_mode_set(snap_dlg->center_check_button, snap_dlg, 64);

	/* ANY POINT check button [ 128 ]*/
	snap_mode_set(snap_dlg->any_check_button, snap_dlg, 128);

	snap_dlg->value = 1;
}





/* -------------------------------------------------------------------
 * 줿٥
 * key_press_event
 */
static gint snap_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, SNAP_DLG *snap_dlg)
{
//	g_print("sagcad.c : snap_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);

	return TRUE; 
}





/* -------------------------------------------------------------------
 * ʥå
 * 
 */
gint SnapDialog(SNAP_DLG *snap_dlg)
{
//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *hbox;
				GtkWidget *base_vbox;
//					GtkWidget *point_check_button;
//					GtkWidget *line_check_button;
//					GtkWidget *arc_check_button;
//					GtkWidget *circle_check_button;
				GtkWidget *etc_vbox;
//					GtkWidget *start_end_check_button;
//					GtkWidget *half_4_point_check_button;
//					GtkWidget *center_check_button;
//					GtkWidget *any_check_button;
				GtkWidget *option_vbox;
//					GtkWidget *polyline_check_button;
//					GtkWidget *dimension_check_button;
//					GtkWidget *block_check_button;
//					GtkWidget *ellipse_check_button;
			GtkWidget *separator;
			GtkWidget *action_hbox;
				GtkWidget *chain_buttun;
				GtkWidget *chain2_buttun;
				GtkWidget *color_buttun;
				GtkWidget *cancel_buttun;
				GtkWidget *ok_buttun;


	/* (snap_dlg->dialog) */
	snap_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(snap_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(snap_dlg->dialog), _("Snap Setting") );
	gtk_signal_connect( GTK_OBJECT(snap_dlg->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(snap_dlg_key_press_event), snap_dlg);



		/* ˤޤѥå󥰥ܥå(main_vbox) */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(snap_dlg->dialog), main_vbox);
		gtk_container_border_width(GTK_CONTAINER(snap_dlg->dialog), 5);
		gtk_widget_show(main_vbox);

			/* -----------------------------------------------------
			 * ѥå󥰥ܥå(main_vbox) 
			 * ѥå󥰥ܥå(hbox & action_hbox) 
			 * Ǽ
			 */
			/* ѥå󥰥ܥå(hbox) */
			hbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
								hbox, TRUE, TRUE, 0);
			gtk_widget_show(hbox);

				/* -----------------------------------------------------
				 * ѥå󥰥ܥå(hbox) 
				 * ѥå󥰥ܥå(label_vbox & entry_vbox) 
				 * Ǽ
				 */
				/* ѥå󥰥ܥå(base_vbox) */
				base_vbox = gtk_vbox_new(FALSE, 2);
				gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), base_vbox, TRUE, TRUE, 0);
				gtk_widget_show(base_vbox);

					/* -----------------------------------------------------
					 * ѥå󥰥ܥå(base_vbox) 
					 * åܥ
					 * snap_dlg->point_check_button
					 * snap_dlg->line_check_button
					 * snap_dlg->arc_check_button
					 * snap_dlg->circle_check_button
					 * Ǽ
					 */
					/*  */
					snap_dlg->point_check_button = gtk_check_button_new_with_label( _("Point") );
					gtk_widget_set_usize (snap_dlg->point_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(base_vbox), snap_dlg->point_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->point_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 1) != 1) {
						gtk_widget_set_sensitive(snap_dlg->point_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 1) == 1) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->point_check_button), TRUE);
					}


					/*  */
					snap_dlg->line_check_button = gtk_check_button_new_with_label( _("Line") );
					gtk_widget_set_usize (snap_dlg->line_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(base_vbox), snap_dlg->line_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->line_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 2) != 2) {
						gtk_widget_set_sensitive(snap_dlg->line_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 2) == 2) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->line_check_button), TRUE);
					}


					/* ߸ */
					snap_dlg->arc_check_button = gtk_check_button_new_with_label( _("Arc") );
					gtk_widget_set_usize (snap_dlg->arc_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(base_vbox), snap_dlg->arc_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->arc_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 4) != 4) {
						gtk_widget_set_sensitive(snap_dlg->arc_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 4) == 4) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->arc_check_button), TRUE);
					}


					/*  */
					snap_dlg->circle_check_button = gtk_check_button_new_with_label( _("Circle") );
					gtk_widget_set_usize (snap_dlg->circle_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(base_vbox), snap_dlg->circle_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->circle_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 8) != 8) {
						gtk_widget_set_sensitive(snap_dlg->circle_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 8) == 8) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->circle_check_button), TRUE);
					}

/*
åȤ̵ʤ뤤ͭˤˤˤϡ
 gtk_widget_set_sensitive()ؿȤäƲ
δؿκǽΥѥ᡼ϡΥåȤؤΥݥ󥿤Ǥ
ܤΥѥ᡼ͤǡTRUE ʤ餽ΥåȤͭˤʤޤ
*/




				/* ѥå󥰥ܥå(etc_vbox) */
				etc_vbox = gtk_vbox_new(FALSE, 2);
				gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), etc_vbox, TRUE, TRUE, 0);
				gtk_widget_show(etc_vbox);

					/* -----------------------------------------------------
					 * ѥå󥰥ܥå(etc_vbox) 
					 * åܥ
					 * snap_dlg->start_end_check_button
					 * snap_dlg->half_4_point_check_button
					 * snap_dlg->center_check_button
					 * snap_dlg->any_check_button
					 * Ǽ
					 */
					/* ü */
					snap_dlg->start_end_check_button = gtk_check_button_new_with_label( _("End Point") );
					gtk_widget_set_usize (snap_dlg->start_end_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(etc_vbox), snap_dlg->start_end_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->start_end_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 16) != 16) {
						gtk_widget_set_sensitive(snap_dlg->start_end_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 16) == 16) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->start_end_check_button), TRUE);
					}


					/* Ⱦ */
					snap_dlg->half_4_point_check_button = gtk_check_button_new_with_label( _("4 half points") );
					gtk_widget_set_usize (snap_dlg->half_4_point_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(etc_vbox), snap_dlg->half_4_point_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->half_4_point_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 32) != 32) {
						gtk_widget_set_sensitive(snap_dlg->half_4_point_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 32) == 32) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->half_4_point_check_button), TRUE);
					}


					/* 濴 */
					snap_dlg->center_check_button = gtk_check_button_new_with_label( _("Central Point") );
					gtk_widget_set_usize (snap_dlg->center_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(etc_vbox), snap_dlg->center_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->center_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 64) != 64) {
						gtk_widget_set_sensitive(snap_dlg->center_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 64) == 64) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->center_check_button), TRUE);
					}


					/* Ǥ */
					snap_dlg->any_check_button = gtk_check_button_new_with_label( _("Optional Point") );
					gtk_widget_set_usize (snap_dlg->any_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(etc_vbox), snap_dlg->any_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->any_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 128) != 128) {
						gtk_widget_set_sensitive(snap_dlg->any_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 128) == 128) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->any_check_button), TRUE);
					}



				/* ѥå󥰥ܥå(option_vbox) */
				option_vbox = gtk_vbox_new(FALSE, 2);
				gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), option_vbox, TRUE, TRUE, 0);
				gtk_widget_show(option_vbox);

					/* -----------------------------------------------------
					 * ѥå󥰥ܥå(option_vbox) 
					 * åܥ
					 * snap_dlg->polyline_check_button
					 * snap_dlg->dimension_check_button
					 * snap_dlg->block_check_button
					 * snap_dlg->ellipse_check_button
					 * Ǽ
					 */
					/* -----------------------------------------------
					 * 
					 */
					snap_dlg->polyline_check_button = gtk_check_button_new_with_label( _("Curve") );
					gtk_widget_set_usize (snap_dlg->polyline_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(option_vbox), snap_dlg->polyline_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->polyline_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 512) != 512) {
						gtk_widget_set_sensitive(snap_dlg->polyline_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 512) == 512) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->polyline_check_button), TRUE);
					}


					/* -----------------------------------------------
					 * ˡ 
					 */
					snap_dlg->dimension_check_button = gtk_check_button_new_with_label( _("Dimension") );
					gtk_widget_set_usize (snap_dlg->dimension_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(option_vbox), snap_dlg->dimension_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->dimension_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 256) != 256) {
						gtk_widget_set_sensitive(snap_dlg->dimension_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 256) == 256) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->dimension_check_button), TRUE);
					}


					/* -----------------------------------------------
					 * ֥å 
					 */
					snap_dlg->block_check_button = gtk_check_button_new_with_label( _("Block") );
					gtk_widget_set_usize (snap_dlg->block_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(option_vbox), snap_dlg->block_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->block_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 1024) != 1024) {
						gtk_widget_set_sensitive(snap_dlg->block_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 1024) == 1024) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->block_check_button), TRUE);
					}


					/* -----------------------------------------------
					 * ʱ 
					 */
					snap_dlg->ellipse_check_button = gtk_check_button_new_with_label( _("Ellipse") );
					gtk_widget_set_usize (snap_dlg->ellipse_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(option_vbox), snap_dlg->ellipse_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->ellipse_check_button);
					/* ̵ͭ */
					if ((snap_dlg->mask & 2048) != 2048) {
						gtk_widget_set_sensitive(snap_dlg->ellipse_check_button, FALSE);
					}
					/*  */
					else if ((snap_dlg->snap & 2048) == 2048) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->ellipse_check_button), TRUE);
					}



			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);



			/* ѥå󥰥ܥå(action_hbox) */
			action_hbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(main_vbox), 
								action_hbox, TRUE, TRUE, 0);
			gtk_widget_show(action_hbox);

				/* -----------------------------------------------------
				 * ѥå󥰥ܥå(action_hbox) 
				 * ܥ(cancel_buttun & ok_buttun) 
				 * Ǽ
				 */
				if (snap_dlg->value == 16) {
					/* chain ܥ */
					chain_buttun = gtk_button_new_with_label("Chain");
//					gtk_widget_set_usize (chain_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), chain_buttun, TRUE, TRUE, 2);
					gtk_signal_connect(GTK_OBJECT(chain_buttun), "clicked", 
									   GTK_SIGNAL_FUNC(snap_dlg_ok_pushed), snap_dlg);
					gtk_signal_connect(GTK_OBJECT(chain_buttun), "clicked", 
									   GTK_SIGNAL_FUNC(snap_dlg_chain_pushed), snap_dlg);
					gtk_signal_connect(GTK_OBJECT(chain_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
					gtk_widget_show(chain_buttun);

					/* chain2 ܥ */
					chain2_buttun = gtk_button_new_with_label("Chain One Way");
//					gtk_widget_set_usize (chain2_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), chain2_buttun, TRUE, TRUE, 2);
					gtk_signal_connect(GTK_OBJECT(chain2_buttun), "clicked", 
									   GTK_SIGNAL_FUNC(snap_dlg_ok_pushed), snap_dlg);
					gtk_signal_connect(GTK_OBJECT(chain2_buttun), "clicked", 
									   GTK_SIGNAL_FUNC(snap_dlg_chain2_pushed), snap_dlg);
					gtk_signal_connect(GTK_OBJECT(chain2_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
					gtk_widget_show(chain2_buttun);

					/* color ܥ */
					color_buttun = gtk_button_new_with_label("Color");
//					gtk_widget_set_usize (color_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), color_buttun, TRUE, TRUE, 2);
					gtk_signal_connect(GTK_OBJECT(color_buttun), "clicked", 
									   GTK_SIGNAL_FUNC(snap_dlg_ok_pushed), snap_dlg);
					gtk_signal_connect(GTK_OBJECT(color_buttun), "clicked", 
									   GTK_SIGNAL_FUNC(snap_dlg_color_pushed), snap_dlg);
					gtk_signal_connect(GTK_OBJECT(color_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
					gtk_widget_show(color_buttun);
				}


				/* CANCELܥ */
				cancel_buttun = gtk_button_new_with_label("CANCEL");
//				gtk_widget_set_usize (cancel_buttun, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
				gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(snap_dlg_cancel_pushed), snap_dlg);
				gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
				gtk_widget_show(cancel_buttun);

				/* OKܥ */
				ok_buttun = gtk_button_new_with_label("OK");
//				gtk_widget_set_usize (ok_buttun, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
				gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(snap_dlg_ok_pushed), snap_dlg);
				gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
			//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
			//	  gtk_widget_grab_default(ok_buttun);
				gtk_widget_show(ok_buttun);



	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(snap_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(snap_dlg->dialog), GTK_WINDOW(snap_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(snap_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(snap_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : SnapDlg.c
 * ====================================================================
 */
