/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : PostScript.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/01
 *    Last                 : 2003/04/01
 * ====================================================================
 */
#ifndef __POSTSCRIPT_H__
#define __POSTSCRIPT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _POSTSCRIPT_
#define   GLOBAL
/*  */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* ʬ̵ */
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL double ViewPortAspect GLOBAL_VAL(0);
//	GLOBAL double WorldWindowAspect GLOBAL_VAL(0);

	GLOBAL double ViewPortX1 GLOBAL_VAL(0);
	GLOBAL double ViewPortY1 GLOBAL_VAL(0);
	GLOBAL double ViewPortX2 GLOBAL_VAL(0);
	GLOBAL double ViewPortY2 GLOBAL_VAL(0);

	GLOBAL double WorldWindowX1 GLOBAL_VAL(0);
	GLOBAL double WorldWindowY1 GLOBAL_VAL(0);
	GLOBAL double WorldWindowX2 GLOBAL_VAL(0);
	GLOBAL double WorldWindowY2 GLOBAL_VAL(0);


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _POSTSCRIPT_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */

/* PostScript File Output Main */
int PostScript(char *SaveFileName);


/* PostScript Set */
int set_start_up(FILE *stream, int ps);
int set_line_width(FILE *stream, double width);
int set_line_color(FILE *stream, long color);
int set_line_style(FILE *stream, int style);


/* ɸѴ Set */
int set_ViewPort(double SX1, double SY1, double SX2, double SY2);
int set_WorldWindow(double WX1, double WY1, double WX2, double WY2);
double WorldToViewX(double x);
double WorldToViewY(double y);
int set_paper_size_ViewPort (struct _printer lo_printer, int ps, FILE *stream);
double Millimeter_To_Point(double millimeter);
double Point_To_Millimeter(double point);
int set_world_size_Window ( struct _printer lo_printer );


/*  Set */
int LineDraw_PS(FILE *stream, double sx, double sy, double ex, double ey, int style, long color);
int CircleDraw_PS(FILE *stream, double CX, double CY, double R, int Style, long color);
int ArcDraw_PS (FILE *stream, double CX, double CY, double R, double SX, double SY, double EX, double EY, int Style, long color);
int EllipseDraw_PS(FILE *stream, ELLIPSE *ellipse);


/*  Set */
int LineK_PS(FILE *stream, double SX, double SY, double EX, double EY, int style, long color);
int CircleK_PS(FILE *stream, double CX, double CY, double R, double SA, double EA, int style, long color);
int EllipseK_PS(FILE *stream, 
			 double cx, double cy, double a, double b, 
			 double sa, double ea, double angle , 
			 int style, long color);

int LineCheckDraw_PS(double *SX, double *SY, double *EX, double *EY);


/* ˡ Set */
int LineEndArrow_PS (FILE *stream, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color);
int LineBothArrow_PS (FILE *stream, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color);
int LineBothConverseArrow_PS (FILE *stream, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color);
int ArcBothArrow_PS (FILE *stream, double CX, double CY, double R, double SX, double SY, double EX, double EY, int ArcFrag, int DrawType, long color);
int AssistanceLine_PS (FILE *stream, double SX, double SY, double EX, double EY, int DrawType, long color);
int LineEndExtension_PS (FILE *stream, double SX, double SY, double EX, double EY, int DrawType, long color);
int Dimension_Draw_Line_PS (FILE *stream, DIMENSION *a);
int DrawTextVector_PS (FILE *stream, DIMENSION *a);

/* ݥ饤 Set */
int open_spline_PS (FILE *stream, int n, VERTEX *vertex, int split, int style, long color);
int close_spline_PS (FILE *stream, int n, VERTEX *vertex, int split, int style, long color);
int b_spline_PS (FILE *stream, int n, VERTEX *vertex, double pitch, int style, long color);
int PolyLineDraw_PS (FILE *stream, POLYLINE *a);







#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __POSTSCRIPT_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : PostScript.h
 * ====================================================================
 */
