/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Select.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#define _LIST_SELECT_
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "etc.h"



/* ---------------------------------------------------------
 * Select Data ꥹȤκǸɲ
 *	
 */
int select_list_add_last(SELECT *add_select)
{
	SELECT_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_select_list = (SELECT_LIST *)xmalloc(sizeof(SELECT_LIST));

	/* ǡ (select) 񤭹िΰݤ */
	p_select_list->select = (SELECT *)xmalloc(sizeof(SELECT));

	/* ݤΰ˥ǡ (select) 񤭹 */
	*p_select_list->select = *add_select;
	p_select_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (select_list_info.head == NULL && select_list_info.tail == NULL) {
		select_list_info.head = p_select_list;
		select_list_info.tail = p_select_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (select_list_info.head != NULL 
				&& select_list_info.tail != NULL 
					&& select_list_info.head == select_list_info.tail) 
	{
		select_list_info.head->next = p_select_list;
		select_list_info.tail = p_select_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = select_list_info.tail;
		select_list_info.tail = p_select_list;
		p->next = select_list_info.tail;
	}

	return 0;
}



/* ---------------------------------------------------------
 * Select Data ꥹȤκǽɲ
 *	
 */
int select_list_add_first(SELECT *add_select)
{
	SELECT_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_select_list = (SELECT_LIST *)xmalloc(sizeof(SELECT_LIST));

	/* ǡ (select) 񤭹िΰݤ */
	p_select_list->select = (SELECT *)xmalloc(sizeof(SELECT));

	/* ݤΰ˥ǡ (select) 񤭹 */
	*p_select_list->select = *add_select;
	p_select_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (select_list_info.head == NULL && select_list_info.tail == NULL) {
		select_list_info.head = p_select_list;
		select_list_info.tail = p_select_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = select_list_info.head;
		select_list_info.head = p_select_list;
		p_select_list->next = p;
	}

	return 0;
}



/* ---------------------------------------------------------
 *	Select Data ꥹȤ
 */
int select_list_free(SELECT_LIST *del_List)
{
	SELECT_LIST *p = NULL;
	SELECT_LIST *pb = NULL;


	/* ǡƬǣĤ  */
	if (del_List == select_list_info.head && del_List->next == NULL) {
		select_list_info.head = NULL;
		select_list_info.tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == select_list_info.head && del_List->next != NULL) {
		select_list_info.head = select_list_info.head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = select_list_info.head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}


		if(p != NULL){
		/* ǸΥǡ */
			if (del_List == select_list_info.tail) {
				pb->next = NULL;
				select_list_info.tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != select_list_info.head && del_List != select_list_info.tail) {
				pb->next = p->next;
			}
		}
		/* ꥹȤΥ쥯ȥǡΤǤϤʤ */
		else {
			// 
			return 0;
		}
	}
	xfree(del_List->select);
	xfree(del_List);
	return 1;
}



/* ---------------------------------------------------------
 * SELECT_LIST Υǡθ
 *	
 *   long
 */
long select_search_select_to_num(SELECT_LIST *p_select)
{
	SELECT_LIST *p;
	long i;

	i = 1;
	p = select_list_info.head;
	/*	*/
	while( p != NULL && p != p_select) {
		p = p->next;
		i++;
	}

	/* p_select ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return i;
	}
	/* ޤǥǡʤ */
	else {
		return 0;
	}
}



/* ---------------------------------------------------------
 *	ꥹȤ
 */
void select_list_all_free(void)
{
	while (select_list_info.head != NULL) {
		select_list_free(select_list_info.head);
	}
}



/* ---------------------------------------------------------
 *	ꥹȤĴ٤
 */
long select_list_num(void)
{
	SELECT_LIST *p;
	long i;

	p = select_list_info.head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}
	return i;
}



/* ---------------------------------------------------------
 * n ܤΥǡθ
 *	
 */
SELECT_LIST *select_search_num(long search_number)
{
	SELECT_LIST *p;
	long i;

	p = select_list_info.head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* ---------------------------------------------------------
 * 쥯ȤƤãĥǡ򸡺
 *	
 */
SELECT_LIST *select_search_cad(CAD *cad)
{
	SELECT_LIST *p;

	p = select_list_info.head;
	/*	*/
	while( p != NULL ) {
		if (p->select->index == 2 || p->select->index == 4) {
			if (p->select->diagram_point.cad_point == cad) break;
		}
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}




/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Select.c
 * ====================================================================
 */
