/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_dimension.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <stdlib.h>
#define _LIST_DIMENSION_
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "etc.h"





int init_dimension(DIMENSION *dimension)
{
	double scale;

	/* DIMENSION Data ν */
	dimension->Layer = 0;
	dimension->text_color = sagcad_color.Dimension;
	dimension->Assist_color = sagcad_color.Dimension;
	dimension->DrawType = DRAW_REAL;
	dimension->FontType = sagcad_dimension.font_Type;
	dimension->FontHeight = sagcad_dimension.Font_height;
	scale = (dimension->FontHeight / 9.);
	dimension->FontSpace = sagcad_dimension.Font_space * scale;
	dimension->WordSpace = sagcad_dimension.Word_space * scale;
	dimension->FontOverLineSpace = sagcad_dimension.Font_space_line * scale;
	dimension->Type = 0;
	strcpy(dimension->Text, "");
	strcpy(dimension->UpperText, "");
	strcpy(dimension->LowerText, "");
	dimension->Angle = 0;
	dimension->SearchPointX = 0;
	dimension->SearchPointY = 0;
	dimension->StartPoint = 0;
	dimension->FitPointX = 0;
	dimension->FitPointY = 0;
	dimension->start.x = 0;
	dimension->start.y = 0;
	dimension->end.x = 0;
	dimension->end.y = 0;
	dimension->diagram_of_char_index = 0;
	dimension->diagram_of_char = NULL;
	dimension->index = 0;
	dimension->AssistLine = NULL;
	return 1;
}





/* -------------------------------------------------------------------
 * DIMENSION Data ꥹȤκǽɲ
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
DIMENSION_LIST *r_dimension_list_add_first(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_dimension_list = (DIMENSION_LIST *)xmalloc(sizeof(DIMENSION_LIST));

	/* ݤΰ˥ǡ (dimension) 񤭹 */
	p_dimension_list->dimension = add_dimension;
	p_dimension_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_dimension_list_info->head == NULL && p_dimension_list_info->tail == NULL) {
		p_dimension_list_info->head = p_dimension_list;
		p_dimension_list_info->tail = p_dimension_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_dimension_list_info->head;
		p_dimension_list_info->head = p_dimension_list;
		p_dimension_list->next = p;
	}

	return p_dimension_list_info->head;
}





/* -------------------------------------------------------------------
 * DIMENSION Data ꥹȤκǽɲ
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
DIMENSION_LIST *dimension_list_add_first(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_dimension_list = (DIMENSION_LIST *)xmalloc(sizeof(DIMENSION_LIST));

	/* ǡ (dimension) 񤭹िΰݤ */
	p_dimension_list->dimension = (DIMENSION *)xmalloc(sizeof(DIMENSION));

	/* ǡ (AssistLine) 񤭹िΰݤ */
//	p_dimension_list->dimension->AssistLine = (ASSISTANCE *)xmalloc(add_dimension->index * sizeof(ASSISTANCE));

	/* ݤΰ˥ǡ (dimension) 񤭹 */
	*p_dimension_list->dimension = *add_dimension;
	p_dimension_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_dimension_list_info->head == NULL && p_dimension_list_info->tail == NULL) {
		p_dimension_list_info->head = p_dimension_list;
		p_dimension_list_info->tail = p_dimension_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_dimension_list_info->head;
		p_dimension_list_info->head = p_dimension_list;
		p_dimension_list->next = p;
	}

	return p_dimension_list_info->head;
}





/* ---------------------------------------------------------
 * DIMENSION Data ꥹȤκǽɲäơ Undo Baffer ˽
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
DIMENSION_LIST *dimension_list_add_first_with_undo(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;
	DIMENSION dimension = {0,0,0,0,0,"","","",0,"",0,0,0,0, 0,0,0,0,0,0, {0,0}, {0,0}, 0,NULL, 0,NULL};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_dimension_list = (DIMENSION_LIST *)xmalloc(sizeof(DIMENSION_LIST));
	/* ǡ (dimension) 񤭹िΰݤ */
	p_dimension_list->dimension = (DIMENSION *)xmalloc(sizeof(DIMENSION));

	/* ǡ (AssistLine) 񤭹िΰݤ */
//	p_dimension_list->dimension->AssistLine = (ASSISTANCE *)xmalloc(add_dimension->index * sizeof(ASSISTANCE));

	/* ݤΰ˥ǡ (dimension) 񤭹 */
	*p_dimension_list->dimension = *add_dimension;
	p_dimension_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_dimension_list_info->head == NULL && p_dimension_list_info->tail == NULL) {
		p_dimension_list_info->head = p_dimension_list;
		p_dimension_list_info->tail = p_dimension_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_dimension_list_info->head;
		p_dimension_list_info->head = p_dimension_list;
		p_dimension_list->next = p;
	}


	lpdiagram.dimension_point = p_dimension_list_info->head->dimension;
	diagram.dimension = dimension;

	/* Undo Buffa Write */
	undo_list_add_first(DIMENSION_NEW, lpdiagram, diagram);
	return p_dimension_list_info->head;
}





/* ---------------------------------------------------------
 * DIMENSION Data ꥹȤκǸɲ
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
DIMENSION_LIST *dimension_list_add_last(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_dimension_list = (DIMENSION_LIST *)xmalloc(sizeof(DIMENSION_LIST));

	/* ǡ (dimension) 񤭹िΰݤ */
	p_dimension_list->dimension = (DIMENSION *)xmalloc(sizeof(DIMENSION));

	/* ǡ (AssistLine) 񤭹िΰݤ */
//	p_dimension_list->dimension->AssistLine = (ASSISTANCE *)xmalloc(add_dimension->index * sizeof(ASSISTANCE));

	/* ݤΰ˥ǡ (dimension) 񤭹 */
	*p_dimension_list->dimension = *add_dimension;
	p_dimension_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_dimension_list_info->head == NULL && p_dimension_list_info->tail == NULL) {
		p_dimension_list_info->head = p_dimension_list;
		p_dimension_list_info->tail = p_dimension_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_dimension_list_info->head != NULL 
				&& p_dimension_list_info->tail != NULL 
					&& p_dimension_list_info->head == p_dimension_list_info->tail) {
		p_dimension_list_info->head->next = p_dimension_list;
		p_dimension_list_info->tail = p_dimension_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_dimension_list_info->tail;
		p_dimension_list_info->tail = p_dimension_list;
		p->next = p_dimension_list_info->tail;
	}

	/* ɥХåե˽ */
//	undo_list_add_first(11, p_dimension_list_info->tail, NULL);
	return p_dimension_list_info->tail;
}





/* ---------------------------------------------------------
 * DIMENSION Data ꥹȤκǸɲá Undo Baffer ˽
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
DIMENSION_LIST *dimension_list_add_last_with_undo(DIMENSION *add_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;
	DIMENSION dimension = {0,0,0,0,0,"","","",0,"",0,0,0,0, 0,0,0,0,0,0, {0,0}, {0,0}, 0,NULL, 0,NULL};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_dimension_list = (DIMENSION_LIST *)xmalloc(sizeof(DIMENSION_LIST));

	/* ǡ (dimension) 񤭹िΰݤ */
	p_dimension_list->dimension = (DIMENSION *)xmalloc(sizeof(DIMENSION));

	/* ǡ (AssistLine) 񤭹िΰݤ */
//	p_dimension_list->dimension->AssistLine = (ASSISTANCE *)xmalloc(add_dimension->index * sizeof(ASSISTANCE));

	/* ݤΰ˥ǡ (dimension) 񤭹 */
	*p_dimension_list->dimension = *add_dimension;
	p_dimension_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_dimension_list_info->head == NULL && p_dimension_list_info->tail == NULL) {
		p_dimension_list_info->head = p_dimension_list;
		p_dimension_list_info->tail = p_dimension_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_dimension_list_info->head != NULL 
				&& p_dimension_list_info->tail != NULL 
					&& p_dimension_list_info->head == p_dimension_list_info->tail) {
		p_dimension_list_info->head->next = p_dimension_list;
		p_dimension_list_info->tail = p_dimension_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_dimension_list_info->tail;
		p_dimension_list_info->tail = p_dimension_list;
		p->next = p_dimension_list_info->tail;
	}


	lpdiagram.dimension_point = p_dimension_list_info->tail->dimension;
	diagram.dimension = dimension;

	/* Undo Buffa Write */
	undo_list_add_first(DIMENSION_NEW, lpdiagram, diagram);
	return p_dimension_list_info->tail;
}





/* -------------------------------------------------------------------
 * DIMENSION Data κǽ (κǤϤʤ)
 * 
 */
int dimension_list_delete(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p = NULL;
	DIMENSION_LIST *pb = NULL;
	long i;

	/* -------------------------------------------
	 * ݥ󥿤ΥǡΤꤿΤǡ
	 * head (ꥹȤƬ) ݥ󥿤
	 * ĤޤǷ֤Υǡõ
	 */
	p = p_dimension_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while (p != NULL && p != del_List) {
		if (i == 0) i++;
		pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}


	/* Ĥä (p  NULL ǤϤʤȤ) */
	if (p != NULL){
		/* ƬΥǡ (i = 0 ΤȤ) */
		if (i == 0) {
			/* ƬΥǡĤʤ(ΥǡΥݥ󥿤 NULL) */
			if (p->next == NULL) {
				p_dimension_list_info->head = NULL;
				p_dimension_list_info->tail = NULL;
			}
			/* İʾǡȤ */
			else 
				p_dimension_list_info->head = p->next;
		}

		/* ǸΥǡΤȤ (p->next = NULL) */
		else if (p->next == NULL) {
			pb->next = NULL;
		}

		/* ֤Υǡ (ξʳ) */
		else {
			pb->next = p->next;
		}

		xfree(del_List);
//		dimension_list_free(del_List);
		return 1;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * DIMENSION Data κǽ (κǤϤʤUndo Buffer ذܤ)
 * 
 */
int dimension_list_delete_Undo(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p = NULL;
	DIMENSION_LIST *pb = NULL;
	long i;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* -------------------------------------------
	 * ݥ󥿤ΥǡΤꤿΤǡ
	 * head (ꥹȤƬ) ݥ󥿤
	 * ĤޤǷ֤Υǡõ
	 */
	p = p_dimension_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL && p != del_List) {
		i++;
		pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}


	/* Ĥä (p  NULL ǤϤʤȤ) */
	if(p != NULL){
		/* ƬΥǡ (i = 0 ΤȤ) */
		if (i == 0) {
			/* ƬΥǡĤʤ(ΥǡΥݥ󥿤 NULL) */
			if (p->next == NULL) {
				p_dimension_list_info->head = NULL;
				p_dimension_list_info->tail = NULL;
			}
			/* İʾǡȤ */
			else 
				p_dimension_list_info->head = p->next;
		}

		/* ǸΥǡΤȤ (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* ֤Υǡ (ξʳ) */
		else pb->next = p->next;

		lpdiagram.dimension_point = del_List->dimension;
		diagram.dimension = *del_List->dimension;

		undo_list_add_first(DIMENSION_DEL, lpdiagram, diagram);
		xfree(del_List);
		return 1;
	}
	return 0;
}





/* ---------------------------------------------------------
 * DIMENSION Υݥ󥿤Υǡ Undo ХåեԽˤơ
 * ξ˿ǡ롣
 * 
 * ͡ΥǡΥɥ쥹
 * 
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
DIMENSION_LIST *dimension_list_edit(DIMENSION_LIST *point, DIMENSION *change_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	/* ǡ (LIST) 񤭹िΰݤ */
	p_dimension_list = (DIMENSION_LIST *)xmalloc(sizeof(DIMENSION_LIST));

	/* ǡ (dimension) 񤭹िΰݤ */
	p_dimension_list->dimension = (DIMENSION *)xmalloc(sizeof(DIMENSION));

	/* ǡ (AssistLine) 񤭹िΰݤ */
//	p_dimension_list->dimension->AssistLine = (ASSISTANCE *)xmalloc(change_dimension->index * sizeof(ASSISTANCE));

	/* ݤΰѹΥǡ (dimension) 񤭹 */
	*p_dimension_list->dimension = *point->dimension;
//	p_dimension_list->next = point;

	/* ѹǡ񤭹 */
	*point->dimension = *change_dimension;

//	undo_list_add_first(13, p_dimension_list, NULL);
	return p_dimension_list;
}





/* ---------------------------------------------------------
 * DIMENSION ѹΥǡ(point) Undo ХåեԽˤơ
 * ξ˿ǡ(change_dimension)졢Undo Baffer ˽
 *	
 * ͡ΥǡΥɥ쥹
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
DIMENSION_LIST *dimension_list_edit_with_undo(DIMENSION_LIST *point, DIMENSION *change_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION dimension = {0,0,0,0,0,"","","",0,"",0,0,0,0, 0,0,0,0,0,0, {0,0}, {0,0}, 0,NULL, 0,NULL};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ݤΰѹΥǡ (DIMENSION) 񤭹 */
	dimension = *point->dimension;

	/* ѹǡ񤭹 */
	*point->dimension = *change_dimension;


	lpdiagram.dimension_point = point->dimension;
	diagram.dimension = dimension;

	undo_list_add_first(DIMENSION_EDIT, lpdiagram, diagram);
	return point;
}





/* ---------------------------------------------------------
 * ꥹȤĴ٤
 */
long dimension_list_num(DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;
	long i;

	p = p_dimension_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}
	return i;
}



/* ---------------------------------------------------------
 * n ܤΥǡθ
 *	
 */
DIMENSION_LIST *dimension_search_num(long search_number, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;
	long i;

	p = p_dimension_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}



/* ---------------------------------------------------------
 * DIMENSION Υǡθ
 *	
 *   DIMENSION_LIST
 */
DIMENSION_LIST *dimension_search_dimension(DIMENSION *p_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;

	p = p_dimension_list_info->head;
	/*	*/
	while( p != NULL && p->dimension != p_dimension) {
		p = p->next;
	}

	/* p_dimension ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}



/* ---------------------------------------------------------
 * DIMENSION Υǡθ
 *	
 *   long
 */
long dimension_search_dimension_to_num(DIMENSION *p_dimension, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;
	long i;

	i = 1;
	p = p_dimension_list_info->head;
	/*	*/
	while( p != NULL && p->dimension != p_dimension) {
		p = p->next;
		i++;
	}

	/* p_dimension ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return i;
	}
	/* ޤǥǡʤ */
	else {
		return 0;
	}
}





/* ---------------------------------------------------------
 * DIMENSION Data ꥹȤ
 */
int dimension_list_free(DIMENSION_LIST *del_List, DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p = NULL;
	DIMENSION_LIST *pb = NULL;
//	int i;
//	char str[256];


	/* ǡƬǣĤ  */
	if (del_List == p_dimension_list_info->head && del_List->next == NULL) {
		p_dimension_list_info->head = NULL;
		p_dimension_list_info->tail = NULL;
		//g_print("ǡƬǣĤ\n");
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_dimension_list_info->head && del_List->next != NULL) {
		p_dimension_list_info->head = p_dimension_list_info->head->next;
		//g_print("ǡƬǣİʾ\n");
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_dimension_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}


		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_dimension_list_info->tail) {
				//g_print("ǸΥǡ\n");
				pb->next = NULL;
				p_dimension_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_dimension_list_info->head && del_List != p_dimension_list_info->tail) {
				//g_print("֤Υǡ\n");
				pb->next = p->next;
			}
		}
		else {
			//g_print("ꥹȤ DIMENSION ǡǤϤʤ\n");
			return 0;
		}
	}
	//select_test();



	if (del_List->dimension->diagram_of_char_index > 0 && del_List->dimension->diagram_of_char != NULL) {
		xfree(del_List->dimension->diagram_of_char);
	}
#ifdef TEST
	else if (del_List->dimension->diagram_of_char_index == 0) {
		g_print("Not Free diagram_of_char (diagram_of_char_index = 0) [0x%x]\n", (int)&del_List->dimension->diagram_of_char);
	}
	else if (del_List->dimension->diagram_of_char == NULL) {
		g_print("Not Free diagram_of_char (diagram_of_char == NULL) [0x%x]\n", (int)&del_List->dimension->diagram_of_char);
	}
	else {
		g_print("Not Free diagram_of_char (I Don't know)\n");
	}
#endif


	if (del_List->dimension->index > 0) {
		xfree(del_List->dimension->AssistLine);
	}

	xfree(del_List->dimension);
	xfree(del_List);
	return 1;
}



/* ---------------------------------------------------------
 * ꥹȤ
 */
void dimension_list_all_free(DIMENSION_LIST_INFO *p_dimension_list_info)
{
	while(p_dimension_list_info->head != NULL) {
		dimension_list_free(p_dimension_list_info->head, p_dimension_list_info);
	}
}


void dimension_list_print(DIMENSION_LIST_INFO *p_dimension_list_info)
{
	DIMENSION_LIST *p;
	int i = 0, j;

	g_print("----- DIMENSION ꥹȤɽ -----\n");
	p = p_dimension_list_info->head;
	while (p != NULL) {
		i++;
		g_print("%d : Layer[%d]  DrawType[%d]  Type[%d]  FontType[%d]  FontHeight[%f]  FontSpace[%f]  Angle[%f]\n", 
				 i,  p->dimension->Layer, p->dimension->DrawType, p->dimension->Type,
				 p->dimension->FontType, p->dimension->FontHeight, p->dimension->FontSpace, 
				 p->dimension->Angle);
		g_print("Text:%s  UpperText:%s  LowerText:%s\n", 
				 p->dimension->Text, p->dimension->UpperText, p->dimension->LowerText);
		g_print("SearchPointX:[%f]  SearchPointY:[%f]  StartPoint:[%d]  index:[%d]\n", 
				 p->dimension->SearchPointX, p->dimension->SearchPointY, p->dimension->StartPoint, p->dimension->index);
		for (j = 0 ; j < p->dimension->index ; j++) {
			g_print("%d  defin:[%d]  sx:[%f]  sy:[%f]  ex:[%f]  ey:[%f]  cx:[%f]  cy:[%f]  r:[%f]\n", 
					 j+1, p->dimension->AssistLine[j].defin, 
					 p->dimension->AssistLine[j].sx, p->dimension->AssistLine[j].sy, 
					 p->dimension->AssistLine[j].ex, p->dimension->AssistLine[j].ey, 
					 p->dimension->AssistLine[j].cx, p->dimension->AssistLine[j].cy, 
					 p->dimension->AssistLine[j].r);
		}
		p = p->next;
	}
	g_print("-----------------------------\n");
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_dimension.c
 * ====================================================================
 */
