/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : InputBox.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/30
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define INPUTBOX
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "InputBox.h"





/* -------------------------------------------------------------------
 * 
 * 
 */
void set_value_ibox(GtkWidget *widget, input_box *ibox)
{
	GtkWidget *entry;

	/* 줿ܥͤ */
	ibox->value = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));
	/* ƥȥȥ꡼μ */
	entry = (GtkWidget*)gtk_object_get_data(GTK_OBJECT(ibox->dialog), "TextEntry" );
	/* ƥȥȥ꡼ʸ */
	if (entry) {
		strcpy(ibox->str, gtk_entry_get_text(GTK_ENTRY(entry)));
	}
}





/* -------------------------------------------------------------------
 * 줿٥
 * 
 */
static gint ibox_key_press_event(GtkWidget *widget, GdkEventKey *event, input_box *ibox)
{		
	GtkWidget *entry;

#ifdef TEST
	g_print("sagcad : key_press_event\n");
	g_print("state  = %d\n", event->state);
	g_print("keyval = %d   0x%x\n", event->keyval, event->keyval);
	g_print("length = %d\n", event->length);
	g_print("string = %s\n", event->string);
#endif
	if(event->keyval == 0xff8d) {
		/* 줿ܥͤ */
		ibox->value = 1;

		/* ƥȥȥ꡼μ */
		entry = (GtkWidget*)gtk_object_get_data(GTK_OBJECT(ibox->dialog), "TextEntry" );
		/* ƥȥȥ꡼ʸ */
		if (entry) {
			strcpy(ibox->str, gtk_entry_get_text(GTK_ENTRY(entry)));
		}
		gtk_main_quit();
	}
	return TRUE; 
}





/* -------------------------------------------------------------------
 * ʸϥ InputBox
 * 
 * 
 * 
 * 
 * 
 * OK Button 줿 1 ֤
 * CANCEL Button 줿 -1 ֤
 * 
 * 
 * 
 */
int InputBox(const char *title, const char *msg1, const char *msg2, char *def_str)
{
	input_box *ibox;

//	GtkWidget *vbox;
	GtkWidget *label;
//	GtkWidget *action_area;
	GtkWidget *action_vbox;
	GtkWidget *hbox;
	GtkWidget *entry;
	GtkWidget *btn_cancel, *btn_ok;
	int x;
	int y;
	int width;
	int height;
	int dlg_width;
	int dlg_height;
	int dlg_pos_x;
	int dlg_pos_y;

//	Display *d;


	if(def_str[0] == '\0') {
//		g_print("def_str  NULL BeforeStr = %s\n", BeforeStr);
		strcpy(def_str, BeforeStr);
	}


	ibox = (input_box *)g_malloc(sizeof(input_box));


	/*  */
	ibox->dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(ibox->dialog), title);
	gtk_signal_connect( GTK_OBJECT(ibox->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(ibox_key_press_event), ibox);


  /* ̤Υ */
//	d = XOpenDisplay(NULL);
//	gdk_window_get_pointer (widget->window, &mx, &my, &mods);
//	gtk_widget_set_uposition(ibox->dialog, DisplayWidth (d, 0), DisplayHeight (d, 0));


	/* vbox */
//	vbox = GTK_DIALOG(ibox->dialog)->vbox;

	/* ٥ 1  */
	if(msg1 != NULL) {
		label = gtk_label_new(msg1);
		gtk_box_pack_start((GtkBox *)GTK_DIALOG(ibox->dialog)->vbox, label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}

	/* ٥ 2  */
	if(msg2 != NULL) {
		label = gtk_label_new(msg2);
		gtk_box_pack_start((GtkBox *)GTK_DIALOG(ibox->dialog)->vbox, label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}


	/* Υ󥨥ꥢ */
//	action_area = GTK_DIALOG(ibox->dialog)->action_area;

	/* vbox */
	action_vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start((GtkBox *)GTK_DIALOG(ibox->dialog)->action_area, 
					   action_vbox, TRUE, TRUE, 0);
	gtk_widget_show(action_vbox);

	/* ƥȥȥ꡼ */
	entry = gtk_entry_new();
	gtk_object_set_data(GTK_OBJECT(ibox->dialog), "TextEntry", entry);
	gtk_box_pack_start(GTK_BOX(action_vbox), entry, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(entry), def_str);
	gtk_entry_select_region(GTK_ENTRY(entry), 0, GTK_ENTRY(entry)->text_length);
	gtk_object_set_data(GTK_OBJECT(entry), "value", (gpointer)1);
	gtk_signal_connect( GTK_OBJECT(entry), "activate",
						GTK_SIGNAL_FUNC(set_value_ibox), ibox);
	gtk_signal_connect( GTK_OBJECT(entry), "activate",
						GTK_SIGNAL_FUNC(gtk_main_quit), ibox);
	gtk_widget_show(entry);

	/* hbox */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(action_vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* CANCELܥ */
	btn_cancel = gtk_button_new_with_label("CANCEL");
	gtk_box_pack_start(GTK_BOX(hbox), btn_cancel, TRUE, TRUE, 2);
	gtk_object_set_data(GTK_OBJECT(btn_cancel), "value", (gpointer)-1);
	gtk_signal_connect( GTK_OBJECT(btn_cancel), "clicked",
						GTK_SIGNAL_FUNC(set_value_ibox), ibox);
	gtk_signal_connect( GTK_OBJECT(btn_cancel), "clicked",
						GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_widget_show(btn_cancel);


	/* OKܥ */
	btn_ok = gtk_button_new_with_label("OK");
	gtk_box_pack_start(GTK_BOX(hbox), btn_ok, TRUE, TRUE, 2);
	gtk_object_set_data(GTK_OBJECT(btn_ok), "value", (gpointer)1);
	gtk_signal_connect(GTK_OBJECT(btn_ok), "clicked",
			   GTK_SIGNAL_FUNC(set_value_ibox), ibox);
	gtk_signal_connect(GTK_OBJECT(btn_ok), "clicked",
			   GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
//	  GTK_WIDGET_SET_FLAGS(btn_ok, GTK_CAN_DEFAULT);
//	  gtk_widget_grab_default(btn_ok);
	gtk_widget_show(btn_ok);

	GTK_WINDOW(ibox->dialog)->focus_widget = GTK_WIDGET(entry);



	/* ᥤ󥦥ɥθ˱Ƥޤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(ibox->dialog), GTK_WINDOW(MainWindow));
	
	/* ᥤ󥦥ɥ֤ */
	gdk_window_get_position(MainWindow->window, &x, &y);
	gdk_window_get_size(MainWindow->window, &width, &height);
	gtk_widget_realize(ibox->dialog);
	gdk_window_get_size(ibox->dialog->window, &dlg_width, &dlg_height);
	dlg_pos_x = x + (width - dlg_width) / 2;
	dlg_pos_y = y + (height - dlg_height) / 2;
	gtk_widget_set_uposition(ibox->dialog,
							 (dlg_pos_x > 0) ? dlg_pos_x : 0,
							 (dlg_pos_y > 0) ? dlg_pos_y : 0);

	/* ⡼ˤ */
	gtk_window_set_modal(GTK_WINDOW(ibox->dialog), TRUE);



	/* Ļ֤ */
	gtk_widget_show(ibox->dialog);
	/* ֤ */
	gtk_grab_add(ibox->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_grab_remove(ibox->dialog);
	gtk_widget_destroy(ibox->dialog);

	strcpy(BeforeStr, ibox->str);
	strcpy(def_str, ibox->str);
	return ibox->value; 
}


/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : InputBox.c
 * ====================================================================
 */
