/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Ellipse.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/25
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __LIST_ELLIPSE_H__
#define __LIST_ELLIPSE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _LIST_ELLIPSE_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL ELLIPSE_LIST *p_ellipse_list;
	GLOBAL ELLIPSE_LIST_INFO ellipse_list_info;

	GLOBAL ELLIPSE_LIST *EllipseStartData GLOBAL_VAL(0);


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _LIST_ELLIPSE_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */

/* ELLIPSE Data の初期化 */
int init_ellipse(ELLIPSE *ellipse);
ELLIPSE_LIST *r_ellipse_list_add_first(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data をリストの最初に追加 */
ELLIPSE_LIST *ellipse_list_add_first(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data をリストの最初に追加して、 Undo Baffer に書込む */
ELLIPSE_LIST *ellipse_list_add_first_with_undo(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ELLIPSE Data をリストの最後に追加 */
ELLIPSE_LIST *ellipse_list_add_last(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data をリストの最後に追加、 Undo Baffer に書込む */
ELLIPSE_LIST *ellipse_list_add_last_with_undo(ELLIPSE *add_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ELLIPSE Data の削除機能 (メモリの削除ではない) */
int ellipse_list_delete(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す) */
int ellipse_list_delete_Undo(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ELLIPSE Data を変更する */
ELLIPSE_LIST *ellipse_list_edit(ELLIPSE_LIST *point, ELLIPSE *change_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* ELLIPSE Data を変更する、 Undo Baffer に書込む */
ELLIPSE_LIST *ellipse_list_edit_with_undo(ELLIPSE_LIST *point, ELLIPSE *change_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* リストの総数を調べる */
long ellipse_list_num(ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* n 番目のデータの検索 */
ELLIPSE_LIST *ellipse_search_num(long search_number, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* データの検索(ELLIPSE *p_ellipse から ELLIPSE_LIST を求める) */
ELLIPSE_LIST *ellipse_search_ellipse(ELLIPSE *p_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* データの検索(ELLIPSE *p_ellipse から Data No. の long 値を求める) */
long ellipse_search_ellipse_to_num(ELLIPSE *p_ellipse, ELLIPSE_LIST_INFO *p_ellipse_list_info);


/* ELLIPSE Data をリストから削除 */
int ellipse_list_free(ELLIPSE_LIST *del_List, ELLIPSE_LIST_INFO *p_ellipse_list_info);
/* 全リストを削除 */
void ellipse_list_all_free(ELLIPSE_LIST_INFO *p_ellipse_list_info);

/* ELLIPSE リストを表示 */
void ellipse_list_print(ELLIPSE_LIST_INFO *p_ellipse_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_ELLIPSE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Ellipse.h
 * ====================================================================
 */
