/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_insert.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/23
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_Undo.h"
//#include "etc.h"

#define _LIST_INSERT_
#include "List_insert.h"





int init_insert(INSERT *insert)
{
	/* INSERT Data の初期化 */
	strcpy(insert->name, "None");
	insert->layer = 0;
	insert->color = 0xffffff;
	insert->style = 0;

	insert->x = 0;
	insert->y = 0;
	insert->angle = 0;
	insert->x_scale = 1;
	insert->y_scale = 1;

	insert->x_num = 0;
	insert->y_num = 0;
	insert->x_pitch = 0;
	insert->y_pitch = 0;
	return 1;
}





/* -------------------------------------------------------------------
 * 領域確保済みの INSERT Data をリストの最初に追加
 * 
 */
INSERT_LIST *r_insert_list_add_first(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));

	/* 確保した領域にデータ (insert) を書き込む */
	p_insert_list->insert = add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_insert_list_info->head;
		p_insert_list_info->head = p_insert_list;
		p_insert_list->next = p;
	}

	return p_insert_list_info->head;
}





/* -------------------------------------------------------------------
 * INSERT Data をリストの最初に追加
 * 
 */
INSERT_LIST *insert_list_add_first(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));
	/* データ (insert) を書き込むための領域を確保する */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* 確保した領域にデータ (insert) を書き込む */
	*p_insert_list->insert = *add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_insert_list_info->head;
		p_insert_list_info->head = p_insert_list;
		p_insert_list->next = p;
	}

	return p_insert_list_info->head;
}





/* -------------------------------------------------------------------
 * INSERT Data をリストの最初に追加して、 Undo Baffer に書込む
 *	
 */
INSERT_LIST *insert_list_add_first_with_undo(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	INSERT insert = {"",0,0,0, 0,0,0,0,0, 0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データ (LIST) を書き込むための領域を確保する */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));
	/* データ (insert) を書き込むための領域を確保する */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* 確保した領域にデータ (insert) を書き込む */
	*p_insert_list->insert = *add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_insert_list_info->head;
		p_insert_list_info->head = p_insert_list;
		p_insert_list->next = p;
	}

	lpdiagram.insert_point = p_insert_list_info->head->insert;
	diagram.insert = insert;

	/* Undo Buffa Write */
	undo_list_add_first(INSERT_NEW, lpdiagram, diagram);
	return p_insert_list_info->head;
}





/* -------------------------------------------------------------------
 * INSERT Data をリストの最後に追加
 * 
 */
INSERT_LIST *insert_list_add_last(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;


	/* データ (LIST) を書き込むための領域を確保する */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));
	/* データ (insert) を書き込むための領域を確保する */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* 確保した領域にデータ (insert) を書き込む */
	*p_insert_list->insert = *add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_insert_list_info->head != NULL 
				&& p_insert_list_info->tail != NULL 
					&& p_insert_list_info->head == p_insert_list_info->tail) {
		p_insert_list_info->head->next = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_insert_list_info->tail;
		p_insert_list_info->tail = p_insert_list;
		p->next = p_insert_list_info->tail;
	}

	/* アンドゥバッファに書込む */
//	undo_list_add_first(11, p_insert_list_info->tail, NULL);
	return p_insert_list_info->tail;
}





/* -------------------------------------------------------------------
 * INSERT Data をリストの最後に追加、 Undo Baffer に書込む
 *	
 */
INSERT_LIST *insert_list_add_last_with_undo(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	INSERT insert = {"",0,0,0, 0,0,0,0,0, 0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データ (LIST) を書き込むための領域を確保する */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));
	/* データ (insert) を書き込むための領域を確保する */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* 確保した領域にデータ (insert) を書き込む */
	*p_insert_list->insert = *add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_insert_list_info->head != NULL 
				&& p_insert_list_info->tail != NULL 
					&& p_insert_list_info->head == p_insert_list_info->tail) {
		p_insert_list_info->head->next = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_insert_list_info->tail;
		p_insert_list_info->tail = p_insert_list;
		p->next = p_insert_list_info->tail;
	}

	lpdiagram.insert_point = p_insert_list_info->tail->insert;
	diagram.insert = insert;

	/* Undo Buffa Write */
	undo_list_add_first(INSERT_NEW, lpdiagram, diagram);
	return p_insert_list_info->tail;
}





/* -------------------------------------------------------------------
 * INSERT Data の削除機能 (メモリの削除ではない)
 * 
 */
int insert_list_delete(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p = NULL;
	INSERT_LIST *pb = NULL;


	/* データが先頭で１個だけ  */
	if (del_List == p_insert_list_info->head && del_List->next == NULL) {
		p_insert_list_info->head = NULL;
		p_insert_list_info->tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_insert_list_info->head && del_List->next != NULL) {
		p_insert_list_info->head = p_insert_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_insert_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}

		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_insert_list_info->tail) {
				pb->next = NULL;
				p_insert_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_insert_list_info->head && del_List != p_insert_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_insert.c : insert_list_delete() : There is not data of structure data INSERT.\n");
			return 0;
		}
	}
	xfree(del_List);
//	StartData = p_insert_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * INSERT Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す)
 * 
 */
int insert_list_delete_Undo(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p = NULL;
	INSERT_LIST *pb = NULL;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データが先頭で１個だけ  */
	if (del_List == p_insert_list_info->head && del_List->next == NULL) {
		p_insert_list_info->head = NULL;
		p_insert_list_info->tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_insert_list_info->head && del_List->next != NULL) {
		p_insert_list_info->head = p_insert_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_insert_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}

		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_insert_list_info->tail) {
				pb->next = NULL;
				p_insert_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_insert_list_info->head && del_List != p_insert_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_insert.c : insert_list_delete() : There is not data of structure data INSERT.\n");
			return 0;
		}
	}

	lpdiagram.insert_point = del_List->insert;
	diagram.insert = *del_List->insert;

	undo_list_add_first(INSERT_DEL, lpdiagram, diagram);
	xfree(del_List);
//	StartData = p_insert_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * INSERT のポインタのデータを Undo バッファ（編集）に入れて、
 * その場所に新しいデータを入れる。
 *	
 * 戻り値　元のデータのアドレス
 */
INSERT_LIST *insert_list_edit(INSERT_LIST *point, INSERT *change_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	/* データ (LIST) を書き込むための領域を確保する */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));

	/* データ (insert) を書き込むための領域を確保する */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* 確保した領域に変更前のデータ (insert) を書き込む */
	*p_insert_list->insert = *point->insert;
	p_insert_list->next = point;

	/* 変更データを書き込む */
	*point->insert = *change_insert;

//	undo_list_add_first(13, p_insert_list, NULL);
	return p_insert_list;
}





/* -------------------------------------------------------------------
 * INSERT のポインタのデータを Undo バッファ（編集）に入れて、
 * その場所に新しいデータを入れ、Undo Baffer に書込む
 *	
 * 戻り値　元のデータのアドレス
 */
INSERT_LIST *insert_list_edit_with_undo(INSERT_LIST *point, INSERT *change_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT insert = {"",0,0,0, 0,0,0,0,0, 0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* 確保した領域に変更前のデータ (INSERT) を書き込む */
	insert = *point->insert;

	/* 変更データを書き込む */
	*point->insert = *change_insert;

	lpdiagram.insert_point = point->insert;
	diagram.insert = insert;

	undo_list_add_first(INSERT_EDIT, lpdiagram, diagram);
	return point;
}





/* -------------------------------------------------------------------
 *	リストの総数を調べる
 */
long insert_list_num(INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	long i;

	p = p_insert_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ポインタを次のデータに移す */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n 番目のデータの検索
 * 
 */
INSERT_LIST *insert_search_num(long search_number, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	long i;


	p = p_insert_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n 番目のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * INSERT のデータの検索
 * 
 * 戻値  INSERT_LIST
 */
INSERT_LIST *insert_search_insert(INSERT *p_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;


	p = p_insert_list_info->head;
	/*	*/
	while( p != NULL && p->insert != p_insert) {
		p = p->next;
	}

	/* p_insert のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * INSERT のデータの検索
 * 
 * 戻値  long
 */
long insert_search_insert_to_num(INSERT *p_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	long i;

	i = 1;
	p = p_insert_list_info->head;
	/*	*/
	while( p != NULL && p->insert != p_insert) {
		p = p->next;
		i++;
	}

	/* p_insert のデータのアドレスを返す */
	if (p != NULL) {
		return i;
	}
	/* そこまでデータがない */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 *	INSERT Data をリストから削除
 */
int insert_list_free(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p = NULL;
	INSERT_LIST *pb = NULL;


	/* データが先頭で１個だけ  */
	if (del_List == p_insert_list_info->head && del_List->next == NULL) {
		p_insert_list_info->head = NULL;
		p_insert_list_info->tail = NULL;
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_insert_list_info->head && del_List->next != NULL) {
		p_insert_list_info->head = p_insert_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_insert_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}


		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_insert_list_info->tail) {
				pb->next = NULL;
				p_insert_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_insert_list_info->head && del_List != p_insert_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_insert.c : insert_list_free() : There is not data of structure data INSERT.\n");
			return 0;
		}
	}
	xfree(del_List->insert);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 *	全リストを削除
 */
void insert_list_all_free(INSERT_LIST_INFO *p_insert_list_info)
{
	while(p_insert_list_info->head != NULL) {
		if (insert_list_free(p_insert_list_info->head, p_insert_list_info) == 0) {
			g_print("List_insert.c : insert_list_all_free() : insert_list_free() でエラー\n");
			g_print("%s : %d : insert_list_all_free() : ERROR\n", __FILE__, __LINE__);
		}
	}
}





void insert_list_print(INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	int i = 0;

	g_print("----- INSERT リストを表示 -----\n");
	p = p_insert_list_info->head;
	while (p != NULL) {
		i++;
		g_print("%d(0x%x) : name[%s] : layer[%d] : color[%d] : style[0x%x]\n位置(%f,%f) %f度 scale(%f,%f) 個数(%d,%d) pitch(%f,%f)\n", 
					i, (int)p->insert, p->insert->name, 
					p->insert->layer, (int)p->insert->color, p->insert->style, 
					p->insert->x, p->insert->y, p->insert->angle, 
					p->insert->x_scale, p->insert->y_scale, 
					p->insert->x_num, p->insert->y_num, 
					p->insert->x_pitch, p->insert->y_pitch);
		p = p->next;
	}
	g_print("-----------------------------\n");
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_insert.c
 * ====================================================================
 */
