#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:25:50  
# conf/config-pam_samba.sh

### I N C L U D E
. ./_include.sh

### P A R A M S
if [ "$1" == "-f" ];then
	MYDIR="$2"
	shift
	shift
else
	MYDIR="${PAMDIR}"
fi
MYSOURCEDIR="$1"
MYSOURCESERVICES="$2"
#echo "dir=${MYDIR}"
#echo "sourcedir=${MYSOURCEDIR}"
#echo "sourceservices=${MYSOURCESERVICES}"

### M O D I F I E D   F I L E S ...
# those specified by ${MYDIR}/samba
pamsamba=/etc/pam.d/samba

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_PAM_MOD=644

### F O R M A T S
case ${DISTRIBUTION} in
	Redhat|Fedora)
		libpath="\/lib\/security\/\$ISA\/"
		sysauthmatcher="^%SERVICE%[[:space:]]*required[[:space:]]*pam_stack.so[[:space:]]*service=system-auth.*$"
		;;
	Debian|Ubuntu)
		libpath=
		sysauthmatcher="^@include[[:space:]]*common-%SERVICE%.*$"
		;;
	Mandriva)
		libpath=
		sysauthmatcher="^%SERVICE%[[:space:]]*include[[:space:]]*service=system-auth.*$"
		;;
	Suse)
		libpath=
		sysauthmatcher="^%SERVICE%[[:space:]]*include[[:space:]]*common-%SERVICE%.*$"
		;;
	*)
		echo "Unsupported distribution" >&2
		exit 1
		;;
esac

### S T A R T

function getpam0()
{
	services="${MYSOURCESERVICES}"
	for f in ${services}; do
		if [ -f ${MYSOURCEDIR}/${f} ]; then
			cat ${MYSOURCEDIR}/${f} | grep -v "^#" | grep -v "^;" | grep -v "^$"
		fi
	done | grep "^$1" | awk '{printf("%s@",$0)}'
}

function getpam()
{
	if [ "${libpath}" != "" ]; then
		getpam0 $@ | sed "s/${libpath}//g"
	else
		getpam0 $@
	fi
}

#getpam
#getpam auth
#getpam account
#getpam password
#getpam session

function pam_expand()
{
target=$1
replacement=`getpam $1`
awk ' \
	{ \
		gsub(/%SERVICE%/,target,matcher); \
		if (match($0,matcher)) \
		{ \
			printf("# sadms remove begin\n"); \
			printf("#%s\n",$0); \
			printf("# sadms remove end\n"); \
			printf("# sadms add begin\n"); \
			n=split(replacement,new,"@"); \
			for (i=1;i<=n;i++) \
			{ \
				if(!match(new[i],"^$")) \
					printf("%s\n",new[i]); \
			} \
			printf("# sadms add end\n"); \
		} \
		else \
		{ \
			n=split($0,fields); \
			for (i=1;i<=n;i++) \
				printf("%s ",fields[i]); \
			printf("\n"); \
		} \
	} \
' "replacement=${replacement}" "target=$1" "matcher=${sysauthmatcher}" -
}

# samba
echo "+modify ${pamsamba} from ${MYSOURCEDIR}/${MYSOURCESERVICES}"
#cat ${MYSOURCEDIR}/${MYSOURCESERVICES}

# expand
echo "expand common services in ${pamsamba}"
cat ${pamsamba} | pam_expand auth |  pam_expand session > ${TMPDIR}/samba
#cat ${TMPDIR}/samba

# install
echo "install modified samba to ${MYDIR}"
${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_PAM_MOD} ${TMPDIR}/samba ${MYDIR} > /dev/null

# cleanup temporary
rm -f ${TMPDIR}/samba
