/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This source file is part of SableVM.                            *
 *                                                                 *
 * See the file "LICENSE" for the copyright information and for    *
 * the terms and conditions for copying, distribution and          *
 * modification of this source file.                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SVM_CONSTANTS_H
#define SVM_CONSTANTS_H

/* type state */

#define SVM_TYPE_STATE_VERIFIED 0x0001
#define SVM_TYPE_STATE_PREPARED 0x0002
#define SVM_TYPE_STATE_INITIALIZED 0x0004

/* array types */
#define SVM_T_BOOLEAN 4
#define SVM_T_CHAR 5
#define SVM_T_FLOAT 6
#define SVM_T_DOUBLE 7
#define SVM_T_BYTE 8
#define SVM_T_SHORT 9
#define SVM_T_INT 10
#define SVM_T_LONG 11

/* constant pool tags */
#define SVM_CONSTANT_Utf8 1
#define SVM_CONSTANT_Integer 3
#define SVM_CONSTANT_Float 4
#define SVM_CONSTANT_Long 5
#define SVM_CONSTANT_Double 6
#define SVM_CONSTANT_Class 7
#define SVM_CONSTANT_String 8
#define SVM_CONSTANT_Fieldref 9
#define SVM_CONSTANT_Methodref 10
#define SVM_CONSTANT_InterfaceMethodref 11
#define SVM_CONSTANT_NameAndType 12

/* access flags */
#define SVM_ACC_PUBLIC 0x0001
#define SVM_ACC_PRIVATE 0x0002
#define SVM_ACC_PROTECTED 0x0004
#define SVM_ACC_STATIC 0x0008
#define SVM_ACC_FINAL 0x0010
#define SVM_ACC_SUPER 0x0020
#define SVM_ACC_SYNCHRONIZED 0x0020
#define SVM_ACC_VOLATILE 0x0040
#define SVM_ACC_TRANSIENT 0x0080
#define SVM_ACC_NATIVE 0x0100
#define SVM_ACC_INTERFACE 0x0200
#define SVM_ACC_ABSTRACT 0x0400
#define SVM_ACC_STRICT 0x0800
#define SVM_ACC_INTERNAL 0x1000

/* types */
#define SVM_TYPE_VOID 0
#define SVM_TYPE_BOOLEAN 1
#define SVM_TYPE_BYTE 2
#define SVM_TYPE_SHORT 3
#define SVM_TYPE_CHAR 4
#define SVM_TYPE_INT 5
#define SVM_TYPE_LONG 6
#define SVM_TYPE_FLOAT 7
#define SVM_TYPE_DOUBLE 8
#define SVM_TYPE_REFERENCE 9

/* signal codes */
#define SVM_SIGNAL_NONE 0
#define SVM_SIGNAL_NULL_POINTER_EXCEPTION 1
#define SVM_SIGNAL_ARITHMETIC_EXCEPTION 2

#ifdef _SABLEVM_INLINABILITY_TESTING

#define SVM_SIGNAL_INLINING_FAILURE 3

#define SVM_ALARM_PERIOD 60

/* used by prepare_code.c:_svmf_no_inlining() calls */
#define SVM_IS_INLINED_FROM_SIGHANDLER 0
#define SVM_IS_INLINED_BYTECODE 1
#define SVM_IS_INLINED_METHOD 2
#define SVM_IS_INLINED_GET_BACKTRACE 3
#define SVM_IS_INLINED_HISTORY_SIZE 20

/* BCI stands for Bytecode Inlinability - NOTE: 1 and 2 are *masks* */
#define SVM_BCI_UNTESTED 0
#define SVM_BCI_INLINED 1
#define SVM_BCI_FAILING 2
#define SVM_BCI_SIGFPE 3

#endif /* _SABLEVM_INLINABILITY_TESTING */

/* needed for Thread.interrupt() */
#define SVM_INTERRUPT_SIGNAL SIGUSR1
/* note: these are *flags* not values! */
#define SVM_THREAD_NOT_INTERRUPTED 0
#define SVM_THREAD_INTERRUPTED 1
#define SVM_THREAD_THROW_INTERRUPTED 2
#define SVM_THREAD_INTERRUPTIBLE_BY_SIGNAL 4
#define SVM_THREAD_INTERRUPTIBLE_ON_FAT_LOCK 8

/* needed to avoid explicit m4 in instructions.m4.c */
#ifdef SABLEVM_GC_WRITE_BARRIER
#define _SABLEVM_GC_WRITE_BARRIER_REFERENCE
#endif

/* min/max values of java integer types */
#define SVM_JBYTE_MIN (-128)
#define SVM_JBYTE_MAX   127

#define SVM_JCHAR_MIN 0
#define SVM_JCHAR_MAX 65535

#define SVM_JSHORT_MIN (-32767 -1)
#define SVM_JSHORT_MAX   32767

#define SVM_JINT_MIN (-2147483647 -1)
#define SVM_JINT_MAX   2147483647

#define SVM_JLONG_MIN (((_svmt_s64) 1) << 63)
#define SVM_JLONG_MAX ((_svmt_s64) (((_svmt_u64) SVM_JLONG_MIN) - 1))

/* #define SVM_JLONG_MIN (-9223372036854775807LL -1LL)
   #define SVM_JLONG_MAX   9223372036854775807LL */

/* various constants */
#define SVM_FRAME_NATIVE_REFS_MIN 16
#define SVM_FRAME_NATIVE_REFS_AUTOADD_STEP 16

#define SVM_CLASS_LOADER_FREE_ARRAY_SIZE 16

/* interpreter flags */
#define SVM_INTRP_FLAG_UNUSED 0
#define SVM_INTRP_FLAG_SPECIAL 1
#define SVM_INTRP_FLAG_INLINEABLE 2
#define SVM_INTRP_FLAG_CONTAINS_BRANCH_OR_CALL 3

#if defined(_SABLEVM_SIGNALS_FOR_EXCEPTIONS) && defined(NDEBUG)

#define SVM_INTRP_FLAG_INLINEABLE_IF_SIGNALS SVM_INTRP_FLAG_INLINEABLE

#else

#define SVM_INTRP_FLAG_INLINEABLE_IF_SIGNALS SVM_INTRP_FLAG_CONTAINS_BRANCH_OR_CALL

#endif


/* stack map types */
#define SVM_STACK_MAP_REF -1
#define SVM_STACK_MAP_NONREF -2

/* thread status */
#define SVM_THREAD_STATUS_RUNNING_JAVA 0
#define SVM_THREAD_STATUS_HALT_REQUESTED 1
#define SVM_THREAD_STATUS_HALTED 2
#define SVM_THREAD_STATUS_NOT_RUNNING_JAVA_RESUMING_ALLOWED 3
#define SVM_THREAD_STATUS_NOT_RUNNING_JAVA_RESUMING_DISALLOWED 4

/* thread status flags */
#define SVM_THREAD_STATUS_FLAGS_NONE 0x00000000
#define SVM_THREAD_STATUS_FLAGS_STOP_THE_WORLD 0x00000001
#define SVM_THREAD_STATUS_FLAGS_SUSPEND 0x00000002

/* size of trace history on stop/resume java calls */
#ifndef NDEBUG
#define SVM_STOP_RESUME_TRACE_SIZE 100
#endif

/* maximum size of a string to keep instruction name */
#define _SABLEVM_BYTECODE_NAME_MAX_LENGTH 30

/* instructions */
#define SVM_INSTRUCTION_NOP   0
#define SVM_INSTRUCTION_ACONST_NULL   1
#define SVM_INSTRUCTION_ICONST_M1   2
#define SVM_INSTRUCTION_ICONST_0   3
#define SVM_INSTRUCTION_ICONST_1   4
#define SVM_INSTRUCTION_ICONST_2   5
#define SVM_INSTRUCTION_ICONST_3   6
#define SVM_INSTRUCTION_ICONST_4   7
#define SVM_INSTRUCTION_ICONST_5   8
#define SVM_INSTRUCTION_LCONST_0   9
#define SVM_INSTRUCTION_LCONST_1  10
#define SVM_INSTRUCTION_FCONST_0  11
#define SVM_INSTRUCTION_FCONST_1  12
#define SVM_INSTRUCTION_FCONST_2  13
#define SVM_INSTRUCTION_DCONST_0  14
#define SVM_INSTRUCTION_DCONST_1  15
#define SVM_INSTRUCTION_BIPUSH  16
#define SVM_INSTRUCTION_SIPUSH  17
#define SVM_INSTRUCTION_LDC  18
#define SVM_INSTRUCTION_LDC_W  19
#define SVM_INSTRUCTION_LDC2_W  20
#define SVM_INSTRUCTION_ILOAD  21
#define SVM_INSTRUCTION_LLOAD  22
#define SVM_INSTRUCTION_FLOAD  23
#define SVM_INSTRUCTION_DLOAD  24
#define SVM_INSTRUCTION_ALOAD  25
#define SVM_INSTRUCTION_ILOAD_0  26
#define SVM_INSTRUCTION_ILOAD_1  27
#define SVM_INSTRUCTION_ILOAD_2  28
#define SVM_INSTRUCTION_ILOAD_3  29
#define SVM_INSTRUCTION_LLOAD_0  30
#define SVM_INSTRUCTION_LLOAD_1  31
#define SVM_INSTRUCTION_LLOAD_2  32
#define SVM_INSTRUCTION_LLOAD_3  33
#define SVM_INSTRUCTION_FLOAD_0  34
#define SVM_INSTRUCTION_FLOAD_1  35
#define SVM_INSTRUCTION_FLOAD_2  36
#define SVM_INSTRUCTION_FLOAD_3  37
#define SVM_INSTRUCTION_DLOAD_0  38
#define SVM_INSTRUCTION_DLOAD_1  39
#define SVM_INSTRUCTION_DLOAD_2  40
#define SVM_INSTRUCTION_DLOAD_3  41
#define SVM_INSTRUCTION_ALOAD_0  42
#define SVM_INSTRUCTION_ALOAD_1  43
#define SVM_INSTRUCTION_ALOAD_2  44
#define SVM_INSTRUCTION_ALOAD_3  45
#define SVM_INSTRUCTION_IALOAD  46
#define SVM_INSTRUCTION_LALOAD  47
#define SVM_INSTRUCTION_FALOAD  48
#define SVM_INSTRUCTION_DALOAD  49
#define SVM_INSTRUCTION_AALOAD  50
#define SVM_INSTRUCTION_BALOAD  51
#define SVM_INSTRUCTION_CALOAD  52
#define SVM_INSTRUCTION_SALOAD  53
#define SVM_INSTRUCTION_ISTORE  54
#define SVM_INSTRUCTION_LSTORE  55
#define SVM_INSTRUCTION_FSTORE  56
#define SVM_INSTRUCTION_DSTORE  57
#define SVM_INSTRUCTION_ASTORE  58
#define SVM_INSTRUCTION_ISTORE_0  59
#define SVM_INSTRUCTION_ISTORE_1  60
#define SVM_INSTRUCTION_ISTORE_2  61
#define SVM_INSTRUCTION_ISTORE_3  62
#define SVM_INSTRUCTION_LSTORE_0  63
#define SVM_INSTRUCTION_LSTORE_1  64
#define SVM_INSTRUCTION_LSTORE_2  65
#define SVM_INSTRUCTION_LSTORE_3  66
#define SVM_INSTRUCTION_FSTORE_0  67
#define SVM_INSTRUCTION_FSTORE_1  68
#define SVM_INSTRUCTION_FSTORE_2  69
#define SVM_INSTRUCTION_FSTORE_3  70
#define SVM_INSTRUCTION_DSTORE_0  71
#define SVM_INSTRUCTION_DSTORE_1  72
#define SVM_INSTRUCTION_DSTORE_2  73
#define SVM_INSTRUCTION_DSTORE_3  74
#define SVM_INSTRUCTION_ASTORE_0  75
#define SVM_INSTRUCTION_ASTORE_1  76
#define SVM_INSTRUCTION_ASTORE_2  77
#define SVM_INSTRUCTION_ASTORE_3  78
#define SVM_INSTRUCTION_IASTORE  79
#define SVM_INSTRUCTION_LASTORE  80
#define SVM_INSTRUCTION_FASTORE  81
#define SVM_INSTRUCTION_DASTORE  82
#define SVM_INSTRUCTION_AASTORE  83
#define SVM_INSTRUCTION_BASTORE  84
#define SVM_INSTRUCTION_CASTORE  85
#define SVM_INSTRUCTION_SASTORE  86
#define SVM_INSTRUCTION_POP  87
#define SVM_INSTRUCTION_POP2  88
#define SVM_INSTRUCTION_DUP  89
#define SVM_INSTRUCTION_DUP_X1  90
#define SVM_INSTRUCTION_DUP_X2  91
#define SVM_INSTRUCTION_DUP2  92
#define SVM_INSTRUCTION_DUP2_X1  93
#define SVM_INSTRUCTION_DUP2_X2  94
#define SVM_INSTRUCTION_SWAP  95
#define SVM_INSTRUCTION_IADD  96
#define SVM_INSTRUCTION_LADD  97
#define SVM_INSTRUCTION_FADD  98
#define SVM_INSTRUCTION_DADD  99
#define SVM_INSTRUCTION_ISUB 100
#define SVM_INSTRUCTION_LSUB 101
#define SVM_INSTRUCTION_FSUB 102
#define SVM_INSTRUCTION_DSUB 103
#define SVM_INSTRUCTION_IMUL 104
#define SVM_INSTRUCTION_LMUL 105
#define SVM_INSTRUCTION_FMUL 106
#define SVM_INSTRUCTION_DMUL 107
#define SVM_INSTRUCTION_IDIV 108
#define SVM_INSTRUCTION_LDIV 109
#define SVM_INSTRUCTION_FDIV 110
#define SVM_INSTRUCTION_DDIV 111
#define SVM_INSTRUCTION_IREM 112
#define SVM_INSTRUCTION_LREM 113
#define SVM_INSTRUCTION_FREM 114
#define SVM_INSTRUCTION_DREM 115
#define SVM_INSTRUCTION_INEG 116
#define SVM_INSTRUCTION_LNEG 117
#define SVM_INSTRUCTION_FNEG 118
#define SVM_INSTRUCTION_DNEG 119
#define SVM_INSTRUCTION_ISHL 120
#define SVM_INSTRUCTION_LSHL 121
#define SVM_INSTRUCTION_ISHR 122
#define SVM_INSTRUCTION_LSHR 123
#define SVM_INSTRUCTION_IUSHR 124
#define SVM_INSTRUCTION_LUSHR 125
#define SVM_INSTRUCTION_IAND 126
#define SVM_INSTRUCTION_LAND 127
#define SVM_INSTRUCTION_IOR 128
#define SVM_INSTRUCTION_LOR 129
#define SVM_INSTRUCTION_IXOR 130
#define SVM_INSTRUCTION_LXOR 131
#define SVM_INSTRUCTION_IINC 132
#define SVM_INSTRUCTION_I2L 133
#define SVM_INSTRUCTION_I2F 134
#define SVM_INSTRUCTION_I2D 135
#define SVM_INSTRUCTION_L2I 136
#define SVM_INSTRUCTION_L2F 137
#define SVM_INSTRUCTION_L2D 138
#define SVM_INSTRUCTION_F2I 139
#define SVM_INSTRUCTION_F2L 140
#define SVM_INSTRUCTION_F2D 141
#define SVM_INSTRUCTION_D2I 142
#define SVM_INSTRUCTION_D2L 143
#define SVM_INSTRUCTION_D2F 144
#define SVM_INSTRUCTION_I2B 145
#define SVM_INSTRUCTION_I2C 146
#define SVM_INSTRUCTION_I2S 147
#define SVM_INSTRUCTION_LCMP 148
#define SVM_INSTRUCTION_FCMPL 149
#define SVM_INSTRUCTION_FCMPG 150
#define SVM_INSTRUCTION_DCMPL 151
#define SVM_INSTRUCTION_DCMPG 152
#define SVM_INSTRUCTION_IFEQ 153
#define SVM_INSTRUCTION_IFNE 154
#define SVM_INSTRUCTION_IFLT 155
#define SVM_INSTRUCTION_IFGE 156
#define SVM_INSTRUCTION_IFGT 157
#define SVM_INSTRUCTION_IFLE 158
#define SVM_INSTRUCTION_IF_ICMPEQ 159
#define SVM_INSTRUCTION_IF_ICMPNE 160
#define SVM_INSTRUCTION_IF_ICMPLT 161
#define SVM_INSTRUCTION_IF_ICMPGE 162
#define SVM_INSTRUCTION_IF_ICMPGT 163
#define SVM_INSTRUCTION_IF_ICMPLE 164
#define SVM_INSTRUCTION_IF_ACMPEQ 165
#define SVM_INSTRUCTION_IF_ACMPNE 166
#define SVM_INSTRUCTION_GOTO 167
#define SVM_INSTRUCTION_JSR 168
#define SVM_INSTRUCTION_RET 169
#define SVM_INSTRUCTION_TABLESWITCH 170
#define SVM_INSTRUCTION_LOOKUPSWITCH 171
#define SVM_INSTRUCTION_IRETURN 172
#define SVM_INSTRUCTION_LRETURN 173
#define SVM_INSTRUCTION_FRETURN 174
#define SVM_INSTRUCTION_DRETURN 175
#define SVM_INSTRUCTION_ARETURN 176
#define SVM_INSTRUCTION_RETURN 177
#define SVM_INSTRUCTION_GETSTATIC 178
#define SVM_INSTRUCTION_PUTSTATIC 179
#define SVM_INSTRUCTION_GETFIELD 180
#define SVM_INSTRUCTION_PUTFIELD 181
#define SVM_INSTRUCTION_INVOKEVIRTUAL 182
#define SVM_INSTRUCTION_INVOKESPECIAL 183
#define SVM_INSTRUCTION_INVOKESTATIC 184
#define SVM_INSTRUCTION_INVOKEINTERFACE 185
#define SVM_INSTRUCTION_UNDEFINED_186 186
#define SVM_INSTRUCTION_NEW 187
#define SVM_INSTRUCTION_NEWARRAY 188
#define SVM_INSTRUCTION_ANEWARRAY 189
#define SVM_INSTRUCTION_ARRAYLENGTH 190
#define SVM_INSTRUCTION_ATHROW 191
#define SVM_INSTRUCTION_CHECKCAST 192
#define SVM_INSTRUCTION_INSTANCEOF 193
#define SVM_INSTRUCTION_MONITORENTER 194
#define SVM_INSTRUCTION_MONITOREXIT 195
#define SVM_INSTRUCTION_WIDE 196
#define SVM_INSTRUCTION_MULTIANEWARRAY 197
#define SVM_INSTRUCTION_IFNULL 198
#define SVM_INSTRUCTION_IFNONNULL 199
#define SVM_INSTRUCTION_GOTO_W 200
#define SVM_INSTRUCTION_JSR_W 201

#define SVM_INSTRUCTION_PREPARE_METHOD 202
#define SVM_INSTRUCTION_LINK_NATIVE_METHOD 203
#define SVM_INSTRUCTION_ABSTRACT_METHOD 204
#define SVM_INSTRUCTION_ASTORE_RET_0 205
#define SVM_INSTRUCTION_ASTORE_RET_1 206
#define SVM_INSTRUCTION_ASTORE_RET_2 207
#define SVM_INSTRUCTION_ASTORE_RET_3 208
#define SVM_INSTRUCTION_ASTORE_RET 209
#define SVM_INSTRUCTION_NEWARRAY_BOOLEAN 210
#define SVM_INSTRUCTION_NEWARRAY_CHAR 211
#define SVM_INSTRUCTION_NEWARRAY_FLOAT 212
#define SVM_INSTRUCTION_NEWARRAY_DOUBLE 213
#define SVM_INSTRUCTION_NEWARRAY_BYTE 214
#define SVM_INSTRUCTION_NEWARRAY_SHORT 215
#define SVM_INSTRUCTION_NEWARRAY_INT 216
#define SVM_INSTRUCTION_NEWARRAY_LONG 217
#define SVM_INSTRUCTION_LDC_INTEGER 218
#define SVM_INSTRUCTION_LDC_FLOAT 219
#define SVM_INSTRUCTION_LDC_STRING 220
#define SVM_INSTRUCTION_LDC_LONG 221
#define SVM_INSTRUCTION_LDC_DOUBLE 222
#define SVM_INSTRUCTION_GETSTATIC_BOOLEAN 223
#define SVM_INSTRUCTION_GETSTATIC_BYTE 224
#define SVM_INSTRUCTION_GETSTATIC_SHORT 225
#define SVM_INSTRUCTION_GETSTATIC_CHAR 226
#define SVM_INSTRUCTION_GETSTATIC_INT 227
#define SVM_INSTRUCTION_GETSTATIC_LONG 228
#define SVM_INSTRUCTION_GETSTATIC_FLOAT 229
#define SVM_INSTRUCTION_GETSTATIC_DOUBLE 230
#define SVM_INSTRUCTION_GETSTATIC_REFERENCE 231
#define SVM_INSTRUCTION_PUTSTATIC_BOOLEAN 232
#define SVM_INSTRUCTION_PUTSTATIC_BYTE 233
#define SVM_INSTRUCTION_PUTSTATIC_SHORT 234
#define SVM_INSTRUCTION_PUTSTATIC_CHAR 235
#define SVM_INSTRUCTION_PUTSTATIC_INT 236
#define SVM_INSTRUCTION_PUTSTATIC_LONG 237
#define SVM_INSTRUCTION_PUTSTATIC_FLOAT 238
#define SVM_INSTRUCTION_PUTSTATIC_DOUBLE 239
#define SVM_INSTRUCTION_PUTSTATIC_REFERENCE 240
#define SVM_INSTRUCTION_GETFIELD_BOOLEAN 241
#define SVM_INSTRUCTION_GETFIELD_BYTE 242
#define SVM_INSTRUCTION_GETFIELD_SHORT 243
#define SVM_INSTRUCTION_GETFIELD_CHAR 244
#define SVM_INSTRUCTION_GETFIELD_INT 245
#define SVM_INSTRUCTION_GETFIELD_LONG 246
#define SVM_INSTRUCTION_GETFIELD_FLOAT 247
#define SVM_INSTRUCTION_GETFIELD_DOUBLE 248
#define SVM_INSTRUCTION_GETFIELD_REFERENCE 249
#define SVM_INSTRUCTION_PUTFIELD_BOOLEAN 250
#define SVM_INSTRUCTION_PUTFIELD_BYTE 251
#define SVM_INSTRUCTION_PUTFIELD_SHORT 252
#define SVM_INSTRUCTION_PUTFIELD_CHAR 253
#define SVM_INSTRUCTION_PUTFIELD_INT 254
#define SVM_INSTRUCTION_PUTFIELD_LONG 255
#define SVM_INSTRUCTION_PUTFIELD_FLOAT 256
#define SVM_INSTRUCTION_PUTFIELD_DOUBLE 257
#define SVM_INSTRUCTION_PUTFIELD_REFERENCE 258
#define SVM_INSTRUCTION_NATIVE_STATIC_METHOD 259
#define SVM_INSTRUCTION_NATIVE_NONSTATIC_METHOD 260
#define SVM_INSTRUCTION_NEXT 261
#define SVM_INSTRUCTION_ERROR 262
#define SVM_INSTRUCTION_INTERNAL_CALL_END 263
#define SVM_INSTRUCTION_PREPARE_LDC_STRING 264
#define SVM_INSTRUCTION_REPLACE 265
#define SVM_INSTRUCTION_PREPARE_MULTIANEWARRAY 266
#define SVM_INSTRUCTION_IFEQ_CHECK 267
#define SVM_INSTRUCTION_IFNE_CHECK 268
#define SVM_INSTRUCTION_IFLT_CHECK 269
#define SVM_INSTRUCTION_IFGE_CHECK 270
#define SVM_INSTRUCTION_IFGT_CHECK 271
#define SVM_INSTRUCTION_IFLE_CHECK 272
#define SVM_INSTRUCTION_IF_ICMPEQ_CHECK 273
#define SVM_INSTRUCTION_IF_ICMPNE_CHECK 274
#define SVM_INSTRUCTION_IF_ICMPLT_CHECK 275
#define SVM_INSTRUCTION_IF_ICMPGE_CHECK 276
#define SVM_INSTRUCTION_IF_ICMPGT_CHECK 277
#define SVM_INSTRUCTION_IF_ICMPLE_CHECK 278
#define SVM_INSTRUCTION_IF_ACMPEQ_CHECK 279
#define SVM_INSTRUCTION_IF_ACMPNE_CHECK 280
#define SVM_INSTRUCTION_GOTO_CHECK 281
#define SVM_INSTRUCTION_JSR_CHECK 282
#define SVM_INSTRUCTION_TABLESWITCH_CHECK 283
#define SVM_INSTRUCTION_LOOKUPSWITCH_CHECK 284
#define SVM_INSTRUCTION_IFNULL_CHECK 285
#define SVM_INSTRUCTION_IFNONNULL_CHECK 286
#define SVM_INSTRUCTION_PREPARE_NEW 287
#define SVM_INSTRUCTION_PREPARE_ANEWARRAY 288
#define SVM_INSTRUCTION_PREPARE_CHECKCAST 289
#define SVM_INSTRUCTION_PREPARE_INSTANCEOF 290
#define SVM_INSTRUCTION_PREPARE_INVOKEVIRTUAL 291
#define SVM_INSTRUCTION_PREPARE_INVOKESPECIAL 292
#define SVM_INSTRUCTION_PREPARE_INVOKESTATIC 293
#define SVM_INSTRUCTION_PREPARE_INVOKEINTERFACE 294
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_BOOLEAN 295
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_BYTE 296
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_SHORT 297
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_CHAR 298
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_INT 299
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_LONG 300
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_FLOAT 301
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_DOUBLE 302
#define SVM_INSTRUCTION_PREPARE_GETSTATIC_REFERENCE 303
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_BOOLEAN 304
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_BYTE 305
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_SHORT 306
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_CHAR 307
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_INT 308
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_LONG 309
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_FLOAT 310
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_DOUBLE 311
#define SVM_INSTRUCTION_PREPARE_PUTSTATIC_REFERENCE 312
#define SVM_INSTRUCTION_PREPARE_GETFIELD_BOOLEAN 313
#define SVM_INSTRUCTION_PREPARE_GETFIELD_BYTE 314
#define SVM_INSTRUCTION_PREPARE_GETFIELD_SHORT 315
#define SVM_INSTRUCTION_PREPARE_GETFIELD_CHAR 316
#define SVM_INSTRUCTION_PREPARE_GETFIELD_INT 317
#define SVM_INSTRUCTION_PREPARE_GETFIELD_LONG 318
#define SVM_INSTRUCTION_PREPARE_GETFIELD_FLOAT 319
#define SVM_INSTRUCTION_PREPARE_GETFIELD_DOUBLE 320
#define SVM_INSTRUCTION_PREPARE_GETFIELD_REFERENCE 321
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_BOOLEAN 322
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_BYTE 323
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_SHORT 324
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_CHAR 325
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_INT 326
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_LONG 327
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_FLOAT 328
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_DOUBLE 329
#define SVM_INSTRUCTION_PREPARE_PUTFIELD_REFERENCE 330
#define SVM_INSTRUCTION_SKIP 331

#define SVM_INSTRUCTION_COUNT 332

#endif /* not SVM_CONSTANTS_H */
