/* rygel-image-item.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-image-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;
typedef struct _RygelImageItemPrivate RygelImageItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelImageItem {
	RygelMediaItem parent_instance;
	RygelImageItemPrivate * priv;
};

struct _RygelImageItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelImageItemPrivate {
	gint _width;
	gint _height;
	gint _pixel_width;
	gint _pixel_height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};


static gpointer rygel_image_item_parent_class = NULL;
static RygelVisualItemIface* rygel_image_item_rygel_visual_item_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_image_item_get_type (void) G_GNUC_CONST;
#define RYGEL_IMAGE_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemPrivate))
enum  {
	RYGEL_IMAGE_ITEM_DUMMY_PROPERTY,
	RYGEL_IMAGE_ITEM_WIDTH,
	RYGEL_IMAGE_ITEM_HEIGHT,
	RYGEL_IMAGE_ITEM_PIXEL_WIDTH,
	RYGEL_IMAGE_ITEM_PIXEL_HEIGHT,
	RYGEL_IMAGE_ITEM_COLOR_DEPTH,
	RYGEL_IMAGE_ITEM_THUMBNAILS
};
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
RygelImageItem* rygel_image_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
static gboolean rygel_image_item_real_streamable (RygelMediaItem* base);
static void rygel_image_item_real_add_uri (RygelMediaItem* base, const char* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri);
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const char* uri);
static void rygel_image_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static GUPnPDIDLLiteResource* rygel_image_item_real_add_resource (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
void rygel_visual_item_add_visual_props (RygelVisualItem* self, GUPnPDIDLLiteResource* res);
static void rygel_image_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_visual_item_add_thumbnail_proxy_resources (RygelVisualItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
static GUPnPProtocolInfo* rygel_image_item_real_get_protocol_info (RygelMediaItem* base, const char* uri, const char* protocol);
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol);
static void rygel_image_item_finalize (GObject* obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
static void rygel_image_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
static void rygel_image_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



#line 42 "rygel-image-item.vala"
RygelImageItem* rygel_image_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 269 "rygel-image-item.c"
	RygelImageItem * self;
	GeeArrayList* _tmp0_;
#line 42 "rygel-image-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 42 "rygel-image-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 42 "rygel-image-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 42 "rygel-image-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 46 "rygel-image-item.vala"
	self = (RygelImageItem*) rygel_media_item_construct (object_type, id, parent, title, upnp_class);
#line 48 "rygel-image-item.vala"
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL));
#line 284 "rygel-image-item.c"
	_g_object_unref0 (_tmp0_);
	return self;
}


#line 42 "rygel-image-item.vala"
RygelImageItem* rygel_image_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 42 "rygel-image-item.vala"
	return rygel_image_item_construct (RYGEL_TYPE_IMAGE_ITEM, id, parent, title, upnp_class);
#line 294 "rygel-image-item.c"
}


#line 51 "rygel-image-item.vala"
static gboolean rygel_image_item_real_streamable (RygelMediaItem* base) {
#line 300 "rygel-image-item.c"
	RygelImageItem * self;
	gboolean result = FALSE;
	self = (RygelImageItem*) base;
	result = FALSE;
#line 52 "rygel-image-item.vala"
	return result;
#line 307 "rygel-image-item.c"
}


#line 55 "rygel-image-item.vala"
static void rygel_image_item_real_add_uri (RygelMediaItem* base, const char* uri) {
#line 313 "rygel-image-item.c"
	RygelImageItem * self;
	self = (RygelImageItem*) base;
#line 55 "rygel-image-item.vala"
	g_return_if_fail (uri != NULL);
#line 56 "rygel-image-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_image_item_parent_class)->add_uri (RYGEL_MEDIA_ITEM (self), uri);
#line 58 "rygel-image-item.vala"
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, uri);
#line 322 "rygel-image-item.c"
}


#line 61 "rygel-image-item.vala"
static void rygel_image_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 328 "rygel-image-item.c"
	RygelImageItem * self;
	GError * _inner_error_ = NULL;
	self = (RygelImageItem*) base;
#line 61 "rygel-image-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 64 "rygel-image-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_image_item_parent_class)->add_resources (RYGEL_MEDIA_ITEM (self), didl_item, allow_internal, &_inner_error_);
#line 336 "rygel-image-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 66 "rygel-image-item.vala"
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, didl_item, allow_internal, &_inner_error_);
#line 343 "rygel-image-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 69 "rygel-image-item.vala"
static GUPnPDIDLLiteResource* rygel_image_item_real_add_resource (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error) {
#line 353 "rygel-image-item.c"
	RygelImageItem * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res;
	GError * _inner_error_ = NULL;
	self = (RygelImageItem*) base;
#line 69 "rygel-image-item.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 69 "rygel-image-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 75 "rygel-image-item.vala"
	res = RYGEL_MEDIA_ITEM_CLASS (rygel_image_item_parent_class)->add_resource (RYGEL_MEDIA_ITEM (self), didl_item, uri, protocol, import_uri, &_inner_error_);
#line 365 "rygel-image-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 77 "rygel-image-item.vala"
	rygel_visual_item_add_visual_props ((RygelVisualItem*) self, res);
#line 372 "rygel-image-item.c"
	result = res;
#line 79 "rygel-image-item.vala"
	return result;
#line 376 "rygel-image-item.c"
}


#line 82 "rygel-image-item.vala"
static void rygel_image_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
#line 382 "rygel-image-item.c"
	RygelImageItem * self;
	GError * _inner_error_ = NULL;
	self = (RygelImageItem*) base;
#line 82 "rygel-image-item.vala"
	g_return_if_fail (server != NULL);
#line 82 "rygel-image-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 85 "rygel-image-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_image_item_parent_class)->add_proxy_resources (RYGEL_MEDIA_ITEM (self), server, didl_item, &_inner_error_);
#line 392 "rygel-image-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 88 "rygel-image-item.vala"
	rygel_visual_item_add_thumbnail_proxy_resources ((RygelVisualItem*) self, server, didl_item, &_inner_error_);
#line 399 "rygel-image-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 91 "rygel-image-item.vala"
static GUPnPProtocolInfo* rygel_image_item_real_get_protocol_info (RygelMediaItem* base, const char* uri, const char* protocol) {
#line 409 "rygel-image-item.c"
	RygelImageItem * self;
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* protocol_info;
	self = (RygelImageItem*) base;
#line 91 "rygel-image-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 93 "rygel-image-item.vala"
	protocol_info = RYGEL_MEDIA_ITEM_CLASS (rygel_image_item_parent_class)->get_protocol_info (RYGEL_MEDIA_ITEM (self), uri, protocol);
#line 95 "rygel-image-item.vala"
	gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
#line 420 "rygel-image-item.c"
	result = protocol_info;
#line 97 "rygel-image-item.vala"
	return result;
#line 424 "rygel-image-item.c"
}


static gint rygel_image_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_width;
#line 34 "rygel-image-item.vala"
	return result;
#line 435 "rygel-image-item.c"
}


static void rygel_image_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	self->priv->_width = value;
	g_object_notify ((GObject *) self, "width");
}


static gint rygel_image_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_height;
#line 35 "rygel-image-item.vala"
	return result;
#line 454 "rygel-image-item.c"
}


static void rygel_image_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	self->priv->_height = value;
	g_object_notify ((GObject *) self, "height");
}


static gint rygel_image_item_real_get_pixel_width (RygelVisualItem* base) {
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_pixel_width;
#line 36 "rygel-image-item.vala"
	return result;
#line 473 "rygel-image-item.c"
}


static void rygel_image_item_real_set_pixel_width (RygelVisualItem* base, gint value) {
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	self->priv->_pixel_width = value;
	g_object_notify ((GObject *) self, "pixel-width");
}


static gint rygel_image_item_real_get_pixel_height (RygelVisualItem* base) {
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_pixel_height;
#line 37 "rygel-image-item.vala"
	return result;
#line 492 "rygel-image-item.c"
}


static void rygel_image_item_real_set_pixel_height (RygelVisualItem* base, gint value) {
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	self->priv->_pixel_height = value;
	g_object_notify ((GObject *) self, "pixel-height");
}


static gint rygel_image_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_color_depth;
#line 38 "rygel-image-item.vala"
	return result;
#line 511 "rygel-image-item.c"
}


static void rygel_image_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	self->priv->_color_depth = value;
	g_object_notify ((GObject *) self, "color-depth");
}


static GeeArrayList* rygel_image_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelImageItem* self;
	self = (RygelImageItem*) base;
	result = self->priv->_thumbnails;
#line 40 "rygel-image-item.vala"
	return result;
#line 530 "rygel-image-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_image_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelImageItem* self;
	GeeArrayList* _tmp0_;
	self = (RygelImageItem*) base;
	self->priv->_thumbnails = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_thumbnails), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnails");
}


static void rygel_image_item_class_init (RygelImageItemClass * klass) {
	rygel_image_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelImageItemPrivate));
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_image_item_real_streamable;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_image_item_real_add_uri;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_image_item_real_add_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_image_item_real_add_resource;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_image_item_real_add_proxy_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->get_protocol_info = rygel_image_item_real_get_protocol_info;
	G_OBJECT_CLASS (klass)->get_property = rygel_image_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_image_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_image_item_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_WIDTH, "width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_HEIGHT, "height");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_PIXEL_WIDTH, "pixel-width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_PIXEL_HEIGHT, "pixel-height");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_COLOR_DEPTH, "color-depth");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_IMAGE_ITEM_THUMBNAILS, "thumbnails");
}


static void rygel_image_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
	rygel_image_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_image_item_real_get_width;
	iface->set_width = rygel_image_item_real_set_width;
	iface->get_height = rygel_image_item_real_get_height;
	iface->set_height = rygel_image_item_real_set_height;
	iface->get_pixel_width = rygel_image_item_real_get_pixel_width;
	iface->set_pixel_width = rygel_image_item_real_set_pixel_width;
	iface->get_pixel_height = rygel_image_item_real_get_pixel_height;
	iface->set_pixel_height = rygel_image_item_real_set_pixel_height;
	iface->get_color_depth = rygel_image_item_real_get_color_depth;
	iface->set_color_depth = rygel_image_item_real_set_color_depth;
	iface->get_thumbnails = rygel_image_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_image_item_real_set_thumbnails;
}


static void rygel_image_item_instance_init (RygelImageItem * self) {
	self->priv = RYGEL_IMAGE_ITEM_GET_PRIVATE (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_pixel_width = -1;
	self->priv->_pixel_height = -1;
	self->priv->_color_depth = -1;
}


static void rygel_image_item_finalize (GObject* obj) {
	RygelImageItem * self;
	self = RYGEL_IMAGE_ITEM (obj);
	_g_object_unref0 (self->priv->_thumbnails);
	G_OBJECT_CLASS (rygel_image_item_parent_class)->finalize (obj);
}


/**
 * Represents an image item.
 */
GType rygel_image_item_get_type (void) {
	static volatile gsize rygel_image_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_image_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelImageItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_image_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelImageItem), 0, (GInstanceInitFunc) rygel_image_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_image_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_image_item_type_id;
		rygel_image_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelImageItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_image_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_image_item_type_id__volatile, rygel_image_item_type_id);
	}
	return rygel_image_item_type_id__volatile;
}


static void rygel_image_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelImageItem * self;
	self = RYGEL_IMAGE_ITEM (object);
	switch (property_id) {
		case RYGEL_IMAGE_ITEM_WIDTH:
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_HEIGHT:
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_PIXEL_WIDTH:
		g_value_set_int (value, rygel_visual_item_get_pixel_width ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_PIXEL_HEIGHT:
		g_value_set_int (value, rygel_visual_item_get_pixel_height ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_COLOR_DEPTH:
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
		break;
		case RYGEL_IMAGE_ITEM_THUMBNAILS:
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_image_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelImageItem * self;
	self = RYGEL_IMAGE_ITEM (object);
	switch (property_id) {
		case RYGEL_IMAGE_ITEM_WIDTH:
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_HEIGHT:
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_PIXEL_WIDTH:
		rygel_visual_item_set_pixel_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_PIXEL_HEIGHT:
		rygel_visual_item_set_pixel_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_COLOR_DEPTH:
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_IMAGE_ITEM_THUMBNAILS:
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




