/* rygel-basic-management-test-traceroute.c generated by valac 0.26.0.39-f3603, the Vala compiler
 * generated from rygel-basic-management-test-traceroute.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE (rygel_basic_management_test_traceroute_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))

typedef struct _RygelBasicManagementTestTraceroute RygelBasicManagementTestTraceroute;
typedef struct _RygelBasicManagementTestTracerouteClass RygelBasicManagementTestTracerouteClass;
typedef struct _RygelBasicManagementTestTraceroutePrivate RygelBasicManagementTestTraceroutePrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_TYPE_STATUS (rygel_basic_management_test_traceroute_status_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_TYPE_PROCESS_STATE (rygel_basic_management_test_traceroute_process_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestTraceroute {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestTraceroutePrivate * priv;
};

struct _RygelBasicManagementTestTracerouteClass {
	RygelBasicManagementTestClass parent_class;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER
} RygelBasicManagementTestTracerouteStatus;

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS
} RygelBasicManagementTestTracerouteProcessState;

struct _RygelBasicManagementTestTraceroutePrivate {
	gchar* _host;
	guint32 _wait_time_out;
	guint _data_block_size;
	guint _max_hop_count;
	guint _dscp;
	GRegex* regex;
	GRegex* rtt_regex;
	RygelBasicManagementTestTracerouteStatus status;
	gboolean error_set;
	RygelBasicManagementTestTracerouteProcessState state;
	gchar* host_ip;
	gchar* additional_info;
	guint32 response_time;
	gchar* hop_ips;
};


static gpointer rygel_basic_management_test_traceroute_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_traceroute_get_type (void) G_GNUC_CONST;
static GType rygel_basic_management_test_traceroute_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_traceroute_process_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroutePrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE,
	RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE
};
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT ((guint) 5000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE ((guint) 32)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS ((guint) 30)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP ((guint) 30)
static gchar* rygel_basic_management_test_traceroute_status_to_string (RygelBasicManagementTestTracerouteStatus self);
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT ((guint) 30000)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE ((guint) 20)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP ((guint) 64)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS ((guint) 64)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOSTS ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_RESULT_SIZE ((guint) 4)
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type, const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
static void rygel_basic_management_test_traceroute_real_constructed (GObject* base);
guint rygel_basic_management_test_traceroute_get_max_hop_count (RygelBasicManagementTestTraceroute* self);
guint32 rygel_basic_management_test_traceroute_get_wait_time_out (RygelBasicManagementTestTraceroute* self);
guint rygel_basic_management_test_traceroute_get_dscp (RygelBasicManagementTestTraceroute* self);
const gchar* rygel_basic_management_test_traceroute_get_host (RygelBasicManagementTestTraceroute* self);
guint rygel_basic_management_test_traceroute_get_data_block_size (RygelBasicManagementTestTraceroute* self);
static void rygel_basic_management_test_traceroute_set_error (RygelBasicManagementTestTraceroute* self, RygelBasicManagementTestTracerouteStatus status, const gchar* info);
static void rygel_basic_management_test_traceroute_real_handle_error (RygelBasicManagementTest* base, const gchar* line);
static void rygel_basic_management_test_traceroute_real_handle_output (RygelBasicManagementTest* base, const gchar* line);
void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self, gchar** status, gchar** additional_info, guint32* response_time, gchar** hop_ips);
static void rygel_basic_management_test_traceroute_set_host (RygelBasicManagementTestTraceroute* self, const gchar* value);
static void rygel_basic_management_test_traceroute_set_wait_time_out (RygelBasicManagementTestTraceroute* self, guint32 value);
static void rygel_basic_management_test_traceroute_set_data_block_size (RygelBasicManagementTestTraceroute* self, guint value);
static void rygel_basic_management_test_traceroute_set_max_hop_count (RygelBasicManagementTestTraceroute* self, guint value);
static void rygel_basic_management_test_traceroute_set_dscp (RygelBasicManagementTestTraceroute* self, guint value);
static void rygel_basic_management_test_traceroute_finalize (GObject* obj);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static void _vala_rygel_basic_management_test_traceroute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_test_traceroute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType rygel_basic_management_test_traceroute_process_state_get_type (void) {
	static volatile gsize rygel_basic_management_test_traceroute_process_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_process_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS", "hops"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_traceroute_process_state_type_id;
		rygel_basic_management_test_traceroute_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestTracerouteProcessState", values);
		g_once_init_leave (&rygel_basic_management_test_traceroute_process_state_type_id__volatile, rygel_basic_management_test_traceroute_process_state_type_id);
	}
	return rygel_basic_management_test_traceroute_process_state_type_id__volatile;
}


static gchar* rygel_basic_management_test_traceroute_status_to_string (RygelBasicManagementTestTracerouteStatus self) {
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("Success");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("Error_CannotResolveHostName");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("Error_MaxHopCountExceeded");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("Error_Internal");
			result = _tmp3_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("Error_Other");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GType rygel_basic_management_test_traceroute_status_get_type (void) {
	static volatile gsize rygel_basic_management_test_traceroute_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME", "error-cannot-resolve-hostname"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED", "error-max-hop-count-exceeded"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_traceroute_status_type_id;
		rygel_basic_management_test_traceroute_status_type_id = g_enum_register_static ("RygelBasicManagementTestTracerouteStatus", values);
		g_once_init_leave (&rygel_basic_management_test_traceroute_status_type_id__volatile, rygel_basic_management_test_traceroute_status_type_id);
	}
	return rygel_basic_management_test_traceroute_status_type_id__volatile;
}


RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type, const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp) {
	RygelBasicManagementTestTraceroute * self = NULL;
	const gchar* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = host;
	_tmp1_ = wait_time_out;
	_tmp2_ = data_block_size;
	_tmp3_ = max_hop_count;
	_tmp4_ = dscp;
	self = (RygelBasicManagementTestTraceroute*) g_object_new (object_type, "host", _tmp0_, "wait-time-out", _tmp1_, "data-block-size", _tmp2_, "max-hop-count", _tmp3_, "dscp", _tmp4_, NULL);
	return self;
}


RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp) {
	return rygel_basic_management_test_traceroute_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, host, wait_time_out, data_block_size, max_hop_count, dscp);
}


static void rygel_basic_management_test_traceroute_real_constructed (GObject* base) {
	RygelBasicManagementTestTraceroute * self;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	guint32 _tmp13_ = 0U;
	guint32 _tmp14_ = 0U;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	gchar* _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	guint32 _tmp28_ = 0U;
	guint32 _tmp29_ = 0U;
	GError * _inner_error_ = NULL;
	self = (RygelBasicManagementTestTraceroute*) base;
	G_OBJECT_CLASS (rygel_basic_management_test_traceroute_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		_tmp1_ = g_regex_new ("^\\s*(\\d+)\\s+(\\S+)\\s*(.*)$", 0, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->regex);
		self->priv->regex = _tmp2_;
		_tmp4_ = g_regex_new ("(\\S+)\\s+ms\\b", 0, 0, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch3_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (self->priv->rtt_regex);
		self->priv->rtt_regex = _tmp5_;
		_g_regex_unref0 (_tmp3_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT;
	self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL;
	self->priv->error_set = FALSE;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->hop_ips);
	self->priv->hop_ips = _tmp6_;
	_tmp7_ = g_strdup ("traceroute");
	_tmp8_ = g_strdup ("-m");
	_tmp9_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%u", _tmp10_);
	_tmp12_ = g_strdup ("-w");
	_tmp13_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%u", _tmp14_ / 1000);
	_tmp16_ = g_strdup ("-t");
	_tmp17_ = rygel_basic_management_test_traceroute_get_dscp (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%u", _tmp18_ >> 2);
	_tmp20_ = g_strdup ("-n");
	_tmp21_ = self->priv->_host;
	_tmp22_ = g_strdup (_tmp21_);
	_tmp23_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf ("%u", _tmp24_);
	_tmp26_ = g_new0 (gchar*, 10 + 1);
	_tmp26_[0] = _tmp7_;
	_tmp26_[1] = _tmp8_;
	_tmp26_[2] = _tmp11_;
	_tmp26_[3] = _tmp12_;
	_tmp26_[4] = _tmp15_;
	_tmp26_[5] = _tmp16_;
	_tmp26_[6] = _tmp19_;
	_tmp26_[7] = _tmp20_;
	_tmp26_[8] = _tmp22_;
	_tmp26_[9] = _tmp25_;
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
	((RygelBasicManagementTest*) self)->command = _tmp26_;
	((RygelBasicManagementTest*) self)->command_length1 = 10;
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
	_tmp28_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
	_tmp29_ = _tmp28_;
	if (_tmp29_ < ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT)) {
		_tmp27_ = TRUE;
	} else {
		guint32 _tmp30_ = 0U;
		guint32 _tmp31_ = 0U;
		_tmp30_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
		_tmp31_ = _tmp30_;
		_tmp27_ = _tmp31_ > ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT);
	}
	if (_tmp27_) {
		gchar* msg = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		guint32 _tmp34_ = 0U;
		guint32 _tmp35_ = 0U;
		gchar* _tmp36_ = NULL;
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
		_tmp32_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
		msg = _tmp32_;
		_tmp33_ = msg;
		_tmp34_ = rygel_basic_management_test_traceroute_get_wait_time_out (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf (_tmp33_, _tmp35_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_TIMEOUT);
		_g_free0 (self->priv->additional_info);
		self->priv->additional_info = _tmp36_;
		_g_free0 (msg);
	} else {
		gboolean _tmp37_ = FALSE;
		guint _tmp38_ = 0U;
		guint _tmp39_ = 0U;
		_tmp38_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
		_tmp39_ = _tmp38_;
		if (_tmp39_ < RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE) {
			_tmp37_ = TRUE;
		} else {
			guint _tmp40_ = 0U;
			guint _tmp41_ = 0U;
			_tmp40_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
			_tmp41_ = _tmp40_;
			_tmp37_ = _tmp41_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE;
		}
		if (_tmp37_) {
			gchar* msg = NULL;
			gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			guint _tmp44_ = 0U;
			guint _tmp45_ = 0U;
			gchar* _tmp46_ = NULL;
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
			_tmp42_ = g_strdup ("DataBlockSize %u is not in allowed range [%u, %u]");
			msg = _tmp42_;
			_tmp43_ = msg;
			_tmp44_ = rygel_basic_management_test_traceroute_get_data_block_size (self);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strdup_printf (_tmp43_, _tmp45_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MIN_DATA_BLOCK_SIZE, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DATA_BLOCK_SIZE);
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp46_;
			_g_free0 (msg);
		} else {
			guint _tmp47_ = 0U;
			guint _tmp48_ = 0U;
			_tmp47_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
			_tmp48_ = _tmp47_;
			if (_tmp48_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS) {
				gchar* msg = NULL;
				gchar* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				guint _tmp51_ = 0U;
				guint _tmp52_ = 0U;
				gchar* _tmp53_ = NULL;
				((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
				_tmp49_ = g_strdup ("MaxHopCount %u is not in allowed range [0, %u]");
				msg = _tmp49_;
				_tmp50_ = msg;
				_tmp51_ = rygel_basic_management_test_traceroute_get_max_hop_count (self);
				_tmp52_ = _tmp51_;
				_tmp53_ = g_strdup_printf (_tmp50_, _tmp52_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOPS);
				_g_free0 (self->priv->additional_info);
				self->priv->additional_info = _tmp53_;
				_g_free0 (msg);
			} else {
				guint _tmp54_ = 0U;
				guint _tmp55_ = 0U;
				_tmp54_ = rygel_basic_management_test_traceroute_get_dscp (self);
				_tmp55_ = _tmp54_;
				if (_tmp55_ > RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP) {
					gchar* msg = NULL;
					gchar* _tmp56_ = NULL;
					const gchar* _tmp57_ = NULL;
					guint _tmp58_ = 0U;
					guint _tmp59_ = 0U;
					gchar* _tmp60_ = NULL;
					((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
					_tmp56_ = g_strdup ("DSCP %u is not in allowed range [0, %u]");
					msg = _tmp56_;
					_tmp57_ = msg;
					_tmp58_ = rygel_basic_management_test_traceroute_get_dscp (self);
					_tmp59_ = _tmp58_;
					_tmp60_ = g_strdup_printf (_tmp57_, _tmp59_, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_DSCP);
					_g_free0 (self->priv->additional_info);
					self->priv->additional_info = _tmp60_;
					_g_free0 (msg);
				}
			}
		}
	}
}


static void rygel_basic_management_test_traceroute_set_error (RygelBasicManagementTestTraceroute* self, RygelBasicManagementTestTracerouteStatus status, const gchar* info) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelBasicManagementTestTracerouteStatus _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	self->priv->error_set = TRUE;
	_tmp0_ = info;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->additional_info);
	self->priv->additional_info = _tmp1_;
	_tmp2_ = status;
	self->priv->status = _tmp2_;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void rygel_basic_management_test_traceroute_real_handle_error (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestTraceroute * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (RygelBasicManagementTestTraceroute*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp1_ = string_contains (_tmp0_, "Cannot handle \"host\" cmdline arg");
	if (_tmp1_) {
		rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "");
	} else {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = line;
		_tmp3_ = string_contains (_tmp2_, "Network is unreachable");
		if (_tmp3_) {
			rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, "Network is unreachable.");
		} else {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = line;
			rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_INTERNAL, _tmp4_);
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static void rygel_basic_management_test_traceroute_real_handle_output (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestTraceroute * self;
	gchar* _error_ = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelBasicManagementTestTracerouteProcessState _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	self = (RygelBasicManagementTestTraceroute*) base;
	g_return_if_fail (line != NULL);
	_error_ = NULL;
	_tmp0_ = line;
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->state;
	switch (_tmp3_) {
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_INIT:
		{
			const gchar* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			_tmp4_ = line;
			_tmp5_ = string_contains (_tmp4_, "traceroute to ");
			if (_tmp5_) {
				gint start = 0;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint end = 0;
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS;
				_tmp6_ = line;
				_tmp7_ = string_index_of_char (_tmp6_, (gunichar) '(', 0);
				start = _tmp7_;
				_tmp8_ = line;
				_tmp9_ = start;
				_tmp10_ = string_index_of_char (_tmp8_, (gunichar) ')', _tmp9_);
				end = _tmp10_;
				_tmp11_ = end;
				_tmp12_ = start;
				if (_tmp11_ > _tmp12_) {
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gchar* _tmp16_ = NULL;
					_tmp13_ = line;
					_tmp14_ = start;
					_tmp15_ = end;
					_tmp16_ = string_slice (_tmp13_, (glong) (_tmp14_ + 1), (glong) _tmp15_);
					_g_free0 (self->priv->host_ip);
					self->priv->host_ip = _tmp16_;
				}
			} else {
				const gchar* _tmp17_ = NULL;
				_tmp17_ = line;
				g_debug ("rygel-basic-management-test-traceroute.vala:255: traceroute parser: Un" \
"expected line '%s'", _tmp17_);
			}
			break;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_PROCESS_STATE_HOPS:
		{
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			const gchar* _tmp36_ = NULL;
			GMatchInfo* info = NULL;
			GRegex* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			GMatchInfo* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			gchar* ip_address = NULL;
			GMatchInfo* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gboolean _tmp45_ = FALSE;
			const gchar* _tmp48_ = NULL;
			gchar* rtt_string = NULL;
			GMatchInfo* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			GRegex* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			GMatchInfo* _tmp54_ = NULL;
			gint rtt_count = 0;
			gdouble rtt_average = 0.0;
			gint _tmp67_ = 0;
			gdouble _tmp70_ = 0.0;
			gdouble _tmp71_ = 0.0;
			const gchar* _tmp72_ = NULL;
			gint _tmp73_ = 0;
			gint _tmp74_ = 0;
			const gchar* _tmp77_ = NULL;
			const gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			_tmp18_ = line;
			_tmp19_ = string_contains (_tmp18_, " !H ");
			if (_tmp19_) {
				gchar* _tmp20_ = NULL;
				_tmp20_ = g_strdup ("Host is unreachable.");
				_g_free0 (_error_);
				_error_ = _tmp20_;
			} else {
				const gchar* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				_tmp21_ = line;
				_tmp22_ = string_contains (_tmp21_, " !N ");
				if (_tmp22_) {
					gchar* _tmp23_ = NULL;
					_tmp23_ = g_strdup ("Network is unreachable.");
					_g_free0 (_error_);
					_error_ = _tmp23_;
				} else {
					const gchar* _tmp24_ = NULL;
					gboolean _tmp25_ = FALSE;
					_tmp24_ = line;
					_tmp25_ = string_contains (_tmp24_, " !P ");
					if (_tmp25_) {
						gchar* _tmp26_ = NULL;
						_tmp26_ = g_strdup ("Protocol is unreachable.");
						_g_free0 (_error_);
						_error_ = _tmp26_;
					} else {
						const gchar* _tmp27_ = NULL;
						gboolean _tmp28_ = FALSE;
						_tmp27_ = line;
						_tmp28_ = string_contains (_tmp27_, " !S ");
						if (_tmp28_) {
							gchar* _tmp29_ = NULL;
							_tmp29_ = g_strdup ("Source route failed.");
							_g_free0 (_error_);
							_error_ = _tmp29_;
						} else {
							const gchar* _tmp30_ = NULL;
							gboolean _tmp31_ = FALSE;
							_tmp30_ = line;
							_tmp31_ = string_contains (_tmp30_, " !F ");
							if (_tmp31_) {
								gchar* _tmp32_ = NULL;
								_tmp32_ = g_strdup ("Fragmentation needed.");
								_g_free0 (_error_);
								_error_ = _tmp32_;
							} else {
								const gchar* _tmp33_ = NULL;
								gboolean _tmp34_ = FALSE;
								_tmp33_ = line;
								_tmp34_ = string_contains (_tmp33_, " !X ");
								if (_tmp34_) {
									gchar* _tmp35_ = NULL;
									_tmp35_ = g_strdup ("Network blocks traceroute.");
									_g_free0 (_error_);
									_error_ = _tmp35_;
								}
							}
						}
					}
				}
			}
			_tmp36_ = _error_;
			if (_tmp36_ != NULL) {
				const gchar* _tmp37_ = NULL;
				_tmp37_ = _error_;
				rygel_basic_management_test_traceroute_set_error (self, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_OTHER, _tmp37_);
				_g_free0 (_error_);
				return;
			}
			_tmp38_ = self->priv->regex;
			_tmp39_ = line;
			_tmp41_ = g_regex_match (_tmp38_, _tmp39_, 0, &_tmp40_);
			_g_match_info_unref0 (info);
			info = _tmp40_;
			if (!_tmp41_) {
				const gchar* _tmp42_ = NULL;
				_tmp42_ = line;
				g_debug ("rygel-basic-management-test-traceroute.vala:280: traceroute parser: Un" \
"expected line '%s'", _tmp42_);
				_g_match_info_unref0 (info);
				_g_free0 (_error_);
				return;
			}
			_tmp43_ = info;
			_tmp44_ = g_match_info_fetch (_tmp43_, 2);
			ip_address = _tmp44_;
			_tmp45_ = self->priv->error_set;
			if (!_tmp45_) {
				const gchar* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				_tmp46_ = ip_address;
				_tmp47_ = self->priv->host_ip;
				if (g_strcmp0 (_tmp46_, _tmp47_) == 0) {
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_SUCCESS;
				} else {
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_STATUS_ERROR_MAX_HOP_COUNT_EXCEEDED;
				}
			}
			_tmp48_ = ip_address;
			if (g_strcmp0 (_tmp48_, "*") == 0) {
				gchar* _tmp49_ = NULL;
				_tmp49_ = g_strdup ("");
				_g_free0 (ip_address);
				ip_address = _tmp49_;
			}
			_tmp50_ = info;
			_tmp51_ = g_match_info_fetch (_tmp50_, 3);
			rtt_string = _tmp51_;
			_tmp52_ = self->priv->rtt_regex;
			_tmp53_ = rtt_string;
			g_regex_match (_tmp52_, _tmp53_, 0, &_tmp54_);
			_g_match_info_unref0 (info);
			info = _tmp54_;
			rtt_count = 0;
			rtt_average = 0.0;
			{
				while (TRUE) {
					GMatchInfo* _tmp55_ = NULL;
					gboolean _tmp56_ = FALSE;
					gint _tmp57_ = 0;
					gdouble _tmp58_ = 0.0;
					GMatchInfo* _tmp59_ = NULL;
					gchar* _tmp60_ = NULL;
					gchar* _tmp61_ = NULL;
					gdouble _tmp62_ = 0.0;
					GMatchInfo* _tmp63_ = NULL;
					_tmp55_ = info;
					_tmp56_ = g_match_info_matches (_tmp55_);
					if (!_tmp56_) {
						break;
					}
					_tmp57_ = rtt_count;
					rtt_count = _tmp57_ + 1;
					_tmp58_ = rtt_average;
					_tmp59_ = info;
					_tmp60_ = g_match_info_fetch (_tmp59_, 1);
					_tmp61_ = _tmp60_;
					_tmp62_ = double_parse (_tmp61_);
					rtt_average = _tmp58_ + _tmp62_;
					_g_free0 (_tmp61_);
					_tmp63_ = info;
					g_match_info_next (_tmp63_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch4_g_regex_error;
						}
						_g_free0 (rtt_string);
						_g_free0 (ip_address);
						_g_match_info_unref0 (info);
						_g_free0 (_error_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			goto __finally4;
			__catch4_g_regex_error:
			{
				GError* e = NULL;
				const gchar* _tmp64_ = NULL;
				GError* _tmp65_ = NULL;
				const gchar* _tmp66_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp64_ = rtt_string;
				_tmp65_ = e;
				_tmp66_ = _tmp65_->message;
				g_debug ("rygel-basic-management-test-traceroute.vala:311: Failed to parse round" \
" trip time values '%s': %s", _tmp64_, _tmp66_);
				_g_error_free0 (e);
			}
			__finally4:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (rtt_string);
				_g_free0 (ip_address);
				_g_match_info_unref0 (info);
				_g_free0 (_error_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp67_ = rtt_count;
			if (_tmp67_ > 0) {
				gdouble _tmp68_ = 0.0;
				gint _tmp69_ = 0;
				_tmp68_ = rtt_average;
				_tmp69_ = rtt_count;
				rtt_average = _tmp68_ / _tmp69_;
			}
			_tmp70_ = rtt_average;
			_tmp71_ = round (_tmp70_);
			self->priv->response_time = (guint32) ((guint) _tmp71_);
			_tmp72_ = self->priv->hop_ips;
			_tmp73_ = strlen (_tmp72_);
			_tmp74_ = _tmp73_;
			if (_tmp74_ != 0) {
				const gchar* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				_tmp75_ = self->priv->hop_ips;
				_tmp76_ = g_strconcat (_tmp75_, ",", NULL);
				_g_free0 (self->priv->hop_ips);
				self->priv->hop_ips = _tmp76_;
			}
			_tmp77_ = self->priv->hop_ips;
			_tmp78_ = ip_address;
			_tmp79_ = g_strconcat (_tmp77_, _tmp78_, NULL);
			_g_free0 (self->priv->hop_ips);
			self->priv->hop_ips = _tmp79_;
			_g_free0 (rtt_string);
			_g_free0 (ip_address);
			_g_match_info_unref0 (info);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_g_free0 (_error_);
}


void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self, gchar** status, gchar** additional_info, guint32* response_time, gchar** hop_ips) {
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint32 _vala_response_time = 0U;
	gchar* _vala_hop_ips = NULL;
	RygelBasicManagementTestTracerouteStatus _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->status;
	_tmp1_ = rygel_basic_management_test_traceroute_status_to_string (_tmp0_);
	_g_free0 (_vala_status);
	_vala_status = _tmp1_;
	_tmp2_ = self->priv->additional_info;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_vala_additional_info);
	_vala_additional_info = _tmp3_;
	_tmp4_ = self->priv->response_time;
	_vala_response_time = _tmp4_;
	_tmp5_ = self->priv->hop_ips;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_vala_hop_ips);
	_vala_hop_ips = _tmp6_;
	if (status) {
		*status = _vala_status;
	} else {
		_g_free0 (_vala_status);
	}
	if (additional_info) {
		*additional_info = _vala_additional_info;
	} else {
		_g_free0 (_vala_additional_info);
	}
	if (response_time) {
		*response_time = _vala_response_time;
	}
	if (hop_ips) {
		*hop_ips = _vala_hop_ips;
	} else {
		_g_free0 (_vala_hop_ips);
	}
}


const gchar* rygel_basic_management_test_traceroute_get_host (RygelBasicManagementTestTraceroute* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_traceroute_set_host (RygelBasicManagementTestTraceroute* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_host);
	self->priv->_host = _tmp1_;
	g_object_notify ((GObject *) self, "host");
}


guint32 rygel_basic_management_test_traceroute_get_wait_time_out (RygelBasicManagementTestTraceroute* self) {
	guint32 result;
	guint32 _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_wait_time_out;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_traceroute_set_wait_time_out (RygelBasicManagementTestTraceroute* self, guint32 value) {
	guint32 _tmp0_ = 0U;
	guint32 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_wait_time_out = _tmp0_;
	_tmp1_ = self->priv->_wait_time_out;
	if (_tmp1_ == ((guint32) 0)) {
		self->priv->_wait_time_out = (guint32) RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT;
	}
	g_object_notify ((GObject *) self, "wait-time-out");
}


guint rygel_basic_management_test_traceroute_get_data_block_size (RygelBasicManagementTestTraceroute* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_data_block_size;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_traceroute_set_data_block_size (RygelBasicManagementTestTraceroute* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_data_block_size = _tmp0_;
	_tmp1_ = self->priv->_data_block_size;
	if (_tmp1_ == ((guint) 0)) {
		self->priv->_data_block_size = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE;
	}
	g_object_notify ((GObject *) self, "data-block-size");
}


guint rygel_basic_management_test_traceroute_get_max_hop_count (RygelBasicManagementTestTraceroute* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_max_hop_count;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_traceroute_set_max_hop_count (RygelBasicManagementTestTraceroute* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_max_hop_count = _tmp0_;
	_tmp1_ = self->priv->_max_hop_count;
	if (_tmp1_ == ((guint) 0)) {
		self->priv->_max_hop_count = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS;
	}
	g_object_notify ((GObject *) self, "max-hop-count");
}


guint rygel_basic_management_test_traceroute_get_dscp (RygelBasicManagementTestTraceroute* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_dscp;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_traceroute_set_dscp (RygelBasicManagementTestTraceroute* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_dscp = _tmp0_;
	_tmp1_ = self->priv->_dscp;
	if (_tmp1_ == ((guint) 0)) {
		self->priv->_dscp = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP;
	}
	g_object_notify ((GObject *) self, "dscp");
}


static const gchar* rygel_basic_management_test_traceroute_real_get_method_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestTraceroute* self;
	self = (RygelBasicManagementTestTraceroute*) base;
	result = "Traceroute";
	return result;
}


static const gchar* rygel_basic_management_test_traceroute_real_get_results_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestTraceroute* self;
	self = (RygelBasicManagementTestTraceroute*) base;
	result = "GetTracerouteResult";
	return result;
}


static void rygel_basic_management_test_traceroute_class_init (RygelBasicManagementTestTracerouteClass * klass) {
	rygel_basic_management_test_traceroute_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelBasicManagementTestTraceroutePrivate));
	((GObjectClass *) klass)->constructed = rygel_basic_management_test_traceroute_real_constructed;
	((RygelBasicManagementTestClass *) klass)->handle_error = rygel_basic_management_test_traceroute_real_handle_error;
	((RygelBasicManagementTestClass *) klass)->handle_output = rygel_basic_management_test_traceroute_real_handle_output;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = rygel_basic_management_test_traceroute_real_get_method_type;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = rygel_basic_management_test_traceroute_real_get_results_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_traceroute_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_traceroute_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_traceroute_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST, g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT, g_param_spec_uint ("wait-time-out", "wait-time-out", "wait-time-out", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_TIMEOUT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE, g_param_spec_uint ("data-block-size", "data-block-size", "data-block-size", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DATA_BLOCK_SIZE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT, g_param_spec_uint ("max-hop-count", "max-hop-count", "max-hop-count", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_HOPS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP, g_param_spec_uint ("dscp", "dscp", "dscp", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DEFAULT_DSCP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE, g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE, g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_basic_management_test_traceroute_instance_init (RygelBasicManagementTestTraceroute * self) {
	gchar* _tmp0_ = NULL;
	self->priv = RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_host = _tmp0_;
}


static void rygel_basic_management_test_traceroute_finalize (GObject* obj) {
	RygelBasicManagementTestTraceroute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
	_g_free0 (self->priv->_host);
	_g_regex_unref0 (self->priv->regex);
	_g_regex_unref0 (self->priv->rtt_regex);
	_g_free0 (self->priv->host_ip);
	_g_free0 (self->priv->additional_info);
	_g_free0 (self->priv->hop_ips);
	G_OBJECT_CLASS (rygel_basic_management_test_traceroute_parent_class)->finalize (obj);
}


GType rygel_basic_management_test_traceroute_get_type (void) {
	static volatile gsize rygel_basic_management_test_traceroute_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_traceroute_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestTracerouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_traceroute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestTraceroute), 0, (GInstanceInitFunc) rygel_basic_management_test_traceroute_instance_init, NULL };
		GType rygel_basic_management_test_traceroute_type_id;
		rygel_basic_management_test_traceroute_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestTraceroute", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_test_traceroute_type_id__volatile, rygel_basic_management_test_traceroute_type_id);
	}
	return rygel_basic_management_test_traceroute_type_id__volatile;
}


static void _vala_rygel_basic_management_test_traceroute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestTraceroute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST:
		g_value_set_string (value, rygel_basic_management_test_traceroute_get_host (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT:
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_wait_time_out (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE:
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_data_block_size (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT:
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_max_hop_count (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP:
		g_value_set_uint (value, rygel_basic_management_test_traceroute_get_dscp (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_METHOD_TYPE:
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_RESULTS_TYPE:
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_basic_management_test_traceroute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestTraceroute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_HOST:
		rygel_basic_management_test_traceroute_set_host (self, g_value_get_string (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_WAIT_TIME_OUT:
		rygel_basic_management_test_traceroute_set_wait_time_out (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DATA_BLOCK_SIZE:
		rygel_basic_management_test_traceroute_set_data_block_size (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_MAX_HOP_COUNT:
		rygel_basic_management_test_traceroute_set_max_hop_count (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_DSCP:
		rygel_basic_management_test_traceroute_set_dscp (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



