/* rygel-main.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-main.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <locale.h>
#include <unistd.h>


#define RYGEL_TYPE_MAIN (rygel_main_get_type ())
#define RYGEL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MAIN, RygelMain))
#define RYGEL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MAIN, RygelMainClass))
#define RYGEL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MAIN))
#define RYGEL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MAIN))
#define RYGEL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MAIN, RygelMainClass))

typedef struct _RygelMain RygelMain;
typedef struct _RygelMainClass RygelMainClass;
typedef struct _RygelMainPrivate RygelMainPrivate;

#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_HANDLER (rygel_log_handler_get_type ())
#define RYGEL_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandler))
#define RYGEL_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))
#define RYGEL_IS_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_IS_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_LOG_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))

typedef struct _RygelLogHandler RygelLogHandler;
typedef struct _RygelLogHandlerClass RygelLogHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelMainCreateDeviceData RygelMainCreateDeviceData;

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;

struct _RygelMain {
	GObject parent_instance;
	RygelMainPrivate * priv;
	gboolean need_restart;
};

struct _RygelMainClass {
	GObjectClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	GMainLoop* main_loop;
	gint exit_code;
};

struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelMainCreateDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMain* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDevice* _tmp0_;
	RygelRootDevice* device;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError * _error_;
	const gchar* _tmp5_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()

static gpointer rygel_main_parent_class = NULL;
static gint rygel_main_PLUGIN_TIMEOUT;
static gint rygel_main_PLUGIN_TIMEOUT = 5;

GType rygel_main_get_type (void) G_GNUC_CONST;
GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_log_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MAIN, RygelMainPrivate))
enum  {
	RYGEL_MAIN_DUMMY_PROPERTY
};
static RygelMain* rygel_main_new (GError** error);
static RygelMain* rygel_main_construct (GType object_type, GError** error);
RygelLogHandler* rygel_log_handler_get_default (void);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin);
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
void rygel_signal_handler_setup (RygelMain* _main);
void rygel_main_exit (RygelMain* self, gint exit_code);
void rygel_signal_handler_cleanup (void);
void rygel_main_restart (RygelMain* self);
static gint rygel_main_run (RygelMain* self);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
static gboolean _lambda13_ (RygelMain* self);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static gboolean __lambda13__gsource_func (gpointer self);
static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_);
gint rygel_configuration_get_port (RygelConfiguration* self, GError** error);
static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
gchar* rygel_configuration_get_interface (RygelConfiguration* self, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
static void rygel_main_create_device_data_free (gpointer _data);
static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* data);
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
gboolean rygel_plugin_get_active (RygelPlugin* self);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec);
static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
static gint rygel_main_main (gchar** args, int args_length1);
GType rygel_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static gchar** _vala_array_dup1 (gchar** self, int length);
GQuark rygel_cmdline_config_error_quark (void);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
RygelDBusService* rygel_dbus_service_new (RygelMain* main, GError** error);
RygelDBusService* rygel_dbus_service_construct (GType object_type, RygelMain* main, GError** error);
void rygel_dbus_service_unpublish (RygelDBusService* self);
static void rygel_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
	rygel_main_on_plugin_loaded (self, _sender, plugin);
}


static RygelMain* rygel_main_construct (GType object_type, GError** error) {
	RygelMain * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelLogHandler* _tmp1_ = NULL;
	RygelMetaConfig* _tmp2_ = NULL;
	RygelPluginLoader* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GUPnPContextManager* _tmp6_ = NULL;
	GMainLoop* _tmp7_ = NULL;
	self = (RygelMain*) g_object_new (object_type, NULL);
	_tmp0_ = _ (PACKAGE_NAME);
	g_set_application_name (_tmp0_);
	_tmp1_ = rygel_log_handler_get_default ();
	_g_object_unref0 (self->priv->log_handler);
	self->priv->log_handler = _tmp1_;
	_tmp2_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp2_;
	_tmp3_ = rygel_plugin_loader_new ();
	_g_object_unref0 (self->priv->plugin_loader);
	self->priv->plugin_loader = _tmp3_;
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = _tmp4_;
	_tmp5_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) rygel_root_device_factory_ref, rygel_root_device_factory_unref, NULL);
	_g_object_unref0 (self->priv->factories);
	self->priv->factories = _tmp5_;
	_tmp6_ = rygel_main_create_context_manager (self);
	_g_object_unref0 (self->priv->context_manager);
	self->priv->context_manager = _tmp6_;
	_tmp7_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp7_;
	self->priv->exit_code = 0;
	g_signal_connect_object (self->priv->plugin_loader, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
	rygel_signal_handler_setup (self);
	return self;
}


static RygelMain* rygel_main_new (GError** error) {
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
}


void rygel_main_exit (RygelMain* self, gint exit_code) {
	g_return_if_fail (self != NULL);
	self->priv->exit_code = exit_code;
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = NULL;
	g_main_loop_quit (self->priv->main_loop);
	rygel_signal_handler_cleanup ();
}


void rygel_main_restart (RygelMain* self) {
	g_return_if_fail (self != NULL);
	self->need_restart = TRUE;
	rygel_main_exit (self, 0);
}


static gboolean _lambda13_ (RygelMain* self) {
	gboolean result = FALSE;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = rygel_plugin_loader_list_plugins (self->priv->plugin_loader);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_collection_get_size (_tmp1_);
	_tmp3_ = _tmp2_ == 0;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = ngettext ("No plugins found in %d second; giving up..", "No plugins found in %d seconds; giving up..", (gulong) rygel_main_PLUGIN_TIMEOUT);
		g_warning (_tmp4_, rygel_main_PLUGIN_TIMEOUT);
		rygel_main_exit (self, -82);
	}
	result = FALSE;
	return result;
}


static gboolean __lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda13_ (self);
	return result;
}


static gint rygel_main_run (RygelMain* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	rygel_plugin_loader_load_plugins (self->priv->plugin_loader);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) rygel_main_PLUGIN_TIMEOUT, __lambda13__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->main_loop);
	result = self->priv->exit_code;
	return result;
}


static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin) {
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* iterator;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_loader != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->factories);
	iterator = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		gpointer _tmp2_ = NULL;
		RygelRootDeviceFactory* _tmp3_;
		_tmp1_ = gee_iterator_next (iterator);
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = gee_iterator_get (iterator);
		_tmp3_ = (RygelRootDeviceFactory*) _tmp2_;
		rygel_main_create_device (self, plugin, _tmp3_, NULL, NULL);
		_rygel_root_device_factory_unref0 (_tmp3_);
	}
	_g_object_unref0 (iterator);
}


static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
	rygel_main_on_context_available (self, _sender, p0);
}


static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
	rygel_main_on_context_unavailable (self, _sender, p0);
}


static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self) {
	GUPnPContextManager* result = NULL;
	gint port;
	gint _tmp0_;
	gint _tmp1_;
	GUPnPContextManager* _tmp2_ = NULL;
	GUPnPContextManager* manager;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	port = 0;
	_tmp0_ = rygel_configuration_get_port (self->priv->config, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch66_g_error;
	}
	port = _tmp1_;
	goto __finally66;
	__catch66_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally66:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = gupnp_context_manager_new (NULL, (guint) port);
	manager = _tmp2_;
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_main_on_context_available_gupnp_context_manager_context_available, self, 0);
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
	result = manager;
	return result;
}


static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	gchar* iface;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	iface = NULL;
	_tmp0_ = gssdp_client_get_network ((GSSDPClient*) context);
	_tmp1_ = gssdp_client_get_interface ((GSSDPClient*) context);
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) context);
	g_debug ("rygel-main.vala:124: New network %s (%s) context available. IP: %s", _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = rygel_configuration_get_interface (self->priv->config, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		goto __catch67_g_error;
	}
	_g_free0 (iface);
	iface = _tmp4_;
	goto __finally67;
	__catch67_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally67:
	if (_inner_error_ != NULL) {
		_g_free0 (iface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (iface == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = gssdp_client_get_interface ((GSSDPClient*) context);
		_tmp6_ = g_strcmp0 (iface, _tmp7_) == 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = gssdp_client_get_network ((GSSDPClient*) context);
		_tmp5_ = g_strcmp0 (iface, _tmp8_) == 0;
	}
	if (_tmp5_) {
		RygelRootDeviceFactory* _tmp9_ = NULL;
		RygelRootDeviceFactory* factory;
		GeeCollection* _tmp10_ = NULL;
		GeeCollection* _tmp11_;
		GeeIterator* _tmp12_ = NULL;
		GeeIterator* _tmp13_;
		GeeIterator* iterator;
		_tmp9_ = rygel_root_device_factory_new (context, &_inner_error_);
		factory = _tmp9_;
		if (_inner_error_ != NULL) {
			goto __catch68_g_error;
		}
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->factories, factory);
		_tmp10_ = rygel_plugin_loader_list_plugins (self->priv->plugin_loader);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		iterator = _tmp13_;
		while (TRUE) {
			gboolean _tmp14_;
			gpointer _tmp15_ = NULL;
			RygelPlugin* _tmp16_;
			_tmp14_ = gee_iterator_next (iterator);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = gee_iterator_get (iterator);
			_tmp16_ = (RygelPlugin*) _tmp15_;
			rygel_main_create_device (self, _tmp16_, factory, NULL, NULL);
			_g_object_unref0 (_tmp16_);
		}
		_g_object_unref0 (iterator);
		_rygel_root_device_factory_unref0 (factory);
		goto __finally68;
		__catch68_g_error:
		{
			GError * err;
			const gchar* _tmp17_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = _ ("Failed to create root device factory: %s");
			g_warning (_tmp17_, err->message);
			_g_error_free0 (err);
		}
		__finally68:
		if (_inner_error_ != NULL) {
			_g_free0 (iface);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp18_ = gssdp_client_get_network ((GSSDPClient*) context);
		_tmp19_ = gssdp_client_get_interface ((GSSDPClient*) context);
		g_debug ("rygel-main.vala:149: Ignoring network %s (%s) context.", _tmp18_, _tmp19_);
	}
	_g_free0 (iface);
}


static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GeeIterator* _tmp3_ = NULL;
	GeeIterator* factory_iter;
	GeeIterator* _tmp8_ = NULL;
	GeeIterator* device_iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = gssdp_client_get_network ((GSSDPClient*) context);
	_tmp1_ = gssdp_client_get_interface ((GSSDPClient*) context);
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) context);
	g_debug ("rygel-main.vala:157: Network %s (%s) context now unavailable. IP: %s", _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->factories);
	factory_iter = _tmp3_;
	while (TRUE) {
		gboolean _tmp4_;
		gpointer _tmp5_ = NULL;
		RygelRootDeviceFactory* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = gee_iterator_next (factory_iter);
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = gee_iterator_get (factory_iter);
		_tmp6_ = (RygelRootDeviceFactory*) _tmp5_;
		_tmp7_ = context == _tmp6_->context;
		_rygel_root_device_factory_unref0 (_tmp6_);
		if (_tmp7_) {
			gee_iterator_remove (factory_iter);
		}
	}
	_tmp8_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->root_devices);
	device_iter = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_;
		gpointer _tmp10_ = NULL;
		RygelRootDevice* _tmp11_;
		GUPnPContext* _tmp12_ = NULL;
		gboolean _tmp13_;
		_tmp9_ = gee_iterator_next (device_iter);
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = gee_iterator_get (device_iter);
		_tmp11_ = (RygelRootDevice*) _tmp10_;
		_tmp12_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp11_);
		_tmp13_ = context == _tmp12_;
		_g_object_unref0 (_tmp11_);
		if (_tmp13_) {
			gee_iterator_remove (device_iter);
		}
	}
	_g_object_unref0 (device_iter);
	_g_object_unref0 (factory_iter);
}


static void rygel_main_create_device_data_free (gpointer _data) {
	RygelMainCreateDeviceData* data;
	data = _data;
	_g_object_unref0 (data->plugin);
	_rygel_root_device_factory_unref0 (data->factory);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMainCreateDeviceData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_root_device_factory_ref0 (gpointer self) {
	return self ? rygel_root_device_factory_ref (self) : NULL;
}


static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMainCreateDeviceData* _data_;
	_data_ = g_slice_new0 (RygelMainCreateDeviceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_main_create_device);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_main_create_device_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->plugin = _g_object_ref0 (plugin);
	_data_->factory = _rygel_root_device_factory_ref0 (factory);
	rygel_main_create_device_co (_data_);
}


static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_) {
	RygelMainCreateDeviceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _rygel_main_create_device_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_main_create_device_co (self);
	return result;
}


static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_main_on_plugin_active_notify (self, _sender, pspec);
}


static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_main_create_device_co_gsource_func, data, NULL);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_root_device_factory_create (data->factory, data->plugin, &data->_inner_error_);
	data->device = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch69_g_error;
	}
	data->_tmp2_ = rygel_plugin_get_active (data->plugin);
	if (data->_tmp2_) {
		data->_tmp3_ = rygel_configuration_get_upnp_enabled (data->self->priv->config, &data->_inner_error_);
		data->_tmp4_ = data->_tmp3_;
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->device);
			goto __catch69_g_error;
		}
		data->_tmp1_ = data->_tmp4_;
	} else {
		data->_tmp1_ = FALSE;
	}
	gupnp_root_device_set_available ((GUPnPRootDevice*) data->device, data->_tmp1_);
	if (data->self->priv->root_devices != NULL) {
		gee_abstract_collection_add ((GeeAbstractCollection*) data->self->priv->root_devices, data->device);
		g_signal_connect_object ((GObject*) data->plugin, "notify::active", (GCallback) _rygel_main_on_plugin_active_notify_g_object_notify, data->self, 0);
	}
	_g_object_unref0 (data->device);
	goto __finally69;
	__catch69_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp5_ = NULL;
		data->_tmp5_ = _ ("Failed to create RootDevice for %s. Reason: %s");
		g_warning (data->_tmp5_, data->plugin->name, data->_error_->message);
		_g_error_free0 (data->_error_);
	}
	__finally69:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec) {
	GObject* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelPlugin* plugin;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (RYGEL_IS_PLUGIN (_tmp0_) ? ((RygelPlugin*) _tmp0_) : NULL);
	plugin = _tmp1_;
	{
		GeeArrayList* _tmp2_;
		GeeArrayList* _device_list;
		gint _tmp3_;
		gint _device_size;
		gint _device_index;
		_tmp2_ = _g_object_ref0 (self->priv->root_devices);
		_device_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _device_list);
		_device_size = _tmp3_;
		_device_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			RygelRootDevice* device;
			GUPnPResourceFactory* _tmp5_ = NULL;
			_device_index = _device_index + 1;
			if (!(_device_index < _device_size)) {
				break;
			}
			_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _device_list, _device_index);
			device = (RygelRootDevice*) _tmp4_;
			_tmp5_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) device);
			if (_tmp5_ == GUPNP_RESOURCE_FACTORY (plugin)) {
				gboolean _tmp6_;
				_tmp6_ = rygel_plugin_get_active (plugin);
				gupnp_root_device_set_available ((GUPnPRootDevice*) device, _tmp6_);
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_list);
	}
	_g_object_unref0 (plugin);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gint rygel_main_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelMain* main;
	RygelDBusService* service;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** original_args;
	gint original_args_length1;
	gint _original_args_size_;
	RygelMain* _tmp2_ = NULL;
	RygelMain* _tmp3_;
	RygelDBusService* _tmp4_ = NULL;
	RygelDBusService* _tmp5_;
	gint _tmp7_;
	gint exit_code;
	GError * _inner_error_ = NULL;
	main = NULL;
	service = NULL;
	_tmp0_ = (_tmp1_ = args, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, args_length1));
	original_args = _tmp0_;
	original_args_length1 = args_length1;
	_original_args_size_ = args_length1;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	rygel_cmdline_config_parse_args (&args, &args_length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch70_g_io_error;
		}
		if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
			goto __catch70_rygel_cmdline_config_error_version_only;
		}
		goto __catch70_g_error;
	}
	_tmp2_ = rygel_main_new (&_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch70_g_io_error;
		}
		if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
			goto __catch70_rygel_cmdline_config_error_version_only;
		}
		goto __catch70_g_error;
	}
	_g_object_unref0 (main);
	main = _tmp3_;
	_tmp4_ = rygel_dbus_service_new (main, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch70_g_io_error;
		}
		if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
			goto __catch70_rygel_cmdline_config_error_version_only;
		}
		goto __catch70_g_error;
	}
	_g_object_unref0 (service);
	service = _tmp5_;
	goto __finally70;
	__catch70_g_io_error:
	{
		GError * err;
		const gchar* _tmp6_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _ ("Failed to start D-Bus service: %s");
		g_warning (_tmp6_, err->message);
		_g_error_free0 (err);
	}
	goto __finally70;
	__catch70_rygel_cmdline_config_error_version_only:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		result = 0;
		_g_error_free0 (err);
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (service);
		_g_object_unref0 (main);
		return result;
	}
	goto __finally70;
	__catch70_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_error ("rygel-main.vala:243: %s", err->message);
		_g_error_free0 (err);
	}
	__finally70:
	if (_inner_error_ != NULL) {
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (service);
		_g_object_unref0 (main);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp7_ = rygel_main_run (main);
	exit_code = _tmp7_;
	if (service != NULL) {
		rygel_dbus_service_unpublish (service);
	}
	if (main->need_restart) {
		execvp (original_args[0], original_args);
	}
	result = exit_code;
	original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (service);
	_g_object_unref0 (main);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return rygel_main_main (argv, argc);
}


static void rygel_main_class_init (RygelMainClass * klass) {
	rygel_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMainPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
}


static void rygel_main_instance_init (RygelMain * self) {
	self->priv = RYGEL_MAIN_GET_PRIVATE (self);
}


static void rygel_main_finalize (GObject* obj) {
	RygelMain * self;
	self = RYGEL_MAIN (obj);
	_g_object_unref0 (self->priv->plugin_loader);
	_g_object_unref0 (self->priv->context_manager);
	_g_object_unref0 (self->priv->factories);
	_g_object_unref0 (self->priv->root_devices);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->log_handler);
	_g_main_loop_unref0 (self->priv->main_loop);
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
}


GType rygel_main_get_type (void) {
	static volatile gsize rygel_main_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		GType rygel_main_type_id;
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
		g_once_init_leave (&rygel_main_type_id__volatile, rygel_main_type_id);
	}
	return rygel_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



