#!/bin/sh
#    Copyright (c) 2005-2007 Romain BONDUE
#    This file is part of RutilT.
#
#    RutilT is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    RutilT is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with RutilT; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#
# This script is called by RutilT with 2 arguments : the device name, and
# the network ESSID.
#
# WARNING : This script is executed with root privileges, so beware.
#
case $2 in
# RutilT doesn't support static IPs currently, until it does, if ever, you can
# customize this script to do the job, don't forget to set the IP setting to
# "Automatic" in the matching profile.
# Here is an example on how you could set a static IP for networks "foo" and/or
# "bar".  The two ";;" at the end of the line are required.
# The "#" at the beginning of the line means comment, so you definetely don't
# want to put one on yours.
#    'foo') /sbin/ifconfig $1 192.168.1.2;;
#    'bar') /sbin/ifconfig $1 192.168.1.3;;
# Note that setting the address is usually not enough, the gateway, netmask
# and dns server address should typically be set too. Have a look at "ifconfig"
# man page and your distribution documentation.
#
# WARNING : Always put your static settings above this line.
# No known essid, fallback on DHCP  but first kill any previously running
# dhcp client :
    *) if [ -e /sbin/dhclient ]; then
           kill `ps -o pid= -C"dhclient $1"`
           exec /sbin/dhclient $1
       else
           kill `ps -o pid= -C"dhcpd $1"`
           exec /sbin/dhcpd $1
       fi;;
esac
