/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CLinkStatusTab.hxx
    \author Romain BONDUE
    \date 29/07/2005
    \warning This file should only be included from CLinkStatusTab.h */
inline nsGUI::CLinkStatusTab::operator ::GtkWidget* () throw()
{
    return m_pAlignment;

} // operator ::GtkWidget*()


inline nsGUI::CLinkStatusTab::operator const ::GtkWidget* () const throw()
{
    return m_pAlignment;

} // operator ::GtkWidget*()


inline double nsGUI::CLinkStatusTab::dBmToPercent (short dBm) throw()
{
    return dBm / 256.0 + 1;

} // dBmToPercent()


inline void nsGUI::CLinkStatusTab::SetLinkQuality (unsigned short Quality)
                                                                        throw()
{
    SetBar (m_pLinkQualityBar, Quality / 100.0, Quality, " %");

} // SetLinkQuality()


inline void nsGUI::CLinkStatusTab::SetSignalLevel (short Level) throw()
{
    SetBar (m_pSignalLevelBar, dBmToPercent (Level), Level, " dBm");

} // SetSignalLevel()


inline void nsGUI::CLinkStatusTab::SetNoiseLevel (short Level) throw()
{
    SetBar (m_pNoiseLevelBar, dBmToPercent (Level), Level, " dBm");

} // SetSignalLevel()


inline void nsGUI::CLinkStatusTab::SetStatus (std::string SSID,
                                       const std::string& Addr) throw()
{
    SSID += " <---> ";
    SSID += Addr;
    ::gtk_label_set_text (m_pStatusLabel, SSID.c_str());

} // SetStatus()


inline void nsGUI::CLinkStatusTab::SetMode (const std::string& Mode) throw()
{
    ::gtk_label_set_text (m_pModeLabel, Mode.c_str());

} // SetMode()


inline void nsGUI::CLinkStatusTab::SetAddr (const std::string& Addr) throw()
{
    ::gtk_label_set_text (m_pAddrLabel, Addr.c_str());

} // SetAddr()
