/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RutilT.cxx
    \author Romain BONDUE
    \date 05/07/2005 */
#include <iostream>
#include <exception>

extern "C"{
#include <gtk/gtk.h>
}

#include "Exceptions.h"
#include "ErrorsCode.h"
#include "GtkGUI.h"



int main (int argc, char* argv [])
{
    ::gtk_init (&argc, &argv);
    try
    {
        nsGUI::CGtkGUI UI;
        UI.Run();
    }
    catch (const nsErrors::CException& Exc) // Handle CSystemExc too.
    {
        std::cerr << Exc.GetMsg() << "\nCode : " << Exc.GetCode() << std::endl;
        return Exc.GetCode();
    }
    catch (const std::exception& Exc)
    {
        std::cerr << "Exception : " << Exc.what() << std::endl;
        return nsErrors::UnknownExc;
    }
    catch (...)
    {
        std::cerr << "Unknown execption." << std::endl;
        return nsErrors::UnknownExc;
    }

    return 0;

} // main()
