/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file MsgHandlerFactory.cxx
    \author Romain BONDUE
    \date 17/02/2006 */
#include "MsgHandlerFactory.h"
#include "CWirelessMsgHandler.h"
#include "SuWProtocolCodes.h"
#include "RTSuWProtocolCodes.h"
#include "RTWMsgHandlers.h"
#include "IfaceProtocolCodes.h"
#include "IfaceMsgHandler.h"
#include "ErrorsCode.h"



nsRoot::IMsgHandler* nsRoot::MakeHandler (const std::string& HandlerName)
                                throw (nsErrors::CException, std::bad_alloc)
{
    if (HandlerName == nsWireless::WE17Handler)
        return new CWirelessMsgHandler;
    if (HandlerName == nsWireless::RT2400Handler)
        return new CRT2400MsgHandler;
    if (HandlerName == nsWireless::RT2500Handler)
        return new CRT2500MsgHandler;
    if (HandlerName == nsWireless::RT2570Handler)
        return new CRT2570MsgHandler;
    if (HandlerName == nsNet::IfaceHandler)
        return new CIfaceMsgHandler;
    throw nsErrors::CException (std::string ("Unknown handler : ") +
                                HandlerName, nsErrors::UnknownHandler);

} // MakeHandler()
