/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file Parameters.hxx
    \author Romain BONDUE
    \date 07/07/2005
    \warning This file should only be included from Parameters.h */
inline nsWireless::Mode_e nsWireless::GetMatchingMode (Mode_e Mode) throw()
{
    switch (Mode)
    {
      case Auto : return Auto; // Shouldn't happen.
      case AdHoc : return AdHoc;
      default : return Managed;
    }

} // GetMatchingMode()


inline nsWireless::CQuality::CQuality (unsigned short LinkQuality,
                                       short SignalLevel, short NoiseLevel)
                                                                        throw()
    : m_LinkQuality (LinkQuality), m_SignalLevel (SignalLevel),
      m_NoiseLevel (NoiseLevel) {}


inline unsigned short nsWireless::CQuality::GetLinkQuality () const throw()
{
    return m_LinkQuality;

} // GetLinkQuality()


inline short nsWireless::CQuality::GetSignalLevel () const throw()
{
    return m_SignalLevel;

} // GetSignalLevel()


inline short nsWireless::CQuality::GetNoiseLevel () const throw()
{
    return m_NoiseLevel;

} // GetNoiseLevel()


inline nsWireless::CDeviceInfo::CDeviceInfo (const std::string& DeviceName,
                                             const std::string& ProtoName)
                                                                        throw()
    : m_DeviceName (DeviceName), m_ProtoName (ProtoName) {}


inline const std::string& nsWireless::CDeviceInfo::GetDeviceName () const
                                                                        throw()
{
    return m_DeviceName;

} // GetDeviceName()


inline const std::string& nsWireless::CDeviceInfo::GetProtoName () const
                                                                        throw()
{
    return m_ProtoName;

} // GetProtoName()


inline nsWireless::CHexaKey::CHexaKey () throw() : m_Size (0), m_Key (0) {}
      

inline nsWireless::CHexaKey::CHexaKey (const char* Key, unsigned Size)
                                                        throw (std::bad_alloc)
    : m_Size (0), m_Key (0)
{
    Set (Key, Size);

} // CHexaKey()


inline nsWireless::CHexaKey::CHexaKey (const std::string& Str)
                                                        throw (CBadFormatExc)
    : m_Size (0), m_Key (0)
{
    Set (Str);

} // CHexaKey()


inline nsWireless::CHexaKey::CHexaKey (const CHexaKey& Key)
                                                        throw (std::bad_alloc)
    : m_Size (0), m_Key (0)
{
    operator = (Key);

} // CHexaKey()


inline nsWireless::CHexaKey::~CHexaKey () throw() {delete[] m_Key;}


inline bool nsWireless::CHexaKey::Empty () const throw()
{
    return !m_Size && m_StrKey.empty();

} // Empty()


inline unsigned nsWireless::CHexaKey::Size () const throw()
{       // 1 hexadecimal digit (1 byte) represents 4 bits (1/2 byte).
    return m_Size ? m_Size
                  : m_StrKey.size() / 2 + (m_StrKey.size() & 1 ? 1 : 0);

} // Size()


inline nsWireless::CEncryptionD::CEncryptionD (const CHexaKey& Key,
                                               AuthType_e Auth,
                                               EncryptType_e Encrypt)
                                                        throw (std::bad_alloc)
    : m_Auth (Auth), m_Encrypt (Encrypt)
{
    m_KeyTab [0] = Key;

} // CEncryptionD()


inline nsWireless::CEncryptionD::CEncryptionD (const CEncryptionD& Descriptor)
                                                        throw (std::bad_alloc)
{
    operator = (Descriptor);

} // CEncryptionD()


inline nsWireless::EncryptType_e nsWireless::CEncryptionD::GetEncrypt () const
                                                                        throw()
{
    return m_Encrypt;

} // GetEncrypt()


inline nsWireless::AuthType_e nsWireless::CEncryptionD::GetAuth () const
                                                                        throw()
{
    return m_Auth;

} // GetAuth()


inline const nsWireless::CHexaKey& nsWireless::CEncryptionD::GetKey
                                                (unsigned Pos) const throw()
{
    return m_KeyTab [Pos];

} // GetKey()


inline void nsWireless::CEncryptionD::SetEncrypt (EncryptType_e Encrypt)
                                                                        throw()
{
    m_Encrypt = Encrypt;

} // SetEncrypt()


inline void nsWireless::CEncryptionD::SetAuth (AuthType_e Auth) throw()
{
    m_Auth = Auth;

} // SetAuth()


inline void nsWireless::CEncryptionD::SetKey (const CHexaKey& Key,
                                              unsigned Pos)
                                                        throw (std::bad_alloc)
{
    m_KeyTab [Pos] = Key;

} // SetKey()


inline nsWireless::CMacAddress::CMacAddress () throw()
    : CHexaKey() {}


inline nsWireless::CMacAddress::CMacAddress (const char* Addr)
                                                        throw (std::bad_alloc)
    : CHexaKey (Addr, Size) {}


inline nsWireless::CMacAddress::CMacAddress (const std::string& Addr)
                                                        throw (CBadFormatExc)
    : CHexaKey (Addr) {Check();}


inline void nsWireless::CMacAddress::Set (const char* Addr)
                                                        throw (std::bad_alloc)
{
    Set (Addr, Size);

} // Set()


inline void nsWireless::CMacAddress::Set (const std::string& Addr)
                                                        throw (CBadFormatExc)
{
    CHexaKey::Set (Addr);
    Check();

} // Set()


inline void nsWireless::CMacAddress::Check () throw (CBadFormatExc)
{
        // One hexadecimal byte is stored with 2 caracters in a std::string.
    if (GetStr().size() < Size * 2)
    {
        Clear();
        throw CBadFormatExc();
    }

} // Check()


inline nsWireless::CCell::CCell () throw()
    : m_Mode (Unknown), m_Channel (0), m_Rate (0) {}


inline const nsWireless::CMacAddress& nsWireless::CCell::GetAPMacAddress () 
                                                                const throw()
{
    return m_APAddr;

} // GetAPMacAddress()


inline nsWireless::Mode_e nsWireless::CCell::GetMode () const throw()
{
    return m_Mode;

} // GetMode()


inline const std::string& nsWireless::CCell::GetSSID () const throw()
{
    return m_SSID;

} // GetSSID()


inline void nsWireless::CCell::SetSSID (const std::string& Str) throw()
{
    m_SSID = Str;

} // SetSSID()


inline const nsWireless::CEncryptionD& nsWireless::CCell::GetEncryptionD ()
                                                                const throw()
{
    return m_EncDescriptor;

} // GetEncryptionD()


inline nsWireless::CEncryptionD& nsWireless::CCell::GetEncryptionD () throw()
{
    return m_EncDescriptor;

} // GetEncryptionD()


inline unsigned nsWireless::CCell::GetChannel () const throw()
{
    return m_Channel;

} // GetChannel()


inline const nsWireless::CQuality& nsWireless::CCell::GetQuality () const
                                                                        throw()
{
    return m_Quality;

} // GetQuality()


inline unsigned nsWireless::CCell::GetTxRate () const throw() {return m_Rate;}


inline nsWireless::CCell::CCell (const CMacAddress& Addr) throw()
    : m_APAddr (Addr), m_Mode (Unknown), m_Channel (0), m_Rate (0) {}


inline nsWireless::CFreq::CFreq (unsigned Channel,
                                              double Frequency) throw()
    : m_Channel (Channel), m_Frequency (Frequency) {}


inline unsigned nsWireless::CFreq::GetChannel () const throw()
{
    return m_Channel;

} // GetChannel()


inline double nsWireless::CFreq::GetFrequency () const throw()
{
    return m_Frequency;

} // GetFrequency()
