/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file Su.h
    \author Romain BONDUE
    \date 29/11/2005 */
#ifndef __SU_H__
#define __SU_H__

#include <string>
#include <memory> // std::auto_ptr<>
#include <stdexcept>
#include <typeinfo>

#include "Exceptions.h"
#include "SystemTools.h"



namespace nsRoot
{
    class CMsg;


    class CSu
    {
      public :
        CSu (const std::string&) throw (nsErrors::CSystemExc);
        ~CSu () throw();
        CMsg Do (const CMsg&) throw (nsErrors::CException, std::bad_alloc);

            /* No CSu object is usable until this function has been called.
               Don't forget to monitor SIGPIPE and eventually SIGCHLD. */
        static bool Init (const std::string&) throw (nsErrors::CSystemExc,
                                                     std::bad_alloc);
        static void Close () throw();


      protected :
            // This is *not* Do().
        static int SendInternalCommand (int, const std::string&)
                                                throw (nsErrors::CSystemExc);


      private :
        static std::auto_ptr<nsSystem::CPipe> pPipe;
        static unsigned long CurrentRemoteHandlerNumber;
        static unsigned long InstanceCounter;

        void SetRemoteHandler () throw (nsErrors::CException);
        void CreateRemoteHandler (const std::string&)
                                                throw (nsErrors::CSystemExc);
        static void WriteString (const std::string&)
                                                throw (nsErrors::CSystemExc);

        const unsigned m_InstanceNumber;

    }; // CSu

} // namespace nsRoot

#include "private/Su.hxx"

#endif // __SU_H__
