#!/bin/sh

# /usr/sbin/policy-rc.d [options] <initscript ID> <actions> [<runlevel>]
# /usr/sbin/policy-rc.d [options] --list <initscript ID> [<runlevel> ...]

# runit's init script policy: don't run init scripts at all.

usage() {
  cat >&2 <<-\EOT
	usage: policy-rc.d [--quiet] <initscript ID> <actions> [<runlevel>]
	usage: policy-rc.d --list <initscript ID> [<runlevel> ...]
	
	EOT
  exit 103  # syntax error
}

quiet=0
list=0
while test $# -gt 0; do
  case "$1" in
  --*)
    case "$1" in
    --quiet) quiet=1 ;;
    --list) list=1 ;;
    *) usage
    esac
    ;;
  *)
    break
    ;;
  esac
  shift
done
test $# -ne 0 || usage

if test "$list" -eq 1; then
  cat <<-\EOT
	runit's init script policy is to not run any init scripts at all.
	
	EOT
  exit 0
fi

test "$quiet" -eq 1 || cat >&2 <<-EOT
	runit-policy-rc.d: forbid: $*
	EOT
exit 101  # forbid
