#! /usr/bin/perl -w
#
# $Id: ruli-sync-smtp.pl,v 1.2 2004/03/26 23:15:52 evertonm Exp $

use strict;
use RULI;

if ($#ARGV != 0) {
    die <<__EOF__;
usage:   $0 domain

example: $0 gnu.org
__EOF__
}

my ($domain) = @ARGV;

my $srv_list_ref = RULI::ruli_sync_smtp_query($domain, 0);
if (!defined($srv_list_ref)) {
    warn "$domain query failed\n";
    exit(1);
}

print $domain, "\n";

foreach (@$srv_list_ref) {
    my $target = $_->{target};
    my $priority = $_->{priority};
    my $weight = $_->{weight};
    my $port = $_->{port};
    my $addr_list_ref = $_->{addr_list};
    
    print "  target=$target priority=$priority weight=$weight port=$port addresses=";
    {
	$, = ",";
	print @$addr_list_ref;
    }
    print "\n";
}

