# benchmarks

Utilities for benchmarking Ruff.

## Getting Started

Run `./scripts/benchmarks/run.sh` to clone the benchmarking target (CPython).

If you're looking to benchmark Ruff against other tools, you'll also need to run `poetry install`
to create a virtual environment with the required dependencies.

## Running Benchmarks

Run `./scripts/benchmarks/run.sh` to run Ruff over the target repo (CPython). The
`./scripts/benchmarks` folder contains a few other benchmarks (e.g., `scripts/benchmarks/run_comparisons.sh`
compares Ruff to a variety of other tools).

## Generating Plots

The Vega specification for the benchmark plot depicted in the root README can be found at
`scripts/benchmarks/graph-spec.json`. You can render this JSON spec in the [Vega Editor](https://vega.github.io/editor/#/edited).

The images seen in the README are generated by exporting the rendered Vega spec as SVG (at around
688px wide) and manually bolding the Ruff title and benchmark time. The dark mode variant is
generated by changing the fill from `fill="#333333"` to `fill="#C9D1D9"`.
