require 'gst0.10'

Thread.abort_on_exception = true

Gst.init

class Thumbnailer < Gst::Pipeline
  def initialize(filename, thumbnail_filename)
    super()
    @thumbnail_filename = thumbnail_filename
    # the initial elements of the pipeline
    @source = Gst::ElementFactory.make('gnlfilesource')
    @source.location = filename
    @source.caps = Gst::Caps.from_string("video/x-raw-yuv;video/x-raw-rgb")
    add(@source)
    
    # callbacks
    @source.signal_connect("pad-added") { | source, pad |
      new_pad_cb(source, pad)
    }
    print "Initialised thumbnailer\n"

   
    
  end

  def new_pad_cb(source, pad)
    # we only care about video
    #
    caps = pad.caps
    capsstr = caps.to_string
    print "New decoded pad with caps: #{capsstr}\n" 
    if capsstr.include? "video"
      # we have video so lets connect ffmpegcolorspace and pngenc
      ffmpegcolorspace = Gst::ElementFactory.make('ffmpegcolorspace')
      pngenc = Gst::ElementFactory.make('pngenc')
      pngenc.snapshot = true
      filesink = Gst::ElementFactory.make('filesink')
      filesink.location = @thumbnail_filename
      add(ffmpegcolorspace, pngenc, filesink)
      ffmpegcolorspace >> pngenc >> filesink
      sinkpad = ffmpegcolorspace.get_pad("sink")
      # Link pad
      print "Linking pad\n"
      pad.link(sinkpad)
    end

  end

  def do_thumbnail(time, mainloop)
    @mainloop = mainloop
    @buswatchid = bus.add_watch { | message | bus_message_cb(message) }
    @source.start = 0
    @source.duration = 1*Gst::SECOND
    @source.set_property('media-start', time*Gst::SECOND)
    @source.set_property('media-duration', 1*Gst::SECOND)

    # set to paused
    print "Setting to playing\n"
    play
    #res = get_state(200*Gst::MSECOND)
    #while res[1] != Gst::Element::STATE_PAUSED
    #  print "State currently #{res[1]} pending #{res[2]}\n"
    #  res = get_state(200*Gst::MSECOND)
    #end
    #print "Sending seek\n"
    # now send seek event
    #result = seek(1.0, Gst::Format::Type::TIME,
    #          Gst::Seek::FLAG_FLUSH.to_i | 
    #          Gst::Seek::FLAG_KEY_UNIT.to_i,
    #          Gst::Seek::TYPE_SET, time*Gst::SECOND,
    #          Gst::Seek::TYPE_NONE, -1)
    #if result
    #  print "Seek failed\n"
    #end
    #print "Setting to playing\n"
    #play
  end
      

  def bus_message_cb(message)
    case message.get_type
      when Gst::Message::MessageType::ERROR then
      	print "error\n"
        #_finished(false)
      when Gst::Message::MessageType::EOS then
        _finished(true)
    end
    true
  end

  def _finished(success)
    print "Finished\n"
    if success
      print "Thumbnail #{@thumbnail_filename} saved\n"
    end
    stop
    @mainloop.quit

  end
end


def usage
    puts "Usage: #{__FILE__} videofile imagefilename.png <time in seconds to thumbnail at>"
    exit
end

usage if ARGV.length <=2

@mainloop = GLib::MainLoop.new(GLib::MainContext.default, true)
@pipeline = Thumbnailer.new(ARGV[0], ARGV[1])
if ARGV.length > 2
  time = ARGV[2].to_i
else
  time = 10
end
print "Doing thumbnail of #{ARGV[0]} to #{ARGV[1]} at time #{time}\n"
@pipeline.do_thumbnail(time, @mainloop)

begin
  @mainloop.run
rescue Interrupt
  ensure
    @pipeline.stop
end

