# frozen_string_literal: true

module Gitlab
  class Experiment
    module Callbacks
      extend ActiveSupport::Concern
      include ActiveSupport::Callbacks

      included do
        define_callbacks(:unsegmented_run)
        define_callbacks(:segmented_run)
        define_callbacks(:exclusion_check, skip_after_callbacks_if_terminated: true)
      end

      class_methods do
        def exclude(*filter_list, **options, &block)
          filters = filter_list.unshift(block).compact.map do |filter|
            result_lambda = ActiveSupport::Callbacks::CallTemplate.build(filter, self).make_lambda
            lambda do |target|
              throw(:abort) if target.instance_variable_get(:'@excluded') || result_lambda.call(target, nil) == true
            end
          end

          raise ArgumentError, 'no filters provided' if filters.empty?

          set_callback(:exclusion_check, :before, *filters, options)
        end

        def segment(*filter_list, variant:, **options, &block)
          filters = filter_list.unshift(block).compact.map do |filter|
            result_lambda = ActiveSupport::Callbacks::CallTemplate.build(filter, self).make_lambda
            ->(target) { target.variant(variant) if !target.variant_assigned? && result_lambda.call(target, nil) }
          end

          raise ArgumentError, 'no filters provided' if filters.empty?

          set_callback(:segmented_run, :before, *filters, options)
        end
      end
    end
  end
end
