require 'rspec/core/rake_task'

RSpec::Core::RakeTask.new(:active_record_spec) do |active_record_spec|
  active_record_spec.pattern      = './spec/database_cleaner/active_record/*_spec.rb'
end

RSpec::Core::RakeTask.new(:generic_spec) do |generic_spec|
  generic_spec.pattern      = './spec/database_cleaner/generic/*_spec.rb'
end

RSpec::Core::RakeTask.new(:mongo_spec) do |mongo_spec|
  mongo_spec.pattern      = './spec/database_cleaner/mongo/*_spec.rb'
end

RSpec::Core::RakeTask.new(:redis_spec) do |redis_spec|
  redis_spec.pattern      = './spec/database_cleaner/redis/*_spec.rb'
end

RSpec::Core::RakeTask.new(:sequel_spec) do |sequel_spec|
  sequel_spec.pattern      = './spec/database_cleaner/sequel/*_spec.rb'
end

# mongo specs needs a mongodb instance running
task :default => [:active_record_spec, :generic_spec, :redis_spec, :sequel_spec]
