# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::SQL
  module Models
    #
    # Represents an Azure SQL Server Security Alert Policy.
    #
    class ServerSecurityAlertPolicy < MsRestAzure::Resource

      include MsRestAzure

      # @return [State] The state of the Azure SQL Security alert policy (New,
      # Enabled or Disabled). Possible values include: 'Enabled', 'Disabled',
      # 'New'
      attr_accessor :state

      # @return [String] The disable alerts of the Azure SQL Security alert
      # policy.
      attr_accessor :disabled_alerts

      # @return [String] The list of email addresses to send the alert.
      attr_accessor :email_addresses

      # @return [EmailAccountAdmins] Value that indicated whether to email the
      # azure account admins. Possible values include: 'Enabled', 'Disabled'
      attr_accessor :email_account_admins


      #
      # Mapper for ServerSecurityAlertPolicy class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'ServerSecurityAlertPolicy',
          type: {
            name: 'Composite',
            class_name: 'ServerSecurityAlertPolicy',
            model_properties: {
              id: {
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              state: {
                required: false,
                read_only: true,
                serialized_name: 'properties.state',
                type: {
                  name: 'Enum',
                  module: 'State'
                }
              },
              disabled_alerts: {
                required: false,
                read_only: true,
                serialized_name: 'properties.disabledAlerts',
                type: {
                  name: 'String'
                }
              },
              email_addresses: {
                required: false,
                read_only: true,
                serialized_name: 'properties.emailAddresses',
                type: {
                  name: 'String'
                }
              },
              email_account_admins: {
                required: false,
                read_only: true,
                serialized_name: 'properties.emailAccountAdmins',
                type: {
                  name: 'Enum',
                  module: 'EmailAccountAdmins'
                }
              }
            }
          }
        }
      end
    end
  end
end
