# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::MachineLearning
  module Models
    #
    # The set of properties specific to the Azure ML web service resource.
    #
    class WebServiceProperties

      include MsRestAzure

      @@discriminatorMap = Hash.new
      @@discriminatorMap["Graph"] = "WebServicePropertiesForGraph"

      def initialize
        @packageType = "WebServiceProperties"
      end

      attr_accessor :packageType

      # @return [String] The title of the Azure ML web service.
      attr_accessor :title

      # @return [String] The description of the Azure ML web service.
      attr_accessor :description

      # @return [DateTime] The moment of time the Azure ML web service was
      # created.
      attr_accessor :created_on

      # @return [DateTime] The moment of time the web service was last
      # modified.
      attr_accessor :modified_on

      # @return [ProvisioningState] The web service resource's provisioning
      # state. Possible values include: 'Unknown', 'Provisioning',
      # 'Succeeded', 'Failed', 'Canceled'
      attr_accessor :provisioning_state

      # @return [WebServiceKeys] The set of access keys for the web service.
      # If not specified at creation time (PUT), they will be generated
      # automatically by the resource provider.
      attr_accessor :keys

      # @return [Boolean] If true, the web service can no longer be updated /
      # patched, only removed. Otherwise, the service resource supports
      # changes.
      attr_accessor :read_only

      # @return [String] The uri for the swagger spec associated with this web
      # service.
      attr_accessor :swagger_location

      # @return [Boolean] Flag that controls whether to expose sample data or
      # not in the web service's swagger definition.
      attr_accessor :expose_sample_data

      # @return [RealtimeConfiguration] Configuration for the service's
      # realtime endpoint.
      attr_accessor :realtime_configuration

      # @return [DiagnosticsConfiguration] Settings controlling the
      # diagnostics traces collection for the web service.
      attr_accessor :diagnostics

      # @return [StorageAccount] The storage account associated with the
      # service. This is used to store both datasets and diagnostic traces.
      # This information is required at creation time (PUT) and only the key
      # is updateable after that. The account credentials are hidden on a GET
      # web service call.
      attr_accessor :storage_account

      # @return [MachineLearningWorkspace] This is only populated at creation
      # time (PUT) for web services originating from an AzureML Studio
      # experiment.
      attr_accessor :machine_learning_workspace

      # @return [CommitmentPlan] The commitment plan associated with this web
      # service. This is required to be specified at creation time (PUT) and
      # is not updateable afterwards.
      attr_accessor :commitment_plan

      # @return [ServiceInputOutputSpecification] Swagger schema for the
      # service's input(s), as applicable.
      attr_accessor :input

      # @return [ServiceInputOutputSpecification] Swagger schema for the
      # service's output(s), as applicable.
      attr_accessor :output

      # @return [ExampleRequest] Sample request data for each of the service's
      # inputs, as applicable.
      attr_accessor :example_request

      # @return [Hash{String => AssetItem}] Set of assets associated with the
      # web service.
      attr_accessor :assets

      # @return [Hash{String => String}] The set of global parameters values
      # defined for the web service, given as a global parameter name to
      # default value map. If no default value is specified, the parameter is
      # considered to be required.
      attr_accessor :parameters


      #
      # Mapper for WebServiceProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'WebServiceProperties',
          type: {
            name: 'Composite',
            polymorphic_discriminator: 'packageType',
            uber_parent: 'WebServiceProperties',
            class_name: 'WebServiceProperties',
            model_properties: {
              title: {
                required: false,
                serialized_name: 'title',
                type: {
                  name: 'String'
                }
              },
              description: {
                required: false,
                serialized_name: 'description',
                type: {
                  name: 'String'
                }
              },
              created_on: {
                required: false,
                read_only: true,
                serialized_name: 'createdOn',
                type: {
                  name: 'DateTime'
                }
              },
              modified_on: {
                required: false,
                read_only: true,
                serialized_name: 'modifiedOn',
                type: {
                  name: 'DateTime'
                }
              },
              provisioning_state: {
                required: false,
                read_only: true,
                serialized_name: 'provisioningState',
                type: {
                  name: 'String'
                }
              },
              keys: {
                required: false,
                serialized_name: 'keys',
                type: {
                  name: 'Composite',
                  class_name: 'WebServiceKeys'
                }
              },
              read_only: {
                required: false,
                serialized_name: 'readOnly',
                type: {
                  name: 'Boolean'
                }
              },
              swagger_location: {
                required: false,
                read_only: true,
                serialized_name: 'swaggerLocation',
                type: {
                  name: 'String'
                }
              },
              expose_sample_data: {
                required: false,
                serialized_name: 'exposeSampleData',
                type: {
                  name: 'Boolean'
                }
              },
              realtime_configuration: {
                required: false,
                serialized_name: 'realtimeConfiguration',
                type: {
                  name: 'Composite',
                  class_name: 'RealtimeConfiguration'
                }
              },
              diagnostics: {
                required: false,
                serialized_name: 'diagnostics',
                type: {
                  name: 'Composite',
                  class_name: 'DiagnosticsConfiguration'
                }
              },
              storage_account: {
                required: false,
                serialized_name: 'storageAccount',
                type: {
                  name: 'Composite',
                  class_name: 'StorageAccount'
                }
              },
              machine_learning_workspace: {
                required: false,
                serialized_name: 'machineLearningWorkspace',
                type: {
                  name: 'Composite',
                  class_name: 'MachineLearningWorkspace'
                }
              },
              commitment_plan: {
                required: false,
                serialized_name: 'commitmentPlan',
                type: {
                  name: 'Composite',
                  class_name: 'CommitmentPlan'
                }
              },
              input: {
                required: false,
                serialized_name: 'input',
                type: {
                  name: 'Composite',
                  class_name: 'ServiceInputOutputSpecification'
                }
              },
              output: {
                required: false,
                serialized_name: 'output',
                type: {
                  name: 'Composite',
                  class_name: 'ServiceInputOutputSpecification'
                }
              },
              example_request: {
                required: false,
                serialized_name: 'exampleRequest',
                type: {
                  name: 'Composite',
                  class_name: 'ExampleRequest'
                }
              },
              assets: {
                required: false,
                serialized_name: 'assets',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'AssetItemElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'AssetItem'
                      }
                  }
                }
              },
              parameters: {
                required: false,
                serialized_name: 'parameters',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
