# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::DataLakeAnalytics
  module Models
    #
    # The account specific properties that are associated with an underlying
    # Data Lake Analytics account.
    #
    class DataLakeAnalyticsAccountProperties

      include MsRestAzure

      # @return [DataLakeAnalyticsAccountStatus] the provisioning status of
      # the Data Lake Analytics account. Possible values include: 'Failed',
      # 'Creating', 'Running', 'Succeeded', 'Patching', 'Suspending',
      # 'Resuming', 'Deleting', 'Deleted'
      attr_accessor :provisioning_state

      # @return [DataLakeAnalyticsAccountState] the state of the Data Lake
      # Analytics account. Possible values include: 'active', 'suspended'
      attr_accessor :state

      # @return [String] the default data lake storage account associated with
      # this Data Lake Analytics account.
      attr_accessor :default_data_lake_store_account

      # @return [Integer] the maximum supported degree of parallelism for this
      # account.
      attr_accessor :max_degree_of_parallelism

      # @return [Integer] the maximum supported jobs running under the account
      # at the same time.
      attr_accessor :max_job_count

      # @return [Array<DataLakeStoreAccountInfo>] the list of Data Lake
      # storage accounts associated with this account.
      attr_accessor :data_lake_store_accounts

      # @return [Array<StorageAccountInfo>] the list of Azure Blob storage
      # accounts associated with this account.
      attr_accessor :storage_accounts

      # @return [DateTime] the account creation time.
      attr_accessor :creation_time

      # @return [DateTime] the account last modified time.
      attr_accessor :last_modified_time

      # @return [String] the full CName endpoint for this account.
      attr_accessor :endpoint


      #
      # Mapper for DataLakeAnalyticsAccountProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'DataLakeAnalyticsAccountProperties',
          type: {
            name: 'Composite',
            class_name: 'DataLakeAnalyticsAccountProperties',
            model_properties: {
              provisioning_state: {
                required: false,
                read_only: true,
                serialized_name: 'provisioningState',
                type: {
                  name: 'Enum',
                  module: 'DataLakeAnalyticsAccountStatus'
                }
              },
              state: {
                required: false,
                read_only: true,
                serialized_name: 'state',
                type: {
                  name: 'Enum',
                  module: 'DataLakeAnalyticsAccountState'
                }
              },
              default_data_lake_store_account: {
                required: false,
                serialized_name: 'defaultDataLakeStoreAccount',
                type: {
                  name: 'String'
                }
              },
              max_degree_of_parallelism: {
                required: false,
                serialized_name: 'maxDegreeOfParallelism',
                type: {
                  name: 'Number'
                }
              },
              max_job_count: {
                required: false,
                serialized_name: 'maxJobCount',
                type: {
                  name: 'Number'
                }
              },
              data_lake_store_accounts: {
                required: false,
                serialized_name: 'dataLakeStoreAccounts',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'DataLakeStoreAccountInfoElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'DataLakeStoreAccountInfo'
                      }
                  }
                }
              },
              storage_accounts: {
                required: false,
                serialized_name: 'storageAccounts',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StorageAccountInfoElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'StorageAccountInfo'
                      }
                  }
                }
              },
              creation_time: {
                required: false,
                read_only: true,
                serialized_name: 'creationTime',
                type: {
                  name: 'DateTime'
                }
              },
              last_modified_time: {
                required: false,
                read_only: true,
                serialized_name: 'lastModifiedTime',
                type: {
                  name: 'DateTime'
                }
              },
              endpoint: {
                required: false,
                read_only: true,
                serialized_name: 'endpoint',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
