/*
*  Rubrica
*  file: preview.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_PREVIEW_H
#define _RUBRICA_PREVIEW_H

#include <libxml/parser.h>
#include "rubrica_type.h"

GtkWidget* rubrica_preview_create_preview(void);

GtkTreeModel *rubrica_preview_create_model(void);
GtkWidget* rubrica_preview_new_view_with_model(GtkTreeModel *model);

void rubrica_preview_load_previewed (GtkButton *button, gpointer user_data);
void rubrica_preview_show_file (GtkButton *button, gpointer user_data);
gboolean  rubrica_preview_display_file(xmlDocPtr doc, GtkTreeStore *model,
				       RubricaErrorType *err);

void rubrica_preview_load_card_node(GtkTreeStore *model, GConfClient *client,
				    xmlNodePtr node, GtkTreeIter *parent);
void rubrica_preview_load_data_node(GtkTreeStore *model, GConfClient *client,
				    xmlNodePtr node, GtkTreeIter *parent);
void rubrica_preview_load_address_node(GtkTreeStore *model,GConfClient *client,
				       xmlNodePtr node, GtkTreeIter *parent);
void rubrica_preview_load_web_node(GtkTreeStore *model, GConfClient *client,
				   xmlNodePtr node, GtkTreeIter *parent);
void rubrica_preview_load_email_node(GtkTreeStore *model, GConfClient *client,
				     xmlNodePtr node, GtkTreeIter *parent);
void rubrica_preview_load_tel_node(GtkTreeStore *model, GConfClient *client,
				   xmlNodePtr node, GtkTreeIter *parent);
void rubrica_preview_load_company_node(GtkTreeStore *model,GConfClient *client,
				       xmlNodePtr node, GtkTreeIter *parent);
void rubrica_preview_load_work_node(GtkTreeStore *model, GConfClient *client,
				    xmlNodePtr node, GtkTreeIter *parent);
void rubrica_preview_load_note_node(GtkTreeStore *model, GConfClient *client,
				    xmlNodePtr node, GtkTreeIter *parent);

void rubrica_preview_print_node(GtkTreeStore *model, GtkTreeIter *child,
				GtkTreeIter *parent, gchar *field, 
				gchar* data);

gchar *rubrica_preview_get_date(xmlNodePtr node, gchar *key);

#endif
