/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file: prefer-configure.c
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h> 
#include <gconf/gconf-schema.h>
#include <libxml/tree.h>
#include <time.h>

#include "main.h"
#include "rubrica.h"
#include "autosave.h"
#include "utils.h"
#include "view.h"
#include "dialog.h"
#include "prefer.h"
#include "prefer_cb.h"
#include "prefer_int.h"
#include "prefer_configure.h"


#undef DEBUG

gboolean have_errors = FALSE;

void rubrica_preferences_reset_errors(void)
{
  have_errors = FALSE;
}

gboolean rubrica_preferences_there_are_errors(void)
{
  return have_errors;
}


void rubrica_preferences_configure_path(GConfClient *client, GtkWidget *path,
					gchar *key)
{
  GConfValue *show_path = NULL;  
  gchar *str;

  g_return_if_fail(key != NULL);

  show_path = gconf_client_get(client, key, NULL);  

  if (show_path != NULL && 
      show_path->type == GCONF_VALUE_BOOL &&
      gconf_value_get_bool(show_path))
    {          
      GConfValue *book = NULL; 
      
      book = gconf_client_get(client, RUBRICA_KEY_LAST_BOOK, NULL);
      
      if (book != NULL && book->type == GCONF_VALUE_STRING)
	{		  	  
	  str = g_dirname(gconf_value_get_string(book));
	  
	  gtk_label_set_text(GTK_LABEL(path), str);
	  
	  g_free(str);	      
	}
    }    
  else    
    gtk_label_set_text(GTK_LABEL(path), "");
  
  gconf_client_notify_add(client, RUBRICA_KEY_SHOW, 
			  rubrica_preferences_notify_path_changes,
			  path, NULL, NULL);
}



void rubrica_preferences_configure_label(GConfClient *client, 
					 GtkWidget *label, gchar *key)
{
  GConfValue *val_key;
  gchar *str;

#ifdef DEBUG
  g_print("\nrubrica_preferences_configure_label");
  g_print("\nlabel: %p\nclient: %p\nkey: %s", label, client, key);
#endif

  g_return_if_fail(key != NULL);

  val_key = gconf_client_get(client, key, NULL);

  if (val_key == NULL || val_key->type != GCONF_VALUE_STRING)
    val_key = gconf_client_get_default_from_schema(client, key, NULL); 
  
  if(val_key)
    {
      str = gconf_client_get_string(client, key, NULL); 
      
      if (str)
	{
	  gtk_label_set_text(GTK_LABEL(label), str);
	}
     else
     	gtk_label_set_text(GTK_LABEL(label), "");
    }
  else
    gtk_label_set_text(GTK_LABEL(label), "");
}


void rubrica_preferences_configure_entry(GConfClient *client, 
					 GtkWidget *entry, gchar *key)
{
  GConfValue *val_key;
  gchar *str;

#ifdef DEBUG
  g_print("\nrubrica_preferences_configure_entry");
  g_print("\nentry: %p\nclient: %p\nkey: %s", entry, client, key);
#endif

  g_return_if_fail(key != NULL);

  val_key = gconf_client_get(client, key, NULL);

  if (val_key == NULL || val_key->type != GCONF_VALUE_STRING)
    val_key = gconf_client_get_default_from_schema(client, key, NULL); 
  
  if (val_key)
    {
      str = gconf_client_get_string(client, key, NULL); 
      
      if (str)
	{
	  gtk_entry_set_text(GTK_ENTRY(entry), g_basename(str));
	  
	  g_free(str);
	}
    }
  else
    gtk_entry_set_text(GTK_ENTRY(entry), "");
}


void 
rubrica_preferences_configure_check(GConfClient *client, GtkWidget *check, 
				    gchar *key)
{
  GConfValue *key_value;

  g_return_if_fail(key != NULL);

  key_value = gconf_client_get(client, key, NULL);

  /*    if rubrica was never run before,
	i will read default value stored in schema.
  */
  if (strcmp(key, RUBRICA_KEY_SORT_DIRECTION) == 0)
    {
      RubricaSortDirectionType value;

      if (key_value == NULL || key_value->type != GCONF_VALUE_INT)
	key_value = gconf_client_get_default_from_schema(client, key, NULL); 

      if (!key_value)
	{
	  have_errors = TRUE;
	  rubrica_dialog_error_in_preferences_key(key);	  
	}

      value = gconf_value_get_int(key_value);
      
      if (value == SORT_ASCENDING)
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE);
      else
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), FALSE);     
    }
  else
    {      
      if (key_value == NULL || key_value->type != GCONF_VALUE_BOOL)
	key_value = gconf_client_get_default_from_schema(client, key, NULL);
      
      if (!key_value)
	{
	  have_errors = TRUE;
	  rubrica_dialog_error_in_preferences_key(key);	  
	}
      else
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check),
				      gconf_value_get_bool(key_value));
    }
}


void rubrica_preferences_configure_radio(GConfClient *client, int count, ...)
{
  va_list ap;
  GtkWidget *radio;
  GConfValue *val_key;
  gchar *key;
  gboolean bool = FALSE;
  gint i = 0;

  va_start(ap, count);
  
  while (i < count)
    {
      radio = (GtkWidget *) va_arg(ap, GtkWidget *);
      key   = (gchar *) va_arg(ap, gchar *);

      g_return_if_fail(key != NULL);

      val_key = gconf_client_get(client, key, NULL);
      
      if (val_key == NULL || val_key->type != GCONF_VALUE_BOOL)    
	val_key = gconf_client_get_default_from_schema(client, key, NULL);  
      
      if (!val_key)
	{
	  have_errors = TRUE;    
	  rubrica_dialog_error_in_preferences_key(key);	  
	}
      else
	{
	  bool = gconf_value_get_bool(val_key); 
	  
	  if (bool)
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE);
	  else
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE); 
	} 
 
      i++;
    }
  va_end(ap); 
}

void rubrica_preferences_configure_option_menu(GConfClient *client, 
					       GtkWidget *optmenu, 
					       gchar* key)
{
  GConfValue *val_key;
  gint option;

  g_return_if_fail(key != NULL);

  val_key = gconf_client_get(client, key, NULL);

  if (val_key == NULL || val_key->type != GCONF_VALUE_INT)
    val_key = gconf_client_get_default_from_schema(client, key, NULL); 
  
  if (!val_key)
    {
      have_errors = TRUE;    
      rubrica_dialog_error_in_preferences_key(key);	  
    }
  else
    {
      option = gconf_value_get_int(val_key); 
      gtk_option_menu_set_history(GTK_OPTION_MENU(optmenu), option); 
    }
}


void rubrica_preferences_configure_check_radio(GConfClient *client,
					       GtkWidget *check, 
					       GtkWidget *radio1, 
					       GtkWidget *radio2,
					       gchar *checkkey,
					       gchar *typekey)
{
  gboolean bool = FALSE;
  GConfValue *checkval = NULL;
  GConfValue *radioval = NULL;  

#ifdef DEBUG
  g_print("\nrubrica_preferences_configure_check_radio");
  g_print("\ncheck: %p\nardio 1: %p\nradio 2: %p\nclient: %p\ncheck_key: %s\ntype key: %s", check, radio1, radio2, client, checkkey, typekey);
#endif

  g_return_if_fail(checkkey != NULL);
  g_return_if_fail(typekey != NULL);

  checkval = gconf_client_get(client, checkkey, NULL);

  if (checkval == NULL || checkval->type != GCONF_VALUE_BOOL)
    checkval = gconf_client_get_default_from_schema(client, checkkey, NULL); 
    
  if (!checkval)
    {
      rubrica_dialog_error_in_preferences_key(checkkey);
      have_errors = TRUE;

      return;
    }
  else
    bool = gconf_value_get_bool(checkval); 
  
  if (bool)
    {
      gboolean type;

      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE);
      gtk_widget_set_sensitive (radio1, TRUE);
      gtk_widget_set_sensitive (radio2, TRUE);
      
      radioval = gconf_client_get(client, typekey, NULL); 
      
      if (radioval == NULL || radioval->type != GCONF_VALUE_BOOL)  	
	radioval = gconf_client_get_default_from_schema(client, typekey, NULL);
      
      if (!radioval)
	{
	  rubrica_dialog_error_in_preferences_key(typekey);
	  
	  have_errors = TRUE;
	  
	  type = rubrica_preferences_get_backup_type(typekey);
	}
      else
	{
	  /* get value stored in the key */
	  type = gconf_value_get_bool(radioval);    
	  
	  if (strcmp(typekey, RUBRICA_KEY_BACKUP_TYPE_INC) == 0)
	    {
	      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio1), type);
	      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio1), !type);
	    }
	  
	  if (strcmp(typekey, RUBRICA_KEY_BACKUP_TYPE_BAK) == 0)
	    {
	      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio1), !type);
	      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio1), type);
	    }
	}
    }	  
  else
    {
      gtk_widget_set_sensitive (radio1, FALSE);
      gtk_widget_set_sensitive (radio2, FALSE);
    }    
}



void 
rubrica_preferences_configure_checked_entry(GConfClient *client,
					    GtkWidget *check, 
					    GtkWidget *gnome_entry,
					    GtkWidget *entry,	    
					    gchar *check_key,  
					    gchar *gentry_key)
{
  gboolean bool = FALSE;
  GConfValue *checkval = NULL;
  GConfValue *gentryval = NULL;  

#ifdef DEBUG
  g_print("\nrubrica_preferences_configure_checked_entry");
  g_print("\ncheck: %p\ngnome entry: %p\nentry: %p\nclient: %p\ncheck_key: %s\ngentry_key: %s", check, gnome_entry, entry, client, check_key, gentry_key);
#endif

  g_return_if_fail(check_key != NULL);
  g_return_if_fail(gentry_key != NULL);

  checkval = gconf_client_get(client, check_key, NULL);

  if (checkval == NULL || checkval->type != GCONF_VALUE_BOOL)
    checkval = gconf_client_get_default_from_schema(client, check_key, NULL); 
    
  if (!checkval)
    {
      rubrica_dialog_error_in_preferences_key(check_key);
      have_errors = TRUE;

      return;
    }
  else
    /* now I have a key value, and i can extract the boolean value  */
    bool = gconf_value_get_bool(checkval); 
  
  if (bool)
    {
      gchar *buffer = NULL;

      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), TRUE);
      gtk_widget_set_sensitive (gnome_entry, TRUE);
      
      /* again get the value stored in gconf database for the key "gentry_key"
       */
      gentryval = gconf_client_get(client, gentry_key, NULL); 
      
      if (gentryval == NULL || gentryval->type != GCONF_VALUE_STRING)  	
	gentryval = gconf_client_get_default_from_schema(client, 
							 gentry_key, NULL); 
      
      if (!gentryval)
	{
	  rubrica_dialog_error_in_preferences_key(gentry_key);	  
	  have_errors = TRUE;
	  
	  return;
	}
      else
	/* get value stored in the key */
	buffer = g_strdup(gconf_value_get_string(gentryval));

      if (buffer)
	{
	  gtk_entry_set_text (GTK_ENTRY (entry), buffer);

	  g_free(buffer);     
	}
      else
	gtk_entry_set_text (GTK_ENTRY (entry), "");      
    }
  else
    {
      gtk_entry_set_text (GTK_ENTRY (entry), "");
      gtk_widget_set_sensitive(gnome_entry, FALSE);
    }  
}




void rubrica_preferences_configure_size_spin(GConfClient *client, 
					     GtkWidget *spin, gchar *key)
{
  GConfValue *gconf_value = NULL;
  gint rate = 0; 

  g_return_if_fail(key != NULL);

  gconf_value = gconf_client_get(client, key, NULL);
  if (gconf_value == NULL || gconf_value->type != GCONF_VALUE_INT)
    gconf_value = gconf_client_get_default_from_schema(client, key, NULL); 
  
  rate = gconf_value_get_int(gconf_value);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), rate);     
}


void rubrica_preferences_configure_spin(GConfClient *client,
					GtkWidget *check, 
					GtkWidget *spin, 
					gchar *check_key, 
					gchar *rate_key)
{
  GtkWidget *prefbox  = NULL;  /* ptr to preferences widget */
  GtkWidget *spin_box = NULL;  /* box that contains spin and labels */

  GConfValue *checkval = NULL; /* value stored for the check button */
  GConfValue *rateval  = NULL; /* value stored for the spin button  */

  gint rate     = 0;           /* zip_rate if compression, time if autosave */
  gboolean bool = FALSE;

#ifdef DEBUG
  g_print("\nrubrica_preferences_configure_spin");
  g_print("\ncheck: %p\nspin: %p\nclient: %p\ncheck_key: %s\nrate_key: %s", 
	  check, spin, client, check_key, rate_key);
#endif

  g_return_if_fail(check_key != NULL);
  g_return_if_fail(rate_key != NULL);

  prefbox = rubrica_preferences_get_preferencesbox();
  spin_box = gtk_object_get_data(GTK_OBJECT(check), "spin_box");

  /* get the key related to SPIN_KEY then get the key value stored
     in gconf database 
  */
  checkval = gconf_client_get(client, check_key, NULL);

  /* if the database hasn't data for the key, then get the default value 
     from the schema
  */
  if (checkval == NULL || checkval->type != GCONF_VALUE_BOOL)
    checkval = gconf_client_get_default_from_schema(client, check_key, NULL); 
  
  if (!checkval)
    {
      rubrica_dialog_error_in_preferences_key(check_key);

      have_errors = TRUE;
      
      if (strcmp(check_key, RUBRICA_KEY_COMPRESS) == 0)
	bool = rubrica_preferences_get_compress();
      
      if (strcmp(check_key, RUBRICA_KEY_AUTOSAVE) == 0)
	bool = rubrica_preferences_get_autosave();      
    }
  else
    /* now I have a key value, and i can extract the boolean value */
    bool = gconf_value_get_bool(checkval); 
  
  /* check the button */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (check), bool);

  if (bool)
    {
      /* make sensitive the spin button and the related labels */
      gtk_widget_set_sensitive(spin_box, TRUE);
      gtk_widget_set_sensitive(spin, TRUE);
      
      /* extract the "compression or time" rate from rate_key value 
	 or read default from schema
      */
      rateval = gconf_client_get(client, rate_key, NULL);
      
      if (rateval == NULL || rateval->type != GCONF_VALUE_INT)
	rateval = gconf_client_get_default_from_schema(client, rate_key, NULL);
      
      if (!rateval)
	{
	  rubrica_dialog_error_in_preferences_key(rate_key);
	  
	  have_errors = TRUE;

	  if (strcmp(check_key, RUBRICA_KEY_RATE) == 0)
	    rate = rubrica_preferences_get_compress_rate();
	  
	  if (strcmp(check_key, RUBRICA_KEY_WAIT_TIME) == 0)
	    rate = rubrica_preferences_get_time_rate();
	}

      else
	/* get the compression_rate/wait_time 
	   and put it into spin button	 
	*/
	rate = gconf_value_get_int(rateval); 
      
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), rate);     
    }
  else
    {
      /* user don't want a compressed addressbook 
	 (automatic save), set sensitive of
	 spin button and related label to false
      */
      gtk_widget_set_sensitive(spin, FALSE);	  
      gtk_widget_set_sensitive(spin_box, FALSE);
    }
}


void       
rubrica_preferences_configure_radio_dictionary(GConfClient *client,    
		       /* external dic */     GtkWidget *radio1,
		       /* default dic  */     GtkWidget *radio2,
		       /* external key */     gchar *key1,       
		       /* default key  */     gchar *key2)
{ 
  GConfValue *val_key;
  
  GtkWidget *prefbox;
  GtkWidget *notebook_box;
  GtkWidget *dictionary_box;
  
  gboolean bool;

#ifdef DEBUG
  g_print("\nrubrica_preferences_configure_radio_dictionary");
  g_print("\nradio1: %p\nradio2: %p\nclient: %p\nkey1: %s\nkey2: %s", 
	  radio1, radio2, client, key1, key2);
#endif

  g_return_if_fail(key1 != NULL);
  g_return_if_fail(key2 != NULL);

  /*    radio1 is the button for external dictionary, while 
	radio2 is the button for default dictionary
  */    
  prefbox = rubrica_preferences_get_preferencesbox();

  dictionary_box = gtk_object_get_data(GTK_OBJECT(prefbox),"box_def_dict");
  notebook_box  = gtk_object_get_data(GTK_OBJECT(prefbox),"notebook_box");

  /*     get the value of key1 (external dictionary) stored in gconf database
  */
  val_key = gconf_client_get(client, key1, NULL);

  if (val_key == NULL || val_key->type != GCONF_VALUE_BOOL)    
    val_key = gconf_client_get_default_from_schema(client, key1, NULL);      

  if (!val_key)
    {
      rubrica_dialog_error_in_preferences_key(key1);
      
      have_errors = TRUE;

      bool = rubrica_preferences_get_use_user_dictionary();
    }
  else
    bool = gconf_client_get_bool(client, key1, NULL); 
    
  if (bool)    /* use external dictionary (user dictionary) */
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio1), TRUE);
      gtk_widget_set_sensitive(dictionary_box, FALSE);
      gtk_widget_set_sensitive(notebook_box, TRUE);   
    }      
  else        /* use one of default dictionary */
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio2), TRUE);  
      gtk_widget_set_sensitive(dictionary_box, TRUE);
      gtk_widget_set_sensitive(notebook_box, FALSE);
    }
}


/*  NOTIFY 
*/


/*  notify changes to path label
*/
void rubrica_preferences_notify_path_changes(GConfClient *client, 
					     guint cnxn_id, 
					     GConfEntry *entry, 
					     gpointer data)
{  
  gboolean bool;
  
  bool = gconf_value_get_bool (entry->value);
  rubrica_view_show_path(bool);     
}


void rubrica_preferences_notify_check_changes(GConfClient *client, 
					      guint cnxn_id, 
					      GConfEntry *entry, 
					      gpointer data)
{  
  GtkWidget *check = data;

  if (entry->value != NULL && entry->value->type == GCONF_VALUE_BOOL)      
    {
      gboolean bool;

      bool = gconf_value_get_bool(entry->value);
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), bool);
    }
}


void rubrica_preferences_notify_autosave_time_changes(GConfClient *client, 
						      guint cnxn_id, 
						      GConfEntry *entry, 
						      gpointer data)
{
  /*     rubrica_autosave_time_changes is called when value in spin button 
	 is changed. Spin button is sensible only if check button is setted.
	 So if we are here, we have a timeout_tag and have_timeout is true
  */
  GtkWidget *spin = data;
  gint time = 0;
  
  time = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
  rubrica_autosave_restart(time);
}


void rubrica_preferences_column_config(GConfClient *client, 
				       GtkTreeViewColumn *column, 
				       gchar *key)
{
  gboolean bool;

  bool = gconf_client_get_bool(client, key, NULL);
  gconf_client_notify_add(client, key, 
			  rubrica_preferences_notify_column_changes, 
			  column, NULL, NULL);
  
  gtk_tree_view_column_set_visible(column, bool);  
}

void rubrica_preferences_notify_column_changes(GConfClient *client, 
					       guint cnxn_id, 
					       GConfEntry *entry, 
					       gpointer data)
{
  GtkTreeViewColumn *column = (GtkTreeViewColumn *) data;
  gboolean bool;

  bool = gconf_value_get_bool(entry->value);
  gtk_tree_view_column_set_visible(GTK_TREE_VIEW_COLUMN(column), bool);    
}


void rubrica_preferences_notify_tooltips_changes(GConfClient *client, 
						 guint cnxn_id, 
						 GConfEntry *entry, 
						 gpointer data)
{
  GtkWidget *toolbar;
  gboolean bool;

  toolbar = rubrica_get_toolbar();
  bool    = gconf_value_get_bool(entry->value);

  gtk_toolbar_set_tooltips(GTK_TOOLBAR(toolbar), bool);

  if (bool)
    rubrica_utils_enable_tooltips();
  else
    rubrica_utils_disable_tooltips();
}


void rubrica_preferences_notify_toolbar_style_changes(GConfClient *client, 
						      guint cnxn_id, 
						      GConfEntry *entry, 
						      gpointer data)
{
  GtkWidget *toolbar;
  gint style;

  toolbar = rubrica_get_toolbar();
  style   = (RubricaToolbarStyle) gconf_value_get_int(entry->value);
 
  switch ((RubricaToolbarStyle) style)
    {
    case RTS_BOTH:
      gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_BOTH);
      break;

    case RTS_ICONS:
      gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);
      break;

    case RTS_TEXT:
      gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_TEXT);
      break;

    case RTS_BOTH_HORIZ:
      gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_BOTH_HORIZ);
      break;

    default:
      break;
    }	
}
