/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file:interface.c
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gnome.h>
#include <gconf/gconf-client.h>
// #include <gdk/gdkkeysyms.h>
// #include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "ui.h"
#include "menu.h"
#include "menubar.h"
#include "prefer.h"
#include "prefer_configure.h"
#include "account.h"
#include "card.h"
#include "view.h"

GtkWidget *app;
GtkWidget *appbar; 
GtkWidget *toolbar;
GtkWidget *main_notebook;
GtkAccelGroup *accel_group;


GtkWidget *
rubrica_interface_create_info_box(GConfClient *client)
{
  GtkWidget *child;
  
  GtkWidget *buttonbox;
  GtkWidget *info_box;
  GtkWidget *hbox;
  GtkWidget *hbox2;

  GtkWidget *button_prev;
  GtkWidget *button_next;

  GtkWidget *alignment1;
  GtkWidget *alignment2; 

  GtkWidget *path_label, *items_label, *path, *items;
  GtkWidget *label1;
  GtkWidget *label2;

  GtkWidget *image1;
  GtkWidget *image2; 


  child = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (child), 5);
  
  buttonbox = gtk_hbutton_box_new ();
  gtk_box_pack_start (GTK_BOX (child), buttonbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (buttonbox), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (buttonbox), 50);
  gtk_widget_show (buttonbox);
  
  /*    Prev button
  */
  button_prev = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (buttonbox), button_prev);
  GTK_WIDGET_SET_FLAGS (button_prev, GTK_CAN_DEFAULT);
  gtk_widget_show (button_prev);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (button_prev), alignment1);
  gtk_widget_show (alignment1);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox);
  gtk_widget_show (hbox);

  image1 = gtk_image_new_from_stock ("gtk-go-back", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start (GTK_BOX (hbox), image1, FALSE, FALSE, 0);
  gtk_widget_show (image1);

  label1 = gtk_label_new_with_mnemonic (_("_Previous"));
  gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
  gtk_widget_show (label1);

  /*    Next button
  */
  button_next = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (buttonbox), button_next);
  GTK_WIDGET_SET_FLAGS (button_next, GTK_CAN_DEFAULT);
  gtk_widget_show (button_next);

  alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (button_next), alignment2);
  gtk_widget_show (alignment2);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox2);
  gtk_widget_show (hbox2);

  image2 = gtk_image_new_from_stock ("gtk-go-forward", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start (GTK_BOX (hbox2), image2, FALSE, FALSE, 0);
  gtk_widget_show (image2);

  label2 = gtk_label_new_with_mnemonic (_("Ne_xt"));
  gtk_box_pack_start (GTK_BOX (hbox2), label2, FALSE, FALSE, 0);
  gtk_widget_show (label2);

  /*    labels
  */
  info_box = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(child), info_box, TRUE, TRUE, 3);
  gtk_widget_show(info_box);
  
  items_label = gtk_label_new(_("Items in this address book:"));
  gtk_box_pack_start (GTK_BOX (info_box), items_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (items_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (items_label), 5, 0);
  gtk_widget_show(items_label);

  items = gtk_label_new("");
  gtk_box_pack_start (GTK_BOX (info_box), items, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (items), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (items), 5, 0);
  gtk_widget_show(items);
  
  path_label = gtk_label_new (_("path:"));
  gtk_box_pack_start (GTK_BOX (info_box), path_label, FALSE, FALSE, 10);
  gtk_label_set_justify (GTK_LABEL (path_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (path_label), 5, 0);
  gtk_widget_show (path_label);

  path = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX (info_box), path, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (path), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (path), 5, 0);
  gtk_widget_show (path);

  rubrica_view_set_path_label(path);
  rubrica_view_set_items_label(items);

  rubrica_preferences_configure_path(client, path, RUBRICA_KEY_SHOW);

  g_signal_connect (G_OBJECT (button_prev), "clicked",
		    G_CALLBACK (on_button_browse_clicked), 
		    GINT_TO_POINTER(RB_PREV_CARD));
  g_signal_connect (G_OBJECT (button_next), "clicked",
		    G_CALLBACK (on_button_browse_clicked),
		    GINT_TO_POINTER(RB_NEXT_CARD));

  return (GtkWidget *) child;
}


GtkWidget *
rubrica_interface_create_data_view(gchar *str)
{
  GtkWidget *child;
  GtkWidget *text_view_parent;

  child = rubrica_ui_frame_new(str);

  /*    text view parent
  */
  text_view_parent = rubrica_view_interface_creation();
  gtk_container_add (GTK_CONTAINER (child), text_view_parent);

  return (GtkWidget *) child;
}


GtkWidget* 
rubrica_interface_notebook_append_child(GtkWidget *notebook, 
					GtkTreeModel *model,  
					RubricaType type, gchar *str)
{
  GtkWidget *frame;
  GtkWidget *frame_label;

  GtkWidget *child = NULL;
  RubricaInfoChild *info;

  info = (RubricaInfoChild *) g_malloc(sizeof(RubricaInfoChild));
  info->type = type;

  frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
  gtk_widget_show (frame);

  frame_label = gtk_label_new (str);
  gtk_frame_set_label_widget (GTK_FRAME (frame), frame_label);
  gtk_label_set_justify (GTK_LABEL (frame_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (frame_label), 5, 0);
  gtk_widget_show (frame_label);

  switch (type)
    {
    case ACCOUNT_TYPE:
      child = rubrica_account_interface_creation(model, info);
      break;

    case CARD_TYPE:
      child = rubrica_card_interface_creation(info);
      break;

    default:
      break;
    }
    
  gtk_container_add(GTK_CONTAINER(frame), child);
  gtk_widget_show(child);

  g_object_set_data(G_OBJECT(frame), "info", info);

  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, NULL);  

  return child;
}


GtkWidget*
create_rubrica_app (GConfClient *client)
{
  GtkWidget *main_vbox;
  GtkTreeModel *model;

  GtkWidget *bonobodock;
  GtkWidget *card_notebook;

  GtkWidget *frame_rubrica;
  GtkWidget *frame_data;

  GtkWidget *paned;
  GtkWidget *label;

  GtkWidget *data_box;
  GtkWidget *info_box;

  
  g_print("\nRubrica: begin interface creation\n");

  accel_group = gtk_accel_group_new (); 

  app = gnome_app_new ("Rubrica", _("Rubrica")); 

  gtk_window_set_title (GTK_WINDOW (app), _("Rubrica")); 
  gtk_window_set_position (GTK_WINDOW (app), GTK_WIN_POS_CENTER);

  bonobodock = GNOME_APP (app)->dock;
  gtk_widget_show (bonobodock);

  /*    create menus: bar menu and popup menu
  */
  gnome_app_create_menus (GNOME_APP (app), menubar_uiinfo);

 /*     Main notebook creation (I need the notebook pointer during
	toolbar creation)

	The main notebook is a two pages notebook, it is packed 
	into left side of the paned. 
	 
	- First page will contains the account list.
	- Second page will conatins addressbooks's notebook
  */
  main_notebook = gtk_notebook_new ();
  gtk_container_set_border_width (GTK_CONTAINER (main_notebook), 2);
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (main_notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (main_notebook), FALSE);

  g_object_set_data(G_OBJECT(app), "notebook", main_notebook);

  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (main_vbox);
  gnome_app_set_contents (GNOME_APP (app), main_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 2);


  /*    Build Toolbar
   */
  toolbar = rubrica_menu_create_toolbar(app, accel_group);  
  gtk_widget_show (toolbar);


  /*    Data box
  */
  data_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (data_box);
  gtk_box_pack_start (GTK_BOX (main_vbox), data_box, TRUE, TRUE, 2);

  frame_rubrica = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (data_box), frame_rubrica, TRUE, TRUE, 3);
  gtk_container_set_border_width (GTK_CONTAINER (frame_rubrica), 2);
  gtk_widget_show (frame_rubrica);

  label = gtk_label_new (_("Rubrica"));
  gtk_frame_set_label_widget (GTK_FRAME (frame_rubrica), label);
  gtk_widget_show (label);


  /*    Paned: rigth side contains the data's window, the left side 
	contains the card's window and account's window 
	(packed in main notebook)
  */
  paned = gtk_hpaned_new ();
  gtk_container_add (GTK_CONTAINER (frame_rubrica), paned);
  gtk_container_set_border_width (GTK_CONTAINER (paned), 2);
  gtk_paned_set_position (GTK_PANED (paned), 400);
  gtk_widget_show (paned);

  /* pack main notebook and show it
   */
  gtk_paned_pack1 (GTK_PANED (paned), main_notebook, FALSE, TRUE);
  gtk_widget_show (main_notebook);


  /*    ***** Card's view, with card model *****
  */
  card_notebook = rubrica_interface_notebook_append_child(main_notebook, 
							  NULL, CARD_TYPE, 
							  _("Cards"));

  /*    ***** Account view, with account model *****
  */
  model = rubrica_account_create_model();
  rubrica_interface_notebook_append_child(main_notebook,GTK_TREE_MODEL(model), 
					  ACCOUNT_TYPE, _("Account"));

  /*    ***** Data View *****
  */
  frame_data = rubrica_interface_create_data_view(_("Data"));
  gtk_widget_show (frame_data);

  gtk_paned_pack2 (GTK_PANED (paned),frame_data, TRUE, TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (frame_data), 5);


  /*     infos box
  */
  info_box = rubrica_interface_create_info_box(client);
  gtk_box_pack_start (GTK_BOX (main_vbox), info_box, FALSE, FALSE, 3);
  gtk_widget_show (info_box);

  /*    Appbar
   */
  appbar = gnome_appbar_new (TRUE, TRUE, GNOME_PREFERENCES_NEVER);
  gnome_app_set_statusbar (GNOME_APP (app), appbar);
  gtk_widget_show (appbar);

  gnome_app_install_menu_hints (GNOME_APP (app), menubar_uiinfo);
  rubrica_view_set_statusbar(appbar);


  /*    CALLBACKS
  */
  g_signal_connect (G_OBJECT (app), "destroy", 
		    G_CALLBACK(gtk_main_quit), NULL);


  /*    NOTEBOOK CALLBACK
   */
  g_signal_connect(G_OBJECT(card_notebook), "switch-page",  
		   G_CALLBACK(on_switch_pages_cb), NULL);  

/*

  gtk_signal_connect (GTK_OBJECT (statusbar), "text_popped",
                      GTK_SIGNAL_FUNC (on_statusbar_text_popped),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (statusbar), "text_pushed",
                      GTK_SIGNAL_FUNC (on_statusbar_text_pushed),
                      NULL);
*/

 
  gtk_window_add_accel_group (GTK_WINDOW (app), accel_group);

  g_print("Rubrica: Interface done...\n");

  return app;
}
