/*
*  Rubrica
*  file: export.h
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __RUBRICA_EXPORT_H
#define __RUBRICA_EXPORT_H


typedef enum {
  EXPORT_HTML = 0,
  EXPORT_TXT,
  EXPORT_NETSCAPE_CSV, 
  EXPORT_MOZILLA_CSV, 
  EXPORT_KDE_VCARD,
  EXPORT_VCARD,
  EXPORT_PINE
} RubricaExportType;

GtkWidget* create_export_dialog(GtkWidget *parent);
void rubrica_export_option_menu_changed(GtkOptionMenu *menu, gpointer data);
void rubrica_export_init(GtkWidget *menu, RubricaExportType type);

gchar *rubrica_export_get_exporting_file(void);
gchar *rubrica_export_get_exported_file(void);

gboolean rubrica_export_export_data (void);
gboolean rubrica_export_engine(gchar *original, gchar *exported, 
			       gchar *stylesheet);


#endif
