/*
*  Rubrica
*  file: callbacks.h
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_CALLBACK_H
#define _RUBRICA_CALLBACK_H


#include <gnome.h>
#include "form_card.h"
#include "rubrica.h"

/*  CALLBACK RELATIVE AI MENU
*/
void on_new_file_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_open_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_save_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_save_as_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_close_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_import_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_export_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_preview_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_exit_activate(GtkMenuItem *menuitem, gpointer user_data);

void on_undo_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_redo_activate(GtkMenuItem *menuitem, gpointer user_data);

void on_cut_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_copy_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_paste_activate(GtkMenuItem *menuitem, gpointer user_data);

void on_alphabetic_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_creation_date_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_modification_date_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_increasing_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_decreasing_activate(GtkMenuItem *menuitem, gpointer user_data);

void on_pop_check_item_clicked(GtkMenuItem *menuitem, gpointer user_data);

void on_preferences_activate(GtkMenuItem *menuitem, gpointer user_data);

void on_pop_cut_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_pop_paste_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_pop_copy_activate(GtkMenuItem *menuitem, gpointer user_data);

void on_pop_add_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_pop_remove_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_pop_modify_activate(GtkMenuItem *menuitem, gpointer user_data);


/* CALLBACK RELATIVE ALLA TOOLBAR
*/
void on_button_new_clicked(GtkButton *button, gpointer user_data);
void on_button_open_clicked(GtkButton *button, gpointer user_data);
void on_button_save_clicked(GtkButton *button, gpointer user_data);
void on_button_close_clicked(GtkButton *button, gpointer user_data);
void on_button_add_clicked(GtkButton *button, gpointer user_data);
void on_button_remove_clicked(GtkButton *button, gpointer user_data);
void on_button_modify_clicked(GtkButton *button, gpointer user_data);
void on_button_browse_clicked (GtkButton *button, gpointer data);
void on_button_find_clicked(GtkButton *button, gpointer user_data);
void on_button_exit_clicked(GtkButton *button, gpointer user_data);
void on_button_cards_clicked(GtkButton *button, gpointer user_data);
void on_button_account_clicked (GtkButton *button, gpointer user_data);

void rubrica_modify_card_item(RubricaItem *item, gint index);
void exit_rubrica(Rubrica *rubrica);
void on_switch_pages_cb(GtkNotebook *notebook, GtkNotebookPage *page, 
			gint page_num, gpointer user_data); 

#endif


