<?xml version="1.0" ?>
<!-- 	 
###############################################################################
###############################################################################
##
##	Nome: rub2vcard.xsl
##	versione: 0.3
##	Copyright (C) 2000-2002 Nicola Fragale <nicolafragale@libero.it>
##	
##	Scopo: Questo foglio di stile traduce i file generati 
##        da Rubrica (.rub) in vcard
##	       This stylesheet translate rubrica's (.rub) file in vcard
##       
##	  This program is free software; you can redistribute it and/or modify
##	  it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
##
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU General Public License for more details.
##
##   You should have received a copy of the GNU General Public License
##   long with this program; if not, write to the Free Software
##   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##  	
###############################################################################
###############################################################################
-->	
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="UTF-8" indent="no"/>

<xsl:template match="Rubrica">
	<xsl:apply-templates/>
</xsl:template>


	<!--				Card/Scheda
	-->
<xsl:template match="Card">
BEGIN:VCARD
VERSION:3.0
FN:<xsl:value-of select="@name"/>
	<xsl:apply-templates select="Data"/>
	<xsl:apply-templates select="Address"/>
	<xsl:apply-templates select="WebAddresses"/>
	<xsl:apply-templates select="EmailAddresses"/>
	<xsl:apply-templates select="TelephoneNumbers"/>	
	<xsl:apply-templates select="Company"/>
	<xsl:apply-templates select="Work"/>
	<xsl:apply-templates select="Notes"/>
X-RUBRICA-X-Group:<xsl:value-of select="@group"/>
END:VCARD						
</xsl:template>
		

		<!--			Personal infos/Dati Personali
		-->
<xsl:template match="Data">	
   <xsl:if test="LastName='' and FirstName='' and MiddleName='' and NamePrefix='' and Title=''">
N:<xsl:value-of select="@name"/>
   </xsl:if>	
   <xsl:if test="LastName!='' or FirstName!='' or MiddleName!='' or NamePrefix!='' or Title!=''">
N:<xsl:if test="LastName!=''"><xsl:value-of 
	select="LastName"/>;</xsl:if><xsl:if test="FirstName!=''"><xsl:value-of 
	select="FirstName"/>;</xsl:if><xsl:if test="MiddleName!=''"><xsl:value-of 
	select="MiddleName"/>;</xsl:if><xsl:if test="NamePrefix!=''"><xsl:value-of 
	select="NamePrefix"/>;</xsl:if><xsl:if test="Title!=''"><xsl:value-of 
	select="Title"/>;</xsl:if>
	</xsl:if>
	<xsl:if test="FirstName/@know_birthday='true'">
BDAY:<xsl:value-of select="FirstName/@birthday"/>
	</xsl:if>
</xsl:template>			

	<!--			Address/Indirizzo
	-->
<xsl:template match="Address">
	<xsl:if test="Street!=''">
ADR;TYPE=home:</xsl:if><xsl:if test="ZipCode!=''"><xsl:value-of 
	select="ZipCode"/>;;<xsl:value-of select="Street"/><xsl:value-of 
	select="StreetNumber"/>;</xsl:if><xsl:if test="City!=''"><xsl:value-of 
	select="City"/>;</xsl:if><xsl:if test="Province!=''"><xsl:value-of 
	select="Province"/>;;</xsl:if><xsl:if test="Country!=''"><xsl:value-of 
	select="Country"/></xsl:if>
</xsl:template>
		
		
		<!-- 			Web 
		-->
<xsl:template match="WebAddresses">			
	<xsl:apply-templates select="Web"/>
</xsl:template>		
	
<xsl:template match="Web">
URL:<xsl:value-of select="."/> 
</xsl:template>			

        <!-- 			Email 
         -->
<xsl:template match="EmailAddresses">			
	<xsl:apply-templates select="Email"/>	
</xsl:template>
		
<xsl:template match="Email">
EMAIL;INTERNET:<xsl:value-of select="."/>
</xsl:template>
		

<!-- 			Telephone/Telefono 
-->
<xsl:template match="TelephoneNumbers">			
	<xsl:apply-templates select="Telephone"/>
</xsl:template>		
		
<xsl:template match="Telephone">
	<xsl:if test="./@type='cellphone'">
TEL;TYPE=cell:<xsl:value-of select="."/>
	</xsl:if>
	
	<xsl:if test="./@type!='cellphone'">
TEL;TYPE=<xsl:value-of select="./@type"/>:<xsl:value-of select="."/>
	</xsl:if>
</xsl:template>

        <!--           Company/society infos
         -->
<xsl:template match="Company">
   <xsl:if test="CompanyName!=''">
X-RUBRICA-X-CompanyName:<xsl:value-of select="CompanyName"/>
   </xsl:if>
   <xsl:if test="Street!=''">
X-RUBRICA-X-Street:<xsl:value-of select="Street"/>
   </xsl:if>
   <xsl:if test="StreetNumber!=''">
X-RUBRICA-X-StreetNumber:<xsl:value-of select="StreetNumber"/>
   </xsl:if>
   <xsl:if test="ZipCode!=''">
X-RUBRICA-X-ZipCode:<xsl:value-of select="ZipCode"/>
   </xsl:if>
   <xsl:if test="City!=''">
X-RUBRICA-X-City:<xsl:value-of select="City"/>
   </xsl:if>
   <xsl:if test="Province!=''">
X-RUBRICA-X-Province:<xsl:value-of select="Province"/>
   </xsl:if>
   <xsl:if test="Country!=''">
X-RUBRICA-X-Country:<xsl:value-of select="Country"/>
   </xsl:if>
   <xsl:if test="Web!=''">
X-RUBRICA-X-Web:<xsl:value-of select="Web"/>
   </xsl:if>
   <xsl:if test="Email!=''">
X-RUBRICA-X-Email:<xsl:value-of select="Email"/>
   </xsl:if>
   <xsl:if test="Operator!=''">
X-RUBRICA-X-Operator:<xsl:value-of select="Operator"/>
   </xsl:if>
   <xsl:if test="Fax!=''">
X-RUBRICA-X-Fax:<xsl:value-of select="Fax"/>
   </xsl:if>
   <xsl:if test="Green!=''">
X-RUBRICA-X-Green:<xsl:value-of select="Green"/>
   </xsl:if>
   <xsl:if test="CustomerCare!=''">
X-RUBRICA-X-CustomerCare:<xsl:value-of select="CustomerCare"/>
   </xsl:if>
   <xsl:if test="Notes!=''">
X-RUBRICA-X-Notes:<xsl:value-of select="Notes"/>
   </xsl:if>
</xsl:template>


        <!-- work info
             -->
<xsl:template match="Work">
   <xsl:if test="Assigment!=''">
ROLE:<xsl:value-of select="Assigment"/>
   </xsl:if>						
   <xsl:if test="Organization!=''">
ORG:<xsl:value-of select="Organization"/>
   </xsl:if>
   <xsl:if test="Department!=''">
X-RUBRICA-Department:<xsl:value-of select="Department"/>
   </xsl:if>
   <xsl:if test="SubDepartment!=''">
X-RUBRICA-X-SubDepartment:<xsl:value-of select="SubDepartment"/>
   </xsl:if>
   <xsl:if test="SecretaryName!=''">
X-RUBRICA-X-SecretaryName:<xsl:value-of select="SecretaryName"/>
   </xsl:if>
   <xsl:if test="SecretaryPhone!=''">
X-RUBRICA-X-SecretaryPhone:<xsl:value-of select="SecretaryPhone"/>
   </xsl:if>         
</xsl:template>
      
      
  <!-- Notes
   -->
<xsl:template match="Notes">
   <xsl:if test="SpouseName!=''">
X-RUBRICA-X-SpouseName:<xsl:value-of select="SpouseName"/>
   </xsl:if>		
   <xsl:if test="Child!=''">
X-RUBRICA-X-Child:<xsl:value-of select="Child"/>		
   </xsl:if>	
   <xsl:if test="Hobbies!=''">
X-RUBRICA-X-Hobbies:<xsl:value-of select="Hobbies"/>	
   </xsl:if>	
   <xsl:if test="OtherNotes!=''">
NOTE:<xsl:value-of select="OtherNotes"/>		
   </xsl:if>
   <xsl:if test="PublicKey!=''">
KEY:<xsl:value-of select="PublicKey"/>			
   </xsl:if>		
</xsl:template>

	<!-- 	end of file
	-->
</xsl:stylesheet>
