/***************************************************************************
 * RT2x00 SourceForge Project - http://rt2x00.serialmonkey.com              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   Licensed under the GNU GPL                                            *
 *   Original code supplied under license from RaLink Inc, 2004.           *
 ***************************************************************************/

/***************************************************************************
 *	Module Name:	rtusb.h
 *
 *	Abstract:
 *
 *	Revision History:
 *	Who		When		What
 *	--------	----------	-------------------------------
 *	Name		Date		Modification logs
 *	Jan Lee		2005-06-01	Release
 ***************************************************************************/

#ifndef	__RTUSB_H__
#define	__RTUSB_H__

//
// MACRO definitions
//
#if 0			// defined(_WIN32_WINNT) && (_WIN32_WINNT >= 0x0501)
#define	NDIS_QUERY_BUFFER(_NdisBuf, _ppVA, _pBufLen)                    \
    NdisQueryBufferSafe(_NdisBuf, _ppVA, _pBufLen, NormalPagePriority)
#else
#define	NDIS_QUERY_BUFFER(_NdisBuf, _ppVA, _pBufLen)                    \
    NdisQueryBuffer(_NdisBuf, _ppVA, _pBufLen)
#endif

// MACRO for Ndis packet extra information
#define	RTUSB_GET_PACKET_MR(_p)						(&(_p)->MiniportReservedEx[0])
#define RTUSB_SET_PACKET_FRAGMENTS(_p, number)   ((_p)->cb[10] = number)
#define RTUSB_GET_PACKET_FRAGMENTS(_p)           ((_p)->cb[10])
#define RTUSB_SET_PACKET_RTS(_p, number)         ((_p)->cb[11] = number)
#define RTUSB_GET_PACKET_RTS(_p)                 ((_p)->cb[11])

// Flags control for RT2500 USB bulk out frame type
#define RTUSB_SET_BULK_FLAG(_M, _F)				((_M)->BulkFlags |= (_F))
#define RTUSB_CLEAR_BULK_FLAG(_M, _F)			((_M)->BulkFlags &= ~(_F))
#define RTUSB_TEST_BULK_FLAG(_M, _F)			(((_M)->BulkFlags & (_F)) != 0)

#define EnqueueCmd(cmdq, cmdqelmt)		\
{										\
	if (cmdq->size == 0)				\
		cmdq->head = cmdqelmt;			\
	else								\
		cmdq->tail->next = cmdqelmt;	\
	cmdq->tail = cmdqelmt;				\
	cmdqelmt->next = NULL;				\
	cmdq->size++;						\
}

// Free Tx ring descriptor MACRO
// This can only called from complete function since it will change the IO counters
#define	FREE_TX_RING(_p, _t)			\
{										\
	(_t)->InUse      = FALSE;			\
	(_t)->LastOne    = FALSE;			\
	(_t)->IRPPending = FALSE;			\
	(_t)->BulkOutSize= 0;				\
	(_p)->NextBulkOutIndex = (((_p)->NextBulkOutIndex + 1) % TX_RING_SIZE);	\
	atomic_dec(&(_p)->TxCount); \
}

#define	LOCAL_TX_RING_EMPTY(_p)		(((_p)->TxContext[(_p)->NextBulkOutIndex].InUse) == FALSE)

//
//  Miniport routines in rtusb_main.c
//


//
// Function Prototype in rtusb_data.c
//

int RTUSBSendPackets(struct sk_buff *skb, struct net_device *dev);

NDIS_STATUS	RTUSBSendPacket(
	IN	PRT2570ADAPTER	pAdapter,
	IN  struct sk_buff  *skb);

VOID	RTUSBDeQueuePacket(
	IN	PRT2570ADAPTER	pAdapter);

NDIS_STATUS	RTUSBFreeDescriptorRequest(
	IN		PRT2570ADAPTER	pAdapter,
	IN		UCHAR			RingType,
	IN		UCHAR			NumberRequired);

VOID	RTUSBRejectPendingPackets(
	IN	PRT2570ADAPTER	pAdapter);

NDIS_STATUS	RTUSBHardEncrypt(
	IN	PRT2570ADAPTER	pAdapter,
	IN  struct sk_buff  *skb,
	IN	UCHAR			NumberRequired,
	IN	ULONG			EnableTxBurst);

VOID RTUSBRxPacket(unsigned long data);
//VOID RTUSBRxPacket(purbb_t pUrb);

VOID	RTUSBDequeueMLMEPacket(
	IN	PRT2570ADAPTER	pAdapter);

VOID	RTUSBCleanUpMLMEWaitQueue(
	IN	PRT2570ADAPTER	pAdapter);
USHORT	RTUSBCalcDuration(
	IN	PRT2570ADAPTER	pAdapter,
	IN	UCHAR			Rate,
	IN	ULONG			Size);

VOID	RTUSBWriteTxDescriptor(
	IN	PTXD_STRUC	pTxD,
	IN	BOOLEAN		Fragment,
	IN	UCHAR		RetryLimit,
	IN	BOOLEAN		Ack,
	IN  BOOLEAN     InsTimestamp,
	IN  BOOLEAN     new_seq,
	IN	UCHAR		Ifs,
	IN	UINT		Length,
	IN	BOOLEAN		Cipher,
	IN	UCHAR		KeyID,
	IN	UCHAR		CWMin,
	IN	UCHAR		CWMax,
	IN	UINT		PLCPLength,
	IN	UINT		Rate,
	IN	UCHAR		Service,
	IN  USHORT      TxPreamble);

VOID	RTUSBWriteBeaconDescriptor(
	IN	PTXD_STRUC	pTxD,
	IN	UINT		Length,
	IN	UINT		PLCPLength,
	IN	UINT		Rate,
	IN	UCHAR		Service,
	IN  USHORT      TxPreamble);
//
// Function Prototype in rtusb_init.c
//
NDIS_STATUS RTMPAllocAdapterBlock( PRT2570ADAPTER	*ppAdapter);
NDIS_STATUS NICInitTransmit( PRT2570ADAPTER pAdapter );
NDIS_STATUS NICInitRecv( PRT2570ADAPTER pAdapter);
NDIS_STATUS RT2570InitAdapterBlock(	PRT2570ADAPTER	pAdapter);
//
// Function Prototype in rtusb_io.c
//
NTSTATUS	RTUSBSingleRead(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUSHORT			pValue);

NTSTATUS	RTUSBSingleWrite(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	USHORT			Value);

NTSTATUS	RTUSBMultiRead(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS	RTUSBMultiWrite(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS	RTUSBReadMACRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUSHORT			pValue);

NTSTATUS	RTUSBWriteMACRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	USHORT			Value);

NTSTATUS	RTUSBMultiReadMAC(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS	RTUSBMultiWriteMAC(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS	RTUSBReadBBPRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	UCHAR			Id,
	IN	PUCHAR			pValue);

NTSTATUS	RTUSBWriteBBPRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	UCHAR			Id,
	IN	UCHAR			Value);

NTSTATUS	RTUSBWriteRFRegister(
	IN	PRT2570ADAPTER	pAdapter,
	IN	ULONG			Value);

NTSTATUS	RTUSB_CallUSBD(
	IN	PRT2570ADAPTER	pAdapter,
	IN	PURB			Urb);

INT	RTUSB_VendorRequest(
	IN	PRT2570ADAPTER	pAdapter,
	IN	ULONG			TransferFlags,
	IN	UCHAR			ReservedBits,
	IN	UCHAR			Request,
	IN	USHORT			Value,
	IN	USHORT			Index,
	IN	PVOID			TransferBuffer,
	IN	ULONG			TransferBufferLength);

NTSTATUS	RTUSB_ConfigureDevice(
	IN	PRT2570ADAPTER	Adapter);

NTSTATUS	RTUSB_GetDeviceDescriptor(
	IN	PRT2570ADAPTER	Adapter);

VOID	RTUSB_FreeDeviceDescriptor(
	IN	PRT2570ADAPTER	pAdapter);


VOID	RTUSB_FreeConfigUrb(
	IN	PURB	pUrb);


NTSTATUS	RTUSB_ResetDevice(
	IN	PRT2570ADAPTER	Adapter);

BOOLEAN	RTUSB_InterfaceStart(
	IN	PRT2570ADAPTER	Adapter);

VOID	RTUSB_InterfaceStop(
	IN	PRT2570ADAPTER	Adapter);

NTSTATUS	RTUSB_ResetPipe(
	IN	PRT2570ADAPTER	pAdapter,
	IN	UINT			BulkPipe);

NTSTATUS	RTUSBReadEEPROM(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	OUT	PUCHAR			pData,
	IN	USHORT			length);

NTSTATUS	RTUSBWriteEEPROM(
	IN	PRT2570ADAPTER	pAdapter,
	IN	USHORT			Offset,
	IN	PUCHAR			pData,
	IN	USHORT			length);

VOID	RTUSBInitializeCmdQ(
	IN	PCmdQ	cmdq);

NDIS_STATUS	RTUSBEnqueueCmdFromNdis(
	IN	PRT2570ADAPTER	pAdapter,
	IN	NDIS_OID		Oid,
	IN	BOOLEAN			SetInformation,
	IN	PVOID			pInformationBuffer,
	IN	ULONG			InformationBufferLength);

VOID	RTUSBEnqueueInternalCmd(
	IN	PRT2570ADAPTER	pAdapter,
	IN	NDIS_OID		Oid);

VOID	RTUSBDequeueCmd(
	IN	PCmdQ		cmdq,
	OUT	PCmdQElmt	*pcmdqelmt);


//
// Function Prototype in rtusb_bulk.c
//
VOID	RTUSBBulkReceive(
	IN	PRT2570ADAPTER	pAdapter);


VOID	RTUSBBulkOutDataPacket(
	IN	PRT2570ADAPTER	pAdapter,
	IN	UCHAR	Index);


VOID	RTUSBBulkOutNullFrame(
	IN	PRT2570ADAPTER	pAdapter);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0) && LINUX_VERSION_CODE < KERNEL_VERSION(2,6,19)
VOID RTUSBBulkOutDataPacketComplete(purbb_t purb,struct pt_regs *pt_regs);
VOID RTUSBBulkOutNullFrameComplete(purbb_t pUrb,struct pt_regs *pt_regs);
VOID RTUSBBulkOutMLMEPacketComplete(purbb_t pUrb,struct pt_regs *pt_regs);
VOID RTUSBBulkRxComplete(purbb_t pUrb,struct pt_regs *pt_regs);
VOID RTUSBBulkOutBeaconComplete(purbb_t pUrb,struct pt_regs *pt_regs);
#else
VOID RTUSBBulkOutDataPacketComplete(purbb_t pUrb);
VOID RTUSBBulkOutNullFrameComplete(purbb_t pUrb);
VOID RTUSBBulkOutMLMEPacketComplete(purbb_t pUrb);
VOID RTUSBBulkRxComplete(purbb_t pUrb);
VOID RTUSBBulkOutBeaconComplete(purbb_t pUrb);
#endif

VOID	RTUSBBulkOutMLMEPacket(
	IN	PRT2570ADAPTER	pAdapter,
	IN	UCHAR			Index);


VOID	RTUSBKickBulkOut(
	IN	PRT2570ADAPTER pAdapter);

VOID	RTUSBCleanUpDataBulkOutQueue(
	IN	PRT2570ADAPTER	pAdapter);

VOID	RTUSBCleanUpMLMEBulkOutQueue(
	IN	PRT2570ADAPTER	pAdapter);

VOID	RTUSBCancelPendingIRPs(
	IN	PRT2570ADAPTER	pAdapter);

VOID	RTUSBCancelPendingBulkInIRP(
	IN	PRT2570ADAPTER	pAdapter);

VOID	RTUSBCancelPendingBulkOutIRP(
	IN	PRT2570ADAPTER	pAdapter);


#endif	// __RTUSB_H__
